/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.loop.DefaultLoopPolicies;
import org.graalvm.compiler.loop.LoopPolicies;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.loop.phases.LoopFullUnrollPhase;
import org.graalvm.compiler.loop.phases.LoopPeelingPhase;
import org.graalvm.compiler.loop.phases.LoopUnswitchingPhase;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.IncrementalCanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.NodeCounterPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.common.inlining.policy.GreedyInliningPolicy;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.virtual.phases.ea.EarlyReadEliminationPhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;

public class HighTier
extends BaseTier<HighTierContext> {
    public HighTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = this.createCanonicalizerPhase(options);
        this.appendPhase(canonicalizer);
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.INIT));
        }
        if (Options.Inline.getValue(options).booleanValue()) {
            this.appendPhase(new InliningPhase(new GreedyInliningPolicy(null), canonicalizer));
            this.appendPhase(new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
        }
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.EARLY));
        }
        if (GraalOptions.OptConvertDeoptsToGuards.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<CoreProviders>(canonicalizer, new ConvertDeoptimizeToGuardPhase()));
        }
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, false));
        }
        LoopPolicies loopPolicies = this.createLoopPolicies(options);
        this.appendPhase(new LoopFullUnrollPhase(canonicalizer, loopPolicies));
        if (GraalOptions.LoopPeeling.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<CoreProviders>(canonicalizer, new LoopPeelingPhase(loopPolicies)));
        }
        if (GraalOptions.LoopUnswitch.getValue(options).booleanValue()) {
            this.appendPhase(new IncrementalCanonicalizerPhase<CoreProviders>(canonicalizer, new LoopUnswitchingPhase(loopPolicies)));
        }
        if (GraalOptions.PartialEscapeAnalysis.getValue(options).booleanValue()) {
            this.appendPhase(new PartialEscapePhase(true, canonicalizer, options));
        }
        if (GraalOptions.OptReadElimination.getValue(options).booleanValue()) {
            this.appendPhase(new EarlyReadEliminationPhase(canonicalizer));
        }
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.LATE));
        }
        this.appendPhase(new LoweringPhase(canonicalizer, LoweringTool.StandardLoweringStage.HIGH_TIER));
    }

    @Override
    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }

    public static class Options {
        @Option(help={"Enable inlining"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> Inline = new OptionKey<Boolean>(true);
    }
}

