/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.util.Arrays;

public final class IntList {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] array;
    private int size;

    public IntList(int initialCapacity) {
        this.array = new int[initialCapacity];
    }

    public IntList(int[] array, int initialSize) {
        assert (initialSize <= array.length);
        this.array = array;
        this.size = initialSize;
    }

    public static IntList copy(IntList other, int startIndex, int length) {
        return IntList.copy(other, startIndex, length, length);
    }

    public static IntList copy(IntList other, int startIndex, int length, int initialCapacity) {
        assert (initialCapacity >= length) : "initialCapacity < length";
        if (initialCapacity == 0) {
            return new IntList(EMPTY_INT_ARRAY, 0);
        }
        int[] array = new int[initialCapacity];
        System.arraycopy(other.array, startIndex, array, 0, length);
        return new IntList(array, length);
    }

    public int size() {
        return this.size;
    }

    public void add(int value) {
        if (this.size == this.array.length) {
            int newSize = this.size * 3 / 2 + 1;
            this.array = Arrays.copyOf(this.array, newSize);
        }
        this.array[this.size++] = value;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[index];
    }

    public void clear() {
        this.size = 0;
    }

    public void set(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.array[index] = value;
    }

    public void setSize(int newSize) {
        if (newSize < this.size) {
            this.size = newSize;
        } else if (newSize > this.size) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
    }

    public String toString() {
        if (this.array.length == this.size) {
            return Arrays.toString(this.array);
        }
        return Arrays.toString(Arrays.copyOf(this.array, this.size));
    }
}

