/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;

public class ObjectStamp
extends AbstractObjectStamp {
    public ObjectStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull) {
        super(type, exactType, nonNull, alwaysNull);
    }

    @Override
    protected ObjectStamp copyWith(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull) {
        return new ObjectStamp(type, exactType, nonNull, alwaysNull);
    }

    @Override
    public Stamp unrestricted() {
        return StampFactory.object();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('a');
        this.appendString(str);
        return str.toString();
    }

    @Override
    public boolean isCompatible(Stamp other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObjectStamp;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof JavaConstant) {
            return ((JavaConstant)constant).getJavaKind().isObject();
        }
        return false;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getObjectKind();
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        try {
            return provider.readObjectConstant(base, displacement);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public SymbolicJVMCIReference<ObjectStamp> makeSymbolic() {
        if (this.type() == null) {
            return null;
        }
        return new SymbolicObjectStamp(this);
    }

    static class SymbolicObjectStamp
    implements SymbolicJVMCIReference<ObjectStamp> {
        UnresolvedJavaType type;
        private boolean exactType;
        private boolean nonNull;
        private boolean alwaysNull;

        SymbolicObjectStamp(ObjectStamp stamp) {
            if (stamp.type() != null) {
                this.type = UnresolvedJavaType.create((String)stamp.type().getName());
            }
            this.exactType = stamp.isExactType();
            this.nonNull = stamp.nonNull();
            this.alwaysNull = stamp.alwaysNull();
        }

        @Override
        public ObjectStamp resolve(ResolvedJavaType accessingClass) {
            return new ObjectStamp(this.type != null ? this.type.resolve(accessingClass) : null, this.exactType, this.nonNull, this.alwaysNull);
        }

        public String toString() {
            return "SymbolicObjectStamp{declaringType=" + this.type + ", exactType=" + this.exactType + ", nonNull=" + this.nonNull + ", alwaysNull=" + this.alwaysNull + '}';
        }
    }
}

