/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import java.util.Optional;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.amd64.AMD64ArrayCompareToOp;
import org.graalvm.compiler.lir.amd64.AMD64ArrayEqualsOp;
import org.graalvm.compiler.lir.amd64.AMD64ArrayIndexOfOp;
import org.graalvm.compiler.lir.amd64.AMD64Binary;
import org.graalvm.compiler.lir.amd64.AMD64BinaryConsumer;
import org.graalvm.compiler.lir.amd64.AMD64ByteSwapOp;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.amd64.AMD64ControlFlow;
import org.graalvm.compiler.lir.amd64.AMD64LFenceOp;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64PauseOp;
import org.graalvm.compiler.lir.amd64.AMD64StringLatin1InflateOp;
import org.graalvm.compiler.lir.amd64.AMD64StringUTF16CompressOp;
import org.graalvm.compiler.lir.amd64.AMD64ZapRegistersOp;
import org.graalvm.compiler.lir.amd64.AMD64ZapStackOp;
import org.graalvm.compiler.lir.amd64.AMD64ZeroMemoryOp;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorCompareOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.hashing.IntHasher;
import org.graalvm.compiler.phases.util.Providers;

public abstract class AMD64LIRGenerator
extends LIRGenerator {
    public AMD64LIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, LIRGeneratorTool.MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
    }

    protected static final boolean canStoreConstant(JavaConstant c) {
        switch (c.getJavaKind()) {
            case Long: {
                return NumUtil.isInt(c.asLong());
            }
            case Double: {
                return false;
            }
            case Object: {
                return c.isNull();
            }
        }
        return true;
    }

    @Override
    protected JavaConstant zapValueForKind(PlatformKind kind) {
        long dead = -2401018187971961171L;
        switch ((AMD64Kind)kind) {
            case BYTE: {
                return JavaConstant.forByte((byte)((byte)dead));
            }
            case WORD: {
                return JavaConstant.forShort((short)((short)dead));
            }
            case DWORD: {
                return JavaConstant.forInt((int)((int)dead));
            }
            case QWORD: {
                return JavaConstant.forLong((long)dead);
            }
            case SINGLE: {
                return JavaConstant.forFloat((float)Float.intBitsToFloat((int)dead));
            }
        }
        return JavaConstant.forDouble((double)Double.longBitsToDouble(dead));
    }

    public AMD64AddressValue asAddressValue(Value address) {
        long displacement;
        if (address instanceof AMD64AddressValue) {
            return (AMD64AddressValue)address;
        }
        if (address instanceof JavaConstant && NumUtil.isInt(displacement = ((JavaConstant)address).asLong())) {
            return new AMD64AddressValue(address.getValueKind(), Value.ILLEGAL, (int)displacement);
        }
        return new AMD64AddressValue(address.getValueKind(), this.asAllocatable(address), 0);
    }

    @Override
    public Variable emitAddress(AllocatableValue stackslot) {
        Variable result = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new AMD64Move.StackLeaOp(result, stackslot));
        return result;
    }

    @Override
    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        switch ((AMD64Kind)kind.getPlatformKind()) {
            case BYTE: 
            case WORD: {
                return (K)kind.changeType((PlatformKind)AMD64Kind.DWORD);
            }
        }
        return kind;
    }

    private AllocatableValue asAllocatable(Value value, ValueKind<?> kind) {
        if (value.getValueKind().equals(kind)) {
            return this.asAllocatable(value);
        }
        if (ValueUtil.isRegister((Value)value)) {
            return ValueUtil.asRegister((Value)value).asValue(kind);
        }
        if (LIRValueUtil.isConstantValue(value)) {
            return this.emitLoadConstant(kind, LIRValueUtil.asConstant(value));
        }
        Variable variable = this.newVariable(kind);
        this.emitMove(variable, value);
        return variable;
    }

    private Value emitCompareAndSwap(boolean isLogic, LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue) {
        ValueKind kind = newValue.getValueKind();
        assert (kind.equals(expectedValue.getValueKind()));
        AMD64AddressValue addressValue = this.asAddressValue(address);
        LIRKind integralAccessKind = accessKind;
        Value reinterpretedExpectedValue = expectedValue;
        Value reinterpretedNewValue = newValue;
        boolean isXmm = ((AMD64Kind)accessKind.getPlatformKind()).isXMM();
        if (isXmm) {
            integralAccessKind = accessKind.getPlatformKind().equals(AMD64Kind.SINGLE) ? LIRKind.fromJavaKind(this.target().arch, JavaKind.Int) : LIRKind.fromJavaKind(this.target().arch, JavaKind.Long);
            reinterpretedExpectedValue = this.arithmeticLIRGen.emitReinterpret(integralAccessKind, expectedValue);
            reinterpretedNewValue = this.arithmeticLIRGen.emitReinterpret(integralAccessKind, newValue);
        }
        AMD64Kind memKind = (AMD64Kind)integralAccessKind.getPlatformKind();
        RegisterValue aRes = AMD64.rax.asValue((ValueKind)integralAccessKind);
        AllocatableValue allocatableNewValue = this.asAllocatable(reinterpretedNewValue, integralAccessKind);
        this.emitMove((AllocatableValue)aRes, reinterpretedExpectedValue);
        this.append(new AMD64Move.CompareAndSwapOp(memKind, (AllocatableValue)aRes, addressValue, (AllocatableValue)aRes, allocatableNewValue));
        if (isLogic) {
            assert (trueValue.getValueKind().equals(falseValue.getValueKind()));
            return this.emitCondMoveOp(Condition.EQ, trueValue, falseValue, false, false);
        }
        if (isXmm) {
            return this.arithmeticLIRGen.emitReinterpret(accessKind, (Value)aRes);
        }
        Variable result = this.newVariable(kind);
        this.emitMove(result, (Value)aRes);
        return result;
    }

    @Override
    public Variable emitLogicCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue, Value trueValue, Value falseValue) {
        return (Variable)this.emitCompareAndSwap(true, accessKind, address, expectedValue, newValue, trueValue, falseValue);
    }

    @Override
    public Value emitValueCompareAndSwap(LIRKind accessKind, Value address, Value expectedValue, Value newValue) {
        return this.emitCompareAndSwap(false, accessKind, address, expectedValue, newValue, null, null);
    }

    public void emitCompareAndSwapBranch(ValueKind<?> kind, AMD64AddressValue address, Value expectedValue, Value newValue, Condition condition, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        assert (kind.getPlatformKind().getSizeInBytes() <= expectedValue.getValueKind().getPlatformKind().getSizeInBytes());
        assert (kind.getPlatformKind().getSizeInBytes() <= newValue.getValueKind().getPlatformKind().getSizeInBytes());
        assert (condition == Condition.EQ || condition == Condition.NE);
        AMD64Kind memKind = (AMD64Kind)kind.getPlatformKind();
        RegisterValue raxValue = AMD64.rax.asValue(kind);
        this.emitMove((AllocatableValue)raxValue, expectedValue);
        this.append(new AMD64Move.CompareAndSwapOp(memKind, (AllocatableValue)raxValue, address, (AllocatableValue)raxValue, this.asAllocatable(newValue)));
        this.append(new AMD64ControlFlow.BranchOp(condition, trueLabel, falseLabel, trueLabelProbability));
    }

    @Override
    public Value emitAtomicReadAndAdd(Value address, ValueKind<?> kind, Value delta) {
        Variable result = this.newVariable(kind);
        AMD64AddressValue addressValue = this.asAddressValue(address);
        this.append(new AMD64Move.AtomicReadAndAddOp((AMD64Kind)kind.getPlatformKind(), result, addressValue, this.asAllocatable(delta)));
        return result;
    }

    @Override
    public Value emitAtomicReadAndWrite(Value address, ValueKind<?> kind, Value newValue) {
        Variable result = this.newVariable(kind);
        AMD64AddressValue addressValue = this.asAddressValue(address);
        this.append(new AMD64Move.AtomicReadAndWriteOp((AMD64Kind)kind.getPlatformKind(), result, addressValue, this.asAllocatable(newValue)));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        this.append(new AMD64Move.NullCheckOp(this.asAddressValue(address), state));
    }

    @Override
    public void emitJump(LabelRef label) {
        assert (label != null);
        this.append(new StandardOp.JumpOp(label));
    }

    @Override
    public void emitCompareBranch(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (cmpKind == AMD64Kind.SINGLE || cmpKind == AMD64Kind.DOUBLE) {
            boolean isSelfEqualsCheck = cond == Condition.EQ && !unorderedIsTrue && left.equals((Object)right);
            Condition finalCondition = this.emitCompare(cmpKind, left, right, cond);
            this.append(new AMD64ControlFlow.FloatBranchOp(finalCondition, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability, isSelfEqualsCheck));
            return;
        }
        if (LIRValueUtil.isVariable(right)) {
            this.emitRawCompareBranch(AMD64BaseAssembler.OperandSize.get(cmpKind), this.load(right), this.loadNonConst(left), cond.mirror(), trueLabel, falseLabel, trueLabelProbability);
        } else {
            this.emitRawCompareBranch(AMD64BaseAssembler.OperandSize.get(cmpKind), this.load(left), this.loadNonConst(right), cond, trueLabel, falseLabel, trueLabelProbability);
        }
    }

    private void emitRawCompareBranch(AMD64BaseAssembler.OperandSize size, Variable left, Value right, Condition cond, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (LIRValueUtil.isConstantValue(right)) {
            Constant c = LIRValueUtil.asConstant(right);
            if (JavaConstant.isNull((Constant)c)) {
                AMD64ArithmeticLIRGenerator arithmeticLIRGenerator = (AMD64ArithmeticLIRGenerator)this.arithmeticLIRGen;
                if (arithmeticLIRGenerator.mustReplaceNullWithNullRegister(c)) {
                    this.append(new AMD64ControlFlow.CmpBranchOp(size, left, (Value)arithmeticLIRGenerator.getNullRegisterValue(), null, cond, trueLabel, falseLabel, trueLabelProbability));
                } else {
                    this.append(new AMD64ControlFlow.TestBranchOp(size, left, (Value)left, null, cond, trueLabel, falseLabel, trueLabelProbability));
                }
                return;
            }
            if (c instanceof VMConstant) {
                VMConstant vc = (VMConstant)c;
                if (size == AMD64BaseAssembler.OperandSize.DWORD && !GraalOptions.GeneratePIC.getValue(this.getResult().getLIR().getOptions()).booleanValue() && this.target().inlineObjects) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(AMD64BaseAssembler.OperandSize.DWORD, (Value)left, vc, null, cond, trueLabel, falseLabel, trueLabelProbability));
                } else {
                    this.append(new AMD64ControlFlow.CmpDataBranchOp(size, left, (Constant)vc, cond, trueLabel, falseLabel, trueLabelProbability));
                }
                return;
            }
            if (c instanceof JavaConstant) {
                JavaConstant jc = (JavaConstant)c;
                if (jc.isDefaultForKind()) {
                    if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                        this.append(new AMD64ControlFlow.TestByteBranchOp(left, left, cond, trueLabel, falseLabel, trueLabelProbability));
                    } else {
                        this.append(new AMD64ControlFlow.TestBranchOp(size, left, (Value)left, null, cond, trueLabel, falseLabel, trueLabelProbability));
                    }
                    return;
                }
                if (NumUtil.is32bit(jc.asLong())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)left, (int)jc.asLong(), null, cond, trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
            }
        }
        this.append(new AMD64ControlFlow.CmpBranchOp(size, left, (Value)this.asAllocatable(right), null, cond, trueLabel, falseLabel, trueLabelProbability));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void emitCompareBranchMemory(AMD64Kind cmpKind, Value left, AMD64AddressValue right, LIRFrameState state, Condition cond, boolean unorderedIsTrue, LabelRef trueLabel, LabelRef falseLabel, double trueLabelProbability) {
        if (cmpKind.isXMM()) {
            if (cmpKind == AMD64Kind.SINGLE) {
                this.append(new AMD64BinaryConsumer.MemoryRMOp(AMD64Assembler.SSEOp.UCOMIS, AMD64BaseAssembler.OperandSize.PS, this.asAllocatable(left), right, state));
                this.append(new AMD64ControlFlow.FloatBranchOp(cond, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability));
                return;
            } else {
                if (cmpKind != AMD64Kind.DOUBLE) throw GraalError.shouldNotReachHere("unexpected kind: " + cmpKind);
                this.append(new AMD64BinaryConsumer.MemoryRMOp(AMD64Assembler.SSEOp.UCOMIS, AMD64BaseAssembler.OperandSize.PD, this.asAllocatable(left), right, state));
                this.append(new AMD64ControlFlow.FloatBranchOp(cond, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability));
            }
            return;
        } else {
            AMD64BaseAssembler.OperandSize size = AMD64BaseAssembler.OperandSize.get((PlatformKind)cmpKind);
            if (LIRValueUtil.isConstantValue(left)) {
                long value;
                ConstantValue a = LIRValueUtil.asConstantValue(left);
                if (JavaConstant.isNull((Constant)a.getConstant())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, 0, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
                if (a.getConstant() instanceof VMConstant && size == AMD64BaseAssembler.OperandSize.DWORD && this.target().inlineObjects) {
                    VMConstant vc = (VMConstant)a.getConstant();
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, vc, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
                if (a.getConstant() instanceof JavaConstant && a.getJavaConstant().getJavaKind() != JavaKind.Object && NumUtil.is32bit(value = a.getJavaConstant().asLong())) {
                    this.append(new AMD64ControlFlow.CmpConstBranchOp(size, (Value)right, (int)value, state, cond.mirror(), trueLabel, falseLabel, trueLabelProbability));
                    return;
                }
            }
            this.append(new AMD64ControlFlow.CmpBranchOp(size, this.asAllocatable(left), right, state, cond, trueLabel, falseLabel, trueLabelProbability));
        }
    }

    @Override
    public void emitOverflowCheckBranch(LabelRef overflow, LabelRef noOverflow, LIRKind cmpLIRKind, double overflowProbability) {
        this.append(new AMD64ControlFlow.BranchOp(AMD64Assembler.ConditionFlag.Overflow, overflow, noOverflow, overflowProbability));
    }

    @Override
    public void emitIntegerTestBranch(Value left, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        if (left.getPlatformKind().getVectorLength() > 1) {
            this.append(new AMD64VectorCompareOp(AMD64Assembler.VexRMOp.VPTEST, AMD64LIRGenerator.getRegisterSize(left), this.asAllocatable(left), this.asAllocatable(right)));
            this.append(new AMD64ControlFlow.BranchOp(Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
        } else {
            AMD64BaseAssembler.OperandSize size;
            assert (((AMD64Kind)left.getPlatformKind()).isInteger());
            AMD64BaseAssembler.OperandSize operandSize = size = left.getPlatformKind() == AMD64Kind.QWORD ? AMD64BaseAssembler.OperandSize.QWORD : AMD64BaseAssembler.OperandSize.DWORD;
            if (LIRValueUtil.isJavaConstant(right) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(right).asLong())) {
                this.append(new AMD64ControlFlow.TestConstBranchOp(size, (Value)this.asAllocatable(left), (int)LIRValueUtil.asJavaConstant(right).asLong(), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else if (LIRValueUtil.isJavaConstant(left) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(left).asLong())) {
                this.append(new AMD64ControlFlow.TestConstBranchOp(size, (Value)this.asAllocatable(right), (int)LIRValueUtil.asJavaConstant(left).asLong(), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else if (ValueUtil.isAllocatableValue((Value)right)) {
                this.append(new AMD64ControlFlow.TestBranchOp(size, this.asAllocatable(right), (Value)this.asAllocatable(left), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            } else {
                this.append(new AMD64ControlFlow.TestBranchOp(size, this.asAllocatable(left), (Value)this.asAllocatable(right), null, Condition.EQ, trueDestination, falseDestination, trueDestinationProbability));
            }
        }
    }

    @Override
    public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        boolean isFloatComparison = cmpKind == AMD64Kind.SINGLE || cmpKind == AMD64Kind.DOUBLE;
        Condition finalCondition = cond;
        Value finalTrueValue = trueValue;
        Value finalFalseValue = falseValue;
        if (isFloatComparison) {
            Value finalLeft = left;
            Value finalRight = right;
            if (unorderedIsTrue != AMD64ControlFlow.trueOnUnordered(finalCondition)) {
                if (unorderedIsTrue == AMD64ControlFlow.trueOnUnordered(finalCondition.mirror())) {
                    finalCondition = finalCondition.mirror();
                    finalLeft = right;
                    finalRight = left;
                } else if (finalCondition != Condition.EQ && finalCondition != Condition.NE) {
                    assert (unorderedIsTrue == AMD64ControlFlow.trueOnUnordered(finalCondition.negate()));
                    finalCondition = finalCondition.negate();
                    finalTrueValue = falseValue;
                    finalFalseValue = trueValue;
                }
            }
            this.emitRawCompare(cmpKind, finalLeft, finalRight);
        } else {
            finalCondition = this.emitCompare(cmpKind, left, right, cond);
        }
        boolean isSelfEqualsCheck = isFloatComparison && finalCondition == Condition.EQ && left.equals((Object)right);
        return this.emitCondMoveOp(finalCondition, finalTrueValue, finalFalseValue, isFloatComparison, unorderedIsTrue, isSelfEqualsCheck);
    }

    private Variable emitCondMoveOp(Condition condition, Value trueValue, Value falseValue, boolean isFloatComparison, boolean unorderedIsTrue) {
        return this.emitCondMoveOp(condition, trueValue, falseValue, isFloatComparison, unorderedIsTrue, false);
    }

    private Variable emitCondMoveOp(Condition condition, Value trueValue, Value falseValue, boolean isFloatComparison, boolean unorderedIsTrue, boolean isSelfEqualsCheck) {
        boolean isParityCheckNecessary = isFloatComparison && unorderedIsTrue != AMD64ControlFlow.trueOnUnordered(condition);
        Variable result = this.newVariable(trueValue.getValueKind());
        if (!isParityCheckNecessary && LIRValueUtil.isIntConstant(trueValue, 1L) && LIRValueUtil.isIntConstant(falseValue, 0L)) {
            if (isFloatComparison) {
                this.append(new AMD64ControlFlow.FloatCondSetOp(result, condition));
            } else {
                this.append(new AMD64ControlFlow.CondSetOp(result, condition));
            }
        } else if (!isParityCheckNecessary && LIRValueUtil.isIntConstant(trueValue, 0L) && LIRValueUtil.isIntConstant(falseValue, 1L)) {
            if (isFloatComparison) {
                if (unorderedIsTrue == AMD64ControlFlow.trueOnUnordered(condition.negate())) {
                    this.append(new AMD64ControlFlow.FloatCondSetOp(result, condition.negate()));
                } else {
                    this.append(new AMD64ControlFlow.FloatCondSetOp(result, condition));
                    Variable negatedResult = this.newVariable(result.getValueKind());
                    this.append(new AMD64Binary.ConstOp(AMD64Assembler.AMD64BinaryArithmetic.XOR, AMD64BaseAssembler.OperandSize.get(result.getPlatformKind()), (AllocatableValue)negatedResult, (AllocatableValue)result, 1));
                    result = negatedResult;
                }
            } else {
                this.append(new AMD64ControlFlow.CondSetOp(result, condition.negate()));
            }
        } else if (isFloatComparison) {
            this.append(new AMD64ControlFlow.FloatCondMoveOp(result, condition, unorderedIsTrue, this.load(trueValue), this.load(falseValue), isSelfEqualsCheck));
        } else {
            this.append(new AMD64ControlFlow.CondMoveOp(result, condition, this.load(trueValue), this.loadNonConst(falseValue)));
        }
        return result;
    }

    @Override
    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        this.emitIntegerTest(left, right);
        return this.emitCondMoveOp(Condition.EQ, (Value)this.load(trueValue), this.loadNonConst(falseValue), false, false);
    }

    protected static AVXKind.AVXSize getRegisterSize(Value a) {
        AMD64Kind kind = (AMD64Kind)a.getPlatformKind();
        if (kind.isXMM()) {
            return AVXKind.getRegisterSize(kind);
        }
        return AVXKind.AVXSize.XMM;
    }

    private void emitIntegerTest(Value a, Value b) {
        if (a.getPlatformKind().getVectorLength() > 1) {
            this.append(new AMD64VectorCompareOp(AMD64Assembler.VexRMOp.VPTEST, AMD64LIRGenerator.getRegisterSize(a), this.asAllocatable(a), this.asAllocatable(b)));
        } else {
            AMD64BaseAssembler.OperandSize size;
            assert (((AMD64Kind)a.getPlatformKind()).isInteger());
            AMD64BaseAssembler.OperandSize operandSize = size = a.getPlatformKind() == AMD64Kind.QWORD ? AMD64BaseAssembler.OperandSize.QWORD : AMD64BaseAssembler.OperandSize.DWORD;
            if (LIRValueUtil.isJavaConstant(b) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(b).asLong())) {
                this.append(new AMD64BinaryConsumer.ConstOp(AMD64Assembler.AMD64MIOp.TEST, size, this.asAllocatable(a), (int)LIRValueUtil.asJavaConstant(b).asLong()));
            } else if (LIRValueUtil.isJavaConstant(a) && NumUtil.is32bit(LIRValueUtil.asJavaConstant(a).asLong())) {
                this.append(new AMD64BinaryConsumer.ConstOp(AMD64Assembler.AMD64MIOp.TEST, size, this.asAllocatable(b), (int)LIRValueUtil.asJavaConstant(a).asLong()));
            } else if (ValueUtil.isAllocatableValue((Value)b)) {
                this.append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.TEST, size, this.asAllocatable(b), this.asAllocatable(a)));
            } else {
                this.append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.TEST, size, this.asAllocatable(a), this.asAllocatable(b)));
            }
        }
    }

    private Condition emitCompare(PlatformKind cmpKind, Value a, Value b, Condition cond) {
        if (LIRValueUtil.isVariable(b)) {
            this.emitRawCompare(cmpKind, b, a);
            return cond.mirror();
        }
        this.emitRawCompare(cmpKind, a, b);
        return cond;
    }

    private void emitRawCompare(PlatformKind cmpKind, Value left, Value right) {
        ((AMD64ArithmeticLIRGeneratorTool)((Object)this.arithmeticLIRGen)).emitCompareOp((AMD64Kind)cmpKind, this.load(left), this.loadNonConst(right));
    }

    @Override
    public void emitMembar(int barriers) {
        int necessaryBarriers = this.target().arch.requiredBarriers(barriers);
        if (this.target().isMP && necessaryBarriers != 0) {
            this.append(new AMD64Move.MembarOp(necessaryBarriers));
        }
    }

    public abstract void emitCCall(long var1, CallingConvention var3, Value[] var4, int var5);

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        long maxOffset = linkage.getMaxCallTargetOffset();
        if (maxOffset != (long)((int)maxOffset) && !GraalOptions.GeneratePIC.getValue(this.getResult().getLIR().getOptions()).booleanValue()) {
            this.append(new AMD64Call.DirectFarForeignCallOp(linkage, result, arguments, temps, info));
        } else {
            this.append(new AMD64Call.DirectNearForeignCallOp(linkage, result, arguments, temps, info));
        }
    }

    @Override
    public Variable emitByteSwap(Value input) {
        Variable result = this.newVariable(LIRKind.combine(input));
        this.append(new AMD64ByteSwapOp((Value)result, input));
        return result;
    }

    @Override
    public Variable emitArrayCompareTo(JavaKind kind1, JavaKind kind2, Value array1, Value array2, Value length1, Value length2) {
        LIRKind resultKind = LIRKind.value((PlatformKind)AMD64Kind.DWORD);
        RegisterValue raxRes = AMD64.rax.asValue((ValueKind)resultKind);
        RegisterValue cnt1 = AMD64.rcx.asValue(length1.getValueKind());
        RegisterValue cnt2 = AMD64.rdx.asValue(length2.getValueKind());
        this.emitMove((AllocatableValue)cnt1, length1);
        this.emitMove((AllocatableValue)cnt2, length2);
        this.append(new AMD64ArrayCompareToOp(this, this.getAVX3Threshold(), kind1, kind2, (Value)raxRes, array1, array2, (Value)cnt1, (Value)cnt2));
        Variable result = this.newVariable(resultKind);
        this.emitMove(result, (Value)raxRes);
        return result;
    }

    @Override
    public Variable emitArrayEquals(JavaKind kind, Value array1, Value array2, Value length, boolean directPointers) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64ArrayEqualsOp(this, kind, kind, (Value)result, array1, array2, length, directPointers, this.getMaxVectorSize()));
        return result;
    }

    @Override
    public Variable emitArrayEquals(JavaKind kind1, JavaKind kind2, Value array1, Value array2, Value length, boolean directPointers) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64ArrayEqualsOp(this, kind1, kind2, (Value)result, array1, array2, length, directPointers, this.getMaxVectorSize()));
        return result;
    }

    protected int getMaxVectorSize() {
        return -1;
    }

    protected int getAVX3Threshold() {
        return 4096;
    }

    @Override
    public Variable emitArrayIndexOf(JavaKind arrayKind, JavaKind valueKind, boolean findTwoConsecutive, Value arrayPointer, Value arrayLength, Value fromIndex, Value ... searchValues) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        this.append(new AMD64ArrayIndexOfOp(arrayKind, valueKind, findTwoConsecutive, this.getMaxVectorSize(), this, (Value)result, (Value)this.asAllocatable(arrayPointer), (Value)this.asAllocatable(arrayLength), (Value)this.asAllocatable(fromIndex), searchValues));
        return result;
    }

    @Override
    public void emitStringLatin1Inflate(Value src, Value dst, Value len) {
        RegisterValue rsrc = AMD64.rsi.asValue(src.getValueKind());
        RegisterValue rdst = AMD64.rdi.asValue(dst.getValueKind());
        RegisterValue rlen = AMD64.rdx.asValue(len.getValueKind());
        this.emitMove((AllocatableValue)rsrc, src);
        this.emitMove((AllocatableValue)rdst, dst);
        this.emitMove((AllocatableValue)rlen, len);
        this.append(new AMD64StringLatin1InflateOp(this, this.getAVX3Threshold(), (Value)rsrc, (Value)rdst, (Value)rlen));
    }

    @Override
    public Variable emitStringUTF16Compress(Value src, Value dst, Value len) {
        RegisterValue rsrc = AMD64.rsi.asValue(src.getValueKind());
        RegisterValue rdst = AMD64.rdi.asValue(dst.getValueKind());
        RegisterValue rlen = AMD64.rdx.asValue(len.getValueKind());
        this.emitMove((AllocatableValue)rsrc, src);
        this.emitMove((AllocatableValue)rdst, dst);
        this.emitMove((AllocatableValue)rlen, len);
        LIRKind reskind = LIRKind.value((PlatformKind)AMD64Kind.DWORD);
        RegisterValue rres = AMD64.rax.asValue((ValueKind)reskind);
        this.append(new AMD64StringUTF16CompressOp(this, this.getAVX3Threshold(), (Value)rres, (Value)rsrc, (Value)rdst, (Value)rlen));
        Variable res = this.newVariable(reskind);
        this.emitMove(res, (Value)rres);
        return res;
    }

    @Override
    public void emitReturn(JavaKind kind, Value input) {
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(kind, input.getValueKind());
            this.emitMove(operand, input);
        }
        this.append(new AMD64ControlFlow.ReturnOp((Value)operand));
    }

    protected AMD64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Variable key, AllocatableValue temp) {
        return new AMD64ControlFlow.StrategySwitchOp(strategy, keyTargets, defaultTarget, (Value)key, (Value)temp);
    }

    @Override
    public void emitStrategySwitch(SwitchStrategy strategy, Variable key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        boolean needsTemp = !LIRKind.isValue((Value)key);
        this.append(this.createStrategySwitchOp(strategy, keyTargets, defaultTarget, key, needsTemp ? this.newVariable(key.getValueKind()) : Value.ILLEGAL));
    }

    @Override
    protected void emitTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Value key) {
        this.append(new AMD64ControlFlow.TableSwitchOp(lowKey, defaultTarget, targets, key, this.newVariable(LIRKind.value(this.target().arch.getWordKind())), this.newVariable(key.getValueKind())));
    }

    @Override
    protected Optional<IntHasher> hasherFor(JavaConstant[] keyConstants, double minDensity) {
        int[] keys = new int[keyConstants.length];
        for (int i = 0; i < keyConstants.length; ++i) {
            keys[i] = keyConstants[i].asInt();
        }
        return IntHasher.forKeys(keys);
    }

    @Override
    protected void emitHashTableSwitch(IntHasher hasher, JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, Value value) {
        Value hash = value;
        if (hasher.factor > 1) {
            Value factor = this.emitJavaConstant((JavaConstant)JavaConstant.forShort((short)hasher.factor));
            hash = this.arithmeticLIRGen.emitMul(hash, factor, false);
        }
        if (hasher.shift > 0) {
            Value shift = this.emitJavaConstant((JavaConstant)JavaConstant.forByte((byte)hasher.shift));
            hash = this.arithmeticLIRGen.emitShr(hash, shift);
        }
        Value cardinalityAnd = this.emitJavaConstant((JavaConstant)JavaConstant.forInt((int)(hasher.cardinality - 1)));
        hash = this.arithmeticLIRGen.emitAnd(hash, cardinalityAnd);
        Variable scratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        Variable entryScratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new AMD64ControlFlow.HashTableSwitchOp(keys, defaultTarget, targets, value, hash, scratch, entryScratch));
    }

    @Override
    public void emitPause() {
        this.append(new AMD64PauseOp());
    }

    @Override
    public StandardOp.ZapRegistersOp createZapRegisters(Register[] zappedRegisters, JavaConstant[] zapValues) {
        return new AMD64ZapRegistersOp(zappedRegisters, zapValues);
    }

    @Override
    public LIRInstruction createZapArgumentSpace(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        return new AMD64ZapStackOp(zappedStack, zapValues);
    }

    @Override
    public void emitSpeculationFence() {
        this.append(new AMD64LFenceOp());
    }

    @Override
    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        RegisterValue lengthReg = AMD64.rcx.asValue(length.getValueKind());
        this.emitMove((AllocatableValue)lengthReg, length);
        this.append(new AMD64ZeroMemoryOp(this.asAddressValue(address), lengthReg));
    }
}

