/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AArch64MoveFactory
implements LIRGeneratorTool.MoveFactory {
    @Override
    public LIRInstruction createMove(AllocatableValue dst, Value src) {
        boolean srcIsSlot = LIRValueUtil.isStackSlotValue(src);
        boolean dstIsSlot = LIRValueUtil.isStackSlotValue((Value)dst);
        if (LIRValueUtil.isConstantValue(src)) {
            return this.createLoad(dst, LIRValueUtil.asConstant(src));
        }
        if (src instanceof AArch64AddressValue) {
            return new AArch64Move.LoadAddressOp(dst, (AArch64AddressValue)src);
        }
        assert (src instanceof AllocatableValue);
        if (srcIsSlot && dstIsSlot) {
            throw GraalError.shouldNotReachHere(src.getClass() + " " + dst.getClass());
        }
        return new AArch64Move.Move(dst, (AllocatableValue)src);
    }

    @Override
    public LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        return new AArch64Move.Move(result, input);
    }

    @Override
    public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (src instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)src;
            if (this.canInlineConstant((Constant)javaConstant)) {
                return new AArch64Move.LoadInlineConstant(javaConstant, dst);
            }
            return new AArch64Move.LoadInlineConstant(javaConstant, dst);
        }
        if (src instanceof DataPointerConstant) {
            return new AArch64Move.LoadDataOp(dst, (DataPointerConstant)src);
        }
        throw GraalError.unimplemented();
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        return this.createLoad(result, input);
    }

    @Override
    public boolean canInlineConstant(Constant con) {
        if (con instanceof JavaConstant) {
            JavaConstant c = (JavaConstant)con;
            switch (c.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: {
                    return AArch64MacroAssembler.isMovableImmediate(c.asInt());
                }
                case Long: {
                    return AArch64MacroAssembler.isMovableImmediate(c.asLong());
                }
                case Object: {
                    return c.isNull();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowConstantToStackMove(Constant value) {
        return false;
    }
}

