/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import jdk.vm.ci.code.BailoutException;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.OptionValues;

public abstract class CompilationWrapper<T> {
    private final DiagnosticsOutputDirectory outputDirectory;
    private final Map<ExceptionAction, Integer> problemsHandledPerAction;

    public CompilationWrapper(DiagnosticsOutputDirectory outputDirectory, Map<ExceptionAction, Integer> problemsHandledPerAction) {
        this.outputDirectory = outputDirectory;
        this.problemsHandledPerAction = problemsHandledPerAction;
    }

    protected abstract T handleException(Throwable var1);

    protected ExceptionAction lookupAction(OptionValues options, Throwable cause) {
        if (cause instanceof BailoutException && !GraalCompilerOptions.CompilationBailoutAsFailure.getValue(options).booleanValue()) {
            return ExceptionAction.Silent;
        }
        if (GraalCompilerOptions.ExitVMOnException.getValue(options).booleanValue()) {
            assert (GraalCompilerOptions.CompilationFailureAction.getDefaultValue() != ExceptionAction.ExitVM);
            assert (!GraalCompilerOptions.ExitVMOnException.getDefaultValue().booleanValue());
            if (GraalCompilerOptions.CompilationFailureAction.hasBeenSet(options) && GraalCompilerOptions.CompilationFailureAction.getValue(options) != ExceptionAction.ExitVM) {
                TTY.printf("WARNING: Ignoring %s=%s since %s=true has been explicitly specified.%n", GraalCompilerOptions.CompilationFailureAction.getName(), GraalCompilerOptions.CompilationFailureAction.getValue(options), GraalCompilerOptions.ExitVMOnException.getName());
            }
            return ExceptionAction.ExitVM;
        }
        return (ExceptionAction)((Object)GraalCompilerOptions.CompilationFailureAction.getValue(options));
    }

    protected abstract T performCompilation(DebugContext var1);

    public abstract String toString();

    protected abstract DebugContext createRetryDebugContext(DebugContext var1, OptionValues var2, PrintStream var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public final T run(DebugContext initialDebug) {
        try {
            return this.performCompilation(initialDebug);
        }
        catch (Throwable cause) {
            OptionValues initialOptions = initialDebug.getOptions();
            EnumOptionKey<ExceptionAction> enumOptionKey = GraalCompilerOptions.CompilationFailureAction;
            synchronized (enumOptionKey) {
                T t;
                Throwable throwable;
                DebugContext retryDebug;
                PrintStream ps;
                ByteArrayOutputStream logBaos;
                File retryLogFile;
                ExceptionAction action;
                block114: {
                    block115: {
                        String message;
                        action = this.lookupAction(initialOptions, cause);
                        action = this.adjustAction(initialOptions, action);
                        if (action == ExceptionAction.Silent) {
                            return this.handleException(cause);
                        }
                        if (action == ExceptionAction.Print) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            try (PrintStream ps2 = new PrintStream(baos);){
                                ps2.printf("%s: Compilation of %s failed: ", Thread.currentThread(), this);
                                cause.printStackTrace(ps2);
                                ps2.printf("To disable compilation failure notifications, set %s to %s (e.g., -Dgraal.%s=%s).%n", new Object[]{GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Silent, GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Silent});
                                ps2.printf("To capture more information for diagnosing or reporting a compilation failure, set %s to %s or %s (e.g., -Dgraal.%s=%s).%n", new Object[]{GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Diagnose, ExceptionAction.ExitVM, GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Diagnose});
                            }
                            TTY.print(baos.toString());
                            return this.handleException(cause);
                        }
                        if (DebugOptions.Dump.hasBeenSet(initialOptions)) {
                            return this.handleException(cause);
                        }
                        File dumpPath = null;
                        try {
                            String dir = this.outputDirectory.getPath();
                            if (dir != null) {
                                String dumpName = PathUtilities.sanitizeFileName(this.toString());
                                dumpPath = new File(dir, dumpName);
                                dumpPath.mkdirs();
                                if (!dumpPath.exists()) {
                                    TTY.println("Warning: could not create diagnostics directory " + dumpPath);
                                    dumpPath = null;
                                }
                            }
                        }
                        catch (Throwable t2) {
                            TTY.println("Warning: could not create Graal diagnostic directory");
                            t2.printStackTrace(TTY.out);
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try (PrintStream ps3 = new PrintStream(baos);){
                            ps3.println("[[[Graal compilation failure]]]");
                            ps3.printf("%s: Compilation of %s failed:%n", Thread.currentThread(), this);
                            cause.printStackTrace(ps3);
                            ps3.printf("To disable compilation failure notifications, set %s to %s (e.g., -Dgraal.%s=%s).%n", new Object[]{GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Silent, GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Silent});
                            ps3.printf("To print a message for a compilation failure without retrying the compilation, set %s to %s (e.g., -Dgraal.%s=%s).%n", new Object[]{GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Print, GraalCompilerOptions.CompilationFailureAction.getName(), ExceptionAction.Print});
                            if (dumpPath != null) {
                                ps3.println("Retrying compilation of " + this);
                            } else {
                                ps3.println("Not retrying compilation of " + this + " as the dump path could not be created.");
                            }
                            message = baos.toString();
                        }
                        TTY.print(message);
                        if (dumpPath == null) {
                            return this.handleException(cause);
                        }
                        retryLogFile = new File(dumpPath, "retry.log");
                        try (PrintStream ps4 = new PrintStream(new FileOutputStream(retryLogFile));){
                            ps4.print(message);
                        }
                        catch (IOException ioe) {
                            TTY.printf("Error writing to %s: %s%n", retryLogFile, ioe);
                        }
                        OptionValues retryOptions = new OptionValues(initialOptions, DebugOptions.Dump, ":" + DebugOptions.DiagnoseDumpLevel.getValue(initialOptions), DebugOptions.MethodFilter, null, DebugOptions.DumpPath, dumpPath.getPath(), GraalOptions.TrackNodeSourcePosition, true);
                        logBaos = new ByteArrayOutputStream();
                        ps = new PrintStream(logBaos);
                        retryDebug = this.createRetryDebugContext(initialDebug, retryOptions, ps);
                        throwable = null;
                        T res = this.performCompilation(retryDebug);
                        ps.println("There was no exception during retry.");
                        this.maybeExitVM(action);
                        t = res;
                        if (retryDebug == null) break block114;
                        if (throwable == null) break block115;
                        try {
                            retryDebug.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block114;
                    }
                    retryDebug.close();
                }
                ps.close();
                try (FileOutputStream fos = new FileOutputStream(retryLogFile, true);){
                    fos.write(logBaos.toByteArray());
                }
                catch (Throwable e) {
                    TTY.printf("Error writing to %s: %s%n", retryLogFile, e);
                }
                return t;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (retryDebug != null) {
                                        if (throwable != null) {
                                            try {
                                                retryDebug.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            retryDebug.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (Throwable e) {
                                ps.println("Exception during retry:");
                                e.printStackTrace(ps);
                                T res = this.handleException(cause);
                                this.maybeExitVM(action);
                                T t3 = res;
                                ps.close();
                                try (FileOutputStream fos = new FileOutputStream(retryLogFile, true);){
                                    fos.write(logBaos.toByteArray());
                                }
                                catch (Throwable e2) {
                                    TTY.printf("Error writing to %s: %s%n", retryLogFile, e2);
                                }
                                return t3;
                            }
                        }
                        catch (Throwable throwable6) {
                            ps.close();
                            try (FileOutputStream fos = new FileOutputStream(retryLogFile, true);){
                                fos.write(logBaos.toByteArray());
                            }
                            catch (Throwable e) {
                                TTY.printf("Error writing to %s: %s%n", retryLogFile, e);
                            }
                            throw throwable6;
                        }
                    }
                }
            }
        }
    }

    protected abstract void exitHostVM(int var1);

    private void maybeExitVM(ExceptionAction action) {
        if (action == ExceptionAction.ExitVM) {
            TTY.println("Exiting VM after retry compilation of " + this);
            this.exitHostVM(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionAction adjustAction(OptionValues initialOptions, ExceptionAction initialAction) {
        ExceptionAction action;
        int maxProblems = GraalCompilerOptions.MaxCompilationProblemsPerAction.getValue(initialOptions);
        if (action != ExceptionAction.ExitVM) {
            Map<ExceptionAction, Integer> map = this.problemsHandledPerAction;
            synchronized (map) {
                int problems;
                for (action = initialAction; action != ExceptionAction.Silent && (problems = this.problemsHandledPerAction.getOrDefault((Object)action, 0).intValue()) >= maxProblems; action = action.quieter()) {
                    if (problems != maxProblems) continue;
                    TTY.printf("Warning: adjusting %s from %s to %s after %s (%d) failed compilations%n", new Object[]{GraalCompilerOptions.CompilationFailureAction, action, action.quieter(), GraalCompilerOptions.MaxCompilationProblemsPerAction, maxProblems});
                    this.problemsHandledPerAction.put(action, problems + 1);
                }
                this.problemsHandledPerAction.put(action, this.problemsHandledPerAction.getOrDefault((Object)action, 0) + 1);
            }
        }
        return action;
    }

    public static final class ExceptionAction
    extends Enum<ExceptionAction> {
        public static final /* enum */ ExceptionAction Silent = new ExceptionAction();
        public static final /* enum */ ExceptionAction Print = new ExceptionAction();
        public static final /* enum */ ExceptionAction Diagnose = new ExceptionAction();
        public static final /* enum */ ExceptionAction ExitVM = new ExceptionAction();
        private static final ExceptionAction[] VALUES;
        private static final /* synthetic */ ExceptionAction[] $VALUES;

        public static ExceptionAction[] values() {
            return (ExceptionAction[])$VALUES.clone();
        }

        public static ExceptionAction valueOf(String name) {
            return Enum.valueOf(ExceptionAction.class, name);
        }

        ExceptionAction quieter() {
            assert (Silent.ordinal() == 0);
            int index = Math.max(this.ordinal() - 1, 0);
            return VALUES[index];
        }

        static {
            $VALUES = new ExceptionAction[]{Silent, Print, Diagnose, ExitVM};
            VALUES = ExceptionAction.values();
        }
    }
}

