/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class AMD64Assembler
extends AMD64BaseAssembler {
    private final boolean useBranchesWithin32ByteBoundary;
    protected CodePatchShifter codePatchShifter = null;
    protected static final int P_0F = 15;
    protected static final int P_0F38 = 14351;
    protected static final int P_0F3A = 14863;
    public static final int JCC_ERRATUM_MITIGATION_BOUNDARY = 32;
    public static final int OPCODE_IN_BYTES = 1;
    public static final int MODRM_IN_BYTES = 1;

    public AMD64Assembler(TargetDescription target) {
        super(target);
        this.useBranchesWithin32ByteBoundary = false;
    }

    public AMD64Assembler(TargetDescription target, OptionValues optionValues) {
        super(target);
        this.useBranchesWithin32ByteBoundary = Options.UseBranchesWithin32ByteBoundary.getValue(optionValues);
    }

    public AMD64Assembler(TargetDescription target, OptionValues optionValues, boolean hasIntelJccErratum) {
        super(target);
        this.useBranchesWithin32ByteBoundary = Options.UseBranchesWithin32ByteBoundary.hasBeenSet(optionValues) ? Options.UseBranchesWithin32ByteBoundary.getValue(optionValues) : hasIntelJccErratum;
    }

    public void setCodePatchShifter(CodePatchShifter codePatchShifter) {
        assert (this.codePatchShifter == null) : "overwriting existing value";
        this.codePatchShifter = codePatchShifter;
    }

    public final void addl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void addl(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void addpd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addpd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void addsd(Register dst, Register src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void addsd(Register dst, AMD64Address src) {
        SSEOp.ADD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    private void addrNop4() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(64);
        this.emitByte(0);
    }

    private void addrNop5() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(68);
        this.emitByte(0);
        this.emitByte(0);
    }

    private void addrNop7() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(128);
        this.emitInt(0);
    }

    private void addrNop8() {
        this.emitByte(15);
        this.emitByte(31);
        this.emitByte(132);
        this.emitByte(0);
        this.emitInt(0);
    }

    public final void andl(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void andl(Register dst, Register src) {
        AMD64BinaryArithmetic.AND.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void andpd(Register dst, Register src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void andpd(Register dst, AMD64Address src) {
        SSEOp.AND.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void bsfq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(188);
        this.emitModRM(dst, src);
    }

    public final void bsrl(Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(189);
        this.emitModRM(dst, src);
    }

    public final void bswapl(Register reg) {
        this.prefix(reg);
        this.emitByte(15);
        this.emitModRM(1, reg);
    }

    public final void cdql() {
        this.emitByte(153);
    }

    public final void cmovl(ConditionFlag cc, Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void cmovl(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void cmpb(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.byteRmOp.emit(this, AMD64BaseAssembler.OperandSize.BYTE, dst, src);
    }

    public final void cmpw(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.WORD, dst, src);
    }

    public final void cmpl(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpl(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cmpl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void cmpxchgb(Register reg, AMD64Address adr) {
        this.prefixb(adr, reg);
        this.emitByte(15);
        this.emitByte(176);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cmpxchgw(Register reg, AMD64Address adr) {
        this.emitByte(102);
        this.prefix(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cmpxchgl(Register reg, AMD64Address adr) {
        this.prefix(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cvtsi2sdl(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void cvttsd2sil(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void decl(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void divsd(Register dst, Register src) {
        SSEOp.DIV.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void hlt() {
        this.emitByte(244);
    }

    public final void imull(Register dst, Register src, int value) {
        if (NumUtil.isByte(value)) {
            AMD64RMIOp.IMUL_SX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        } else {
            AMD64RMIOp.IMUL.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src, value);
        }
    }

    public final void incl(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte) {
        boolean needsRex = AMD64Assembler.needsRex(dst, dstIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, Register src, boolean srcIsByte) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src, srcIsByte);
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected static int getPrefixInBytes(AMD64BaseAssembler.OperandSize size, Register dst, boolean dstIsByte, AMD64Address src) {
        boolean needsRex;
        boolean bl = needsRex = AMD64Assembler.needsRex(dst, dstIsByte) || AMD64Assembler.needsRex(src.getBase()) || AMD64Assembler.needsRex(src.getIndex());
        if (size == AMD64BaseAssembler.OperandSize.WORD) {
            return needsRex ? 2 : 1;
        }
        return size == AMD64BaseAssembler.OperandSize.QWORD || needsRex ? 1 : 0;
    }

    protected boolean mayCrossBoundary(int opStart, int opEnd) {
        return opStart / 32 != (opEnd - 1) / 32 || opEnd % 32 == 0;
    }

    private static int bytesUntilBoundary(int pos) {
        return 32 - pos % 32;
    }

    protected boolean ensureWithinBoundary(int opStart) {
        if (this.useBranchesWithin32ByteBoundary) assert (!this.mayCrossBoundary(opStart, this.position()));
        return true;
    }

    protected final void testAndAlign(int bytesToEmit) {
        int afterNextOp;
        int beforeNextOp;
        if (this.useBranchesWithin32ByteBoundary && this.mayCrossBoundary(beforeNextOp = this.position(), afterNextOp = beforeNextOp + bytesToEmit)) {
            int bytesToShift = AMD64Assembler.bytesUntilBoundary(beforeNextOp);
            this.nop(bytesToShift);
            if (this.codePatchShifter != null) {
                this.codePatchShifter.shift(beforeNextOp, bytesToShift);
            }
        }
    }

    public void jcc(ConditionFlag cc, int jumpTarget, boolean forceDisp32) {
        int shortSize = 2;
        int longSize = 6;
        long disp = jumpTarget - this.position();
        if (!forceDisp32 && NumUtil.isByte(disp - 2L)) {
            this.testAndAlign(2);
            disp = jumpTarget - this.position();
            if (NumUtil.isByte(disp - 2L)) {
                this.emitByte(0x70 | cc.getValue());
                this.emitByte((int)(disp - 2L & 0xFFL));
                return;
            }
        }
        assert (forceDisp32 || NumUtil.isInt(disp - 6L)) : "must be 32bit offset (call4)";
        this.testAndAlign(6);
        disp = jumpTarget - this.position();
        this.emitByte(15);
        this.emitByte(0x80 | cc.getValue());
        this.emitInt((int)(disp - 6L));
    }

    public final void jcc(ConditionFlag cc, Label l) {
        assert (0 <= cc.getValue() && cc.getValue() < 16) : "illegal cc";
        if (l.isBound()) {
            this.jcc(cc, l.position(), false);
        } else {
            this.testAndAlign(6);
            l.addPatchAt(this.position(), this);
            this.emitByte(15);
            this.emitByte(0x80 | cc.getValue());
            this.emitInt(0);
        }
    }

    public final void jccb(ConditionFlag cc, Label l) {
        int shortSize = 2;
        this.testAndAlign(2);
        if (l.isBound()) {
            int entry = l.position();
            assert (NumUtil.isByte(entry - (this.position() + 2))) : "Displacement too large for a short jmp";
            long disp = entry - this.position();
            this.emitByte(0x70 | cc.getValue());
            this.emitByte((int)(disp - 2L & 0xFFL));
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(0x70 | cc.getValue());
            this.emitByte(0);
        }
    }

    public final void jcc(ConditionFlag cc, Label branchTarget, boolean isShortJmp) {
        if (branchTarget == null) {
            this.jcc(cc, 0, true);
        } else if (isShortJmp) {
            this.jccb(cc, branchTarget);
        } else {
            this.jcc(cc, branchTarget);
        }
    }

    public final int jmp(int jumpTarget, boolean forceDisp32) {
        long disp;
        int pos;
        int shortSize = 2;
        int longSize = 5;
        if (!forceDisp32) {
            this.testAndAlign(2);
            pos = this.position();
            disp = jumpTarget - pos;
            if (NumUtil.isByte(disp - 2L)) {
                this.emitByte(235);
                this.emitByte((int)(disp - 2L & 0xFFL));
                return pos;
            }
        }
        this.testAndAlign(5);
        pos = this.position();
        disp = jumpTarget - pos;
        this.emitByte(233);
        this.emitInt((int)(disp - 5L));
        return pos;
    }

    @Override
    public final void jmp(Label l) {
        if (l.isBound()) {
            this.jmp(l.position(), false);
        } else {
            this.testAndAlign(5);
            l.addPatchAt(this.position(), this);
            this.emitByte(233);
            this.emitInt(0);
        }
    }

    protected final void jmpWithoutAlignment(Register entry) {
        this.prefix(entry);
        this.emitByte(255);
        this.emitModRM(4, entry);
    }

    public final void jmp(Register entry) {
        int bytesToEmit = AMD64Assembler.needsRex(entry) ? 3 : 2;
        this.testAndAlign(bytesToEmit);
        int beforeJmp = this.position();
        this.jmpWithoutAlignment(entry);
        assert (beforeJmp + bytesToEmit == this.position());
    }

    public final void jmp(AMD64Address adr) {
        int bytesToEmit = AMD64Assembler.getPrefixInBytes(AMD64BaseAssembler.OperandSize.DWORD, adr) + 1 + AMD64Assembler.addressInBytes(adr);
        this.testAndAlign(bytesToEmit);
        int beforeJmp = this.position();
        this.prefix(adr);
        this.emitByte(255);
        this.emitOperandHelper(AMD64.rsp, adr, 0);
        assert (beforeJmp + bytesToEmit == this.position());
    }

    protected static int addressInBytes(AMD64Address addr) {
        Register base = addr.getBase();
        Register index = addr.getIndex();
        int disp = addr.getDisplacement();
        if (base.equals((Object)AMD64.rip)) {
            return 5;
        }
        if (base.isValid()) {
            boolean isZeroDisplacement;
            boolean bl = isZeroDisplacement = disp == 0 && !base.equals((Object)AMD64.rbp) && !base.equals((Object)AMD64.r13);
            if (index.isValid()) {
                if (isZeroDisplacement) {
                    return 2;
                }
                if (NumUtil.isByte(disp)) {
                    return 3;
                }
                return 6;
            }
            if (base.equals((Object)AMD64.rsp) || base.equals((Object)AMD64.r12)) {
                if (disp == 0) {
                    return 2;
                }
                if (NumUtil.isByte(disp)) {
                    return 3;
                }
                return 6;
            }
            if (isZeroDisplacement) {
                return 1;
            }
            if (NumUtil.isByte(disp)) {
                return 2;
            }
            return 5;
        }
        return 6;
    }

    public final void jmpb(Label l) {
        int shortSize = 2;
        this.testAndAlign(2);
        if (l.isBound()) {
            int displacement = l.position() - this.position() - 2;
            GraalError.guarantee(NumUtil.isByte(displacement), "Displacement too large to be encoded as a byte: %d", (Object)displacement);
            this.emitByte(235);
            this.emitByte(displacement & 0xFF);
        } else {
            l.addPatchAt(this.position(), this);
            this.emitByte(235);
            this.emitByte(0);
        }
    }

    public final void lead(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leaq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(141);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void leave() {
        this.emitByte(201);
    }

    public final void lock() {
        this.emitByte(240);
    }

    public final void movapd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(40);
        this.emitModRM(dst, src);
    }

    public final void movaps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(40);
        this.emitModRM(dst, src);
    }

    public final void movb(Register dst, AMD64Address src) {
        this.prefixb(src, dst);
        this.emitByte(138);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movb(AMD64Address dst, int imm8) {
        this.prefix(dst);
        this.emitByte(198);
        this.emitOperandHelper(0, dst, 1);
        this.emitByte(imm8);
    }

    public final void movb(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, src)) : "must have byte register";
        this.prefixb(dst, src);
        this.emitByte(136);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movl(Register dst, int imm32) {
        this.movl(dst, imm32, false);
    }

    public final void movl(Register dst, int imm32, boolean annotateImm) {
        int insnPos = this.position();
        this.prefix(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitInt(imm32);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movl(Register dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(139);
        this.emitModRM(dst, src);
    }

    public final void movl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movl(Register dst, AMD64Address src, boolean wide) {
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, wide, 0);
    }

    public final void movl(AMD64Address dst, int imm32) {
        this.prefix(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 4);
        this.emitInt(imm32);
    }

    public final void movl(AMD64Address dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(137);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movlpd(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(18);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movlhps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, src, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(22);
        this.emitModRM(dst, src);
    }

    public final void movq(Register dst, AMD64Address src) {
        this.movq(dst, src, false);
    }

    public final void movq(Register dst, AMD64Address src, boolean force4BytesDisplacement) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst)) {
            this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
            this.emitByte(126);
            this.emitOperandHelper(dst, src, force4BytesDisplacement, 0);
        } else {
            this.prefixq(src, dst);
            this.emitByte(139);
            this.emitOperandHelper(dst, src, force4BytesDisplacement, 0);
        }
    }

    public final void movq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.CPU, src));
        this.prefixq(dst, src);
        this.emitByte(139);
        this.emitModRM(dst, src);
    }

    public final void movq(AMD64Address dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, src)) {
            this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
            this.emitByte(214);
            this.emitOperandHelper(src, dst, 0);
        } else {
            this.prefixq(dst, src);
            this.emitByte(137);
            this.emitOperandHelper(src, dst, 0);
        }
    }

    public final void movsbl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(190);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movsbl(Register dst, Register src) {
        this.prefix(dst, false, src, true);
        this.emitByte(15);
        this.emitByte(190);
        this.emitModRM(dst, src);
    }

    public final void movsbq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(15);
        this.emitByte(190);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movsbq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(190);
        this.emitModRM(dst, src);
    }

    public final void movsd(Register dst, Register src) {
        AMD64RMOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movsd(AMD64Address dst, Register src) {
        AMD64MROp.MOVSD.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void movss(Register dst, Register src) {
        AMD64RMOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movss(AMD64Address dst, Register src) {
        AMD64MROp.MOVSS.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void mulpd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulpd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void mulsd(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulsd(Register dst, AMD64Address src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void mulss(Register dst, Register src) {
        SSEOp.MUL.emit(this, AMD64BaseAssembler.OperandSize.SS, dst, src);
    }

    public final void movswl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movswq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVSX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movw(AMD64Address dst, int imm16) {
        this.emitByte(102);
        this.prefix(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 2);
        this.emitShort(imm16);
    }

    public final void movw(AMD64Address dst, Register src) {
        this.emitByte(102);
        this.prefix(dst, src);
        this.emitByte(137);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movw(Register dst, AMD64Address src) {
        this.emitByte(102);
        this.prefix(src, dst);
        this.emitByte(139);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movzbl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(15);
        this.emitByte(182);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movzbl(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzbq(Register dst, Register src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzbq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZXB.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movzwl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movzwq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVZX.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void negl(Register dst) {
        AMD64MOp.NEG.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void notl(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void notq(Register dst) {
        AMD64MOp.NOT.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    @Override
    public final void ensureUniquePC() {
        this.nop();
    }

    public final void nop() {
        this.nop(1);
    }

    public void nop(int count) {
        int i = count;
        this.intelNops(i);
    }

    private void amdNops(int count) {
        int i;
        for (i = count; i >= 22; i -= 11) {
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.addrNop8();
        }
        switch (i) {
            case 21: {
                i -= 11;
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 19: 
            case 20: {
                i -= 10;
                this.emitByte(102);
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 17: 
            case 18: {
                i -= 9;
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 15: 
            case 16: {
                i -= 8;
                this.addrNop8();
                break;
            }
            case 13: 
            case 14: {
                i -= 7;
                this.addrNop7();
                break;
            }
            case 12: {
                i -= 6;
                this.emitByte(102);
                this.addrNop5();
                break;
            }
            default: {
                assert (i < 12);
                break;
            }
        }
        switch (i) {
            case 11: {
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 10: {
                this.emitByte(102);
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 9: {
                this.emitByte(102);
                this.addrNop8();
                break;
            }
            case 8: {
                this.addrNop8();
                break;
            }
            case 7: {
                this.addrNop7();
                break;
            }
            case 6: {
                this.emitByte(102);
                this.addrNop5();
                break;
            }
            case 5: {
                this.addrNop5();
                break;
            }
            case 4: {
                this.addrNop4();
                break;
            }
            case 3: {
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(144);
                break;
            }
            case 2: {
                this.emitByte(102);
                this.emitByte(144);
                break;
            }
            case 1: {
                this.emitByte(144);
                break;
            }
            default: {
                assert (i == 0);
                break;
            }
        }
    }

    private void intelNops(int count) {
        int i;
        for (i = count; i >= 15; i -= 15) {
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.addrNop8();
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(102);
            this.emitByte(144);
        }
        switch (i) {
            case 14: {
                this.emitByte(102);
            }
            case 13: {
                this.emitByte(102);
            }
            case 12: {
                this.addrNop8();
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(102);
                this.emitByte(144);
                break;
            }
            case 11: {
                this.emitByte(102);
            }
            case 10: {
                this.emitByte(102);
            }
            case 9: {
                this.emitByte(102);
            }
            case 8: {
                this.addrNop8();
                break;
            }
            case 7: {
                this.addrNop7();
                break;
            }
            case 6: {
                this.emitByte(102);
            }
            case 5: {
                this.addrNop5();
                break;
            }
            case 4: {
                this.addrNop4();
                break;
            }
            case 3: {
                this.emitByte(102);
            }
            case 2: {
                this.emitByte(102);
            }
            case 1: {
                this.emitByte(144);
                break;
            }
            default: {
                assert (i == 0);
                break;
            }
        }
    }

    public final void orl(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void orl(Register dst, int imm32) {
        AMD64BinaryArithmetic.OR.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void packuswb(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(103);
        this.emitModRM(dst, src);
    }

    public final void pop(Register dst) {
        this.prefix(dst);
        this.emitByte(88 + AMD64Assembler.encode(dst));
    }

    public void popfq() {
        this.emitByte(157);
    }

    public final void ptest(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(23);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(116);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(117);
        this.emitModRM(dst, src);
    }

    public final void pcmpeqd(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (dst.getRegisterCategory().equals((Object)AMD64.XMM) && src.getRegisterCategory().equals((Object)AMD64.XMM));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(118);
        this.emitModRM(dst, src);
    }

    public final void pcmpestri(Register dst, AMD64Address src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(97);
        this.emitOperandHelper(dst, src, 0);
        this.emitByte(imm8);
    }

    public final void pcmpestri(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE4_2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14863, false);
        this.emitByte(97);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pmovmskb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(215);
        this.emitModRM(dst, src);
    }

    private void pmovSZx(Register dst, AMD64Address src, int op) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(op);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void pmovsxbw(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 32);
    }

    public final void pmovsxbd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 33);
    }

    public final void pmovsxbq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 34);
    }

    public final void pmovsxwd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 35);
    }

    public final void pmovsxwq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 36);
    }

    public final void pmovsxdq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 37);
    }

    public final void pmovzxbw(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 48);
    }

    public final void pmovzxbd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 49);
    }

    public final void pmovzxbq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 50);
    }

    public final void pmovzxwd(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 51);
    }

    public final void pmovzxwq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 52);
    }

    public final void pmovzxdq(Register dst, AMD64Address src) {
        this.pmovSZx(dst, src, 53);
    }

    public final void pmovzxbw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE4_1));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(48);
        this.emitModRM(dst, src);
    }

    public final void push(Register src) {
        this.prefix(src);
        this.emitByte(80 + AMD64Assembler.encode(src));
    }

    public void pushfq() {
        this.emitByte(156);
    }

    public final void paddd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(254);
        this.emitModRM(dst, src);
    }

    public final void paddq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(212);
        this.emitModRM(dst, src);
    }

    public final void pextrw(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.CPU, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(197);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pinsrw(Register dst, Register src, int imm8) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(196);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void por(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(235);
        this.emitModRM(dst, src);
    }

    public final void pand(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(219);
        this.emitModRM(dst, src);
    }

    public final void pxor(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(239);
        this.emitModRM(dst, src);
    }

    public final void pslld(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm6, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(6, dst);
        this.emitByte(imm8 & 0xFF);
    }

    public final void psllq(Register dst, Register shift) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, shift));
        this.simdPrefix(dst, dst, shift, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(243);
        this.emitModRM(dst, shift);
    }

    public final void psllq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm6, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(6, dst);
        this.emitByte(imm8);
    }

    public final void psrad(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm4, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(4, dst);
        this.emitByte(imm8);
    }

    public final void psrld(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm2, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(114);
        this.emitModRM(2, dst);
        this.emitByte(imm8);
    }

    public final void psrlq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm2, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(2, dst);
        this.emitByte(imm8);
    }

    public final void psrldq(Register dst, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(AMD64.xmm3, dst, dst, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(115);
        this.emitModRM(3, dst);
        this.emitByte(imm8);
    }

    public final void pshufb(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSSE3));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 14351, false);
        this.emitByte(0);
        this.emitModRM(dst, src);
    }

    public final void pshuflw(Register dst, Register src, int imm8) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SD, 15, false);
        this.emitByte(112);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void pshufd(Register dst, Register src, int imm8) {
        assert (NumUtil.isUByte(imm8)) : "invalid value";
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(112);
        this.emitModRM(dst, src);
        this.emitByte(imm8);
    }

    public final void psubd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(250);
        this.emitModRM(dst, src);
    }

    public final void punpcklbw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE2));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(96);
        this.emitModRM(dst, src);
    }

    public final void rcpps(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PS, 15, false);
        this.emitByte(83);
        this.emitModRM(dst, src);
    }

    public final void ret(int imm16) {
        if (imm16 == 0) {
            this.testAndAlign(1);
            this.emitByte(195);
        } else {
            this.testAndAlign(3);
            this.emitByte(194);
            this.emitShort(imm16);
        }
    }

    public final void sarl(Register dst, int imm8) {
        this.prefix(dst);
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(7, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(7, dst);
            this.emitByte(imm8);
        }
    }

    public final void shll(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefix(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(4, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(4, dst);
            this.emitByte(imm8);
        }
    }

    public final void shll(Register dst) {
        this.prefix(dst);
        this.emitByte(211);
        this.emitModRM(4, dst);
    }

    public final void shlxl(Register dst, Register src1, Register src2) {
        VexGeneralPurposeRMVOp.SHLX.emit(this, AVXKind.AVXSize.DWORD, dst, src1, src2);
    }

    public final void shrl(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefix(dst);
        this.emitByte(193);
        this.emitModRM(5, dst);
        this.emitByte(imm8);
    }

    public final void shrl(Register dst) {
        this.prefix(dst);
        this.emitByte(211);
        this.emitModRM(5, dst);
    }

    public final void subl(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
    }

    public final void subl(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void subpd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void subsd(Register dst, Register src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void subsd(Register dst, AMD64Address src) {
        SSEOp.SUB.emit(this, AMD64BaseAssembler.OperandSize.SD, dst, src);
    }

    public final void testl(Register dst, int imm32) {
        if (dst.encoding == 0) {
            this.emitByte(169);
            this.emitInt(imm32);
        } else {
            AMD64MIOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, imm32);
        }
    }

    public final void testl(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void testl(Register dst, AMD64Address src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void unpckhpd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(21);
        this.emitModRM(dst, src);
    }

    public final void unpcklpd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, dst, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(20);
        this.emitModRM(dst, src);
    }

    public final void xorl(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void xorq(Register dst, Register src) {
        AMD64BinaryArithmetic.XOR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void xorpd(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PD, dst, src);
    }

    public final void xorps(Register dst, Register src) {
        SSEOp.XOR.emit(this, AMD64BaseAssembler.OperandSize.PS, dst, src);
    }

    public final void decl(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void incl(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst);
    }

    public final void addq(Register dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.ADD.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void addq(Register dst, Register src) {
        AMD64BinaryArithmetic.ADD.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void addq(AMD64Address dst, Register src) {
        AMD64BinaryArithmetic.ADD.mrOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void andq(Register dst, int imm32) {
        AMD64BinaryArithmetic.AND.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void bsrq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(189);
        this.emitModRM(dst, src);
    }

    public final void bswapq(Register reg) {
        this.prefixq(reg);
        this.emitByte(15);
        this.emitByte(200 + AMD64Assembler.encode(reg));
    }

    public final void cdqq() {
        this.rexw();
        this.emitByte(153);
    }

    public final void repStosb() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(170);
    }

    public final void repStosq() {
        this.emitByte(243);
        this.rexw();
        this.emitByte(171);
    }

    public final void cmovq(ConditionFlag cc, Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitModRM(dst, src);
    }

    public final void setb(ConditionFlag cc, Register dst) {
        this.prefix(dst, true);
        this.emitByte(15);
        this.emitByte(0x90 | cc.getValue());
        this.emitModRM(0, dst);
    }

    public final void cmovq(ConditionFlag cc, Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(15);
        this.emitByte(0x40 | cc.getValue());
        this.emitOperandHelper(dst, src, 0);
    }

    public final void cmpq(Register dst, int imm32) {
        AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void cmpq(Register dst, Register src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpq(Register dst, AMD64Address src) {
        AMD64BinaryArithmetic.CMP.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cmpxchgq(Register reg, AMD64Address adr) {
        this.prefixq(adr, reg);
        this.emitByte(15);
        this.emitByte(177);
        this.emitOperandHelper(reg, adr, 0);
    }

    public final void cvtdq2pd(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(230);
        this.emitModRM(dst, src);
    }

    public final void cvtsi2sdq(Register dst, Register src) {
        SSEOp.CVTSI2SD.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttsd2siq(Register dst, Register src) {
        SSEOp.CVTTSD2SI.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void cvttpd2dq(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.PD, 15, false);
        this.emitByte(230);
        this.emitModRM(dst, src);
    }

    public final void decq(Register dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void decq(AMD64Address dst) {
        AMD64MOp.DEC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void imulq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(175);
        this.emitModRM(dst, src);
    }

    public final void incq(Register dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void incq(AMD64Address dst) {
        AMD64MOp.INC.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst);
    }

    public final void movq(Register dst, long imm64) {
        this.movq(dst, imm64, false);
    }

    public final void movq(Register dst, long imm64, boolean annotateImm) {
        int insnPos = this.position();
        this.prefixq(dst);
        this.emitByte(184 + AMD64Assembler.encode(dst));
        int immPos = this.position();
        this.emitLong(imm64);
        int nextInsnPos = this.position();
        if (annotateImm && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
        }
    }

    public final void movslq(Register dst, int imm32) {
        this.prefixq(dst);
        this.emitByte(199);
        this.emitModRM(0, dst);
        this.emitInt(imm32);
    }

    public final void movdq(Register dst, AMD64Address src) {
        AMD64RMOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(AMD64Address dst, Register src) {
        AMD64MROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void movdq(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            AMD64RMOp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            AMD64MROp.MOVQ.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdl(Register dst, Register src) {
        if (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src)) {
            AMD64RMOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else if (AMD64Assembler.inRC(AMD64.XMM, src) && AMD64Assembler.inRC(AMD64.CPU, dst)) {
            AMD64MROp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
        } else {
            throw new InternalError("should not reach here");
        }
    }

    public final void movdl(Register dst, AMD64Address src) {
        AMD64RMOp.MOVD.emit(this, AMD64BaseAssembler.OperandSize.DWORD, dst, src);
    }

    public final void movddup(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.SSE3));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SD, 15, false);
        this.emitByte(18);
        this.emitModRM(dst, src);
    }

    public final void movdqu(Register dst, AMD64Address src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movdqu(Register dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(dst, Register.None, src, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(111);
        this.emitModRM(dst, src);
    }

    public final void movdqu(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.simdPrefix(src, Register.None, dst, AMD64BaseAssembler.OperandSize.SS, 15, false);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void movslq(AMD64Address dst, int imm32) {
        this.prefixq(dst);
        this.emitByte(199);
        this.emitOperandHelper(0, dst, 4);
        this.emitInt(imm32);
    }

    public final void movslq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(99);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void movslq(Register dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(99);
        this.emitModRM(dst, src);
    }

    public final void negq(Register dst) {
        this.prefixq(dst);
        this.emitByte(247);
        this.emitModRM(3, dst);
    }

    public final void orq(Register dst, Register src) {
        AMD64BinaryArithmetic.OR.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void shlq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(4, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(4, dst);
            this.emitByte(imm8);
        }
    }

    public final void shlq(Register dst) {
        this.prefixq(dst);
        this.emitByte(211);
        this.emitModRM(4, dst);
    }

    public final void shrq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(5, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(5, dst);
            this.emitByte(imm8);
        }
    }

    public final void shrq(Register dst) {
        this.prefixq(dst);
        this.emitByte(211);
        this.emitModRM(5, dst);
    }

    public final void sarq(Register dst, int imm8) {
        assert (NumUtil.isShiftCount(imm8 >> 1)) : "illegal shift count";
        this.prefixq(dst);
        if (imm8 == 1) {
            this.emitByte(209);
            this.emitModRM(7, dst);
        } else {
            this.emitByte(193);
            this.emitModRM(7, dst);
            this.emitByte(imm8);
        }
    }

    public final void sbbq(Register dst, Register src) {
        AMD64BinaryArithmetic.SBB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void subq(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(AMD64Address dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, NumUtil.isByte(imm32)).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subqWide(Register dst, int imm32) {
        AMD64BinaryArithmetic.SUB.getMIOpcode(AMD64BaseAssembler.OperandSize.QWORD, false).emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, imm32);
    }

    public final void subq(Register dst, Register src) {
        AMD64BinaryArithmetic.SUB.rmOp.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void testq(Register dst, Register src) {
        AMD64RMOp.TEST.emit(this, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
    }

    public final void btrq(Register src, int imm8) {
        this.prefixq(src);
        this.emitByte(15);
        this.emitByte(186);
        this.emitModRM(6, src);
        this.emitByte(imm8);
    }

    public final void xaddb(AMD64Address dst, Register src) {
        this.prefixb(dst, src);
        this.emitByte(15);
        this.emitByte(192);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddw(AMD64Address dst, Register src) {
        this.emitByte(102);
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddl(AMD64Address dst, Register src) {
        this.prefix(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xaddq(AMD64Address dst, Register src) {
        this.prefixq(dst, src);
        this.emitByte(15);
        this.emitByte(193);
        this.emitOperandHelper(src, dst, 0);
    }

    public final void xchgb(Register dst, AMD64Address src) {
        this.prefixb(src, dst);
        this.emitByte(134);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgw(Register dst, AMD64Address src) {
        this.emitByte(102);
        this.prefix(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgl(Register dst, AMD64Address src) {
        this.prefix(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void xchgq(Register dst, AMD64Address src) {
        this.prefixq(src, dst);
        this.emitByte(135);
        this.emitOperandHelper(dst, src, 0);
    }

    public final void membar(int barriers) {
        if (this.target.isMP && (barriers & 4) != 0) {
            this.lock();
            this.addl(new AMD64Address(AMD64.rsp, 0), 0);
        }
    }

    @Override
    protected final void patchJumpTarget(int branch, int branchTarget) {
        int op = this.getByte(branch);
        assert (op == 232 || op == 0 || op == 233 || op == 235 || (op & 0xF0) == 112 || op == 15 && (this.getByte(branch + 1) & 0xF0) == 128) : "Invalid opcode at patch point branch=" + branch + ", branchTarget=" + branchTarget + ", op=" + op;
        if (op == 0) {
            int offsetToJumpTableBase = this.getShort(branch + 1);
            int jumpTableBase = branch - offsetToJumpTableBase;
            int imm32 = branchTarget - jumpTableBase;
            this.emitInt(imm32, branch);
        } else if (op == 235 || (op & 0xF0) == 112) {
            int imm8 = branchTarget - (branch + 2);
            GraalError.guarantee(NumUtil.isByte(imm8), "Displacement too large to be encoded as a byte: %d", (Object)imm8);
            this.emitByte(imm8, branch + 1);
        } else {
            int off = 1;
            if (op == 15) {
                off = 2;
            }
            int imm32 = branchTarget - (branch + 4 + off);
            this.emitInt(imm32, branch + off);
        }
    }

    public void nullCheck(AMD64Address address) {
        this.testl(AMD64.rax, address);
    }

    @Override
    public void align(int modulus) {
        if (this.position() % modulus != 0) {
            this.nop(modulus - this.position() % modulus);
        }
    }

    public final void call() {
        this.annotatePatchingImmediate(1, 4);
        this.emitByte(232);
        this.emitInt(0);
    }

    public final void call(Register src) {
        this.prefix(src);
        this.emitByte(255);
        this.emitModRM(2, src);
    }

    public final void int3() {
        this.emitByte(204);
    }

    public final void pause() {
        this.emitByte(243);
        this.emitByte(144);
    }

    private void emitx87(int b1, int b2, int i) {
        assert (0 <= i && i < 8) : "illegal stack offset";
        this.emitByte(b1);
        this.emitByte(b2 + i);
    }

    public final void fldd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(0, src, 0);
    }

    public final void flds(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(0, src, 0);
    }

    public final void fldln2() {
        this.emitByte(217);
        this.emitByte(237);
    }

    public final void fldlg2() {
        this.emitByte(217);
        this.emitByte(236);
    }

    public final void fyl2x() {
        this.emitByte(217);
        this.emitByte(241);
    }

    public final void fstps(AMD64Address src) {
        this.emitByte(217);
        this.emitOperandHelper(3, src, 0);
    }

    public final void fstpd(AMD64Address src) {
        this.emitByte(221);
        this.emitOperandHelper(3, src, 0);
    }

    private void emitFPUArith(int b1, int b2, int i) {
        assert (0 <= i && i < 8) : "illegal FPU register: " + i;
        this.emitByte(b1);
        this.emitByte(b2 + i);
    }

    public void ffree(int i) {
        this.emitFPUArith(221, 192, i);
    }

    public void fincstp() {
        this.emitByte(217);
        this.emitByte(247);
    }

    public void fxch(int i) {
        this.emitFPUArith(217, 200, i);
    }

    public void fnstswAX() {
        this.emitByte(223);
        this.emitByte(224);
    }

    public void fwait() {
        this.emitByte(155);
    }

    public void fprem() {
        this.emitByte(217);
        this.emitByte(248);
    }

    public final void fsin() {
        this.emitByte(217);
        this.emitByte(254);
    }

    public final void fcos() {
        this.emitByte(217);
        this.emitByte(255);
    }

    public final void fptan() {
        this.emitByte(217);
        this.emitByte(242);
    }

    public final void fstp(int i) {
        this.emitx87(221, 216, i);
    }

    @Override
    public AMD64Address makeAddress(Register base, int displacement) {
        return new AMD64Address(base, displacement);
    }

    @Override
    public AMD64Address getPlaceholder(int instructionStartPosition) {
        return new AMD64Address(AMD64.rip, Register.None, AMD64Address.Scale.Times1, 0, instructionStartPosition);
    }

    private void prefetchPrefix(AMD64Address src) {
        this.prefix(src);
        this.emitByte(15);
    }

    public void prefetchnta(AMD64Address src) {
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(0, src, 0);
    }

    void prefetchr(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AMD_3DNOW_PREFETCH));
        this.prefetchPrefix(src);
        this.emitByte(13);
        this.emitOperandHelper(0, src, 0);
    }

    public void prefetcht0(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(1, src, 0);
    }

    public void prefetcht1(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefetchPrefix(src);
        this.emitByte(24);
        this.emitOperandHelper(2, src, 0);
    }

    public void prefetcht2(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.SSE));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(24);
        this.emitOperandHelper(3, src, 0);
    }

    public void prefetchw(AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AMD_3DNOW_PREFETCH));
        this.prefix(src);
        this.emitByte(15);
        this.emitByte(13);
        this.emitOperandHelper(1, src, 0);
    }

    public void rdtsc() {
        this.emitByte(15);
        this.emitByte(49);
    }

    public void illegal() {
        this.emitByte(15);
        this.emitByte(11);
    }

    public void lfence() {
        this.emitByte(15);
        this.emitByte(174);
        this.emitByte(232);
    }

    public final void vptest(Register dst, Register src) {
        VexRMOp.VPTEST.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vpxor(Register dst, Register nds, Register src) {
        VexRVMOp.VPXOR.emit(this, AVXKind.AVXSize.YMM, dst, nds, src);
    }

    public final void vpxor(Register dst, Register nds, AMD64Address src) {
        VexRVMOp.VPXOR.emit(this, AVXKind.AVXSize.YMM, dst, nds, src);
    }

    public final void vmovdqu(Register dst, AMD64Address src) {
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vmovdqu(AMD64Address dst, Register src) {
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        VexMoveOp.VMOVDQU32.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vpmovzxbw(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX2));
        VexRMOp.VPMOVZXBW.emit(this, AVXKind.AVXSize.YMM, dst, src);
    }

    public final void vzeroupper() {
        this.emitVEX(0, 0, 1, 0, 0, 0, true);
        this.emitByte(119);
    }

    public final void kortestd(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2));
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 1, 1, 1, 1, true);
        this.emitByte(152);
        this.emitModRM(src1, src2);
    }

    public final void kortestq(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2));
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 0, 1, 1, 1, true);
        this.emitByte(152);
        this.emitModRM(src1, src2);
    }

    public final void kmovd(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, dst) || AMD64Assembler.inRC(AMD64.CPU, dst));
        assert (AMD64Assembler.inRC(AMD64.MASK, src) || AMD64Assembler.inRC(AMD64.CPU, src));
        assert (!AMD64Assembler.inRC(AMD64.CPU, dst) || !AMD64Assembler.inRC(AMD64.CPU, src));
        if (AMD64Assembler.inRC(AMD64.MASK, dst)) {
            if (AMD64Assembler.inRC(AMD64.MASK, src)) {
                this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 1, 1, 1, 1, true);
                this.emitByte(144);
                this.emitModRM(dst, src);
            } else {
                this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 3, 1, 0, 0, true);
                this.emitByte(146);
                this.emitModRM(dst, src);
            }
        } else if (AMD64Assembler.inRC(AMD64.MASK, src)) {
            this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 3, 1, 0, 0, true);
            this.emitByte(147);
            this.emitModRM(dst, src);
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    public final void kmovq(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, dst) || AMD64Assembler.inRC(AMD64.CPU, dst));
        assert (AMD64Assembler.inRC(AMD64.MASK, src) || AMD64Assembler.inRC(AMD64.CPU, src));
        assert (!AMD64Assembler.inRC(AMD64.CPU, dst) || !AMD64Assembler.inRC(AMD64.CPU, src));
        if (AMD64Assembler.inRC(AMD64.MASK, dst)) {
            if (AMD64Assembler.inRC(AMD64.MASK, src)) {
                this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 0, 1, 1, 1, true);
                this.emitByte(144);
                this.emitModRM(dst, src);
            } else {
                this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 3, 1, 1, 1, true);
                this.emitByte(146);
                this.emitModRM(dst, src);
            }
        } else if (AMD64Assembler.inRC(AMD64.MASK, src)) {
            this.vexPrefix(dst, Register.None, src, AVXKind.AVXSize.XMM, 3, 1, 1, 1, true);
            this.emitByte(147);
            this.emitModRM(dst, src);
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    public final void ktestd(Register src1, Register src2) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, src1) && AMD64Assembler.inRC(AMD64.MASK, src2));
        this.vexPrefix(src1, Register.None, src2, AVXKind.AVXSize.XMM, 1, 1, 1, 1, true);
        this.emitByte(153);
        this.emitModRM(src1, src2);
    }

    public final void evmovdqu64(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512F));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 2, 1, 1, 0, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu64(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512F));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovzxbw(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpcmpeqb(Register kdst, Register nds, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.XMM, nds));
        this.evexPrefix(kdst, Register.None, nds, src, AVXKind.AVXSize.ZMM, 1, 1, 0, 0, 0);
        this.emitByte(116);
        this.emitOperandHelper(kdst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(Register dst, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(Register dst, Register mask, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.MASK, mask));
        this.evexPrefix(dst, mask, Register.None, src, AVXKind.AVXSize.ZMM, 3, 1, 1, 1, 0);
        this.emitByte(111);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evmovdqu16(AMD64Address dst, Register mask, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, mask, Register.None, dst, AVXKind.AVXSize.ZMM, 3, 1, 1, 0, 0);
        this.emitByte(127);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.FVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpbroadcastw(Register dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, dst) && AMD64Assembler.inRC(AMD64.CPU, src));
        this.evexPrefix(dst, Register.None, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(123);
        this.emitModRM(dst, src);
    }

    public final void evpcmpuw(Register kdst, Register nds, Register src, int vcc) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.XMM, nds) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(kdst, Register.None, nds, src, AVXKind.AVXSize.ZMM, 1, 3, 1, 0, 0);
        this.emitByte(62);
        this.emitModRM(kdst, src);
        this.emitByte(vcc);
    }

    public final void evpcmpuw(Register kdst, Register mask, Register nds, Register src, int vcc) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, kdst) && AMD64Assembler.inRC(AMD64.MASK, mask));
        assert (AMD64Assembler.inRC(AMD64.XMM, nds) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(kdst, mask, nds, src, AVXKind.AVXSize.ZMM, 1, 3, 1, 0, 0);
        this.emitByte(62);
        this.emitModRM(kdst, src);
        this.emitByte(vcc);
    }

    public final void evpmovwb(AMD64Address dst, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, Register.None, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovwb(AMD64Address dst, Register mask, Register src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, src));
        this.evexPrefix(src, mask, Register.None, dst, AVXKind.AVXSize.ZMM, 2, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(src, dst, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public final void evpmovzxbw(Register dst, Register mask, AMD64Address src) {
        assert (this.supports(AMD64.CPUFeature.AVX512BW));
        assert (AMD64Assembler.inRC(AMD64.MASK, mask) && AMD64Assembler.inRC(AMD64.XMM, dst));
        this.evexPrefix(dst, mask, Register.None, src, AVXKind.AVXSize.ZMM, 1, 2, 0, 0, 0);
        this.emitByte(48);
        this.emitOperandHelper(dst, src, 0, AMD64BaseAssembler.EVEXTuple.HVM.getDisp8ScalingFactor(AVXKind.AVXSize.ZMM));
    }

    public static final class VexFloatCompareOp
    extends VexOp {
        public static final VexFloatCompareOp VCMPPS = new VexFloatCompareOp("VCMPPS", 0, 1, 0, 194);
        public static final VexFloatCompareOp VCMPPD = new VexFloatCompareOp("VCMPPD", 1, 1, 0, 194);
        public static final VexFloatCompareOp VCMPSS = new VexFloatCompareOp("VCMPSS", 3, 1, 0, 194);
        public static final VexFloatCompareOp VCMPSD = new VexFloatCompareOp("VCMPSD", 3, 1, 0, 194);

        private VexFloatCompareOp(String opcode, int pp, int mmmmm, int w, int op) {
            super(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, Predicate p) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, src2));
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(p.imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, Predicate p) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, null));
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(p.imm8);
        }

        public static enum Predicate {
            EQ_OQ(0),
            LT_OS(1),
            LE_OS(2),
            UNORD_Q(3),
            NEQ_UQ(4),
            NLT_US(5),
            NLE_US(6),
            ORD_Q(7),
            EQ_UQ(8),
            NGE_US(9),
            NGT_US(10),
            FALSE_OQ(11),
            NEQ_OQ(12),
            GE_OS(13),
            GT_OS(14),
            TRUE_UQ(15),
            EQ_OS(16),
            LT_OQ(17),
            LE_OQ(18),
            UNORD_S(19),
            NEQ_US(20),
            NLT_UQ(21),
            NLE_UQ(22),
            ORD_S(23),
            EQ_US(24),
            NGE_UQ(25),
            NGT_UQ(26),
            FALSE_OS(27),
            NEQ_OS(28),
            GE_OQ(29),
            GT_OQ(30),
            TRUE_US(31);

            private int imm8;

            private Predicate(int imm8) {
                this.imm8 = imm8;
            }

            public static Predicate getPredicate(Condition condition, boolean unorderedIsTrue) {
                if (unorderedIsTrue) {
                    switch (condition) {
                        case EQ: {
                            return EQ_UQ;
                        }
                        case NE: {
                            return NEQ_UQ;
                        }
                        case LT: {
                            return NGE_UQ;
                        }
                        case LE: {
                            return NGT_UQ;
                        }
                        case GT: {
                            return NLE_UQ;
                        }
                        case GE: {
                            return NLT_UQ;
                        }
                    }
                    throw GraalError.shouldNotReachHere();
                }
                switch (condition) {
                    case EQ: {
                        return EQ_OQ;
                    }
                    case NE: {
                        return NEQ_OQ;
                    }
                    case LT: {
                        return LT_OQ;
                    }
                    case LE: {
                        return LE_OQ;
                    }
                    case GT: {
                        return GT_OQ;
                    }
                    case GE: {
                        return GE_OQ;
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static final class VexRVMIOp
    extends VexOp {
        public static final VexRVMIOp VSHUFPS = new VexRVMIOp("VSHUFPS", 0, 1, 0, 198);
        public static final VexRVMIOp VSHUFPD = new VexRVMIOp("VSHUFPD", 1, 1, 0, 198);
        public static final VexRVMIOp VINSERTF128 = new VexRVMIOp("VINSERTF128", 1, 3, 0, 24, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRVMIOp VINSERTI128 = new VexRVMIOp("VINSERTI128", 1, 3, 0, 56, VEXOpAssertion.AVX2_256ONLY);

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op) {
            this(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1);
        }

        private VexRVMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, src2));
            assert ((imm8 & 0xFF) == imm8);
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, null));
            assert ((imm8 & 0xFF) == imm8);
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexMaskMoveOp
    extends VexOp {
        public static final VexMaskMoveOp VMASKMOVPS = new VexMaskMoveOp("VMASKMOVPS", 1, 2, 0, 44, 46);
        public static final VexMaskMoveOp VMASKMOVPD = new VexMaskMoveOp("VMASKMOVPD", 1, 2, 0, 45, 47);
        public static final VexMaskMoveOp VPMASKMOVD = new VexMaskMoveOp("VPMASKMOVD", 1, 2, 0, 140, 142, VEXOpAssertion.AVX2);
        public static final VexMaskMoveOp VPMASKMOVQ = new VexMaskMoveOp("VPMASKMOVQ", 1, 2, 1, 140, 142, VEXOpAssertion.AVX2);
        private final int opReverse;

        private VexMaskMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse) {
            this(opcode, pp, mmmmm, w, op, opReverse, VEXOpAssertion.AVX1);
        }

        private VexMaskMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.opReverse = opReverse;
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, AMD64Address src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, mask, null));
            asm.vexPrefix(dst, mask, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register mask, Register src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, src, mask, null));
            boolean useEvex = asm.vexPrefix(src, mask, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(useEvex, size));
        }
    }

    public static final class VexShiftOp
    extends VexRVMOp
    implements VexRRIOp {
        public static final VexShiftOp VPSRLW = new VexShiftOp("VPSRLW", 1, 1, 0, 209, 113, 2);
        public static final VexShiftOp VPSRLD = new VexShiftOp("VPSRLD", 1, 1, 0, 210, 114, 2);
        public static final VexShiftOp VPSRLQ = new VexShiftOp("VPSRLQ", 1, 1, 0, 211, 115, 2);
        public static final VexShiftOp VPSRAW = new VexShiftOp("VPSRAW", 1, 1, 0, 225, 113, 4);
        public static final VexShiftOp VPSRAD = new VexShiftOp("VPSRAD", 1, 1, 0, 226, 114, 4);
        public static final VexShiftOp VPSLLW = new VexShiftOp("VPSLLW", 1, 1, 0, 241, 113, 6);
        public static final VexShiftOp VPSLLD = new VexShiftOp("VPSLLD", 1, 1, 0, 242, 114, 6);
        public static final VexShiftOp VPSLLQ = new VexShiftOp("VPSLLQ", 1, 1, 0, 243, 115, 6);
        private final int immOp;
        private final int r;

        private VexShiftOp(String opcode, int pp, int mmmmm, int w, int op, int immOp, int r) {
            super(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1_2);
            this.immOp = immOp;
            this.r = r;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, null, dst, src));
            asm.vexPrefix(null, dst, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.immOp);
            asm.emitModRM(this.r, src);
            asm.emitByte(imm8);
        }
    }

    public static final class VexGeneralPurposeRMOp
    extends VexRMOp {
        public static final VexGeneralPurposeRMOp BLSI = new VexGeneralPurposeRMOp("BLSI", 0, 2, 0, 243, 3, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSMSK = new VexGeneralPurposeRMOp("BLSMSK", 0, 2, 0, 243, 2, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMOp BLSR = new VexGeneralPurposeRMOp("BLSR", 0, 2, 0, 243, 1, VEXOpAssertion.BMI1);
        private final int ext;

        private VexGeneralPurposeRMOp(String opcode, int pp, int mmmmm, int w, int op, int ext, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
            this.ext = ext;
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, null));
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(this.ext, src);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, null));
            asm.vexPrefix(AMD64.cpuRegisters[this.ext], dst, src, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(this.ext, src, 0);
        }
    }

    public static final class VexGatherOp
    extends VexOp {
        public static final VexGatherOp VPGATHERDD = new VexGatherOp("VPGATHERDD", 1, 2, 0, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQD = new VexGatherOp("VPGATHERQD", 1, 2, 0, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERDQ = new VexGatherOp("VPGATHERDQ", 1, 2, 1, 144, VEXOpAssertion.AVX2);
        public static final VexGatherOp VPGATHERQQ = new VexGatherOp("VPGATHERQQ", 1, 2, 1, 145, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPD = new VexGatherOp("VGATHERDPD", 1, 2, 1, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPD = new VexGatherOp("VGATHERQPD", 1, 2, 1, 147, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERDPS = new VexGatherOp("VGATHERDPS", 1, 2, 0, 146, VEXOpAssertion.AVX2);
        public static final VexGatherOp VGATHERQPS = new VexGatherOp("VGATHERQPS", 1, 2, 0, 147, VEXOpAssertion.AVX2);

        protected VexGatherOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address address, Register mask) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, mask, null, null));
            assert (size == AVXKind.AVXSize.XMM || size == AVXKind.AVXSize.YMM);
            asm.vexPrefix(dst, mask, address, size, this.pp, this.mmmmm, this.w, this.wEvex, true);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, address, 0);
        }
    }

    public static final class VexGeneralPurposeRMVOp
    extends VexOp {
        public static final VexGeneralPurposeRMVOp BEXTR = new VexGeneralPurposeRMVOp("BEXTR", 0, 2, 0, 247, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRMVOp BZHI = new VexGeneralPurposeRMVOp("BZHI", 0, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SARX = new VexGeneralPurposeRMVOp("SARX", 2, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHRX = new VexGeneralPurposeRMVOp("SHRX", 3, 2, 0, 247, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRMVOp SHLX = new VexGeneralPurposeRMVOp("SHLX", 1, 2, 0, 247, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRMVOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, 0, dst, src2, src1, null));
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD);
            asm.vexPrefix(dst, src2, src1, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src1);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src1, Register src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, 0, dst, src2, null, null));
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD);
            asm.vexPrefix(dst, src2, src1, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src1, 0);
        }
    }

    public static final class VexGeneralPurposeRVMOp
    extends VexRVMOp {
        public static final VexGeneralPurposeRVMOp ANDN = new VexGeneralPurposeRVMOp("ANDN", 0, 2, 0, 242, VEXOpAssertion.BMI1);
        public static final VexGeneralPurposeRVMOp MULX = new VexGeneralPurposeRVMOp("MULX", 3, 2, 0, 246, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PDEP = new VexGeneralPurposeRVMOp("PDEP", 3, 2, 0, 245, VEXOpAssertion.BMI2);
        public static final VexGeneralPurposeRVMOp PEXT = new VexGeneralPurposeRVMOp("PEXT", 2, 2, 0, 245, VEXOpAssertion.BMI2);

        private VexGeneralPurposeRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, 0, dst, src1, src2, null));
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD);
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, 0, dst, src1, null, null));
            assert (size == AVXKind.AVXSize.DWORD || size == AVXKind.AVXSize.QWORD);
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, size == AVXKind.AVXSize.DWORD ? 0 : 1, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0);
        }
    }

    public static class VexRVMOp
    extends VexOp {
        public static final VexRVMOp VANDPS = new VexRVMOp("VANDPS", 0, 1, 0, 84);
        public static final VexRVMOp VANDPD = new VexRVMOp("VANDPD", 1, 1, 0, 84);
        public static final VexRVMOp VANDNPS = new VexRVMOp("VANDNPS", 0, 1, 0, 85);
        public static final VexRVMOp VANDNPD = new VexRVMOp("VANDNPD", 1, 1, 0, 85);
        public static final VexRVMOp VORPS = new VexRVMOp("VORPS", 0, 1, 0, 86);
        public static final VexRVMOp VORPD = new VexRVMOp("VORPD", 1, 1, 0, 86);
        public static final VexRVMOp VXORPS = new VexRVMOp("VXORPS", 0, 1, 0, 87);
        public static final VexRVMOp VXORPD = new VexRVMOp("VXORPD", 1, 1, 0, 87);
        public static final VexRVMOp VADDPS = new VexRVMOp("VADDPS", 0, 1, 0, 88);
        public static final VexRVMOp VADDPD = new VexRVMOp("VADDPD", 1, 1, 0, 88);
        public static final VexRVMOp VADDSS = new VexRVMOp("VADDSS", 2, 1, 0, 88);
        public static final VexRVMOp VADDSD = new VexRVMOp("VADDSD", 3, 1, 0, 88);
        public static final VexRVMOp VMULPS = new VexRVMOp("VMULPS", 0, 1, 0, 89);
        public static final VexRVMOp VMULPD = new VexRVMOp("VMULPD", 1, 1, 0, 89);
        public static final VexRVMOp VMULSS = new VexRVMOp("VMULSS", 2, 1, 0, 89);
        public static final VexRVMOp VMULSD = new VexRVMOp("VMULSD", 3, 1, 0, 89);
        public static final VexRVMOp VSUBPS = new VexRVMOp("VSUBPS", 0, 1, 0, 92);
        public static final VexRVMOp VSUBPD = new VexRVMOp("VSUBPD", 1, 1, 0, 92);
        public static final VexRVMOp VSUBSS = new VexRVMOp("VSUBSS", 2, 1, 0, 92);
        public static final VexRVMOp VSUBSD = new VexRVMOp("VSUBSD", 3, 1, 0, 92);
        public static final VexRVMOp VMINPS = new VexRVMOp("VMINPS", 0, 1, 0, 93);
        public static final VexRVMOp VMINPD = new VexRVMOp("VMINPD", 1, 1, 0, 93);
        public static final VexRVMOp VMINSS = new VexRVMOp("VMINSS", 2, 1, 0, 93);
        public static final VexRVMOp VMINSD = new VexRVMOp("VMINSD", 3, 1, 0, 93);
        public static final VexRVMOp VDIVPS = new VexRVMOp("VDIVPS", 0, 1, 0, 94);
        public static final VexRVMOp VDIVPD = new VexRVMOp("VDIVPD", 1, 1, 0, 94);
        public static final VexRVMOp VDIVSS = new VexRVMOp("VDIVPS", 2, 1, 0, 94);
        public static final VexRVMOp VDIVSD = new VexRVMOp("VDIVPD", 3, 1, 0, 94);
        public static final VexRVMOp VMAXPS = new VexRVMOp("VMAXPS", 0, 1, 0, 95);
        public static final VexRVMOp VMAXPD = new VexRVMOp("VMAXPD", 1, 1, 0, 95);
        public static final VexRVMOp VMAXSS = new VexRVMOp("VMAXSS", 2, 1, 0, 95);
        public static final VexRVMOp VMAXSD = new VexRVMOp("VMAXSD", 3, 1, 0, 95);
        public static final VexRVMOp VADDSUBPS = new VexRVMOp("VADDSUBPS", 3, 1, 0, 208);
        public static final VexRVMOp VADDSUBPD = new VexRVMOp("VADDSUBPD", 1, 1, 0, 208);
        public static final VexRVMOp VPAND = new VexRVMOp("VPAND", 1, 1, 0, 219, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPOR = new VexRVMOp("VPOR", 1, 1, 0, 235, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPXOR = new VexRVMOp("VPXOR", 1, 1, 0, 239, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPADDB = new VexRVMOp("VPADDB", 1, 1, 0, 252, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPADDW = new VexRVMOp("VPADDW", 1, 1, 0, 253, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPADDD = new VexRVMOp("VPADDD", 1, 1, 0, 254, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPADDQ = new VexRVMOp("VPADDQ", 1, 1, 0, 212, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPMULHUW = new VexRVMOp("VPMULHUW", 1, 1, 0, 228, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPMULHW = new VexRVMOp("VPMULHW", 1, 1, 0, 229, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPMULLW = new VexRVMOp("VPMULLW", 1, 1, 0, 213, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPMULLD = new VexRVMOp("VPMULLD", 1, 2, 0, 64, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPSUBB = new VexRVMOp("VPSUBB", 1, 1, 0, 248, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPSUBW = new VexRVMOp("VPSUBW", 1, 1, 0, 249, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPSUBD = new VexRVMOp("VPSUBD", 1, 1, 0, 250, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPSUBQ = new VexRVMOp("VPSUBQ", 1, 1, 0, 251, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPSHUFB = new VexRVMOp("VPSHUFB", 1, 2, 0, 0, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VCVTSD2SS = new VexRVMOp("VCVTSD2SS", 3, 1, 0, 90);
        public static final VexRVMOp VCVTSS2SD = new VexRVMOp("VCVTSS2SD", 2, 1, 0, 90);
        public static final VexRVMOp VCVTSI2SD = new VexRVMOp("VCVTSI2SD", 3, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMOp VCVTSQ2SD = new VexRVMOp("VCVTSQ2SD", 3, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMOp VCVTSI2SS = new VexRVMOp("VCVTSI2SS", 2, 1, 0, 42, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMOp VCVTSQ2SS = new VexRVMOp("VCVTSQ2SS", 2, 1, 1, 42, VEXOpAssertion.XMM_XMM_CPU);
        public static final VexRVMOp VPCMPEQB = new VexRVMOp("VPCMPEQB", 1, 1, 0, 116, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQW = new VexRVMOp("VPCMPEQW", 1, 1, 0, 117, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQD = new VexRVMOp("VPCMPEQD", 1, 1, 0, 118, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPEQQ = new VexRVMOp("VPCMPEQQ", 1, 2, 0, 41, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTB = new VexRVMOp("VPCMPGTB", 1, 1, 0, 100, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTW = new VexRVMOp("VPCMPGTW", 1, 1, 0, 101, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTD = new VexRVMOp("VPCMPGTD", 1, 1, 0, 102, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VPCMPGTQ = new VexRVMOp("VPCMPGTQ", 1, 2, 0, 55, VEXOpAssertion.AVX1_2);
        public static final VexRVMOp VFMADD231SS = new VexRVMOp("VFMADD231SS", 1, 2, 0, 185, VEXOpAssertion.FMA);
        public static final VexRVMOp VFMADD231SD = new VexRVMOp("VFMADD231SD", 1, 2, 1, 185, VEXOpAssertion.FMA);

        private VexRVMOp(String opcode, int pp, int mmmmm, int w, int op) {
            this(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1);
        }

        protected VexRVMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, Register src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, src2));
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src1, AMD64Address src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, src1, null));
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
        }
    }

    public static class VexRVMROp
    extends VexOp {
        public static final VexRVMROp VPBLENDVB = new VexRVMROp("VPBLENDVB", 1, 3, 0, 76, VEXOpAssertion.AVX1_2);
        public static final VexRVMROp VBLENDVPS = new VexRVMROp("VBLENDVPS", 1, 3, 0, 74, VEXOpAssertion.AVX1);
        public static final VexRVMROp VBLENDVPD = new VexRVMROp("VBLENDVPD", 1, 3, 0, 75, VEXOpAssertion.AVX1);

        protected VexRVMROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, Register src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, mask, src1, src2));
            asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src2);
            asm.emitByte(mask.encoding() << 4);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register mask, Register src1, AMD64Address src2) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, mask, src1, null));
            boolean useEvex = asm.vexPrefix(dst, src1, src2, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src2, 0, this.getDisp8Scale(useEvex, size));
            asm.emitByte(mask.encoding() << 4);
        }
    }

    public static final class VexMRIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexMRIOp VEXTRACTF128 = new VexMRIOp("VEXTRACTF128", 1, 3, 0, 25, VEXOpAssertion.AVX1_256ONLY);
        public static final VexMRIOp VEXTRACTI128 = new VexMRIOp("VEXTRACTI128", 1, 3, 0, 57, VEXOpAssertion.AVX2_256ONLY);
        public static final VexMRIOp VPEXTRB = new VexMRIOp("VPEXTRB", 1, 3, 0, 20, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRW = new VexMRIOp("VPEXTRW", 1, 3, 0, 21, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRD = new VexMRIOp("VPEXTRD", 1, 3, 0, 22, VEXOpAssertion.XMM_CPU);
        public static final VexMRIOp VPEXTRQ = new VexMRIOp("VPEXTRQ", 1, 3, 1, 22, VEXOpAssertion.XMM_CPU);

        private VexMRIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, src, null, dst));
            asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(src, dst);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, src, null, null));
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(src, dst, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static final class VexRMIOp
    extends VexOp
    implements VexRRIOp {
        public static final VexRMIOp VPERMQ = new VexRMIOp("VPERMQ", 1, 3, 1, 0, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRMIOp VPSHUFLW = new VexRMIOp("VPSHUFLW", 3, 1, 0, 112, VEXOpAssertion.AVX1_2);
        public static final VexRMIOp VPSHUFHW = new VexRMIOp("VPSHUFHW", 2, 1, 0, 112, VEXOpAssertion.AVX1_2);
        public static final VexRMIOp VPSHUFD = new VexRMIOp("VPSHUFD", 1, 1, 0, 112, VEXOpAssertion.AVX1_2);

        private VexRMIOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            super(opcode, pp, mmmmm, w, op, assertion);
        }

        @Override
        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, src));
            asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
            asm.emitByte(imm8);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src, int imm8) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, null));
            boolean useEvex = asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 1, this.getDisp8Scale(useEvex, size));
            asm.emitByte(imm8);
        }
    }

    public static interface VexRRIOp {
        public void emit(AMD64Assembler var1, AVXKind.AVXSize var2, Register var3, Register var4, int var5);
    }

    public static final class VexMoveOp
    extends VexRMOp {
        public static final VexMoveOp VMOVDQA32 = new VexMoveOp("VMOVDQA32", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQA64 = new VexMoveOp("VMOVDQA64", 1, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVDQU32 = new VexMoveOp("VMOVDQU32", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVDQU64 = new VexMoveOp("VMOVDQU64", 2, 1, 0, 111, 127, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVAPS = new VexMoveOp("VMOVAPS", 0, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVAPD = new VexMoveOp("VMOVAPD", 1, 1, 0, 40, 41, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVUPS = new VexMoveOp("VMOVUPS", 0, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 0);
        public static final VexMoveOp VMOVUPD = new VexMoveOp("VMOVUPD", 1, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_VL, AMD64BaseAssembler.EVEXTuple.FVM, 1);
        public static final VexMoveOp VMOVSS = new VexMoveOp("VMOVSS", 2, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.T1S_32BIT, 0);
        public static final VexMoveOp VMOVSD = new VexMoveOp("VMOVSD", 3, 1, 0, 16, 17, VEXOpAssertion.AVX1_AVX512F_ALL, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        public static final VexMoveOp VMOVD = new VexMoveOp("VMOVD", 1, 1, 0, 110, 126, VEXOpAssertion.XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1F_32BIT, 0);
        public static final VexMoveOp VMOVQ = new VexMoveOp("VMOVQ", 1, 1, 1, 110, 126, VEXOpAssertion.XMM_CPU_AVX512F_128ONLY, AMD64BaseAssembler.EVEXTuple.T1S_64BIT, 1);
        private final int opReverse;

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse) {
            this(opcode, pp, mmmmm, w, op, opReverse, VEXOpAssertion.AVX1, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, opReverse, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        private VexMoveOp(String opcode, int pp, int mmmmm, int w, int op, int opReverse, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
            this.opReverse = opReverse;
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, AMD64Address dst, Register src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, src, null, null));
            boolean useEvex = asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.opReverse);
            asm.emitOperandHelper(src, dst, 0, this.getDisp8Scale(useEvex, size));
        }

        public void emitReverse(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, src, null, dst));
            asm.vexPrefix(src, Register.None, dst, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.opReverse);
            asm.emitModRM(src, dst);
        }
    }

    public static class VexRMOp
    extends VexRROp {
        public static final VexRMOp VCVTTSS2SI = new VexRMOp("VCVTTSS2SI", 2, 1, 0, 44, VEXOpAssertion.CPU_XMM);
        public static final VexRMOp VCVTTSS2SQ = new VexRMOp("VCVTTSS2SQ", 2, 1, 1, 44, VEXOpAssertion.CPU_XMM);
        public static final VexRMOp VCVTTSD2SI = new VexRMOp("VCVTTSD2SI", 3, 1, 0, 44, VEXOpAssertion.CPU_XMM);
        public static final VexRMOp VCVTTSD2SQ = new VexRMOp("VCVTTSD2SQ", 3, 1, 1, 44, VEXOpAssertion.CPU_XMM);
        public static final VexRMOp VCVTPS2PD = new VexRMOp("VCVTPS2PD", 0, 1, 0, 90);
        public static final VexRMOp VCVTPD2PS = new VexRMOp("VCVTPD2PS", 1, 1, 0, 90);
        public static final VexRMOp VCVTDQ2PS = new VexRMOp("VCVTDQ2PS", 0, 1, 0, 91);
        public static final VexRMOp VCVTTPS2DQ = new VexRMOp("VCVTTPS2DQ", 2, 1, 0, 91);
        public static final VexRMOp VCVTTPD2DQ = new VexRMOp("VCVTTPD2DQ", 1, 1, 0, 230);
        public static final VexRMOp VCVTDQ2PD = new VexRMOp("VCVTDQ2PD", 2, 1, 0, 230);
        public static final VexRMOp VBROADCASTSS = new VexRMOp("VBROADCASTSS", 1, 2, 0, 24);
        public static final VexRMOp VBROADCASTSD = new VexRMOp("VBROADCASTSD", 1, 2, 0, 25, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRMOp VBROADCASTF128 = new VexRMOp("VBROADCASTF128", 1, 2, 0, 26, VEXOpAssertion.AVX1_256ONLY);
        public static final VexRMOp VPBROADCASTI128 = new VexRMOp("VPBROADCASTI128", 1, 2, 0, 90, VEXOpAssertion.AVX2_256ONLY);
        public static final VexRMOp VPBROADCASTB = new VexRMOp("VPBROADCASTB", 1, 2, 0, 120, VEXOpAssertion.AVX2);
        public static final VexRMOp VPBROADCASTW = new VexRMOp("VPBROADCASTW", 1, 2, 0, 121, VEXOpAssertion.AVX2);
        public static final VexRMOp VPBROADCASTD = new VexRMOp("VPBROADCASTD", 1, 2, 0, 88, VEXOpAssertion.AVX2);
        public static final VexRMOp VPBROADCASTQ = new VexRMOp("VPBROADCASTQ", 1, 2, 0, 89, VEXOpAssertion.AVX2);
        public static final VexRMOp VPMOVMSKB = new VexRMOp("VPMOVMSKB", 1, 1, 0, 215, VEXOpAssertion.AVX1_2_CPU_XMM);
        public static final VexRMOp VPMOVSXBW = new VexRMOp("VPMOVSXBW", 1, 2, 0, 32);
        public static final VexRMOp VPMOVSXBD = new VexRMOp("VPMOVSXBD", 1, 2, 0, 33);
        public static final VexRMOp VPMOVSXBQ = new VexRMOp("VPMOVSXBQ", 1, 2, 0, 34);
        public static final VexRMOp VPMOVSXWD = new VexRMOp("VPMOVSXWD", 1, 2, 0, 35);
        public static final VexRMOp VPMOVSXWQ = new VexRMOp("VPMOVSXWQ", 1, 2, 0, 36);
        public static final VexRMOp VPMOVSXDQ = new VexRMOp("VPMOVSXDQ", 1, 2, 0, 37);
        public static final VexRMOp VPMOVZXBW = new VexRMOp("VPMOVZXBW", 1, 2, 0, 48);
        public static final VexRMOp VPMOVZXBD = new VexRMOp("VPMOVZXBD", 1, 2, 0, 49);
        public static final VexRMOp VPMOVZXBQ = new VexRMOp("VPMOVZXBQ", 1, 2, 0, 50);
        public static final VexRMOp VPMOVZXWD = new VexRMOp("VPMOVZXWD", 1, 2, 0, 51);
        public static final VexRMOp VPMOVZXWQ = new VexRMOp("VPMOVZXWQ", 1, 2, 0, 52);
        public static final VexRMOp VPMOVZXDQ = new VexRMOp("VPMOVZXDQ", 1, 2, 0, 53);
        public static final VexRMOp VPTEST = new VexRMOp("VPTEST", 1, 2, 0, 23);
        public static final VexRMOp VSQRTPD = new VexRMOp("VSQRTPD", 1, 1, 0, 81);
        public static final VexRMOp VSQRTPS = new VexRMOp("VSQRTPS", 0, 1, 0, 81);
        public static final VexRMOp VSQRTSD = new VexRMOp("VSQRTSD", 3, 1, 0, 81);
        public static final VexRMOp VSQRTSS = new VexRMOp("VSQRTSS", 2, 1, 0, 81);
        public static final VexRMOp VUCOMISS = new VexRMOp("VUCOMISS", 0, 1, 0, 46);
        public static final VexRMOp VUCOMISD = new VexRMOp("VUCOMISD", 1, 1, 0, 46);

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op) {
            this(opcode, pp, mmmmm, w, op, VEXOpAssertion.AVX1, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        protected VexRMOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, AMD64Address src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, null));
            boolean useEvex = asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitOperandHelper(dst, src, 0, this.getDisp8Scale(useEvex, size));
        }
    }

    public static class VexRROp
    extends VexOp {
        public static final VexRROp VMASKMOVDQU = new VexRROp("VMASKMOVDQU", 1, 1, 0, 247, VEXOpAssertion.AVX1_128ONLY, AMD64BaseAssembler.EVEXTuple.INVALID, 0);

        protected VexRROp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            super(opcode, pp, mmmmm, w, op, assertion, evexTuple, wEvex);
        }

        public void emit(AMD64Assembler asm, AVXKind.AVXSize size, Register dst, Register src) {
            assert (this.assertion.check((AMD64)asm.target.arch, size, dst, null, src));
            assert (this.op != 26 || this.op != 90);
            asm.vexPrefix(dst, Register.None, src, size, this.pp, this.mmmmm, this.w, this.wEvex, false);
            asm.emitByte(this.op);
            asm.emitModRM(dst, src);
        }
    }

    public static class VexOp {
        protected final int pp;
        protected final int mmmmm;
        protected final int w;
        protected final int op;
        private final String opcode;
        protected final VEXOpAssertion assertion;
        protected final AMD64BaseAssembler.EVEXTuple evexTuple;
        protected final int wEvex;

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion, AMD64BaseAssembler.EVEXTuple evexTuple, int wEvex) {
            this.pp = pp;
            this.mmmmm = mmmmm;
            this.w = w;
            this.op = op;
            this.opcode = opcode;
            this.assertion = assertion;
            this.evexTuple = evexTuple;
            this.wEvex = wEvex;
        }

        protected VexOp(String opcode, int pp, int mmmmm, int w, int op, VEXOpAssertion assertion) {
            this(opcode, pp, mmmmm, w, op, assertion, AMD64BaseAssembler.EVEXTuple.INVALID, 0);
        }

        public final boolean isSupported(AMD64Assembler vasm, AVXKind.AVXSize size) {
            return this.isSupported(vasm, size, false);
        }

        public final boolean isSupported(AMD64Assembler vasm, AVXKind.AVXSize size, boolean useZMMRegisters) {
            return this.assertion.supports(((AMD64)vasm.target.arch).getFeatures(), size, useZMMRegisters);
        }

        public String toString() {
            return this.opcode;
        }

        protected final int getDisp8Scale(boolean useEvex, AVXKind.AVXSize size) {
            return useEvex ? this.evexTuple.getDisp8ScalingFactor(size) : 1;
        }
    }

    private static final class VEXOpAssertion
    extends Enum<VEXOpAssertion> {
        public static final /* enum */ VEXOpAssertion AVX1 = new VEXOpAssertion(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, null);
        public static final /* enum */ VEXOpAssertion AVX1_2 = new VEXOpAssertion(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, null);
        public static final /* enum */ VEXOpAssertion AVX2 = new VEXOpAssertion(AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX2, null);
        public static final /* enum */ VEXOpAssertion AVX1_128ONLY = new VEXOpAssertion(AMD64.CPUFeature.AVX, null, null);
        public static final /* enum */ VEXOpAssertion AVX1_256ONLY = new VEXOpAssertion(null, AMD64.CPUFeature.AVX, null);
        public static final /* enum */ VEXOpAssertion AVX2_256ONLY = new VEXOpAssertion(null, AMD64.CPUFeature.AVX2, null);
        public static final /* enum */ VEXOpAssertion XMM_CPU = new VEXOpAssertion(AMD64.CPUFeature.AVX, null, null, AMD64.XMM, null, AMD64.CPU, null);
        public static final /* enum */ VEXOpAssertion XMM_XMM_CPU = new VEXOpAssertion(AMD64.CPUFeature.AVX, null, null, AMD64.XMM, AMD64.XMM, AMD64.CPU, null);
        public static final /* enum */ VEXOpAssertion CPU_XMM = new VEXOpAssertion(AMD64.CPUFeature.AVX, null, null, AMD64.CPU, null, AMD64.XMM, null);
        public static final /* enum */ VEXOpAssertion AVX1_2_CPU_XMM = new VEXOpAssertion(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, null, AMD64.CPU, null, AMD64.XMM, null);
        public static final /* enum */ VEXOpAssertion BMI1 = new VEXOpAssertion(AMD64.CPUFeature.BMI1, null, null, AMD64.CPU, AMD64.CPU, AMD64.CPU, null);
        public static final /* enum */ VEXOpAssertion BMI2 = new VEXOpAssertion(AMD64.CPUFeature.BMI2, null, null, AMD64.CPU, AMD64.CPU, AMD64.CPU, null);
        public static final /* enum */ VEXOpAssertion FMA = new VEXOpAssertion(AMD64.CPUFeature.FMA, null, null, AMD64.XMM, AMD64.XMM, AMD64.XMM, null);
        public static final /* enum */ VEXOpAssertion XMM_CPU_AVX512F_128ONLY = new VEXOpAssertion(AMD64.CPUFeature.AVX, null, EVEXFeatureAssertion.AVX512F_128ONLY, AMD64.XMM, null, AMD64.CPU, null);
        public static final /* enum */ VEXOpAssertion AVX1_AVX512F_ALL = new VEXOpAssertion(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_ALL);
        public static final /* enum */ VEXOpAssertion AVX1_AVX512F_VL = new VEXOpAssertion(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX, EVEXFeatureAssertion.AVX512F_VL);
        private final AMD64.CPUFeature l128feature;
        private final AMD64.CPUFeature l256feature;
        private final EVEXFeatureAssertion l512features;
        private final Register.RegisterCategory rCategory;
        private final Register.RegisterCategory vCategory;
        private final Register.RegisterCategory mCategory;
        private final Register.RegisterCategory imm8Category;
        private static final /* synthetic */ VEXOpAssertion[] $VALUES;

        public static VEXOpAssertion[] values() {
            return (VEXOpAssertion[])$VALUES.clone();
        }

        public static VEXOpAssertion valueOf(String name) {
            return Enum.valueOf(VEXOpAssertion.class, name);
        }

        private VEXOpAssertion(AMD64.CPUFeature l128feature, AMD64.CPUFeature l256feature, EVEXFeatureAssertion l512features) {
            this(l128feature, l256feature, l512features, AMD64.XMM, AMD64.XMM, AMD64.XMM, AMD64.XMM);
        }

        private VEXOpAssertion(AMD64.CPUFeature l128feature, AMD64.CPUFeature l256feature, EVEXFeatureAssertion l512features, Register.RegisterCategory rCategory, Register.RegisterCategory vCategory, Register.RegisterCategory mCategory, Register.RegisterCategory imm8Category) {
            this.l128feature = l128feature;
            this.l256feature = l256feature;
            this.l512features = l512features;
            this.rCategory = rCategory;
            this.vCategory = vCategory;
            this.mCategory = mCategory;
            this.imm8Category = imm8Category;
        }

        public boolean check(AMD64 arch, AVXKind.AVXSize size, Register r, Register v, Register m) {
            return this.check(arch, AMD64BaseAssembler.getLFlag(size), r, v, m, null);
        }

        public boolean check(AMD64 arch, AVXKind.AVXSize size, Register r, Register v, Register m, Register imm8) {
            return this.check(arch, AMD64BaseAssembler.getLFlag(size), r, v, m, imm8);
        }

        public boolean check(AMD64 arch, int l, Register r, Register v, Register m, Register imm8) {
            if (AMD64BaseAssembler.isAVX512Register(r) || AMD64BaseAssembler.isAVX512Register(v) || AMD64BaseAssembler.isAVX512Register(m) || l == 2) {
                assert (this.l512features != null && this.l512features.check(arch, l));
            } else if (l == 0) {
                assert (this.l128feature != null && arch.getFeatures().contains(this.l128feature)) : "emitting illegal 128 bit instruction";
            } else if (l == 1) assert (this.l256feature != null && arch.getFeatures().contains(this.l256feature)) : "emitting illegal 256 bit instruction";
            if (r != null) assert (r.getRegisterCategory().equals((Object)this.rCategory));
            if (v != null) assert (v.getRegisterCategory().equals((Object)this.vCategory));
            if (m != null) assert (m.getRegisterCategory().equals((Object)this.mCategory));
            if (imm8 != null) assert (imm8.getRegisterCategory().equals((Object)this.imm8Category));
            return true;
        }

        public boolean supports(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize avxSize, boolean useZMMRegisters) {
            if (useZMMRegisters || avxSize == AVXKind.AVXSize.ZMM) {
                return this.l512features != null && this.l512features.supports(features, avxSize);
            }
            if (avxSize == AVXKind.AVXSize.XMM) {
                return this.l128feature != null && features.contains(this.l128feature);
            }
            if (avxSize == AVXKind.AVXSize.YMM) {
                return this.l256feature != null && features.contains(this.l256feature);
            }
            throw GraalError.shouldNotReachHere();
        }

        static {
            $VALUES = new VEXOpAssertion[]{AVX1, AVX1_2, AVX2, AVX1_128ONLY, AVX1_256ONLY, AVX2_256ONLY, XMM_CPU, XMM_XMM_CPU, CPU_XMM, AVX1_2_CPU_XMM, BMI1, BMI2, FMA, XMM_CPU_AVX512F_128ONLY, AVX1_AVX512F_ALL, AVX1_AVX512F_VL};
        }
    }

    private static final class EVEXFeatureAssertion
    extends Enum<EVEXFeatureAssertion> {
        public static final /* enum */ EVEXFeatureAssertion AVX512F_ALL = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F), EnumSet.of(AMD64.CPUFeature.AVX512F), EnumSet.of(AMD64.CPUFeature.AVX512F));
        public static final /* enum */ EVEXFeatureAssertion AVX512F_128ONLY = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F), null, null);
        public static final /* enum */ EVEXFeatureAssertion AVX512F_VL = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F));
        public static final /* enum */ EVEXFeatureAssertion AVX512CD_VL = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512CD));
        public static final /* enum */ EVEXFeatureAssertion AVX512DQ_VL = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512DQ));
        public static final /* enum */ EVEXFeatureAssertion AVX512BW_VL = new EVEXFeatureAssertion(EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW, AMD64.CPUFeature.AVX512VL), EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW));
        private final EnumSet<AMD64.CPUFeature> l128features;
        private final EnumSet<AMD64.CPUFeature> l256features;
        private final EnumSet<AMD64.CPUFeature> l512features;
        private static final /* synthetic */ EVEXFeatureAssertion[] $VALUES;

        public static EVEXFeatureAssertion[] values() {
            return (EVEXFeatureAssertion[])$VALUES.clone();
        }

        public static EVEXFeatureAssertion valueOf(String name) {
            return Enum.valueOf(EVEXFeatureAssertion.class, name);
        }

        private EVEXFeatureAssertion(EnumSet<AMD64.CPUFeature> l128features, EnumSet<AMD64.CPUFeature> l256features, EnumSet<AMD64.CPUFeature> l512features) {
            this.l128features = l128features;
            this.l256features = l256features;
            this.l512features = l512features;
        }

        public boolean check(AMD64 arch, int l) {
            switch (l) {
                case 0: {
                    assert (this.l128features != null && arch.getFeatures().containsAll(this.l128features)) : "emitting illegal 128 bit instruction";
                    break;
                }
                case 1: {
                    assert (this.l256features != null && arch.getFeatures().containsAll(this.l256features)) : "emitting illegal 256 bit instruction";
                    break;
                }
                case 2: {
                    assert (this.l512features != null && arch.getFeatures().containsAll(this.l512features)) : "emitting illegal 512 bit instruction";
                    break;
                }
            }
            return true;
        }

        public boolean supports(EnumSet<AMD64.CPUFeature> features, AVXKind.AVXSize avxSize) {
            switch (avxSize) {
                case XMM: {
                    return this.l128features != null && features.containsAll(this.l128features);
                }
                case YMM: {
                    return this.l256features != null && features.containsAll(this.l256features);
                }
                case ZMM: {
                    return this.l512features != null && features.containsAll(this.l512features);
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        static {
            $VALUES = new EVEXFeatureAssertion[]{AVX512F_ALL, AVX512F_128ONLY, AVX512F_VL, AVX512CD_VL, AVX512DQ_VL, AVX512BW_VL};
        }
    }

    public static final class AMD64Shift {
        public static final AMD64Shift ROL = new AMD64Shift("ROL", 0);
        public static final AMD64Shift ROR = new AMD64Shift("ROR", 1);
        public static final AMD64Shift RCL = new AMD64Shift("RCL", 2);
        public static final AMD64Shift RCR = new AMD64Shift("RCR", 3);
        public static final AMD64Shift SHL = new AMD64Shift("SHL", 4);
        public static final AMD64Shift SHR = new AMD64Shift("SHR", 5);
        public static final AMD64Shift SAR = new AMD64Shift("SAR", 7);
        public final AMD64MOp m1Op;
        public final AMD64MOp mcOp;
        public final AMD64MIOp miOp;

        private AMD64Shift(String opcode, int code) {
            this.m1Op = new AMD64MOp(opcode, 0, 209, code, OpAssertion.WordOrLargerAssertion);
            this.mcOp = new AMD64MOp(opcode, 0, 211, code, OpAssertion.WordOrLargerAssertion);
            this.miOp = new AMD64MIOp(opcode, true, 0, 193, code, OpAssertion.WordOrLargerAssertion);
        }
    }

    public static final class AMD64BinaryArithmetic {
        public static final AMD64BinaryArithmetic ADD = new AMD64BinaryArithmetic("ADD", 0);
        public static final AMD64BinaryArithmetic OR = new AMD64BinaryArithmetic("OR", 1);
        public static final AMD64BinaryArithmetic ADC = new AMD64BinaryArithmetic("ADC", 2);
        public static final AMD64BinaryArithmetic SBB = new AMD64BinaryArithmetic("SBB", 3);
        public static final AMD64BinaryArithmetic AND = new AMD64BinaryArithmetic("AND", 4);
        public static final AMD64BinaryArithmetic SUB = new AMD64BinaryArithmetic("SUB", 5);
        public static final AMD64BinaryArithmetic XOR = new AMD64BinaryArithmetic("XOR", 6);
        public static final AMD64BinaryArithmetic CMP = new AMD64BinaryArithmetic("CMP", 7);
        private final AMD64MIOp byteImmOp;
        private final AMD64MROp byteMrOp;
        private final AMD64RMOp byteRmOp;
        private final AMD64MIOp immOp;
        private final AMD64MIOp immSxOp;
        private final AMD64MROp mrOp;
        private final AMD64RMOp rmOp;

        private AMD64BinaryArithmetic(String opcode, int code) {
            int baseOp = code << 3;
            this.byteImmOp = new AMD64MIOp(opcode, true, 0, 128, code, OpAssertion.ByteAssertion);
            this.byteMrOp = new AMD64MROp(opcode, 0, baseOp, OpAssertion.ByteAssertion);
            this.byteRmOp = new AMD64RMOp(opcode, 0, baseOp | 2, OpAssertion.ByteAssertion);
            this.immOp = new AMD64MIOp(opcode, false, 0, 129, code, OpAssertion.WordOrLargerAssertion);
            this.immSxOp = new AMD64MIOp(opcode, true, 0, 131, code, OpAssertion.WordOrLargerAssertion);
            this.mrOp = new AMD64MROp(opcode, 0, baseOp | 1, OpAssertion.WordOrLargerAssertion);
            this.rmOp = new AMD64RMOp(opcode, 0, baseOp | 3, OpAssertion.WordOrLargerAssertion);
        }

        public AMD64MIOp getMIOpcode(AMD64BaseAssembler.OperandSize size, boolean sx) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteImmOp;
            }
            if (sx) {
                return this.immSxOp;
            }
            return this.immOp;
        }

        public AMD64MROp getMROpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteMrOp;
            }
            return this.mrOp;
        }

        public AMD64RMOp getRMOpcode(AMD64BaseAssembler.OperandSize size) {
            if (size == AMD64BaseAssembler.OperandSize.BYTE) {
                return this.byteRmOp;
            }
            return this.rmOp;
        }
    }

    public static class SSEOp
    extends AMD64RMOp {
        public static final SSEOp CVTSI2SS = new SSEOp("CVTSI2SS", 243, 15, 42, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTSI2SD = new SSEOp("CVTSI2SD", 242, 15, 42, OpAssertion.IntToFloatAssertion);
        public static final SSEOp CVTTSS2SI = new SSEOp("CVTTSS2SI", 243, 15, 44, OpAssertion.FloatToIntAssertion);
        public static final SSEOp CVTTSD2SI = new SSEOp("CVTTSD2SI", 242, 15, 44, OpAssertion.FloatToIntAssertion);
        public static final SSEOp UCOMIS = new SSEOp("UCOMIS", 15, 46, OpAssertion.PackedFloatAssertion);
        public static final SSEOp SQRT = new SSEOp("SQRT", 15, 81);
        public static final SSEOp AND = new SSEOp("AND", 15, 84, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ANDN = new SSEOp("ANDN", 15, 85, OpAssertion.PackedFloatAssertion);
        public static final SSEOp OR = new SSEOp("OR", 15, 86, OpAssertion.PackedFloatAssertion);
        public static final SSEOp XOR = new SSEOp("XOR", 15, 87, OpAssertion.PackedFloatAssertion);
        public static final SSEOp ADD = new SSEOp("ADD", 15, 88);
        public static final SSEOp MUL = new SSEOp("MUL", 15, 89);
        public static final SSEOp CVTSS2SD = new SSEOp("CVTSS2SD", 15, 90, OpAssertion.SingleAssertion);
        public static final SSEOp CVTSD2SS = new SSEOp("CVTSD2SS", 15, 90, OpAssertion.DoubleAssertion);
        public static final SSEOp SUB = new SSEOp("SUB", 15, 92);
        public static final SSEOp MIN = new SSEOp("MIN", 15, 93);
        public static final SSEOp DIV = new SSEOp("DIV", 15, 94);
        public static final SSEOp MAX = new SSEOp("MAX", 15, 95);

        protected SSEOp(String opcode, int prefix, int op) {
            this(opcode, prefix, op, OpAssertion.FloatAssertion);
        }

        protected SSEOp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion);
        }

        protected SSEOp(String opcode, int mandatoryPrefix, int prefix, int op, OpAssertion assertion) {
            super(opcode, mandatoryPrefix, prefix, op, assertion, AMD64.CPUFeature.SSE2);
        }
    }

    public static class AMD64RMIOp
    extends AMD64ImmOp {
        public static final AMD64RMIOp IMUL = new AMD64RMIOp("IMUL", false, 105);
        public static final AMD64RMIOp IMUL_SX = new AMD64RMIOp("IMUL", true, 107);
        public static final AMD64RMIOp ROUNDSS = new AMD64RMIOp("ROUNDSS", true, 14863, 10, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);
        public static final AMD64RMIOp ROUNDSD = new AMD64RMIOp("ROUNDSD", true, 14863, 11, OpAssertion.PackedDoubleAssertion, AMD64.CPUFeature.SSE4_1);

        protected AMD64RMIOp(String opcode, boolean immIsByte, int op) {
            this(opcode, immIsByte, 0, op, OpAssertion.WordOrLargerAssertion, null);
        }

        protected AMD64RMIOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, immIsByte, prefix, op, assertion, feature);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src, int imm) {
            assert (this.verify(asm, size, dst, src));
            if (this.isSSEInstruction()) {
                Register nds = Register.None;
                switch (this.op) {
                    case 10: 
                    case 11: {
                        nds = dst;
                        break;
                    }
                }
                asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, false);
                asm.emitByte(this.op);
                asm.emitModRM(dst, src);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
                asm.emitModRM(dst, src);
            }
            this.emitImmediate(asm, size, imm);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src, int imm) {
            assert (this.verify(asm, size, dst, null));
            if (this.isSSEInstruction()) {
                Register nds = Register.None;
                switch (this.op) {
                    case 10: 
                    case 11: {
                        nds = dst;
                        break;
                    }
                }
                asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, false);
                asm.emitByte(this.op);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
            }
            asm.emitOperandHelper(dst, src, this.immediateSize(size));
            this.emitImmediate(asm, size, imm);
        }
    }

    public static class AMD64MIOp
    extends AMD64ImmOp {
        public static final AMD64MIOp MOVB = new AMD64MIOp("MOVB", true, 198, 0, OpAssertion.ByteAssertion);
        public static final AMD64MIOp MOV = new AMD64MIOp("MOV", false, 199, 0);
        public static final AMD64MIOp TEST = new AMD64MIOp("TEST", false, 247, 0);
        private final int ext;

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext) {
            this(opcode, immIsByte, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int op, int ext, OpAssertion assertion) {
            this(opcode, immIsByte, 0, op, ext, assertion);
        }

        protected AMD64MIOp(String opcode, boolean immIsByte, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, immIsByte, prefix, op, assertion);
            this.ext = ext;
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, dst, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm) {
            this.emit(asm, size, dst, imm, false);
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, int imm, boolean annotateImm) {
            assert (this.verify(asm, size, null, null));
            int insnPos = asm.position();
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, this.immediateSize(size));
            int immPos = asm.position();
            this.emitImmediate(asm, size, imm);
            int nextInsnPos = asm.position();
            if (annotateImm && asm.codePatchingAnnotationConsumer != null) {
                asm.codePatchingAnnotationConsumer.accept(new AMD64BaseAssembler.OperandDataAnnotation(insnPos, immPos, nextInsnPos - immPos, nextInsnPos));
            }
        }
    }

    public static final class AMD64MOp
    extends AMD64Op {
        public static final AMD64MOp NOT = new AMD64MOp("NOT", 247, 2);
        public static final AMD64MOp NEG = new AMD64MOp("NEG", 247, 3);
        public static final AMD64MOp MUL = new AMD64MOp("MUL", 247, 4);
        public static final AMD64MOp IMUL = new AMD64MOp("IMUL", 247, 5);
        public static final AMD64MOp DIV = new AMD64MOp("DIV", 247, 6);
        public static final AMD64MOp IDIV = new AMD64MOp("IDIV", 247, 7);
        public static final AMD64MOp INC = new AMD64MOp("INC", 255, 0);
        public static final AMD64MOp DEC = new AMD64MOp("DEC", 255, 1);
        public static final AMD64MOp PUSH = new AMD64MOp("PUSH", 255, 6);
        public static final AMD64MOp POP = new AMD64MOp("POP", 143, 0, OpAssertion.WordOrDwordAssertion);
        private final int ext;

        protected AMD64MOp(String opcode, int op, int ext) {
            this(opcode, 0, op, ext, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MOp(String opcode, int op, int ext, OpAssertion assertion) {
            this(opcode, 0, op, ext, assertion);
        }

        protected AMD64MOp(String opcode, int prefix, int op, int ext, OpAssertion assertion) {
            super(opcode, 0, prefix, op, assertion, null);
            this.ext = ext;
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst) {
            assert (this.verify(asm, size, dst, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, dst.encoding);
            asm.emitModRM(this.ext, dst);
        }

        public void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst) {
            assert (this.verify(asm, size, null, null));
            this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(null, dst), 0, 0);
            asm.emitOperandHelper(this.ext, dst, 0);
        }
    }

    public static class AMD64MROp
    extends AMD64RROp {
        public static final AMD64MROp MOVB = new AMD64MROp("MOVB", 136, OpAssertion.ByteAssertion);
        public static final AMD64MROp MOV = new AMD64MROp("MOV", 137);
        public static final AMD64MROp MOVD = new AMD64MROp("MOVD", 102, 15, 126, OpAssertion.IntToFloatAssertion, AMD64.CPUFeature.SSE2);
        public static final AMD64MROp MOVQ = new AMD64MROp("MOVQ", 102, 15, 126, OpAssertion.IntToFloatAssertion, AMD64.CPUFeature.SSE2);
        public static final AMD64MROp MOVSS = new AMD64MROp("MOVSS", 15, 17, OpAssertion.FloatAssertion, AMD64.CPUFeature.SSE);
        public static final AMD64MROp MOVSD = new AMD64MROp("MOVSD", 15, 17, OpAssertion.FloatAssertion, AMD64.CPUFeature.SSE);

        protected AMD64MROp(String opcode, int op) {
            this(opcode, 0, op);
        }

        protected AMD64MROp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, op, assertion);
        }

        protected AMD64MROp(String opcode, int prefix, int op) {
            this(opcode, prefix, op, OpAssertion.WordOrLargerAssertion);
        }

        protected AMD64MROp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, prefix, op, assertion, null);
        }

        protected AMD64MROp(String opcode, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, assertion, feature);
        }

        protected AMD64MROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, src, dst));
            if (this.isSSEInstruction()) {
                Register nds = Register.None;
                switch (this.op) {
                    case 17: {
                        if (size != AMD64BaseAssembler.OperandSize.SS && size != AMD64BaseAssembler.OperandSize.SD) break;
                        nds = src;
                        break;
                    }
                }
                asm.simdPrefix(src, nds, dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
                asm.emitByte(this.op);
                asm.emitModRM(src, dst);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, dst.encoding);
                asm.emitModRM(src, dst);
            }
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, AMD64Address dst, Register src) {
            assert (this.verify(asm, size, src, null));
            if (this.isSSEInstruction()) {
                asm.simdPrefix(src, Register.None, dst, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
                asm.emitByte(this.op);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(src, dst), src.encoding, 0);
            }
            asm.emitOperandHelper(src, dst, 0);
        }
    }

    public static class AMD64RMOp
    extends AMD64RROp {
        public static final AMD64RMOp IMUL = new AMD64RMOp("IMUL", 15, 175, OpAssertion.ByteOrLargerAssertion);
        public static final AMD64RMOp BSF = new AMD64RMOp("BSF", 15, 188);
        public static final AMD64RMOp BSR = new AMD64RMOp("BSR", 15, 189);
        public static final AMD64RMOp POPCNT = new AMD64RMOp("POPCNT", 243, 15, 184, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.POPCNT);
        public static final AMD64RMOp TZCNT = new AMD64RMOp("TZCNT", 243, 15, 188, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.BMI1);
        public static final AMD64RMOp LZCNT = new AMD64RMOp("LZCNT", 243, 15, 189, OpAssertion.DwordOrLargerAssertion, AMD64.CPUFeature.LZCNT);
        public static final AMD64RMOp MOVZXB = new AMD64RMOp("MOVZXB", 15, 182, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVZX = new AMD64RMOp("MOVZX", 15, 183, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXB = new AMD64RMOp("MOVSXB", 15, 190, false, true, OpAssertion.WordOrLargerAssertion);
        public static final AMD64RMOp MOVSX = new AMD64RMOp("MOVSX", 15, 191, OpAssertion.DwordOrLargerAssertion);
        public static final AMD64RMOp MOVSXD = new AMD64RMOp("MOVSXD", 99, OpAssertion.QwordAssertion);
        public static final AMD64RMOp MOVB = new AMD64RMOp("MOVB", 138, OpAssertion.ByteAssertion);
        public static final AMD64RMOp MOV = new AMD64RMOp("MOV", 139);
        public static final AMD64RMOp CMP = new AMD64RMOp("CMP", 59);
        public static final AMD64RMOp MOVD = new AMD64RMOp("MOVD", 102, 15, 110, OpAssertion.IntToFloatAssertion, AMD64.CPUFeature.SSE2);
        public static final AMD64RMOp MOVQ = new AMD64RMOp("MOVQ", 102, 15, 110, OpAssertion.IntToFloatAssertion, AMD64.CPUFeature.SSE2);
        public static final AMD64RMOp MOVSS = new AMD64RMOp("MOVSS", 15, 16, OpAssertion.FloatAssertion, AMD64.CPUFeature.SSE);
        public static final AMD64RMOp MOVSD = new AMD64RMOp("MOVSD", 15, 16, OpAssertion.FloatAssertion, AMD64.CPUFeature.SSE);
        public static final AMD64RMOp TESTB = new AMD64RMOp("TEST", 132, OpAssertion.ByteAssertion);
        public static final AMD64RMOp TEST = new AMD64RMOp("TEST", 133);

        protected AMD64RMOp(String opcode, int op) {
            this(opcode, 0, op);
        }

        protected AMD64RMOp(String opcode, int op, OpAssertion assertion) {
            this(opcode, 0, op, assertion);
        }

        protected AMD64RMOp(String opcode, int prefix, int op) {
            this(opcode, 0, prefix, op, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion) {
            this(opcode, 0, prefix, op, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, 0, prefix, op, assertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion) {
            super(opcode, 0, prefix, op, dstIsByte, srcIsByte, assertion, null);
        }

        protected AMD64RMOp(String opcode, int prefix1, int prefix2, int op, AMD64.CPUFeature feature) {
            this(opcode, prefix1, prefix2, op, OpAssertion.WordOrLargerAssertion, feature);
        }

        protected AMD64RMOp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        @Override
        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, Register src) {
            assert (this.verify(asm, size, dst, src));
            if (this.isSSEInstruction()) {
                Register nds = Register.None;
                switch (this.op) {
                    case 16: 
                    case 81: {
                        if (size != AMD64BaseAssembler.OperandSize.SS && size != AMD64BaseAssembler.OperandSize.SD) break;
                        nds = dst;
                        break;
                    }
                    case 42: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        nds = dst;
                        break;
                    }
                }
                asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
                asm.emitByte(this.op);
                asm.emitModRM(dst, src);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, src.encoding);
                asm.emitModRM(dst, src);
            }
        }

        public final void emit(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register dst, AMD64Address src) {
            assert (this.verify(asm, size, dst, null));
            if (this.isSSEInstruction()) {
                Register nds = Register.None;
                switch (this.op) {
                    case 81: {
                        if (size != AMD64BaseAssembler.OperandSize.SS && size != AMD64BaseAssembler.OperandSize.SD) break;
                        nds = dst;
                        break;
                    }
                    case 42: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        nds = dst;
                        break;
                    }
                }
                asm.simdPrefix(dst, nds, src, size, this.prefix1, this.prefix2, size == AMD64BaseAssembler.OperandSize.QWORD);
                asm.emitByte(this.op);
                asm.emitOperandHelper(dst, src, 0);
            } else {
                this.emitOpcode(asm, size, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, 0);
                asm.emitOperandHelper(dst, src, 0);
            }
        }
    }

    public static abstract class AMD64RROp
    extends AMD64Op {
        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, assertion, feature);
        }

        protected AMD64RROp(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, prefix1, prefix2, op, dstIsByte, srcIsByte, assertion, feature);
        }

        public abstract void emit(AMD64Assembler var1, AMD64BaseAssembler.OperandSize var2, Register var3, Register var4);
    }

    public static class AMD64ImmOp
    extends AMD64Op {
        private final boolean immIsByte;

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion) {
            this(opcode, immIsByte, prefix, op, assertion, null);
        }

        protected AMD64ImmOp(String opcode, boolean immIsByte, int prefix, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            super(opcode, 0, prefix, op, assertion, feature);
            this.immIsByte = immIsByte;
        }

        protected final void emitImmediate(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int imm) {
            if (this.immIsByte) {
                assert (imm == (byte)imm);
                asm.emitByte(imm);
            } else {
                size.emitImmediate(asm, imm);
            }
        }

        public final int immediateSize(AMD64BaseAssembler.OperandSize size) {
            if (this.immIsByte) {
                return 1;
            }
            return size.immediateSize();
        }
    }

    public static class AMD64Op {
        private final String opcode;
        protected final int prefix1;
        protected final int prefix2;
        protected final int op;
        final boolean dstIsByte;
        final boolean srcIsByte;
        private final OpAssertion assertion;
        private final AMD64.CPUFeature feature;

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, OpAssertion assertion, AMD64.CPUFeature feature) {
            this(opcode, prefix1, prefix2, op, assertion == OpAssertion.ByteAssertion, assertion == OpAssertion.ByteAssertion, assertion, feature);
        }

        protected AMD64Op(String opcode, int prefix1, int prefix2, int op, boolean dstIsByte, boolean srcIsByte, OpAssertion assertion, AMD64.CPUFeature feature) {
            this.opcode = opcode;
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
            this.op = op;
            this.dstIsByte = dstIsByte;
            this.srcIsByte = srcIsByte;
            this.assertion = assertion;
            this.feature = feature;
        }

        protected final void emitOpcode(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, int rxb, int dstEnc, int srcEnc) {
            if (this.prefix1 != 0) {
                asm.emitByte(this.prefix1);
            }
            if (size.getSizePrefix() != 0) {
                asm.emitByte(size.getSizePrefix());
            }
            int rexPrefix = 0x40 | rxb;
            if (size == AMD64BaseAssembler.OperandSize.QWORD) {
                rexPrefix |= 8;
            }
            if (rexPrefix != 64 || this.dstIsByte && dstEnc >= 4 || this.srcIsByte && srcEnc >= 4) {
                asm.emitByte(rexPrefix);
            }
            if (this.prefix2 > 255) {
                asm.emitShort(this.prefix2);
            } else if (this.prefix2 > 0) {
                asm.emitByte(this.prefix2);
            }
            asm.emitByte(this.op);
        }

        protected final boolean verify(AMD64Assembler asm, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (this.feature == null || asm.supports(this.feature)) : String.format("unsupported feature %s required for %s", this.feature, this.opcode);
            assert (this.assertion.checkOperands(this, size, resultReg, inputReg));
            return true;
        }

        public AMD64BaseAssembler.OperandSize[] getAllowedSizes() {
            return this.assertion.allowedSizes;
        }

        protected final boolean isSSEInstruction() {
            if (this.feature == null) {
                return false;
            }
            switch (this.feature) {
                case SSE: 
                case SSE2: 
                case SSE3: 
                case SSSE3: 
                case SSE4A: 
                case SSE4_1: 
                case SSE4_2: {
                    return true;
                }
            }
            return false;
        }

        public final OpAssertion getAssertion() {
            return this.assertion;
        }

        public String toString() {
            return this.opcode;
        }
    }

    private static final class OpAssertion
    extends Enum<OpAssertion> {
        public static final /* enum */ OpAssertion ByteAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE);
        public static final /* enum */ OpAssertion ByteOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.BYTE, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion DwordOrLargerAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion WordOrDwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.WORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion QwordAssertion = new OpAssertion(AMD64.CPU, AMD64.CPU, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS, AMD64BaseAssembler.OperandSize.SD, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion PackedFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PS, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion SingleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SS);
        public static final /* enum */ OpAssertion DoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.SD);
        public static final /* enum */ OpAssertion PackedDoubleAssertion = new OpAssertion(AMD64.XMM, AMD64.XMM, AMD64BaseAssembler.OperandSize.PD);
        public static final /* enum */ OpAssertion IntToFloatAssertion = new OpAssertion(AMD64.XMM, AMD64.CPU, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        public static final /* enum */ OpAssertion FloatToIntAssertion = new OpAssertion(AMD64.CPU, AMD64.XMM, AMD64BaseAssembler.OperandSize.DWORD, AMD64BaseAssembler.OperandSize.QWORD);
        private final Register.RegisterCategory resultCategory;
        private final Register.RegisterCategory inputCategory;
        private final AMD64BaseAssembler.OperandSize[] allowedSizes;
        private static final /* synthetic */ OpAssertion[] $VALUES;

        public static OpAssertion[] values() {
            return (OpAssertion[])$VALUES.clone();
        }

        public static OpAssertion valueOf(String name) {
            return Enum.valueOf(OpAssertion.class, name);
        }

        private OpAssertion(Register.RegisterCategory resultCategory, Register.RegisterCategory inputCategory, AMD64BaseAssembler.OperandSize ... allowedSizes) {
            this.resultCategory = resultCategory;
            this.inputCategory = inputCategory;
            this.allowedSizes = allowedSizes;
        }

        protected boolean checkOperands(AMD64Op op, AMD64BaseAssembler.OperandSize size, Register resultReg, Register inputReg) {
            assert (resultReg == null || this.resultCategory.equals((Object)resultReg.getRegisterCategory())) : "invalid result register " + resultReg + " used in " + op;
            assert (inputReg == null || this.inputCategory.equals((Object)inputReg.getRegisterCategory())) : "invalid input register " + inputReg + " used in " + op;
            for (AMD64BaseAssembler.OperandSize s : this.allowedSizes) {
                if (size != s) continue;
                return true;
            }
            assert (false) : "invalid operand size " + (Object)((Object)size) + " used in " + op;
            return false;
        }

        static {
            $VALUES = new OpAssertion[]{ByteAssertion, ByteOrLargerAssertion, WordOrLargerAssertion, DwordOrLargerAssertion, WordOrDwordAssertion, QwordAssertion, FloatAssertion, PackedFloatAssertion, SingleAssertion, DoubleAssertion, PackedDoubleAssertion, IntToFloatAssertion, FloatToIntAssertion};
        }
    }

    public static enum ConditionFlag {
        Zero(4, "|zero|"),
        NotZero(5, "|nzero|"),
        Equal(4, "="),
        NotEqual(5, "!="),
        Less(12, "<"),
        LessEqual(14, "<="),
        Greater(15, ">"),
        GreaterEqual(13, ">="),
        Below(2, "|<|"),
        BelowEqual(6, "|<=|"),
        Above(7, "|>|"),
        AboveEqual(3, "|>=|"),
        Overflow(0, "|of|"),
        NoOverflow(1, "|nof|"),
        CarrySet(2, "|carry|"),
        CarryClear(3, "|ncarry|"),
        Negative(8, "|neg|"),
        Positive(9, "|pos|"),
        Parity(10, "|par|"),
        NoParity(11, "|npar|");

        private final int value;
        private final String operator;

        private ConditionFlag(int value, String operator) {
            this.value = value;
            this.operator = operator;
        }

        public ConditionFlag negate() {
            switch (this) {
                case Zero: {
                    return NotZero;
                }
                case NotZero: {
                    return Zero;
                }
                case Equal: {
                    return NotEqual;
                }
                case NotEqual: {
                    return Equal;
                }
                case Less: {
                    return GreaterEqual;
                }
                case LessEqual: {
                    return Greater;
                }
                case Greater: {
                    return LessEqual;
                }
                case GreaterEqual: {
                    return Less;
                }
                case Below: {
                    return AboveEqual;
                }
                case BelowEqual: {
                    return Above;
                }
                case Above: {
                    return BelowEqual;
                }
                case AboveEqual: {
                    return Below;
                }
                case Overflow: {
                    return NoOverflow;
                }
                case NoOverflow: {
                    return Overflow;
                }
                case CarrySet: {
                    return CarryClear;
                }
                case CarryClear: {
                    return CarrySet;
                }
                case Negative: {
                    return Positive;
                }
                case Positive: {
                    return Negative;
                }
                case Parity: {
                    return NoParity;
                }
                case NoParity: {
                    return Parity;
                }
            }
            throw new IllegalArgumentException();
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.operator;
        }
    }

    public static interface CodePatchShifter {
        public void shift(int var1, int var2);
    }

    public static class Options {
        @Option(help={"Force branch instructions to align with 32-bytes boundary, to mitigate the jcc erratum. See https://www.intel.com/content/dam/support/us/en/documents/processors/mitigations-jump-conditional-code-erratum.pdf for more details. If not set explicitly, the default value will be determined according to the CPU model."}, type=OptionType.User)
        public static final OptionKey<Boolean> UseBranchesWithin32ByteBoundary = new OptionKey<Boolean>(false);
    }
}

