/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.BranchTargetOutOfBoundsException;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public class AArch64MacroAssembler
extends AArch64Assembler {
    private final ScratchRegister[] scratchRegister = new ScratchRegister[]{new ScratchRegister(AArch64.rscratch1), new ScratchRegister(AArch64.rscratch2)};
    private int nextFreeScratchRegister = 0;
    private AArch64MemoryEncoding lastImmLoadStoreEncoding;
    private boolean isImmLoadStoreMerged = false;

    public AArch64MacroAssembler(TargetDescription target) {
        super(target);
    }

    public ScratchRegister getScratchRegister() {
        return this.scratchRegister[this.nextFreeScratchRegister++];
    }

    @Override
    public void bind(Label l) {
        super.bind(l);
        this.lastImmLoadStoreEncoding = null;
    }

    public static AddressGenerationPlan generateAddressPlan(long displacement, boolean hasIndexRegister, int transferSize) {
        boolean displacementScalable;
        assert (transferSize == 0 || transferSize == 1 || transferSize == 2 || transferSize == 4 || transferSize == 8);
        boolean indexScaled = transferSize != 0;
        int log2Scale = NumUtil.log2Ceil(transferSize);
        long scaledDisplacement = displacement >> log2Scale;
        boolean bl = displacementScalable = indexScaled && (displacement & (long)(transferSize - 1)) == 0L;
        if (displacement == 0L) {
            return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.NO_WORK, AArch64Address.AddressingMode.REGISTER_OFFSET, false);
        }
        if (hasIndexRegister) {
            if (displacementScalable) {
                boolean needsScratch = !AArch64MacroAssembler.isArithmeticImmediate(scaledDisplacement);
                return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.ADD_TO_INDEX, AArch64Address.AddressingMode.REGISTER_OFFSET, needsScratch);
            }
            boolean needsScratch = !AArch64MacroAssembler.isArithmeticImmediate(displacement);
            return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.ADD_TO_BASE, AArch64Address.AddressingMode.REGISTER_OFFSET, needsScratch);
        }
        if (displacementScalable && NumUtil.isUnsignedNbit(12, scaledDisplacement)) {
            return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.NO_WORK, AArch64Address.AddressingMode.IMMEDIATE_SCALED, false);
        }
        if (NumUtil.isSignedNbit(9, displacement)) {
            return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.NO_WORK, AArch64Address.AddressingMode.IMMEDIATE_UNSCALED, false);
        }
        boolean needsScratch = !AArch64MacroAssembler.isArithmeticImmediate(displacement);
        return new AddressGenerationPlan(AddressGenerationPlan.WorkPlan.ADD_TO_BASE, AArch64Address.AddressingMode.REGISTER_OFFSET, needsScratch);
    }

    public AArch64Address makeAddress(Register base, long displacement, Register index, boolean signExtendIndex, int transferSize, Register additionalReg, boolean allowOverwrite) {
        int immediate;
        AddressGenerationPlan plan = AArch64MacroAssembler.generateAddressPlan(displacement, !index.equals((Object)AArch64.zr), transferSize);
        assert (allowOverwrite || !AArch64.zr.equals((Object)additionalReg) || plan.workPlan == AddressGenerationPlan.WorkPlan.NO_WORK);
        assert (!plan.needsScratch || !AArch64.zr.equals((Object)additionalReg));
        int log2Scale = NumUtil.log2Ceil(transferSize);
        long scaledDisplacement = displacement >> log2Scale;
        Register newIndex = index;
        Register newBase = base;
        switch (plan.workPlan) {
            case NO_WORK: {
                if (plan.addressingMode == AArch64Address.AddressingMode.IMMEDIATE_SCALED) {
                    immediate = (int)scaledDisplacement;
                    break;
                }
                immediate = (int)displacement;
                break;
            }
            case ADD_TO_INDEX: {
                Register register = newIndex = allowOverwrite ? index : additionalReg;
                assert (!newIndex.equals((Object)AArch64.sp) && !newIndex.equals((Object)AArch64.zr));
                if (plan.needsScratch) {
                    this.mov(additionalReg, scaledDisplacement);
                    this.add(signExtendIndex ? 32 : 64, newIndex, index, additionalReg);
                } else {
                    this.add(signExtendIndex ? 32 : 64, newIndex, index, (int)scaledDisplacement);
                }
                immediate = 0;
                break;
            }
            case ADD_TO_BASE: {
                Register register = newBase = allowOverwrite ? base : additionalReg;
                assert (!newBase.equals((Object)AArch64.sp) && !newBase.equals((Object)AArch64.zr));
                if (plan.needsScratch) {
                    this.mov(additionalReg, displacement);
                    this.add(64, newBase, base, additionalReg);
                } else {
                    this.add(64, newBase, base, (int)displacement);
                }
                immediate = 0;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        AArch64Address.AddressingMode addressingMode = plan.addressingMode;
        AArch64Assembler.ExtendType extendType = null;
        if (addressingMode == AArch64Address.AddressingMode.REGISTER_OFFSET) {
            if (newIndex.equals((Object)AArch64.zr)) {
                addressingMode = AArch64Address.AddressingMode.BASE_REGISTER_ONLY;
            } else if (signExtendIndex) {
                addressingMode = AArch64Address.AddressingMode.EXTENDED_REGISTER_OFFSET;
                extendType = AArch64Assembler.ExtendType.SXTW;
            }
        }
        return AArch64Address.createAddress(addressingMode, newBase, newIndex, immediate, transferSize != 0, extendType);
    }

    public AArch64Address makeAddress(Register base, long displacement, Register additionalReg, int transferSize, boolean allowOverwrite) {
        assert (additionalReg.getRegisterCategory().equals((Object)AArch64.CPU));
        return this.makeAddress(base, displacement, AArch64.zr, false, transferSize, additionalReg, allowOverwrite);
    }

    public AArch64Address makeAddress(Register base, long displacement, int transferSize) {
        return this.makeAddress(base, displacement, AArch64.zr, false, transferSize, AArch64.zr, false);
    }

    public void loadAddress(Register dst, AArch64Address address, int transferSize) {
        assert (transferSize == 1 || transferSize == 2 || transferSize == 4 || transferSize == 8);
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        int shiftAmt = NumUtil.log2Ceil(transferSize);
        switch (address.getAddressingMode()) {
            case IMMEDIATE_SCALED: {
                int scaledImmediate = address.getImmediateRaw() << shiftAmt;
                int lowerBits = scaledImmediate & NumUtil.getNbitNumberInt(12);
                int higherBits = scaledImmediate & ~NumUtil.getNbitNumberInt(12);
                boolean firstAdd = true;
                if (lowerBits != 0) {
                    this.add(64, dst, address.getBase(), lowerBits);
                    firstAdd = false;
                }
                if (higherBits == 0) break;
                Register src = firstAdd ? address.getBase() : dst;
                this.add(64, dst, src, higherBits);
                break;
            }
            case IMMEDIATE_UNSCALED: {
                int immediate = address.getImmediateRaw();
                this.add(64, dst, address.getBase(), immediate);
                break;
            }
            case REGISTER_OFFSET: {
                this.add(64, dst, address.getBase(), address.getOffset(), AArch64Assembler.ShiftType.LSL, address.isScaled() ? shiftAmt : 0);
                break;
            }
            case EXTENDED_REGISTER_OFFSET: {
                this.add(64, dst, address.getBase(), address.getOffset(), address.getExtendType(), address.isScaled() ? shiftAmt : 0);
                break;
            }
            case PC_LITERAL: {
                this.addressOf(dst);
                break;
            }
            case BASE_REGISTER_ONLY: {
                this.movx(dst, address.getBase());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryMerge(int sizeInBytes, Register rt, AArch64Address address, boolean isStore) {
        int preOffset;
        Register preBase;
        this.isImmLoadStoreMerged = false;
        if (this.lastImmLoadStoreEncoding == null) {
            return false;
        }
        AArch64Address.AddressingMode addressMode = address.getAddressingMode();
        if (addressMode != AArch64Address.AddressingMode.IMMEDIATE_SCALED && addressMode != AArch64Address.AddressingMode.IMMEDIATE_UNSCALED) {
            return false;
        }
        int lastPosition = this.position() - 4;
        if (lastPosition < 0 || lastPosition != this.lastImmLoadStoreEncoding.position) {
            return false;
        }
        if (isStore != this.lastImmLoadStoreEncoding.isStore) {
            return false;
        }
        if (sizeInBytes != this.lastImmLoadStoreEncoding.sizeInBytes || sizeInBytes != 4 && sizeInBytes != 8) {
            return false;
        }
        Register curBase = address.getBase();
        if (!curBase.equals((Object)(preBase = this.lastImmLoadStoreEncoding.getBase()))) {
            return false;
        }
        Register curRt = rt;
        Register preRt = this.lastImmLoadStoreEncoding.result;
        if (!isStore && (curRt.equals((Object)preRt) || preRt.equals((Object)curBase))) {
            return false;
        }
        int curOffset = address.getImmediateRaw();
        if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_SCALED) {
            curOffset *= sizeInBytes;
        }
        if (Math.abs(curOffset - (preOffset = this.lastImmLoadStoreEncoding.getOffset())) != sizeInBytes) {
            return false;
        }
        int offset = curOffset > preOffset ? preOffset : curOffset;
        int minOffset = -64 * sizeInBytes;
        int maxOffset = 63 * sizeInBytes;
        if (offset < minOffset || offset > maxOffset) {
            return false;
        }
        if (this.isFlagSet(AArch64.Flag.AvoidUnalignedAccesses)) {
            if (!curBase.equals((Object)AArch64.sp)) return false;
            long pairMask = sizeInBytes * 2 - 1;
            if (((long)offset & pairMask) != 0L) {
                return false;
            }
        } else {
            long mask = sizeInBytes - 1;
            if (((long)curOffset & mask) != 0L || ((long)preOffset & mask) != 0L) {
                return false;
            }
        }
        Register rt1 = preRt;
        Register rt2 = curRt;
        if (curOffset < preOffset) {
            rt1 = curRt;
            rt2 = preRt;
        }
        int immediate = offset / sizeInBytes;
        AArch64Assembler.Instruction instruction = isStore ? AArch64Assembler.Instruction.STP : AArch64Assembler.Instruction.LDP;
        int size = sizeInBytes * 8;
        this.insertLdpStp(size, instruction, rt1, rt2, curBase, immediate, lastPosition);
        this.lastImmLoadStoreEncoding = null;
        this.isImmLoadStoreMerged = true;
        return true;
    }

    private boolean tryMergeLoadStore(int srcSize, Register rt, AArch64Address address, boolean isStore) {
        int sizeInBytes = srcSize / 8;
        if (this.tryMerge(sizeInBytes, rt, address, isStore)) {
            return true;
        }
        AArch64Address.AddressingMode addressMode = address.getAddressingMode();
        if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_SCALED || addressMode == AArch64Address.AddressingMode.IMMEDIATE_UNSCALED) {
            if (addressMode == AArch64Address.AddressingMode.IMMEDIATE_UNSCALED) {
                long mask = sizeInBytes - 1;
                int offset = address.getImmediateRaw();
                if (((long)offset & mask) != 0L) {
                    return false;
                }
            }
            this.lastImmLoadStoreEncoding = new AArch64MemoryEncoding(sizeInBytes, rt, address, isStore, this.position());
        }
        return false;
    }

    public boolean isImmLoadStoreMerged() {
        return this.isImmLoadStoreMerged;
    }

    public void movx(Register dst, Register src) {
        this.mov(64, dst, src);
    }

    public void mov(int size, Register dst, Register src) {
        if (dst.equals((Object)AArch64.sp) || src.equals((Object)AArch64.sp)) {
            this.add(size, dst, src, 0);
        } else {
            this.or(size, dst, AArch64.zr, src);
        }
    }

    private void mov32(Register dst, int imm, boolean needsImmAnnotation) {
        MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED};
        int pos = this.position();
        int low16 = imm & 0xFFFF;
        int high16 = imm >>> 16 & 0xFFFF;
        if (high16 == 0) {
            this.movz(32, dst, low16, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
        } else if (high16 == 65535) {
            this.movn(32, dst, low16 ^ 0xFFFF, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.NEGATED;
        } else if (low16 == 0) {
            this.movz(32, dst, high16, 16);
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
        } else if (low16 == 65535) {
            this.movn(32, dst, high16 ^ 0xFFFF, 16);
            includeSet[1] = MovSequenceAnnotation.MovAction.NEGATED;
        } else {
            this.movz(32, dst, low16, 0);
            this.movk(32, dst, high16, 16);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
        }
        if (needsImmAnnotation) {
            this.annotateImmediateMovSequence(pos, includeSet);
        }
    }

    private void mov64(Register dst, long imm, boolean needsImmAnnotation) {
        int numMovks;
        int k;
        int i;
        MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED, MovSequenceAnnotation.MovAction.SKIPPED};
        int pos = this.position();
        int[] chunks = new int[4];
        int zeroCount = 0;
        int negCount = 0;
        for (i = 0; i < 4; ++i) {
            int chunk = (int)(imm >>> i * 16 & 0xFFFFL);
            if (chunk == 0) {
                ++zeroCount;
            } else if (chunk == 65535) {
                ++negCount;
            }
            chunks[i] = chunk;
        }
        if (zeroCount == 4) {
            this.movz(64, dst, 0, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
        } else if (negCount == 4) {
            this.movn(64, dst, 0, 0);
            includeSet[0] = MovSequenceAnnotation.MovAction.NEGATED;
        } else if (zeroCount == 3) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (negCount == 3) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
        } else if (zeroCount == 2) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
            for (k = i + 1; k < 4; ++k) {
                if (chunks[k] == 0) continue;
                this.movk(64, dst, chunks[k], k * 16);
                includeSet[k] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (negCount == 2) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
            for (k = i + 1; k < 4; ++k) {
                if (chunks[k] == 65535) continue;
                this.movk(64, dst, chunks[k], k * 16);
                includeSet[k] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
        } else if (zeroCount == 1) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 0) continue;
                this.movz(64, dst, chunks[i], i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.USED;
                break;
            }
            numMovks = 0;
            for (int k2 = i + 1; k2 < 4; ++k2) {
                if (chunks[k2] == 0) continue;
                this.movk(64, dst, chunks[k2], k2 * 16);
                includeSet[k2] = MovSequenceAnnotation.MovAction.USED;
                ++numMovks;
            }
            assert (numMovks == 2);
        } else if (negCount == 1) {
            for (i = 0; i < 4; ++i) {
                if (chunks[i] == 65535) continue;
                this.movn(64, dst, chunks[i] ^ 0xFFFF, i * 16);
                includeSet[i] = MovSequenceAnnotation.MovAction.NEGATED;
                break;
            }
            numMovks = 0;
            for (int k3 = i + 1; k3 < 4; ++k3) {
                if (chunks[k3] == 65535) continue;
                this.movk(64, dst, chunks[k3], k3 * 16);
                includeSet[k3] = MovSequenceAnnotation.MovAction.USED;
                ++numMovks;
            }
            assert (numMovks == 2);
        } else {
            this.movz(64, dst, chunks[0], 0);
            this.movk(64, dst, chunks[1], 16);
            this.movk(64, dst, chunks[2], 32);
            this.movk(64, dst, chunks[3], 48);
            includeSet[0] = MovSequenceAnnotation.MovAction.USED;
            includeSet[1] = MovSequenceAnnotation.MovAction.USED;
            includeSet[2] = MovSequenceAnnotation.MovAction.USED;
            includeSet[3] = MovSequenceAnnotation.MovAction.USED;
        }
        if (needsImmAnnotation) {
            this.annotateImmediateMovSequence(pos, includeSet);
        }
    }

    public void mov(Register dst, int imm) {
        this.mov(dst, imm, false);
    }

    public void mov(Register dst, long imm) {
        this.mov(dst, imm, false);
    }

    public void mov(Register dst, int imm, boolean needsImmAnnotation) {
        if (imm == 0) {
            this.mov(32, dst, AArch64.zr);
        } else if (AArch64MacroAssembler.isLogicalImmediate(imm)) {
            this.or(32, dst, AArch64.zr, imm);
        } else {
            this.mov32(dst, imm, needsImmAnnotation);
        }
    }

    public void mov(Register dst, long imm, boolean needsImmAnnotation) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        if (imm == 0L) {
            this.movx(dst, AArch64.zr);
        } else if (AArch64MacroAssembler.isLogicalImmediate(imm)) {
            this.or(64, dst, AArch64.zr, imm);
        } else if (imm >> 32 == -1L && (int)imm < 0 && AArch64Assembler.LogicalImmediateTable.isRepresentable((int)imm) != AArch64Assembler.LogicalImmediateTable.Representable.NO) {
            this.mov(dst, (int)imm);
            this.sxt(64, 32, dst, dst);
        } else {
            this.mov64(dst, imm, needsImmAnnotation);
        }
    }

    public void movNativeAddress(Register dst, long imm) {
        this.movNativeAddress(dst, imm, false);
    }

    public void movNativeAddress(Register dst, long imm, boolean needsImmAnnotation) {
        assert ((imm & 0xFFFF000000000000L) == 0L);
        boolean firstMove = true;
        int pos = this.position();
        for (int offset = 0; offset < 48; offset += 16) {
            int chunk = (int)(imm >> offset) & NumUtil.getNbitNumberInt(16);
            if (firstMove) {
                this.movz(64, dst, chunk, offset);
                firstMove = false;
                continue;
            }
            this.movk(64, dst, chunk, offset);
        }
        if (needsImmAnnotation) {
            MovSequenceAnnotation.MovAction[] includeSet = new MovSequenceAnnotation.MovAction[]{MovSequenceAnnotation.MovAction.USED, MovSequenceAnnotation.MovAction.USED, MovSequenceAnnotation.MovAction.USED};
            this.annotateImmediateMovSequence(pos, includeSet);
        }
        assert (!firstMove);
    }

    public void movNarrowAddress(Register dst, long imm) {
        assert ((imm & 0xFFFFFFFF00000000L) == 0L);
        this.movz(64, dst, (int)(imm >>> 16), 16);
        this.movk(64, dst, (int)(imm & 0xFFFFL), 0);
    }

    public static int nrInstructionsToMoveImmediate(long imm) {
        if (imm == 0L || AArch64Assembler.LogicalImmediateTable.isRepresentable(true, imm) != AArch64Assembler.LogicalImmediateTable.Representable.NO) {
            return 1;
        }
        if (imm >> 32 == -1L && (int)imm < 0 && AArch64Assembler.LogicalImmediateTable.isRepresentable((int)imm) != AArch64Assembler.LogicalImmediateTable.Representable.NO) {
            return 2;
        }
        int nrInstructions = 0;
        for (int offset = 0; offset < 64; offset += 16) {
            int part = (int)(imm >> offset) & NumUtil.getNbitNumberInt(16);
            if (part == 0) continue;
            ++nrInstructions;
        }
        return nrInstructions;
    }

    @Override
    public void ldrs(int targetSize, int srcSize, Register rt, AArch64Address address) {
        assert (targetSize == 32 || targetSize == 64);
        assert (srcSize <= targetSize);
        if (targetSize == srcSize) {
            this.ldr(srcSize, rt, address);
        } else {
            super.ldrs(targetSize, srcSize, rt, address);
        }
    }

    @Override
    public void ldr(int srcSize, Register rt, AArch64Address address) {
        if (!this.tryMergeLoadStore(srcSize, rt, address, false)) {
            super.ldr(srcSize, rt, address);
        }
    }

    @Override
    public void str(int destSize, Register rt, AArch64Address address) {
        if (!this.tryMergeLoadStore(destSize, rt, address, true)) {
            super.str(destSize, rt, address);
        }
    }

    public void cmov(int size, Register result, Register trueValue, Register falseValue, AArch64Assembler.ConditionFlag cond) {
        super.csel(size, result, trueValue, falseValue, cond);
    }

    public void cset(int size, Register dst, AArch64Assembler.ConditionFlag condition) {
        super.csinc(size, dst, AArch64.zr, AArch64.zr, condition.negate());
    }

    public void add(int size, Register dst, Register src1, Register src2) {
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.add(size, dst, src1, src2, AArch64Assembler.ExtendType.UXTX, 0);
        } else {
            super.add(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void adds(int size, Register dst, Register src1, Register src2) {
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.adds(size, dst, src1, src2, AArch64Assembler.ExtendType.UXTX, 0);
        } else {
            super.adds(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void subs(int size, Register dst, Register src1, Register src2) {
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.subs(size, dst, src1, src2, AArch64Assembler.ExtendType.UXTX, 0);
        } else {
            super.subs(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    public void sub(int size, Register dst, Register src1, Register src2) {
        if (dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp)) {
            super.sub(size, dst, src1, src2, AArch64Assembler.ExtendType.UXTX, 0);
        } else {
            super.sub(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
        }
    }

    @Override
    public void add(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        int shift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        super.add(size, dst, src1, src2, shiftType, shift);
    }

    @Override
    public void sub(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        int shift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        super.sub(size, dst, src1, src2, shiftType, shift);
    }

    public void neg(int size, Register dst, Register src) {
        this.sub(size, dst, AArch64.zr, src);
    }

    @Override
    public void add(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.sub(size, dst, src, -immediate);
        } else if (AArch64MacroAssembler.isAimm(immediate)) {
            if (!dst.equals((Object)src) || immediate != 0) {
                super.add(size, dst, src, immediate);
            }
        } else if (immediate >= -16777216 && immediate < 0x1000000) {
            super.add(size, dst, src, immediate & 0xFFFFF000);
            super.add(size, dst, dst, immediate & 0xFFF);
        } else {
            assert (!dst.equals((Object)src));
            this.mov(dst, immediate);
            this.add(size, src, dst, dst);
        }
    }

    public void add(int size, Register dst, Register src, long immediate) {
        if (NumUtil.isInt(immediate)) {
            this.add(size, dst, src, (int)immediate);
        } else {
            assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
            assert (!dst.equals((Object)src));
            assert (size == 64);
            this.mov(dst, immediate);
            this.add(size, src, dst, dst);
        }
    }

    @Override
    public void adds(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.sp) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.subs(size, dst, src, -immediate);
        } else if (!dst.equals((Object)src) || immediate != 0) {
            super.adds(size, dst, src, immediate);
        }
    }

    @Override
    public void sub(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.zr) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.add(size, dst, src, -immediate);
        } else if (AArch64MacroAssembler.isAimm(immediate)) {
            if (!dst.equals((Object)src) || immediate != 0) {
                super.sub(size, dst, src, immediate);
            }
        } else if (immediate >= -16777216 && immediate < 0x1000000) {
            super.sub(size, dst, src, immediate & 0xFFFFF000);
            super.sub(size, dst, dst, immediate & 0xFFF);
        } else {
            assert (!dst.equals((Object)src));
            this.mov(dst, immediate);
            this.sub(size, src, dst, dst);
        }
    }

    @Override
    public void subs(int size, Register dst, Register src, int immediate) {
        assert (!dst.equals((Object)AArch64.sp) && !src.equals((Object)AArch64.zr));
        if (immediate < 0) {
            this.adds(size, dst, src, -immediate);
        } else if (!dst.equals((Object)src) || immediate != 0) {
            super.subs(size, dst, src, immediate);
        }
    }

    public void mul(int size, Register dst, Register src1, Register src2) {
        super.madd(size, dst, src1, src2, AArch64.zr);
    }

    @Override
    public void madd(int size, Register dst, Register src1, Register src2, Register src3) {
        super.madd(size, dst, src1, src2, src3);
    }

    @Override
    public void msub(int size, Register dst, Register src1, Register src2, Register src3) {
        super.msub(size, dst, src1, src2, src3);
    }

    public void mneg(int size, Register dst, Register src1, Register src2) {
        super.msub(size, dst, src1, src2, AArch64.zr);
    }

    public void umulh(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp)));
        assert (size == 32 || size == 64);
        if (size == 64) {
            super.umulh(dst, src1, src2);
        } else {
            super.umaddl(dst, src1, src2, AArch64.zr);
            this.lshr(64, dst, dst, 32L);
        }
    }

    public void smulh(int size, Register dst, Register src1, Register src2) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp)));
        assert (size == 32 || size == 64);
        if (size == 64) {
            super.smulh(dst, src1, src2);
        } else {
            super.smaddl(dst, src1, src2, AArch64.zr);
            this.lshr(64, dst, dst, 32L);
        }
    }

    public void smull(int size, Register dst, Register src1, Register src2) {
        this.smaddl(size, dst, src1, src2, AArch64.zr);
    }

    public void smnegl(int size, Register dst, Register src1, Register src2) {
        this.smsubl(size, dst, src1, src2, AArch64.zr);
    }

    public void smaddl(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp) || src3.equals((Object)AArch64.sp)));
        assert (size == 64);
        super.smaddl(dst, src1, src2, src3);
    }

    public void smsubl(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (!(dst.equals((Object)AArch64.sp) || src1.equals((Object)AArch64.sp) || src2.equals((Object)AArch64.sp) || src3.equals((Object)AArch64.sp)));
        assert (size == 64);
        super.smsubl(dst, src1, src2, src3);
    }

    public void rem(int size, Register dst, Register n, Register d) {
        assert (!(dst.equals((Object)AArch64.sp) || n.equals((Object)AArch64.sp) || d.equals((Object)AArch64.sp)));
        super.sdiv(size, dst, n, d);
        super.msub(size, dst, dst, d, n);
    }

    public void urem(int size, Register dst, Register n, Register d) {
        super.udiv(size, dst, n, d);
        super.msub(size, dst, dst, d, n);
    }

    public static boolean isArithmeticImmediate(long imm) {
        return NumUtil.isInt(Math.abs(imm)) && AArch64MacroAssembler.isAimm((int)Math.abs(imm));
    }

    public static boolean isComparisonImmediate(long imm) {
        return AArch64MacroAssembler.isArithmeticImmediate(imm);
    }

    public static boolean isMovableImmediate(long imm) {
        return NumUtil.isInt(Math.abs(imm)) && NumUtil.isUnsignedNbit(16, (int)Math.abs(imm));
    }

    public void shl(int size, Register dst, Register src, long shiftAmt) {
        int shift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        super.ubfm(size, dst, src, size - shift & size - 1, size - 1 - shift);
    }

    public void shl(int size, Register dst, Register src, Register shift) {
        super.lsl(size, dst, src, shift);
    }

    public void lshr(int size, Register dst, Register src, long shiftAmt) {
        int shift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        super.ubfm(size, dst, src, shift, size - 1);
    }

    public void lshr(int size, Register dst, Register src, Register shift) {
        super.lsr(size, dst, src, shift);
    }

    public void ashr(int size, Register dst, Register src, long shiftAmt) {
        int shift = AArch64MacroAssembler.clampShiftAmt(size, shiftAmt);
        super.sbfm(size, dst, src, shift, size - 1);
    }

    public void ashr(int size, Register dst, Register src, Register shift) {
        super.asr(size, dst, src, shift);
    }

    @Override
    public void rorv(int size, Register dst, Register src1, Register src2) {
        super.rorv(size, dst, src1, src2);
    }

    public void ror(int size, Register dst, Register src, int shift) {
        assert (0 <= shift && shift <= size - 1);
        super.extr(size, dst, src, src, shift);
    }

    private static int clampShiftAmt(int size, long shiftAmt) {
        return (int)(shiftAmt & (long)(size - 1));
    }

    public void and(int size, Register dst, Register src1, Register src2) {
        super.and(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void eor(int size, Register dst, Register src1, Register src2) {
        super.eor(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void or(int size, Register dst, Register src1, Register src2) {
        super.orr(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void or(int size, Register dst, Register src, long bimm) {
        super.orr(size, dst, src, bimm);
    }

    public void bic(int size, Register dst, Register src1, Register src2) {
        super.bic(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void eon(int size, Register dst, Register src1, Register src2) {
        super.eon(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void orn(int size, Register dst, Register src1, Register src2) {
        super.orn(size, dst, src1, src2, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void not(int size, Register dst, Register src) {
        super.orn(size, dst, AArch64.zr, src, AArch64Assembler.ShiftType.LSL, 0);
    }

    @Override
    public void and(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.and(size, dst, src1, src2, shiftType, shiftAmt);
    }

    @Override
    public void eor(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.eor(size, dst, src1, src2, shiftType, shiftAmt);
    }

    public void or(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.orr(size, dst, src1, src2, shiftType, shiftAmt);
    }

    @Override
    public void bic(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.bic(size, dst, src1, src2, shiftType, shiftAmt);
    }

    @Override
    public void eon(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.eon(size, dst, src1, src2, shiftType, shiftAmt);
    }

    @Override
    public void orn(int size, Register dst, Register src1, Register src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
        super.orn(size, dst, src1, src2, shiftType, shiftAmt);
    }

    public void sxt(int destSize, int srcSize, Register dst, Register src) {
        assert (srcSize < destSize && srcSize > 0);
        super.sbfm(destSize, dst, src, 0, srcSize - 1);
    }

    public void csneg(int size, Register dst, Register src, AArch64Assembler.ConditionFlag condition) {
        super.csneg(size, dst, src, src, condition.negate());
    }

    public static boolean isLogicalImmediate(long imm) {
        return AArch64Assembler.LogicalImmediateTable.isRepresentable(true, imm) != AArch64Assembler.LogicalImmediateTable.Representable.NO;
    }

    public static boolean isLogicalImmediate(int imm) {
        return AArch64Assembler.LogicalImmediateTable.isRepresentable(imm) == AArch64Assembler.LogicalImmediateTable.Representable.YES;
    }

    @Override
    public void fmov(int size, Register dst, Register src) {
        assert (!dst.getRegisterCategory().equals((Object)AArch64.CPU) || !src.getRegisterCategory().equals((Object)AArch64.CPU)) : "src and dst cannot both be integer registers.";
        if (dst.getRegisterCategory().equals((Object)AArch64.CPU)) {
            super.fmovFpu2Cpu(size, dst, src);
        } else if (src.getRegisterCategory().equals((Object)AArch64.CPU)) {
            super.fmovCpu2Fpu(size, dst, src);
        } else {
            super.fmov(size, dst, src);
        }
    }

    @Override
    public void fmov(int size, Register dst, double imm) {
        if (imm == 0.0) {
            assert (Double.doubleToRawLongBits(imm) == 0L) : "-0.0 is no valid immediate.";
            super.fmovCpu2Fpu(size, dst, AArch64.zr);
        } else {
            super.fmov(size, dst, imm);
        }
    }

    public static boolean isDoubleImmediate(double imm) {
        return Double.doubleToRawLongBits(imm) == 0L || AArch64Assembler.isDoubleImmediate(imm);
    }

    public static boolean isFloatImmediate(float imm) {
        return Float.floatToRawIntBits(imm) == 0 || AArch64Assembler.isFloatImmediate(imm);
    }

    public void fcmov(int size, Register result, Register trueValue, Register falseValue, AArch64Assembler.ConditionFlag condition) {
        super.fcsel(size, result, trueValue, falseValue, condition);
    }

    @Override
    public void fmadd(int size, Register dst, Register src1, Register src2, Register src3) {
        super.fmadd(size, dst, src1, src2, src3);
    }

    public void cmp(int size, Register x, Register y) {
        assert (size == 32 || size == 64);
        super.subs(size, AArch64.zr, x, y, AArch64Assembler.ShiftType.LSL, 0);
    }

    public void cmp(int size, Register x, int y) {
        assert (size == 32 || size == 64);
        if (y < 0) {
            super.adds(size, AArch64.zr, x, -y);
        } else {
            super.subs(size, AArch64.zr, x, y);
        }
    }

    public void ands(int size, Register dst, Register x, Register y) {
        super.ands(size, dst, x, y, AArch64Assembler.ShiftType.LSL, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mulvs(int size, Register dst, Register x, Register y) {
        try (ScratchRegister sc1 = this.getScratchRegister();
             ScratchRegister sc2 = this.getScratchRegister();){
            switch (size) {
                case 64: {
                    Register temp1 = sc1.getRegister();
                    Register temp2 = sc2.getRegister();
                    this.mul(64, temp1, x, y);
                    this.smulh(64, temp2, x, y);
                    this.subs(64, AArch64.zr, temp2, temp1, AArch64Assembler.ShiftType.ASR, 63);
                    this.mov(64, dst, temp1);
                    this.mov(temp1, Integer.MIN_VALUE);
                    this.cmov(32, temp1, temp1, AArch64.zr, AArch64Assembler.ConditionFlag.NE);
                    this.cmp(32, temp1, 1);
                    return;
                }
                case 32: {
                    Register temp1 = sc1.getRegister();
                    this.smaddl(temp1, x, y, AArch64.zr);
                    this.mov(32, dst, temp1);
                    this.subs(64, AArch64.zr, temp1, temp1, AArch64Assembler.ExtendType.SXTW, 0);
                    this.mov(temp1, Integer.MIN_VALUE);
                    this.cmov(32, temp1, temp1, AArch64.zr, AArch64Assembler.ConditionFlag.NE);
                    this.cmp(32, temp1, 1);
                    return;
                }
            }
            return;
        }
    }

    public void adr(Register dst, Label label) {
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.adr(dst, offset);
        } else {
            label.addPatchAt(this.position(), this);
            this.emitInt(PatchLabelKind.ADR.encoding | dst.encoding << 5);
        }
    }

    public void cbnz(int size, Register cmp, Label label) {
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.cbnz(size, cmp, offset);
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 6;
            int sizeEncoding = (size == 64 ? 1 : 0) << 5;
            this.emitInt(PatchLabelKind.BRANCH_NONZERO.encoding | regEncoding | sizeEncoding);
        }
    }

    public void cbz(int size, Register cmp, Label label) {
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.cbz(size, cmp, offset);
        } else {
            label.addPatchAt(this.position(), this);
            int regEncoding = cmp.encoding << 6;
            int sizeEncoding = (size == 64 ? 1 : 0) << 5;
            this.emitInt(PatchLabelKind.BRANCH_ZERO.encoding | regEncoding | sizeEncoding);
        }
    }

    public void tbnz(Register cmp, int uimm6, Label label) {
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.tbnz(cmp, uimm6, offset);
        } else {
            label.addPatchAt(this.position(), this);
            int indexEncoding = uimm6 << 5;
            int regEncoding = cmp.encoding << 11;
            this.emitInt(PatchLabelKind.BRANCH_BIT_NONZERO.encoding | indexEncoding | regEncoding);
        }
    }

    public void tbz(Register cmp, int uimm6, Label label) {
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.tbz(cmp, uimm6, offset);
        } else {
            label.addPatchAt(this.position(), this);
            int indexEncoding = uimm6 << 5;
            int regEncoding = cmp.encoding << 11;
            this.emitInt(PatchLabelKind.BRANCH_BIT_ZERO.encoding | indexEncoding | regEncoding);
        }
    }

    public void branchConditionally(AArch64Assembler.ConditionFlag condition, Label label) {
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.b(condition, offset);
        } else {
            label.addPatchAt(this.position(), this);
            this.emitInt(PatchLabelKind.BRANCH_CONDITIONALLY.encoding | condition.encoding << 5);
        }
    }

    public void branchConditionally(AArch64Assembler.ConditionFlag condition) {
        super.b(condition, 0);
    }

    @Override
    public void jmp(Label label) {
        if (label.isBound()) {
            int offset = label.position() - this.position();
            super.b(offset);
        } else {
            label.addPatchAt(this.position(), this);
            this.emitInt(PatchLabelKind.BRANCH_UNCONDITIONALLY.encoding);
        }
    }

    public void jmp(Register dest) {
        super.br(dest);
    }

    public void jmp() {
        super.b(0);
    }

    public static boolean isBranchImmediateOffset(long imm) {
        return NumUtil.isSignedNbit(28, imm);
    }

    public void hlt(AArch64ExceptionCode exceptionCode) {
        super.hlt(exceptionCode.encoding);
    }

    public void brk(AArch64ExceptionCode exceptionCode) {
        super.brk(exceptionCode.encoding);
    }

    public void pause() {
        super.hint(AArch64Assembler.SystemHint.YIELD);
    }

    public void nop() {
        super.hint(AArch64Assembler.SystemHint.NOP);
    }

    public void csdb() {
        super.hint(AArch64Assembler.SystemHint.CSDB);
    }

    public void fullSystemBarrier() {
        super.dsb(AArch64Assembler.BarrierKind.SYSTEM);
        super.isb();
    }

    @Override
    public void ensureUniquePC() {
        this.nop();
    }

    @Override
    public void align(int modulus) {
        assert (modulus > 0 && (modulus & 3) == 0) : "Modulus has to be a positive multiple of 4.";
        if (this.position() % modulus == 0) {
            return;
        }
        int offset = modulus - this.position() % modulus;
        for (int i = 0; i < offset; i += 4) {
            this.nop();
        }
    }

    @Override
    protected void patchJumpTarget(int branch, int jumpTarget) {
        int instruction = this.getInt(branch);
        int branchOffset = jumpTarget - branch;
        PatchLabelKind type = PatchLabelKind.fromEncoding(instruction);
        switch (type) {
            case BRANCH_CONDITIONALLY: {
                AArch64Assembler.ConditionFlag cf = AArch64Assembler.ConditionFlag.fromEncoding(instruction >>> 5);
                super.b(cf, branchOffset, branch);
                break;
            }
            case BRANCH_UNCONDITIONALLY: {
                super.b(branchOffset, branch);
                break;
            }
            case JUMP_ADDRESS: {
                int offset = instruction >>> 5;
                this.emitInt(jumpTarget - offset, branch);
                break;
            }
            case BRANCH_NONZERO: 
            case BRANCH_ZERO: {
                int information = instruction >>> 5;
                int sizeEncoding = information & 1;
                int regEncoding = information >>> 1;
                Register reg = AArch64.cpuRegisters.get(regEncoding);
                int size = sizeEncoding * 32 + 32;
                if (!NumUtil.isSignedNbit(21, branchOffset)) {
                    throw new BranchTargetOutOfBoundsException(true, "Branch target %d out of bounds", branchOffset);
                }
                switch (type) {
                    case BRANCH_NONZERO: {
                        super.cbnz(size, reg, branchOffset, branch);
                        break;
                    }
                    case BRANCH_ZERO: {
                        super.cbz(size, reg, branchOffset, branch);
                    }
                }
                break;
            }
            case BRANCH_BIT_NONZERO: 
            case BRANCH_BIT_ZERO: {
                int information = instruction >>> 5;
                int sizeEncoding = information & NumUtil.getNbitNumberInt(6);
                int regEncoding = information >>> 6;
                Register reg = AArch64.cpuRegisters.get(regEncoding);
                if (!NumUtil.isSignedNbit(16, branchOffset)) {
                    throw new BranchTargetOutOfBoundsException(true, "Branch target %d out of bounds", branchOffset);
                }
                switch (type) {
                    case BRANCH_BIT_NONZERO: {
                        super.tbnz(reg, sizeEncoding, branchOffset, branch);
                        break;
                    }
                    case BRANCH_BIT_ZERO: {
                        super.tbz(reg, sizeEncoding, branchOffset, branch);
                    }
                }
                break;
            }
            case ADR: {
                int information;
                int regEncoding = information = instruction >>> 5;
                Register reg = AArch64.cpuRegisters.get(regEncoding);
                super.adr(reg, branchOffset, branch);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    @Override
    public AArch64Address makeAddress(Register base, int displacement) {
        return this.makeAddress(base, displacement, AArch64.zr, false, 0, AArch64.zr, false);
    }

    @Override
    public AArch64Address getPlaceholder(int instructionStartPosition) {
        return AArch64Address.PLACEHOLDER;
    }

    public void addressOf(Register dst) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AdrpAddMacroInstruction(this.position()));
        }
        super.adrp(dst);
        super.add(64, dst, dst, 0);
    }

    public void lea(Register d, AArch64Address a) {
        a.lea(this, d);
    }

    public void popcnt(int size, Register dst, Register src, Register vreg) {
        assert (32 == size || 64 == size) : "Invalid data size";
        this.fmov(size, vreg, src);
        int fixedSize = 64;
        this.cnt(64, vreg, vreg);
        this.addv(64, AArch64Assembler.SIMDElementSize.Byte, vreg, vreg);
        this.umov(64, dst, 0, vreg);
    }

    public void adrpLdr(int srcSize, Register result, AArch64Address a) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AdrpLdrMacroInstruction(this.position(), srcSize));
        }
        super.adrp(a.getBase());
        this.ldr(srcSize, result, a);
    }

    private void annotateImmediateMovSequence(int pos, MovSequenceAnnotation.MovAction[] includeSet) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new MovSequenceAnnotation(pos, includeSet));
        }
    }

    public static class MovSequenceAnnotation
    extends AArch64Assembler.PatchableCodeAnnotation {
        public final MovAction[] includeSet;

        MovSequenceAnnotation(int instructionPosition, MovAction[] includeSet) {
            super(instructionPosition);
            this.includeSet = includeSet;
        }

        public String toString() {
            return "MOV_SEQ";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void patch(int codePos, int relative, byte[] code) {
            int curValue = relative;
            int[] bitsUsed = new int[]{3, 8, 5};
            int[] offsets = new int[]{5, 0, 0};
            int siteOffset = 0;
            boolean containsNegatedMov = false;
            for (MovAction include : this.includeSet) {
                if (include != MovAction.NEGATED) continue;
                containsNegatedMov = true;
                break;
            }
            int i = 0;
            while (true) {
                block9: {
                    if (i >= this.includeSet.length) {
                        return;
                    }
                    int value = curValue & 0xFFFF;
                    curValue >>= 16;
                    switch (this.includeSet[i]) {
                        case USED: {
                            break;
                        }
                        case SKIPPED: {
                            assert (value == (containsNegatedMov ? 65535 : 0)) : "Unable to patch this value.";
                            break block9;
                        }
                        case NEGATED: {
                            value ^= 0xFFFF;
                        }
                    }
                    int bytePosition = this.instructionPosition + siteOffset;
                    AArch64Assembler.PatcherUtil.writeBitSequence(code, bytePosition, value, bitsUsed, offsets);
                    siteOffset += 4;
                }
                ++i;
            }
        }

        public static enum MovAction {
            USED,
            SKIPPED,
            NEGATED;

        }
    }

    public static class AdrpAddMacroInstruction
    extends AArch64Assembler.PatchableCodeAnnotation {
        public AdrpAddMacroInstruction(int position) {
            super(position);
        }

        public String toString() {
            return "ADRP_ADD";
        }

        @Override
        public void patch(int codePos, int relative, byte[] code) {
            int pos = this.instructionPosition;
            int targetAddress = pos + relative;
            int relativePageDifference = AArch64Assembler.PatcherUtil.computeRelativePageDifference(targetAddress, pos, 4096);
            int curValue = relativePageDifference >> 2 & 0x7FFFF;
            int[] adrHiBits = new int[]{3, 8, 8};
            int[] adrHiOffsets = new int[]{5, 0, 0};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos, curValue, adrHiBits, adrHiOffsets);
            curValue = relativePageDifference & 3;
            int[] adrLoBits = new int[]{2};
            int[] adrLoOffsets = new int[]{5};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos + 3, curValue, adrLoBits, adrLoOffsets);
            curValue = targetAddress & 0xFFF;
            int[] addBits = new int[]{6, 6};
            int[] addOffsets = new int[]{2, 0};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos + 5, curValue, addBits, addOffsets);
        }
    }

    public static class AdrpLdrMacroInstruction
    extends AArch64Assembler.PatchableCodeAnnotation {
        public final int srcSize;

        public AdrpLdrMacroInstruction(int position, int srcSize) {
            super(position);
            this.srcSize = srcSize;
        }

        public String toString() {
            return "ADRP_LDR";
        }

        @Override
        public void patch(int codePos, int relative, byte[] code) {
            int shiftSize = 0;
            switch (this.srcSize) {
                case 64: {
                    shiftSize = 3;
                    break;
                }
                case 32: {
                    shiftSize = 2;
                    break;
                }
                case 16: {
                    shiftSize = 1;
                    break;
                }
                case 8: {
                    shiftSize = 0;
                    break;
                }
                default: {
                    assert (false) : "srcSize must be either 8, 16, 32, or 64";
                    break;
                }
            }
            int pos = this.instructionPosition;
            int targetAddress = pos + relative;
            assert (shiftSize == 0 || (targetAddress & (1 << shiftSize) - 1) == 0) : "shift bits must be zero";
            int relativePageDifference = AArch64Assembler.PatcherUtil.computeRelativePageDifference(targetAddress, pos, 4096);
            int curValue = relativePageDifference >> 2 & 0x7FFFF;
            int[] adrHiBits = new int[]{3, 8, 8};
            int[] adrHiOffsets = new int[]{5, 0, 0};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos, curValue, adrHiBits, adrHiOffsets);
            curValue = relativePageDifference & 3;
            int[] adrLoBits = new int[]{2};
            int[] adrLoOffsets = new int[]{5};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos + 3, curValue, adrLoBits, adrLoOffsets);
            curValue = (targetAddress & 0xFFF) >> shiftSize;
            int[] ldrBits = new int[]{6, 6};
            int[] ldrOffsets = new int[]{2, 0};
            AArch64Assembler.PatcherUtil.writeBitSequence(code, pos + 5, curValue, ldrBits, ldrOffsets);
        }
    }

    public static enum AArch64ExceptionCode {
        NO_SWITCH_TARGET(0),
        BREAKPOINT(1);

        public final int encoding;

        private AArch64ExceptionCode(int encoding) {
            this.encoding = encoding;
        }
    }

    public static enum PatchLabelKind {
        BRANCH_CONDITIONALLY(0),
        BRANCH_UNCONDITIONALLY(1),
        BRANCH_NONZERO(2),
        BRANCH_ZERO(3),
        BRANCH_BIT_NONZERO(4),
        BRANCH_BIT_ZERO(5),
        JUMP_ADDRESS(6),
        ADR(7);

        public static final int INFORMATION_OFFSET = 5;
        public final int encoding;

        private PatchLabelKind(int encoding) {
            this.encoding = encoding;
        }

        private static PatchLabelKind fromEncoding(int encoding) {
            return PatchLabelKind.values()[encoding & NumUtil.getNbitNumberInt(5)];
        }
    }

    public static class AddressGenerationPlan {
        public final WorkPlan workPlan;
        public final AArch64Address.AddressingMode addressingMode;
        public final boolean needsScratch;

        public AddressGenerationPlan(WorkPlan workPlan, AArch64Address.AddressingMode addressingMode, boolean needsScratch) {
            this.workPlan = workPlan;
            this.addressingMode = addressingMode;
            this.needsScratch = needsScratch;
        }

        public static enum WorkPlan {
            NO_WORK,
            ADD_TO_INDEX,
            ADD_TO_BASE;

        }
    }

    private static class AArch64MemoryEncoding {
        private AArch64Address address;
        private Register result;
        private int sizeInBytes;
        private int position;
        private boolean isStore;

        AArch64MemoryEncoding(int sizeInBytes, Register result, AArch64Address address, boolean isStore, int position) {
            this.sizeInBytes = sizeInBytes;
            this.result = result;
            this.address = address;
            this.isStore = isStore;
            this.position = position;
            AArch64Address.AddressingMode addressingMode = address.getAddressingMode();
            assert (addressingMode == AArch64Address.AddressingMode.IMMEDIATE_SCALED || addressingMode == AArch64Address.AddressingMode.IMMEDIATE_UNSCALED) : "Invalid address modeto merge: " + (Object)((Object)addressingMode);
        }

        Register getBase() {
            return this.address.getBase();
        }

        int getOffset() {
            if (this.address.getAddressingMode() == AArch64Address.AddressingMode.IMMEDIATE_UNSCALED) {
                return this.address.getImmediateRaw();
            }
            return this.address.getImmediate() * this.sizeInBytes;
        }
    }

    public class ScratchRegister
    implements AutoCloseable {
        private final Register register;

        public ScratchRegister(Register register) {
            this.register = register;
        }

        public Register getRegister() {
            return this.register;
        }

        @Override
        public void close() {
            assert (AArch64MacroAssembler.this.nextFreeScratchRegister > 0) : "Close called too often";
            AArch64MacroAssembler.this.nextFreeScratchRegister--;
        }
    }
}

