/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.InvokeExactHandle;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class MethodType
implements Serializable {
    static final Class<?>[] EMTPY_PARAMS = new Class[0];
    static final Set<Class<?>> WRAPPER_SET;
    static final Class<?>[] primitivesArray;
    private static Map<MethodType, WeakReference<MethodType>> internTable;
    private static InternTableAddLock internTableAddLock;
    final Class<?> returnType;
    final Class<?>[] arguments;
    int argSlots;
    int[] stackDescriptionBits;
    private String methodDescriptor;
    private int hashcode = 0;
    private InvokeExactHandle invoker;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final long serialVersionUID = 292L;
    private DeserializedFieldsHolder deserializedFields;

    private MethodType(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        this.returnType = clazz;
        if (bl) {
            this.arguments = new Class[classArray.length];
            System.arraycopy(classArray, 0, this.arguments, 0, classArray.length);
        } else {
            this.arguments = classArray;
        }
    }

    private final int[] stackDescriptionBits(Class<?>[] classArray, int n) {
        int n2 = (n + 1 + 31) / 32;
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        n5 |= n4;
        n4 <<= 1;
        for (Class<?> clazz : classArray) {
            if (clazz.isPrimitive()) {
                if ((clazz.equals(Double.TYPE) || clazz.equals(Long.TYPE)) && (n4 <<= 1) == 0) {
                    n4 = 1;
                    nArray[n3] = n5;
                    ++n3;
                    n5 = 0;
                }
            } else {
                n5 |= n4;
            }
            if ((n4 <<= 1) != 0) continue;
            n4 = 1;
            nArray[n3] = n5;
            ++n3;
            n5 = 0;
        }
        if (n3 < nArray.length) {
            nArray[n3] = n5;
        }
        return nArray;
    }

    public MethodType changeParameterType(int n, Class<?> clazz) {
        Class[] classArray = (Class[])this.arguments.clone();
        classArray[n] = clazz;
        return MethodType.methodType(this.returnType, classArray, false);
    }

    public MethodType changeReturnType(Class<?> clazz) {
        return MethodType.methodType(clazz, this.arguments, false);
    }

    public MethodType dropParameterTypes(int n, int n2) throws IndexOutOfBoundsException {
        if (n >= 0 && n2 >= 0 && n <= n2 && n2 <= this.arguments.length) {
            int n3 = n2 - n;
            Class[] classArray = new Class[this.arguments.length - n3];
            System.arraycopy(this.arguments, 0, (Object)classArray, 0, n);
            System.arraycopy(this.arguments, n2, (Object)classArray, n, this.arguments.length - n2);
            return MethodType.methodType(this.returnType, classArray, false);
        }
        throw new IndexOutOfBoundsException("'" + this + "' startPosition=" + n + " endPosition=" + n2);
    }

    MethodType dropFirstParameterType() throws IndexOutOfBoundsException {
        if (this.arguments.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return MethodType.methodType(this.returnType, Arrays.copyOfRange(this.arguments, 1, this.arguments.length), false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodType)) {
            return false;
        }
        MethodType methodType = (MethodType)object;
        if (this.arguments.length != methodType.arguments.length || this.returnType != methodType.returnType) {
            return false;
        }
        return Arrays.equals(this.arguments, methodType.arguments);
    }

    public MethodType erase() {
        Class[] classArray = (Class[])this.arguments.clone();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            classArray[i] = Object.class;
        }
        return MethodType.methodType(this.returnType.isPrimitive() ? this.returnType : Object.class, classArray, false);
    }

    public static MethodType fromMethodDescriptorString(String string, ClassLoader classLoader) {
        Map<String, MethodType> map;
        MethodType methodType;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        MethodType methodType2 = methodType = (map = VM.getVMLangAccess().getMethodTypeCache(classLoader2)) != null ? map.get(string) : null;
        if (null == methodType) {
            if (string.indexOf(46) != -1) {
                throw new IllegalArgumentException(string);
            }
            ArrayList<Class<?>> arrayList = MethodType.parseIntoClasses(string, classLoader2);
            if (arrayList.size() == 0) {
                throw new IllegalArgumentException(string);
            }
            Class<?> clazz = arrayList.remove(arrayList.size() - 1);
            methodType = MethodType.methodType(clazz, arrayList);
            if (map != null) {
                map.put(methodType.methodDescriptor, methodType);
            }
        }
        return methodType;
    }

    private static final MethodType fromMethodDescriptorStringAppendArg(String string, ClassLoader classLoader, Class<?> clazz) {
        ArrayList<Class<?>> arrayList = MethodType.parseIntoClasses(string, classLoader);
        Class clazz2 = (Class)arrayList.remove(arrayList.size() - 1);
        arrayList.add(clazz);
        return MethodType.methodType(clazz2, arrayList);
    }

    static final MethodType vmResolveFromMethodDescriptorString(String string, ClassLoader classLoader, Class<?> clazz) throws Throwable {
        try {
            if (null == clazz) {
                return MethodType.fromMethodDescriptorString(string, classLoader);
            }
            return MethodType.fromMethodDescriptorStringAppendArg(string, classLoader, clazz);
        }
        catch (TypeNotPresentException typeNotPresentException) {
            throw MethodType.throwNoClassDefFoundError(typeNotPresentException);
        }
    }

    private static final Throwable throwNoClassDefFoundError(TypeNotPresentException typeNotPresentException) {
        Throwable throwable = typeNotPresentException.getCause();
        if (throwable instanceof ClassNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(throwable.getMessage());
            noClassDefFoundError.initCause(throwable);
            throw noClassDefFoundError;
        }
        throw typeNotPresentException;
    }

    private static final Class<?> nonPrimitiveClassFromString(String string, ClassLoader classLoader) {
        try {
            string = string.replace('/', '.');
            if (string.indexOf(76) == 0) {
                string = string.substring(1, string.length() - 1);
            }
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
    }

    static final int parseIntoClass(char[] cArray, int n, ArrayList<Class<?>> arrayList, ClassLoader classLoader, String string) {
        Class<Object> clazz;
        char c = cArray[n];
        if (c == 'L' || c == '[') {
            String string2;
            int n2 = n;
            while (cArray[n] == '[') {
                ++n;
            }
            if (cArray[n] != 'L') {
                string2 = string.substring(n2, n + 1);
            } else {
                int n3 = string.indexOf(59, n);
                if (n3 == -1) {
                    throw new IllegalArgumentException(Msg.getString("K05d6", string));
                }
                string2 = string.substring(n2, n3 + 1);
                n = n3;
            }
            clazz = MethodType.nonPrimitiveClassFromString(string2, classLoader);
        } else {
            try {
                clazz = primitivesArray[c - 65];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                clazz = null;
            }
            if (clazz == null) {
                if (c == 'V') {
                    MethodType.primitivesArray[21] = Void.TYPE;
                    clazz = Void.TYPE;
                } else {
                    throw new IllegalArgumentException(Msg.getString("K05d7", c));
                }
            }
        }
        arrayList.add(clazz);
        return n;
    }

    private static final ArrayList<Class<?>> parseIntoClasses(String string, ClassLoader classLoader) {
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", string));
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        boolean bl = false;
        if (cArray[n2] != '(') {
            throw new IllegalArgumentException(Msg.getString("K05d4", string));
        }
        ++n2;
        ArrayList arrayList = new ArrayList();
        while (n2 < n) {
            if (cArray[n2] == ')') {
                if (bl) {
                    throw new IllegalArgumentException(Msg.getString("K05d5", string));
                }
                bl = true;
                ++n2;
                continue;
            }
            n2 = MethodType.parseIntoClass(cArray, n2, arrayList, classLoader, string);
            ++n2;
        }
        return arrayList;
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.arguments.length);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int n = 31 + this.returnType.hashCode();
            for (Class<?> clazz : this.arguments) {
                n = 31 * n + clazz.hashCode();
            }
            this.hashcode = n;
        }
        return this.hashcode;
    }

    public boolean hasPrimitives() {
        if (this.returnType.isPrimitive()) {
            return true;
        }
        for (Class<?> clazz : this.arguments) {
            if (!clazz.isPrimitive()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWrappers() {
        if (WRAPPER_SET.contains(this.returnType) || this.returnType == Void.class) {
            return true;
        }
        for (Class<?> clazz : this.arguments) {
            if (!WRAPPER_SET.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    public MethodType insertParameterTypes(int n, Class<?> ... classArray) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.arguments.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = classArray.length;
        if (n2 == 0) {
            return this;
        }
        Class[] classArray2 = new Class[this.arguments.length + n2];
        System.arraycopy(this.arguments, 0, (Object)classArray2, 0, n);
        System.arraycopy(classArray, 0, (Object)classArray2, n, n2);
        System.arraycopy(this.arguments, n, (Object)classArray2, n + n2, this.arguments.length - n);
        return MethodType.methodType(this.returnType, classArray2, false);
    }

    public MethodType insertParameterTypes(int n, List<Class<?>> list) {
        return this.insertParameterTypes(n, list.toArray(new Class[list.size()]));
    }

    public static MethodType methodType(Class<?> clazz) {
        return MethodType.methodType(clazz, EMTPY_PARAMS, false);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2) {
        return MethodType.methodType(clazz, new Class[]{clazz2}, false);
    }

    public static MethodType methodType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.methodType(clazz, classArray, true);
    }

    private static MethodType methodType(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        clazz.getClass();
        MethodType methodType = new MethodType(clazz, classArray, bl);
        return methodType.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodType intern() {
        MethodType methodType = this.probeTable();
        if (methodType != null) {
            return methodType;
        }
        InternTableAddLock internTableAddLock = MethodType.internTableAddLock;
        synchronized (internTableAddLock) {
            methodType = this.probeTable();
            if (methodType != null) {
                return methodType;
            }
            int n = this.arguments.length;
            for (Class<?> clazz : this.arguments) {
                clazz.getClass();
                if (clazz == Double.TYPE || clazz == Long.TYPE) {
                    ++n;
                    continue;
                }
                if (clazz != Void.TYPE) continue;
                throw new IllegalArgumentException(Msg.getString("K05d9", Void.TYPE));
            }
            if (n > 255) {
                throw new IllegalArgumentException(Msg.getString("K05d8", n));
            }
            this.argSlots = n;
            this.stackDescriptionBits = this.stackDescriptionBits(this.arguments, this.argSlots);
            this.methodDescriptor = this.createMethodDescriptorString();
            MethodType methodType2 = MethodType.makeTenured(this);
            internTable.put(methodType2, new WeakReference<MethodType>(methodType2));
            return methodType2;
        }
    }

    private MethodType probeTable() {
        Reference reference = internTable.get(this);
        if (reference != null) {
            return (MethodType)reference.get();
        }
        return null;
    }

    private static native MethodType makeTenured(MethodType var0);

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        Class[] classArray2 = new Class[classArray.length + 1];
        classArray2[0] = clazz2;
        System.arraycopy(classArray, 0, (Object)classArray2, 1, classArray.length);
        return MethodType.methodType(clazz, classArray2, false);
    }

    public static MethodType methodType(Class<?> clazz, List<Class<?>> list) {
        return MethodType.methodType(clazz, list.toArray(new Class[list.size()]), false);
    }

    public static MethodType methodType(Class<?> clazz, MethodType methodType) {
        return MethodType.methodType(clazz, methodType.arguments, false);
    }

    public static MethodType genericMethodType(int n) throws IllegalArgumentException {
        return MethodType.genericMethodType(n, false);
    }

    public static MethodType genericMethodType(int n, boolean bl) throws IllegalArgumentException {
        if (n < 0 || n > (bl ? 254 : 255)) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        if (bl) {
            ++n2;
        }
        Object[] objectArray = new Class[n2];
        Arrays.fill(objectArray, Object.class);
        if (bl) {
            objectArray[n] = Object[].class;
        }
        return MethodType.methodType(Object.class, objectArray, false);
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.arguments.clone();
    }

    public int parameterCount() {
        return this.arguments.length;
    }

    public List<Class<?>> parameterList() {
        List<Object> list = Arrays.asList((Object[])this.arguments.clone());
        return Collections.unmodifiableList(list);
    }

    public Class<?> parameterType(int n) throws IndexOutOfBoundsException {
        return this.arguments[n];
    }

    public Class<?> returnType() {
        return this.returnType;
    }

    Class<?> lastParameterType() {
        Class<Void> clazz = Void.TYPE;
        if (this.arguments.length > 0) {
            clazz = this.arguments[this.arguments.length - 1];
        }
        return clazz;
    }

    public String toMethodDescriptorString() {
        return this.methodDescriptor;
    }

    private String createMethodDescriptorString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Class<?> clazz : this.arguments) {
            stringBuilder.append(MethodType.getBytecodeStringName(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append(MethodType.getBytecodeStringName(this.returnType));
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            stringBuilder.append(this.arguments[i].getSimpleName());
            if (i >= this.arguments.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        stringBuilder.append(this.returnType.getSimpleName());
        return stringBuilder.toString();
    }

    public MethodType unwrap() {
        Class[] classArray = (Class[])this.arguments.clone();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = MethodType.unwrapPrimitive(classArray[i]);
        }
        Class<Object> clazz = MethodType.unwrapPrimitive(this.returnType);
        if (MethodType.unwrapPrimitive(this.returnType) == Void.class) {
            clazz = Void.TYPE;
        }
        return MethodType.methodType(clazz, classArray, false);
    }

    public MethodType wrap() {
        Class[] classArray = (Class[])this.arguments.clone();
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = MethodType.wrapPrimitive(classArray[i]);
        }
        return MethodType.methodType(MethodType.wrapPrimitive(this.returnType), classArray, false);
    }

    public MethodType appendParameterTypes(Class<?> ... classArray) throws IllegalArgumentException, NullPointerException {
        if (classArray == null) {
            throw new NullPointerException();
        }
        return this.appendParameterTypes(Arrays.asList(classArray));
    }

    public MethodType appendParameterTypes(List<Class<?>> list) throws IllegalArgumentException, NullPointerException {
        if (list == null) {
            throw new NullPointerException();
        }
        ArrayList arrayList = new ArrayList(Arrays.asList(this.arguments));
        arrayList.addAll(list);
        return MethodType.methodType(this.returnType, arrayList);
    }

    static Class<?> wrapPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Integer.TYPE == clazz) {
                return Integer.class;
            }
            if (Long.TYPE == clazz) {
                return Long.class;
            }
            if (Byte.TYPE == clazz) {
                return Byte.class;
            }
            if (Character.TYPE == clazz) {
                return Character.class;
            }
            if (Double.TYPE == clazz) {
                return Double.class;
            }
            if (Float.TYPE == clazz) {
                return Float.class;
            }
            if (Boolean.TYPE == clazz) {
                return Boolean.class;
            }
            if (Void.TYPE == clazz) {
                return Void.class;
            }
            if (Short.TYPE == clazz) {
                return Short.class;
            }
        }
        return clazz;
    }

    static Class<?> unwrapPrimitive(Class<?> clazz) {
        if (Integer.class == clazz) {
            return Integer.TYPE;
        }
        if (Long.class == clazz) {
            return Long.TYPE;
        }
        if (Byte.class == clazz) {
            return Byte.TYPE;
        }
        if (Character.class == clazz) {
            return Character.TYPE;
        }
        if (Double.class == clazz) {
            return Double.TYPE;
        }
        if (Float.class == clazz) {
            return Float.TYPE;
        }
        if (Short.class == clazz) {
            return Short.TYPE;
        }
        if (Boolean.class == clazz) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    static String getBytecodeStringName(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
        }
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
            }
        }
        String string = clazz.getName().replace('.', '/');
        if (clazz.isArray()) {
            return string;
        }
        return "L" + string + ";";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.returnType());
        objectOutputStream.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            final Field field = this.getClass().getDeclaredField("returnType");
            final Field field2 = this.getClass().getDeclaredField("arguments");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    field2.setAccessible(true);
                    return null;
                }
            });
            field.set(this, Void.TYPE);
            field2.set(this, EMTPY_PARAMS);
            this.methodDescriptor = "()V";
            this.stackDescriptionBits = this.stackDescriptionBits(EMTPY_PARAMS, 0);
            Class clazz = (Class)objectInputStream.readObject();
            Class[] classArray = (Class[])objectInputStream.readObject();
            this.deserializedFields = new DeserializedFieldsHolder(clazz, classArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Object readResolve() throws ObjectStreamException {
        Class<Void> clazz = Void.TYPE;
        Class<?>[] classArray = EMTPY_PARAMS;
        DeserializedFieldsHolder deserializedFieldsHolder = this.deserializedFields;
        if (deserializedFieldsHolder != null) {
            clazz = this.deserializedFields.returnType;
            classArray = this.deserializedFields.arguments;
        }
        return MethodType.methodType(clazz, classArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvokeExactHandle getInvokeExactHandle() {
        if (null == this.invoker) {
            MethodType methodType = this;
            synchronized (methodType) {
                if (null == this.invoker) {
                    this.invoker = new InvokeExactHandle(this);
                }
            }
        }
        return this.invoker;
    }

    MethodType basicType() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodType invokerType() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodType replaceParameterTypes(int n, int n2, Class<?> ... classArray) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodTypeForm form() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    Class<?> rtype() {
        return this.returnType;
    }

    MethodType asCollectorType(Class<?> clazz, int n) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    static {
        Class[] classArray = new Class[]{Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Boolean.class};
        WRAPPER_SET = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(classArray)));
        primitivesArray = new Class[26];
        MethodType.primitivesArray[1] = Byte.TYPE;
        MethodType.primitivesArray[2] = Character.TYPE;
        MethodType.primitivesArray[3] = Double.TYPE;
        MethodType.primitivesArray[5] = Float.TYPE;
        MethodType.primitivesArray[8] = Integer.TYPE;
        MethodType.primitivesArray[9] = Long.TYPE;
        MethodType.primitivesArray[18] = Short.TYPE;
        MethodType.primitivesArray[25] = Boolean.TYPE;
        internTable = Collections.synchronizedMap(new WeakHashMap());
        internTableAddLock = new InternTableAddLock();
        serialPersistentFields = new ObjectStreamField[0];
    }

    private static class DeserializedFieldsHolder {
        Class<?> returnType;
        Class<?>[] arguments;

        DeserializedFieldsHolder(Class<?> clazz, Class<?>[] classArray) {
            this.returnType = clazz == null ? Void.TYPE : clazz;
            this.arguments = classArray == null ? EMTPY_PARAMS : classArray;
        }
    }

    static final class InternTableAddLock {
        InternTableAddLock() {
        }
    }
}

