/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.dtfj.java.j9.TraceBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class JavaRuntime
implements com.ibm.dtfj.java.JavaRuntime {
    private ImageProcess _containingProc;
    private ImagePointer _address;
    private LinkedHashMap _classLoaders = new LinkedHashMap();
    private Vector _vmThreads = new Vector();
    private LinkedHashMap _classes = new LinkedHashMap();
    private Set _arrayClasses = new HashSet();
    private Map _arrayClassesMap = new HashMap();
    private Vector _monitors = new Vector();
    private Vector _heaps = new Vector();
    private Vector _heapRoots = new Vector();
    private HashMap _traceBuffers = new HashMap();
    private Properties _systemProperties = new Properties();
    private com.ibm.dtfj.java.j9.JavaVMInitArgs _javaVMInitArgs;
    private boolean _objectsShouldInferHash = false;
    private HashMap _methodsByID = new HashMap();
    private Vector deferMonitors = new Vector();
    private HashMap _specialObjects = new HashMap();
    JavaClass _weakReferenceClass = null;
    JavaClass _softReferenceClass = null;
    JavaClass _phantomReferenceClass = null;
    JavaClass _javaLangObjectClass = null;
    private static final String WEAKREF_CLASS_NAME = "java/lang/ref/WeakReference";
    private static final String SOFTREF_CLASS_NAME = "java/lang/ref/SoftReference";
    private static final String PHANTOMREF_CLASS_NAME = "java/lang/ref/PhantomReference";
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private static final int DEFAULT_OBJECT_ALIGNMENT = 8;

    public JavaRuntime(ImageProcess imageProcess, ImagePointer imagePointer, String string) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Runtime cannot have a null base address");
        }
        this._containingProc = imageProcess;
        this._address = imagePointer;
        this._objectsShouldInferHash = "2.2".equals(string) || "2.3".equals(string) || "2.4".equals(string);
    }

    @Override
    public ImagePointer getJavaVM() throws CorruptDataException {
        return this._address;
    }

    @Override
    public Iterator getJavaClassLoaders() {
        return this._classLoaders.values().iterator();
    }

    @Override
    public Iterator getThreads() {
        return this._vmThreads.iterator();
    }

    @Override
    public Iterator getCompiledMethods() {
        Iterator iterator = this._classes.values().iterator();
        Vector<JavaMethod> vector = new Vector<JavaMethod>();
        while (iterator.hasNext()) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)iterator.next();
            Iterator iterator2 = javaAbstractClass.getDeclaredMethods();
            while (iterator2.hasNext()) {
                JavaMethod javaMethod = (JavaMethod)iterator2.next();
                if (!javaMethod.getCompiledSections().hasNext()) continue;
                vector.add(javaMethod);
            }
        }
        return vector.iterator();
    }

    @Override
    public Iterator getMonitors() {
        this.checkDeferredMonitors();
        return this._monitors.iterator();
    }

    @Override
    public Iterator getHeaps() {
        return this._heaps.iterator();
    }

    @Override
    public Object getTraceBuffer(String string, boolean bl) throws CorruptDataException {
        return this._traceBuffers.get(string);
    }

    @Override
    public String getFullVersion() throws CorruptDataException {
        return this.getVersion();
    }

    @Override
    public String getVersion() throws CorruptDataException {
        String string = this.getRequiredSystemProperty("java.fullversion");
        String string2 = this.getRequiredSystemProperty("java.runtime.version");
        String string3 = this.getRequiredSystemProperty("java.runtime.name");
        String string4 = this.getRequiredSystemProperty("java.vm.name");
        String string5 = string3 + "(build " + string2 + ")\n";
        string5 = string5 + string4 + "(" + string + ")";
        return string5;
    }

    public void addClass(JavaAbstractClass javaAbstractClass) {
        if (null == javaAbstractClass) {
            return;
        }
        long l = javaAbstractClass.getID().getAddress();
        this._classes.put(l, javaAbstractClass);
        try {
            if (javaAbstractClass.isArray()) {
                this._arrayClasses.add(javaAbstractClass);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (javaAbstractClass instanceof JavaClass) {
            try {
                if (WEAKREF_CLASS_NAME.equals(javaAbstractClass.getName())) {
                    this._weakReferenceClass = (JavaClass)javaAbstractClass;
                } else if (SOFTREF_CLASS_NAME.equals(javaAbstractClass.getName())) {
                    this._softReferenceClass = (JavaClass)javaAbstractClass;
                } else if (PHANTOMREF_CLASS_NAME.equals(javaAbstractClass.getName())) {
                    this._phantomReferenceClass = (JavaClass)javaAbstractClass;
                } else if (OBJECT_CLASS_NAME.equals(javaAbstractClass.getName())) {
                    this._javaLangObjectClass = (JavaClass)javaAbstractClass;
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
    }

    public void addClassLoader(JavaClassLoader javaClassLoader) {
        long l = javaClassLoader.getID();
        this._classLoaders.put(l, javaClassLoader);
    }

    public com.ibm.dtfj.java.JavaClass getClassForID(long l) {
        return (com.ibm.dtfj.java.JavaClass)this._classes.get(l);
    }

    com.ibm.dtfj.java.JavaClass getComponentTypeForClass(com.ibm.dtfj.java.JavaClass javaClass) throws CorruptDataException {
        com.ibm.dtfj.java.JavaClassLoader javaClassLoader;
        Object object;
        String string;
        Object object22;
        if (this._arrayClasses != null && this._arrayClassesMap.isEmpty()) {
            for (Object object22 : this._arrayClasses) {
                string = ((JavaArrayClass)object22).getName();
                object = "";
                javaClassLoader = ((JavaArrayClass)object22).getClassLoader();
                if (javaClassLoader != null) {
                    object = javaClassLoader.toString();
                }
                this._arrayClassesMap.put(string + (String)object, object22);
            }
            this._arrayClasses.clear();
            this._arrayClasses = null;
        }
        Object object3 = null;
        object22 = javaClass.getName().substring(1);
        string = "";
        object = javaClass.getClassLoader();
        if (object != null) {
            string = object.toString();
        }
        if ((javaClassLoader = this._arrayClassesMap.get((String)object22 + string)) instanceof com.ibm.dtfj.java.JavaClass) {
            object3 = (com.ibm.dtfj.java.JavaClass)((Object)javaClassLoader);
        }
        return object3;
    }

    public com.ibm.dtfj.java.JavaClassLoader getClassLoaderForID(long l) {
        return (com.ibm.dtfj.java.JavaClassLoader)this._classLoaders.get(l);
    }

    public void addMonitor(JavaMonitor javaMonitor) {
        this._monitors.add(javaMonitor);
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor deferMonitor = (DeferMonitor)this.deferMonitors.get(i);
            if (javaMonitor.getID().getAddress() != deferMonitor.id) continue;
            if (deferMonitor.blocked) {
                javaMonitor.addBlockedThread(deferMonitor.thread);
            } else {
                javaMonitor.addWaitingThread(deferMonitor.thread);
            }
            deferMonitor.id = 0L;
        }
    }

    public void addHeap(JavaHeap javaHeap) {
        this._heaps.add(javaHeap);
    }

    public void addHeapRoot(JavaReference javaReference) {
        this._heapRoots.add(javaReference);
    }

    private void checkDeferredMonitors() {
        int n = 0;
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor deferMonitor = (DeferMonitor)this.deferMonitors.get(i);
            if (deferMonitor.id == 0L) continue;
            ImagePointer imagePointer = this.pointerInAddressSpace(deferMonitor.id);
            JavaMonitor javaMonitor = new JavaMonitor(this, imagePointer, "Auto-generated monitor #" + deferMonitor.id, null, 0L);
            this.addMonitor(javaMonitor);
            ++n;
        }
        this.deferMonitors.clear();
    }

    public void addThread(JavaThread javaThread, long l, long l2) {
        JavaMonitor javaMonitor;
        boolean bl;
        Iterator iterator;
        this._vmThreads.add(javaThread);
        if (0L != l) {
            assert (0L == l2) : "Thread cannot be blocked and waiting at the same time";
            iterator = this._monitors.iterator();
            bl = false;
            while (iterator.hasNext()) {
                javaMonitor = (JavaMonitor)iterator.next();
                if (javaMonitor.getID().getAddress() != l) continue;
                javaMonitor.addBlockedThread(javaThread);
                bl = true;
                break;
            }
            if (!bl) {
                this.deferMonitors.add(new DeferMonitor(l, true, javaThread));
            }
        }
        if (0L != l2) {
            assert (0L == l) : "Thread cannot be blocked and waiting at the same time";
            iterator = this._monitors.iterator();
            bl = false;
            while (iterator.hasNext()) {
                javaMonitor = (JavaMonitor)iterator.next();
                if (javaMonitor.getID().getAddress() != l2) continue;
                javaMonitor.addWaitingThread(javaThread);
                bl = true;
                break;
            }
            if (!bl) {
                this.deferMonitors.add(new DeferMonitor(l2, false, javaThread));
            }
        }
    }

    public void setTraceBufferForName(TraceBuffer traceBuffer, String string) {
        this._traceBuffers.put(string, traceBuffer);
    }

    public String getSystemProperty(String string) {
        return this._systemProperties.getProperty(string);
    }

    public String getSystemProperty(String string, String string2) {
        return this._systemProperties.getProperty(string, string2);
    }

    String getRequiredSystemProperty(String string) throws CorruptDataException {
        String string2 = this.getSystemProperty(string);
        if (string2 == null) {
            throw new CorruptDataException(new CorruptData("Required system property " + string + " not found in JExtract output", null));
        }
        return string2;
    }

    public void setSystemProperty(String string, String string2) {
        this._systemProperties.setProperty(string, string2);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaRuntime) {
            bl = this._address.equals(((JavaRuntime)object)._address);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this._address.hashCode();
    }

    @Override
    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this._javaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs");
        }
        return this._javaVMInitArgs;
    }

    boolean objectShouldInferHash() {
        return this._objectsShouldInferHash;
    }

    public ImagePointer pointerInAddressSpace(long l) {
        return this._address.getAddressSpace().getPointer(l);
    }

    public ImageThread nativeThreadForID(long l) {
        ImageThread imageThread = null;
        try {
            if (null != this._containingProc) {
                Iterator iterator = this._containingProc.getThreads();
                while (iterator.hasNext()) {
                    ImageThread imageThread2 = (ImageThread)iterator.next();
                    if (Long.decode(imageThread2.getID()) != l) continue;
                    imageThread = imageThread2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageThread;
    }

    public JavaMethod methodForID(long l) {
        return (JavaMethod)this._methodsByID.get(l);
    }

    public void addMethodForID(JavaMethod javaMethod, long l) {
        this._methodsByID.put(l, javaMethod);
    }

    public com.ibm.dtfj.java.j9.JavaVMInitArgs createJavaVMInitArgs(int n, boolean bl) {
        if (null != this._javaVMInitArgs) {
            throw new IllegalStateException("JavaVMInitArgs being created more than once");
        }
        this._javaVMInitArgs = new com.ibm.dtfj.java.j9.JavaVMInitArgs(this._address.getAddressSpace(), n, bl);
        return this._javaVMInitArgs;
    }

    public int bytesPerPointer() {
        int n = this._containingProc.getPointerSize();
        int n2 = ((ImageAddressSpace)this._address.getAddressSpace()).bytesPerPointer();
        if (n == 64 || n == 32 || n == 31) {
            return (n + 7) / 8;
        }
        return n2;
    }

    protected Iterator getClasses() {
        return this._classes.values().iterator();
    }

    @Override
    public Iterator getHeapRoots() {
        return this._heapRoots.iterator();
    }

    @Override
    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer imagePointer) throws CorruptDataException, IllegalArgumentException {
        if (null == imagePointer) {
            throw new NullPointerException("The ImagePointer was null");
        }
        long l = imagePointer.getAddress();
        if (0L == l) {
            throw new IllegalArgumentException("The object address " + l + " is not in any heap");
        }
        Iterator iterator = this.getHeaps();
        JavaHeapRegion javaHeapRegion = null;
        JavaHeap javaHeap = null;
        while (null == javaHeapRegion && iterator.hasNext()) {
            javaHeap = (JavaHeap)iterator.next();
            javaHeapRegion = javaHeap.regionForPointer(imagePointer);
        }
        if (null == javaHeapRegion) {
            if ((imagePointer.getAddress() & 7L) != 0L) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + imagePointer.toString());
            }
            return new JavaObject(this, imagePointer, javaHeap, 0L, 0L, false, 8);
        }
        return javaHeapRegion.getObjectAtAddress(imagePointer);
    }

    public void addSpecialObject(com.ibm.dtfj.java.JavaObject javaObject) {
        this._specialObjects.put(javaObject.getID(), javaObject);
    }

    public com.ibm.dtfj.java.JavaObject getSpecialObject(ImagePointer imagePointer) {
        return (com.ibm.dtfj.java.JavaObject)this._specialObjects.get(imagePointer);
    }

    @Override
    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemoryCategories");
    }

    @Override
    public Iterator getMemorySections(boolean bl) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemorySections");
    }

    @Override
    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support isJITEnabled");
    }

    @Override
    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getJITProperies");
    }

    @Override
    public long getStartTime() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("Dump start time is not available");
    }

    @Override
    public long getStartTimeNanos() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("Dump start time is not available");
    }

    private static class DeferMonitor {
        long id;
        boolean blocked;
        JavaThread thread;

        DeferMonitor(long l, boolean bl, JavaThread javaThread) {
            this.id = l;
            this.blocked = bl;
            this.thread = javaThread;
        }

        public String toString() {
            return "Defer monitor " + this.id;
        }
    }
}

