/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Util;
import java.math.BigInteger;
import java.util.Vector;

public final class TraceArgs {
    public static String traceFile;
    public static String outputFile;
    public static boolean indent;
    public static boolean summary;
    public static boolean debug;
    public static boolean symbolic;
    public static boolean isHelpOnly;
    public static boolean gui;
    public static boolean j9;
    public static boolean verbose;
    public static String userVMIdentifier;
    public static BigInteger timeZoneOffset;
    public static boolean is50orNewer;
    public static boolean override;
    public static String datFileDirectory;

    protected static final void initStatics() {
        traceFile = null;
        outputFile = null;
        indent = false;
        summary = false;
        debug = false;
        symbolic = false;
        gui = false;
        j9 = false;
        userVMIdentifier = null;
        is50orNewer = false;
        override = false;
    }

    public TraceArgs(String[] stringArray) throws UsageException {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-help")) {
                isHelpOnly = true;
            } else {
                traceFile = stringArray[0];
            }
            if (stringArray.length > 1) {
                int n;
                if (stringArray[1].startsWith("-")) {
                    outputFile = stringArray[0] + ".fmt";
                    n = 1;
                } else {
                    outputFile = stringArray[1];
                    n = 2;
                }
                while (n < stringArray.length) {
                    if (stringArray[n].equals("-summary")) {
                        summary = true;
                    } else if (stringArray[n].startsWith("-entries:")) {
                        this.parseComponentParameter(stringArray[n]);
                    } else if (stringArray[n].startsWith("-thread:")) {
                        this.parseThread(stringArray[n]);
                    } else if (stringArray[n].equals("-indent")) {
                        indent = true;
                    } else if (stringArray[n].equals("-symbolic")) {
                        symbolic = true;
                    } else if (stringArray[n].equals("-help")) {
                        isHelpOnly = true;
                    } else if (stringArray[n].equals("-version")) {
                        System.out.println("TraceFormat Version 1.0");
                    } else if (stringArray[n].equals("-debug")) {
                        debug = true;
                        verbose = true;
                    } else if (stringArray[n].equals("-j9")) {
                        j9 = true;
                    } else if (stringArray[n].equals("-verbose")) {
                        verbose = true;
                    } else if (stringArray[n].equalsIgnoreCase("-uservmid")) {
                        if (++n >= stringArray.length || stringArray[n].startsWith("-")) {
                            throw new UsageException("no uservmid string provided");
                        }
                        userVMIdentifier = stringArray[n];
                    } else if (stringArray[n].equalsIgnoreCase("-overridetimezone")) {
                        if (++n >= stringArray.length) {
                            throw new UsageException("no time provided with overridetimezone option");
                        }
                        try {
                            int n2 = Integer.parseInt(stringArray[n]);
                            System.out.println("All formatted tracepoints will be formatted with an offset to the hours field of " + n2 + "hours.");
                            timeZoneOffset = new BigInteger(stringArray[n]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Cannot format " + stringArray[n] + " into an integer to use as an hour offset in Trace Formatter.");
                            System.err.println(numberFormatException);
                            throw new UsageException("please specify an integer value after -overridetimezone that will be used as an offset for the formatted hour field");
                        }
                    } else if (stringArray[n].startsWith("-50")) {
                        is50orNewer = true;
                    } else if (stringArray[n].startsWith("-11")) {
                        is50orNewer = false;
                        override = true;
                    } else if (stringArray[n].startsWith("-datdir")) {
                        if (++n >= stringArray.length || stringArray[n].startsWith("-")) {
                            throw new UsageException("no dat file directory name provided");
                        }
                        datFileDirectory = new String(stringArray[n]);
                    } else {
                        throw new UsageException();
                    }
                    ++n;
                }
            } else {
                outputFile = stringArray[0] + ".fmt";
            }
        } else {
            throw new UsageException();
        }
    }

    private void parseComponentParameter(String string) throws UsageException {
        String string2 = string.substring("-entries:".length());
        this.parseComponents(string2);
    }

    private void parseComponents(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(",");
        if (n2 != -1) {
            if (n2 < n) {
                this.parseComponent(string.substring(0, n2));
                this.parseComponents(string.substring(n2 + 1, string.length()));
            } else {
                int n3 = string.indexOf(")");
                this.parseComponent(string.substring(0, n3 + 1));
                int n4 = string.indexOf(",", n3);
                if (n4 != -1) {
                    this.parseComponents(string.substring(n4 + 1, string.length()));
                }
            }
        } else {
            this.parseComponent(string);
        }
    }

    private void parseComponent(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n2 < n) {
            throw new UsageException();
        }
        if (n2 == n) {
            Util.putComponent(string);
        } else {
            int n3;
            Vector<String> vector = new Vector<String>(10);
            String string2 = string.substring(n + 1, string.length() - 1);
            while ((n3 = string2.indexOf(",")) != -1) {
                vector.addElement(string2.substring(0, n3));
                string2 = string2.substring(n3 + 1, string2.length());
            }
            vector.addElement(string2.substring(0, string2.length()));
            Util.putComponent(string.substring(0, n), vector);
        }
    }

    private void parseThread(String string) throws UsageException {
        String string2 = null;
        try {
            int n;
            String string3 = string.substring("-thread:".length());
            while ((n = string3.indexOf(",")) != -1) {
                string2 = string3.substring(0, n);
                Util.putThreadID(Long.decode(string2));
                string3 = string3.substring(n + 1, string3.length());
            }
            string2 = string3.substring(0, string3.length());
            Util.putThreadID(Long.decode(string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new UsageException("Bad thread ID: " + string2);
        }
    }

    static {
        timeZoneOffset = BigInteger.ZERO;
        datFileDirectory = null;
    }

    class UsageException
    extends Exception {
        UsageException(String string) {
            super(string);
        }

        UsageException() {
        }
    }
}

