/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import sun.awt.CGraphicsDevice;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWGraphicsConfig;
import sun.lwawt.macosx.CPlatformView;

public abstract class CGraphicsConfig
extends GraphicsConfiguration
implements LWGraphicsConfig {
    private final CGraphicsDevice device;
    private ColorModel colorModel;

    protected CGraphicsConfig(CGraphicsDevice cGraphicsDevice) {
        this.device = cGraphicsDevice;
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2) {
        throw new UnsupportedOperationException("not implemented");
    }

    private static native Rectangle2D nativeGetBounds(int var0);

    @Override
    public Rectangle getBounds() {
        Rectangle2D rectangle2D = CGraphicsConfig.nativeGetBounds(this.device.getCGDisplayID());
        return rectangle2D.getBounds();
    }

    @Override
    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.getColorModel(1);
        }
        return this.colorModel;
    }

    @Override
    public ColorModel getColorModel(int n) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    public CGraphicsDevice getDevice() {
        return this.device;
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        double d = this.device.getXResolution() / 72.0;
        double d2 = this.device.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    public abstract SurfaceData createSurfaceData(CPlatformView var1);

    public abstract SurfaceData createSurfaceData(CGLLayer var1);

    @Override
    public final boolean isTranslucencyCapable() {
        return true;
    }
}

