/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils {
    public static final String byteToAscii = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................";
    public static final String byteToEbcdic = "................................................................ ...........<(+|&.........!$*);.-/.........,%_>?.........`:#@'=\".abcdefghi.......jklmnopqr.......~stuvwxyz......^..........[]...{ABCDEFGHI......}JKLMNOPQR......\\.STUVWXYZ......0123456789......";
    public static final String CURRENT_MEM_ADDRESS = "currentMemPtrAddress";
    public static final String CURRENT_NUM_BYTES_TO_PRINT = "currentNumBytes";
    public static final String RootCommand_OBJECT = "RootCommandObject";
    public static final String FIND_ATTRIBUTES = "FindAttributes";
    private static final int CLASS_MODIFIERS_MASK = 3103;
    private static final int INTERFACE_MODIFIERS_MASK = 3599;
    private static final int CONSTRUCTOR_MODIFIERS_MASK = 7;
    private static final int METHOD_MODIFIERS_MASK = 3391;
    private static final int FIELD_MODIFIERS_MASK = 223;
    public static final String SORT_BY_SIZE_FLAG = "-sort:size";
    public static final String SORT_BY_NAME_FLAG = "-sort:name";
    public static final String SORT_BY_ADDRESS_FLAG = "-sort:address";
    public static final String SORT_BY_COUNT_FLAG = "-sort:count";
    public static final String REVERSE_SORT_FLAG = "-sort:reverse";
    public static final String VERBOSE_FLAG = "-verbose";

    public static Iterator getRuntimes(Image image) {
        Vector<ManagedRuntime> vector = new Vector<ManagedRuntime>();
        Iterator iterator = image.getAddressSpaces();
        while (iterator.hasNext()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)iterator.next();
            Iterator iterator2 = imageAddressSpace.getProcesses();
            while (iterator2.hasNext()) {
                ImageProcess imageProcess = (ImageProcess)iterator2.next();
                Iterator iterator3 = imageProcess.getRuntimes();
                while (iterator3.hasNext()) {
                    ManagedRuntime managedRuntime;
                    Object e = iterator3.next();
                    if (e instanceof CorruptData || vector.contains(managedRuntime = (ManagedRuntime)e)) continue;
                    vector.add(managedRuntime);
                }
            }
        }
        return vector.iterator();
    }

    public static String toHex(ImagePointer imagePointer) {
        return Utils.toHex(imagePointer.getAddress());
    }

    public static String toHex(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static String toHex(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static String toHex(short s) {
        return "0x" + Integer.toHexString(s & 0xFFFF);
    }

    public static String toHex(byte by) {
        return "0x" + Integer.toHexString(by & 0xFF);
    }

    public static String toFixedWidthHex(long l) {
        return Utils.padWithZeroes(Long.toHexString(l), 16);
    }

    public static String toFixedWidthHex(int n) {
        return Utils.padWithZeroes(Integer.toHexString(n), 8);
    }

    public static String toFixedWidthHex(short s) {
        return Utils.padWithZeroes(Integer.toHexString(s & 0xFFFF), 4);
    }

    public static String toFixedWidthHex(byte by) {
        return Utils.padWithZeroes(Integer.toHexString(by & 0xFF), 2);
    }

    public static Stack<String> constructStackFromString(String string) {
        String[] stringArray = string.split("\\s+");
        return Utils.constructStackFromStringArray(stringArray);
    }

    public static Stack<String> constructStackFromStringArray(String[] stringArray) {
        Stack<String> stack = new Stack<String>();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stack.push(stringArray[i]);
        }
        return stack;
    }

    public static String concatArgsFromStack(Stack<String> stack) {
        String string = "";
        while (!stack.empty()) {
            string = string.concat(stack.pop());
        }
        return string;
    }

    public static ImageAddressSpace _extractAddressSpace(Image image) {
        ImageAddressSpace imageAddressSpace = null;
        Iterator iterator = image.getAddressSpaces();
        Object var3_3 = null;
        while (iterator.hasNext()) {
            var3_3 = iterator.next();
            if (!(var3_3 instanceof ImageAddressSpace)) continue;
            imageAddressSpace = var3_3;
            Iterator iterator2 = imageAddressSpace.getProcesses();
            while (iterator2.hasNext()) {
                var3_3 = iterator2.next();
                if (!(var3_3 instanceof ImageProcess)) continue;
                return imageAddressSpace;
            }
        }
        return null;
    }

    public static Long longFromString(String string) {
        Long l = null;
        if (null != string) {
            if (string.startsWith("0x")) {
                string = string.substring(2);
            }
            try {
                l = Long.valueOf(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigInteger bigInteger = new BigInteger(string, 16);
                    l = bigInteger.longValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    l = null;
                }
            }
        }
        return l;
    }

    public static Long longFromStringWithPrefix(String string) {
        Long l = null;
        if (string.startsWith("0x")) {
            l = Utils.longFromString(string);
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSignatureName(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = null;
        hashtable.put("Z", "boolean");
        hashtable.put("B", "byte");
        hashtable.put("C", "char");
        hashtable.put("S", "short");
        hashtable.put("I", "int");
        hashtable.put("J", "long");
        hashtable.put("F", "float");
        hashtable.put("D", "double");
        hashtable.put("V", "void");
        if (string.startsWith("L")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), ";");
            if (!stringTokenizer.hasMoreTokens()) return null;
            String string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("java/lang/")) return string3.replaceAll("/", ".");
            string3 = string3.substring(10);
            return string3.replaceAll("/", ".");
        }
        if (!string.startsWith("[")) return (String)hashtable.get(string.substring(0, 1));
        String string4 = new String(string);
        String string5 = "";
        while (string4.startsWith("[")) {
            string5 = string5 + "[]";
            string4 = string4.substring(1);
        }
        return Utils.getSignatureName(string4) + string5;
    }

    public static String getMethodSignatureName(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        hashtable.put("Z", "boolean");
        hashtable.put("B", "byte");
        hashtable.put("C", "char");
        hashtable.put("S", "short");
        hashtable.put("I", "int");
        hashtable.put("J", "long");
        hashtable.put("F", "float");
        hashtable.put("D", "double");
        if (string.startsWith("(")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), ")");
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.hasMoreTokens() ? "(" + Utils.getMethodSignatureName(string3) + ")" : "()";
            } else {
                string2 = null;
            }
        } else if (string.startsWith("L")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1), ";");
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.startsWith("java/lang/")) {
                    string4 = string4.substring(10);
                }
                string2 = string4.replaceAll("/", ".");
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + ", " + Utils.getMethodSignatureName(string.substring(string.indexOf(59) + 1));
                }
            } else {
                string2 = null;
            }
        } else if (string.startsWith("[")) {
            String string5 = new String(string);
            String string6 = "";
            while (string5.startsWith("[")) {
                string6 = string6 + "[]";
                string5 = string5.substring(1);
            }
            if (string5.startsWith("L")) {
                if (string5.indexOf(59) + 1 == string5.length()) {
                    string2 = Utils.getSignatureName(string5) + string6;
                } else {
                    string2 = Utils.getMethodSignatureName(string5.substring(0, string5.indexOf(59) + 1));
                    string2 = string2 + string6 + ", ";
                    string2 = string2 + Utils.getMethodSignatureName(string5.substring(string5.indexOf(59) + 1));
                }
            } else if (1 == string5.length()) {
                string2 = (String)hashtable.get(string5) + string6;
            } else {
                string2 = (String)hashtable.get(string5.substring(0, 1)) + string6;
                string2 = string2 + ", ";
                string2 = string2 + Utils.getMethodSignatureName(string5.substring(1));
            }
        } else {
            string2 = (String)hashtable.get(string.substring(0, 1));
            if (string.length() > 1) {
                string2 = string2 + ", " + Utils.getMethodSignatureName(string.substring(1));
            }
        }
        return string2;
    }

    public static String getReturnValueName(String string) {
        if (string.startsWith("(")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ")");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        return null;
                    }
                    return Utils.getSignatureName(string2);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String toString(String string) {
        if (null == string) {
            return "null";
        }
        return string;
    }

    public static File absPath(Properties properties, String string) {
        File file = (File)properties.get("pwd");
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2;
    }

    public static String getVal(Object object) {
        return Utils.getVal(object, null, null);
    }

    public static String getVal(JavaObject javaObject, JavaField javaField) {
        String string;
        Object object;
        if (null == javaField) {
            object = javaObject;
            string = null;
        } else {
            try {
                object = javaField.get(javaObject);
            }
            catch (CorruptDataException corruptDataException) {
                return "<corrupt data>";
            }
            catch (MemoryAccessException memoryAccessException) {
                return "<invalid memory address>";
            }
            catch (NumberFormatException numberFormatException) {
                return "<invalid number>";
            }
            try {
                string = javaField.getString(javaObject);
            }
            catch (CorruptDataException corruptDataException) {
                string = null;
            }
            catch (MemoryAccessException memoryAccessException) {
                string = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = null;
            }
        }
        return Utils.getVal(object, string, javaField);
    }

    public static String getVal(Object object, String string, JavaField javaField) {
        String string2 = "";
        Long l = null;
        boolean bl = false;
        if (null == object) {
            string2 = string2 + "null";
        } else {
            if (object instanceof Boolean) {
                string2 = string2 + ((Boolean)object).toString();
            } else if (object instanceof Byte) {
                byte by = (Byte)object;
                string2 = string2 + String.valueOf(by);
                l = by;
            } else if (object instanceof Character) {
                char c = ((Character)object).charValue();
                string2 = string2 + Utils.getPrintableWithQuotes(c);
                l = c;
            } else if (object instanceof Double) {
                double d = (Double)object;
                string2 = string2 + String.valueOf(d);
                l = Double.doubleToRawLongBits(d);
            } else if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                string2 = string2 + String.valueOf(f);
                l = Float.floatToRawIntBits(f);
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                string2 = string2 + String.valueOf(n);
                l = n;
            } else if (object instanceof Long) {
                long l2 = (Long)object;
                string2 = string2 + String.valueOf(l2);
                l = l2;
            } else if (object instanceof Short) {
                short s = (Short)object;
                string2 = string2 + String.valueOf(s);
                l = s;
            } else if (object instanceof String) {
                string2 = string2 + (String)object;
            } else if (object instanceof JavaObject) {
                if (Utils.isNull((JavaObject)object)) {
                    string2 = string2 + "null";
                } else {
                    bl = true;
                }
            }
            if (bl) {
                String string3;
                JavaClass javaClass;
                JavaObject javaObject = (JavaObject)object;
                try {
                    javaClass = javaObject.getJavaClass();
                }
                catch (CorruptDataException corruptDataException) {
                    javaClass = null;
                }
                try {
                    string3 = null != javaClass ? javaClass.getName() : null;
                }
                catch (CorruptDataException corruptDataException) {
                    string3 = null;
                }
                if (null != string3 && string3.equals("java/lang/String")) {
                    string2 = null == string ? string2 + Utils.getStringVal(javaObject) : string2 + "\"" + Utils.getPrintable(string) + "\"";
                    string2 = string2 + " @ ";
                    string2 = string2 + Utils.toHex(javaObject.getID().getAddress());
                } else {
                    string2 = string2 + "<object> @ " + Utils.toHex(javaObject.getID().getAddress());
                }
            }
        }
        if (null != l) {
            string2 = string2 + " (";
            string2 = string2 + Utils.toHex(l);
            string2 = string2 + ")";
        }
        return string2;
    }

    private static String getStringVal(JavaObject javaObject) {
        int n;
        JavaClass javaClass;
        try {
            javaClass = javaObject.getJavaClass();
        }
        catch (CorruptDataException corruptDataException) {
            return "<cannot get String class from String object (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        Iterator iterator = javaClass.getDeclaredFields();
        JavaField javaField = null;
        while (iterator.hasNext()) {
            javaField = (JavaField)iterator.next();
            try {
                if (!javaField.getSignature().equals("[C") || Modifier.isStatic(javaField.getModifiers())) continue;
                break;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        if (javaField == null) {
            return "<cannot get char array out of String>";
        }
        JavaObject javaObject2 = null;
        try {
            javaObject2 = (JavaObject)javaField.get(javaObject);
        }
        catch (CorruptDataException corruptDataException) {
            return "<cannot get char array out of String (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        catch (MemoryAccessException memoryAccessException) {
            return "<cannot get char array out of String (" + Exceptions.getMemoryAccessExceptionString() + ")>";
        }
        try {
            n = javaObject2.getArraySize();
        }
        catch (CorruptDataException corruptDataException) {
            return "<cannot determine the size of the array (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        char[] cArray = new char[n];
        try {
            javaObject2.arraycopy(0, (Object)cArray, 0, n);
        }
        catch (CorruptDataException corruptDataException) {
            return "<cannot copy data from the array (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        catch (MemoryAccessException memoryAccessException) {
            return "<cannot copy data from the array (" + Exceptions.getMemoryAccessExceptionString() + ")>";
        }
        return "\"" + Utils.getPrintable(new String(cArray)) + "\"";
    }

    public static String getPrintable(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        char c2 = c;
        if (c2 <= '\u00ff') {
            if (c2 >= ' ' && c2 <= '~') {
                return String.valueOf(c);
            }
            return "\\" + Utils.padWithZeroes(Integer.toOctalString(c2), 3);
        }
        return "\\u" + Utils.padWithZeroes(Integer.toHexString(c2), 4);
    }

    public static String getPrintableWithQuotes(char c) {
        return "'" + Utils.getPrintable(c) + "'";
    }

    public static String getPrintable(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + Utils.getPrintable(string.charAt(i));
        }
        return string2;
    }

    public static String padWithZeroes(String string, int n) {
        String string2 = new String(string);
        for (int i = string.length(); i < n; ++i) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public static Iterator getAddressSpaceSectionInfo(Image image) {
        Iterator iterator = image.getAddressSpaces();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)iterator.next();
            Iterator iterator2 = imageAddressSpace.getImageSections();
            while (iterator2.hasNext()) {
                vector.add(iterator2.next());
            }
        }
        return vector.iterator();
    }

    public static String getFieldModifierString(JavaField javaField) throws CorruptDataException {
        int n = javaField.getModifiers();
        int n2 = 223;
        return Utils.getModifierString(n, n2);
    }

    public static String getMethodModifierString(JavaMethod javaMethod) throws CorruptDataException {
        int n = javaMethod.getModifiers();
        int n2 = "<init>".equals(javaMethod.getName()) ? 7 : 3391;
        return Utils.getModifierString(n, n2);
    }

    public static String getClassModifierString(JavaClass javaClass) throws CorruptDataException {
        int n = javaClass.getModifiers();
        int n2 = Modifier.isInterface(n) ? 3599 : 3103;
        return Utils.getModifierString(n, n2);
    }

    private static String getModifierString(int n, int n2) {
        if (n == -16777216) {
            return "No modifiers available";
        }
        String string = "";
        if (Modifier.isPublic(n &= n2)) {
            string = string + "public ";
        }
        if (Modifier.isPrivate(n)) {
            string = string + "private ";
        }
        if (Modifier.isProtected(n)) {
            string = string + "protected ";
        }
        if (Modifier.isStatic(n)) {
            string = string + "static ";
        }
        if (Modifier.isAbstract(n)) {
            string = string + "abstract ";
        }
        if (Modifier.isFinal(n)) {
            string = string + "final ";
        }
        if (Modifier.isSynchronized(n)) {
            string = string + "synchronized ";
        }
        if (Modifier.isVolatile(n)) {
            string = string + "volatile ";
        }
        if (Modifier.isTransient(n)) {
            string = string + "transient ";
        }
        if (Modifier.isNative(n)) {
            string = string + "native ";
        }
        if (Modifier.isInterface(n)) {
            string = string + "interface ";
        }
        if (Modifier.isStrict(n)) {
            string = string + "strict ";
        }
        return string;
    }

    public static boolean isNull(JavaObject javaObject) {
        return javaObject.getID().getAddress() == 0L;
    }

    public static String padWithSpaces(String string, int n) {
        String string2 = new String(string);
        for (int i = string.length(); i < n; ++i) {
            string2 = string2 + " ";
        }
        return string2;
    }

    public static String prePadWithSpaces(String string, int n) {
        String string2 = "";
        for (int i = string.length(); i < n; ++i) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    public static JavaClass[] getClassGivenName(String string, JavaRuntime javaRuntime, PrintStream printStream) {
        Iterator iterator = javaRuntime.getJavaClassLoaders();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClassLoader)) continue;
            JavaClassLoader javaClassLoader = (JavaClassLoader)e;
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                String string2;
                Object e2 = iterator2.next();
                if (!(e2 instanceof JavaClass)) continue;
                JavaClass javaClass = (JavaClass)e2;
                try {
                    string2 = javaClass.getName();
                    if (!string2.equals(string)) continue;
                    arrayList.add(javaClass);
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.print("\t  <error getting class name while traversing classes: ");
                    printStream.print(Exceptions.getCorruptDataExceptionString());
                    printStream.print(">\n");
                    string2 = null;
                }
            }
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new JavaClass[0]);
        }
        return null;
    }

    public static JavaClass getClassGivenAddress(long l, JavaRuntime javaRuntime) {
        Iterator iterator = javaRuntime.getJavaClassLoaders();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClassLoader)) continue;
            JavaClassLoader javaClassLoader = (JavaClassLoader)e;
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                JavaClass javaClass;
                long l2;
                Object e2 = iterator2.next();
                if (!(e2 instanceof JavaClass) || !(e2 instanceof JavaClass) || (l2 = (javaClass = (JavaClass)e2).getID().getAddress()) != l) continue;
                return javaClass;
            }
        }
        return null;
    }

    public static JavaThread getParkBlockerOwner(JavaObject javaObject, JavaRuntime javaRuntime) throws CorruptDataException, MemoryAccessException {
        JavaObject javaObject2 = Utils.getParkBlockerOwnerObject(javaObject, javaRuntime);
        if (javaObject2 == null) {
            return null;
        }
        Iterator iterator = javaRuntime.getThreads();
        while (iterator.hasNext()) {
            JavaThread javaThread;
            Object e = iterator.next();
            if (!(e instanceof JavaThread) || !javaObject2.equals((Object)(javaThread = (JavaThread)e).getObject())) continue;
            return javaThread;
        }
        return null;
    }

    public static JavaObject getParkBlockerOwnerObject(JavaObject javaObject, JavaRuntime javaRuntime) throws CorruptDataException, MemoryAccessException {
        JavaClass javaClass;
        if (javaObject == null) {
            return null;
        }
        for (javaClass = javaObject.getJavaClass(); javaClass != null && !"java/util/concurrent/locks/AbstractOwnableSynchronizer".equals(javaClass.getName()); javaClass = javaClass.getSuperclass()) {
        }
        if (javaClass != null) {
            Iterator iterator = javaClass.getDeclaredFields();
            while (iterator.hasNext()) {
                JavaField javaField;
                Object e = iterator.next();
                if (!(e instanceof JavaField) || !"exclusiveOwnerThread".equals((javaField = (JavaField)e).getName())) continue;
                JavaObject javaObject2 = (JavaObject)javaField.get(javaObject);
                return javaObject2;
            }
        }
        return null;
    }

    public static String getThreadNameFromObject(JavaObject javaObject, JavaRuntime javaRuntime, PrintStream printStream) throws CorruptDataException, MemoryAccessException {
        if (javaObject == null) {
            return null;
        }
        JavaClass[] javaClassArray = Utils.getClassGivenName("java/lang/Thread", javaRuntime, printStream);
        if (javaClassArray.length == 1) {
            Iterator iterator = javaClassArray[0].getDeclaredFields();
            while (iterator.hasNext()) {
                JavaField javaField;
                Object e = iterator.next();
                if (!(e instanceof JavaField) || !"name".equalsIgnoreCase((javaField = (JavaField)e).getName())) continue;
                return javaField.getString(javaObject);
            }
        }
        return null;
    }
}

