/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.ObjectFieldInfo;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HiddenInstanceFieldPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class J9ObjectFieldOffsetIterator_V1
extends J9ObjectFieldOffsetIterator {
    private ValueTypeHelper valueTypeHelper = ValueTypeHelper.getValueTypeHelper();
    private J9JavaVMPointer vm;
    private J9ROMClassPointer romClass;
    private J9ClassPointer superClazz;
    private Iterator romFieldsShapeIterator;
    private J9ClassPointer instanceClass;
    private U32 doubleSeen = new U32(0L);
    private U32 doubleStaticsSeen = new U32(0L);
    private UDATA firstDoubleOffset = new UDATA(0L);
    private UDATA firstSingleOffset = new UDATA(0L);
    private UDATA firstObjectOffset = new UDATA(0L);
    private UDATA firstFlatDoubleOffset = new UDATA(0L);
    private UDATA firstFlatObjectOffset = new UDATA(0L);
    private UDATA firstFlatSingleOffset = new UDATA(0L);
    private UDATA currentFlatDoubleOffset = new UDATA(0L);
    private UDATA currentFlatObjectOffset = new UDATA(0L);
    private UDATA currentFlatSingleOffset = new UDATA(0L);
    private U32 objectsSeen = new U32(0L);
    private U32 objectStaticsSeen = new U32(0L);
    private U32 singlesSeen = new U32(0L);
    private U32 singleStaticsSeen = new U32(0L);
    private U32 walkFlags = new U32(0L);
    private J9ROMFieldShapePointer field;
    private UDATA index = new UDATA(0L);
    private UDATA offset = new UDATA(0L);
    private IDATA backfillOffsetToUse = new IDATA(-1L);
    private UDATA lockwordNeeded = new UDATA(0L);
    private UDATA lockOffset = new UDATA(0L);
    private boolean isHidden;
    private UDATA finalizeLinkOffset = new UDATA(0L);
    private int hiddenInstanceFieldWalkIndex = -1;
    private ArrayList<HiddenInstanceField> hiddenInstanceFieldList = new ArrayList();
    private static final UDATA NO_LOCKWORD_NEEDED = new UDATA(-1L);
    private static final UDATA LOCKWORD_NEEDED = new UDATA(-2L);
    private J9ObjectFieldOffset next;
    static PrintStream err = System.err;

    protected J9ObjectFieldOffsetIterator_V1(J9JavaVMPointer j9JavaVMPointer, J9ROMClassPointer j9ROMClassPointer, J9ClassPointer j9ClassPointer, J9ClassPointer j9ClassPointer2, U32 u32) {
        this.vm = j9JavaVMPointer;
        this.romClass = j9ROMClassPointer;
        this.instanceClass = j9ClassPointer;
        this.superClazz = j9ClassPointer2;
        this.walkFlags = u32;
    }

    private void init() throws CorruptDataException {
        this.calculateInstanceSize(this.romClass, this.superClazz);
        this.romFieldsShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
    }

    private void nextField() throws CorruptDataException {
        boolean bl = false;
        this.isHidden = false;
        this.field = null;
        if (this.hiddenInstanceFieldWalkIndex == -1) {
            this.fieldOffsetsFindNext();
            if (this.field == null && this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN)) {
                bl = true;
                this.hiddenInstanceFieldWalkIndex = this.hiddenInstanceFieldList.size();
            }
        } else {
            bl = true;
        }
        if (bl && this.hiddenInstanceFieldWalkIndex != 0) {
            HiddenInstanceField hiddenInstanceField = this.hiddenInstanceFieldList.get(--this.hiddenInstanceFieldWalkIndex);
            this.field = hiddenInstanceField.shape();
            this.isHidden = true;
            this.offset = new UDATA((long)hiddenInstanceField.fieldOffset().intValue() - J9ObjectHelper.headerSize());
            this.index = new UDATA(-1L);
        }
    }

    private void fieldOffsetsFindNext() throws CorruptDataException {
        while (this.romFieldsShapeIterator.hasNext()) {
            J9ROMFieldShapePointer j9ROMFieldShapePointer = (J9ROMFieldShapePointer)this.romFieldsShapeIterator.next();
            UDATA uDATA = j9ROMFieldShapePointer.modifiers();
            this.index = this.index.add(1L);
            if (uDATA.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) {
                if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC)) continue;
                if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    this.offset = new UDATA(this.objectStaticsSeen.mult(UDATA.SIZEOF));
                    this.objectStaticsSeen = this.objectStaticsSeen.add(1);
                    this.field = j9ROMFieldShapePointer;
                    break;
                }
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
                if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    UDATA uDATA2 = J9BuildFlags.env_data64 ? new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount())) : new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount()).add(1L)).rightShift(1);
                    this.offset = uDATA2.mult(8).add(this.doubleStaticsSeen.mult(8));
                    this.doubleStaticsSeen = this.doubleStaticsSeen.add(1);
                } else {
                    this.offset = new UDATA(this.romClass.objectStaticCount().mult(UDATA.SIZEOF).add(this.singleStaticsSeen.mult(UDATA.SIZEOF)));
                    this.singleStaticsSeen = this.singleStaticsSeen.add(1);
                }
                this.field = j9ROMFieldShapePointer;
                break;
            }
            if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE)) continue;
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD)) {
                    this.offset = new UDATA(this.backfillOffsetToUse);
                    this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD).bitNot()));
                } else if (this.valueTypeHelper.isFlattenableFieldSignature(J9ROMFieldShapeHelper.getSignature(j9ROMFieldShapePointer))) {
                    J9ClassPointer j9ClassPointer = this.valueTypeHelper.findJ9ClassInFlattenedClassCacheWithFieldName(this.instanceClass, J9ROMFieldShapeHelper.getName(j9ROMFieldShapePointer));
                    if (this.valueTypeHelper.isJ9ClassIsFlattened(j9ClassPointer)) {
                        IDATA iDATA = j9ClassPointer.backfillOffset();
                        if (this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintDouble(j9ClassPointer)) {
                            this.offset = this.firstFlatDoubleOffset.add(this.currentFlatDoubleOffset).sub(iDATA);
                            this.currentFlatDoubleOffset = this.currentFlatDoubleOffset.add(Scalar.roundToSizeofU64(j9ClassPointer.totalInstanceSize().sub(iDATA)));
                        } else if (this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintReference(j9ClassPointer)) {
                            this.offset = this.firstFlatObjectOffset.add(this.currentFlatObjectOffset).sub(iDATA);
                            this.currentFlatObjectOffset = this.currentFlatObjectOffset.add(Scalar.roundToSizeToFJ9object(j9ClassPointer.totalInstanceSize().sub(iDATA)));
                        } else {
                            this.offset = this.firstFlatSingleOffset.add(this.currentFlatSingleOffset).sub(iDATA);
                            this.currentFlatSingleOffset = this.currentFlatSingleOffset.add(j9ClassPointer.totalInstanceSize().sub(iDATA));
                        }
                    } else {
                        this.offset = this.firstObjectOffset.add(this.objectsSeen.mult(ObjectFieldInfo.fj9object_t_SizeOf));
                        this.objectsSeen = this.objectsSeen.add(1);
                    }
                } else {
                    this.offset = this.firstObjectOffset.add(this.objectsSeen.mult(ObjectFieldInfo.fj9object_t_SizeOf));
                    this.objectsSeen = this.objectsSeen.add(1);
                }
                this.field = j9ROMFieldShapePointer;
                break;
            }
            if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.offset = this.firstDoubleOffset.add(this.doubleSeen.mult(8));
                this.doubleSeen = this.doubleSeen.add(1);
            } else if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                this.offset = new UDATA(this.backfillOffsetToUse);
                this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD).bitNot()));
            } else {
                this.offset = this.firstSingleOffset.add(this.singlesSeen.mult(4));
                this.singlesSeen = this.singlesSeen.add(1);
            }
            this.field = j9ROMFieldShapePointer;
            break;
        }
    }

    private LinkedList<HiddenInstanceField> copyHiddenInstanceFieldsList(J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        LinkedList<HiddenInstanceField> linkedList = new LinkedList<HiddenInstanceField>();
        J9HiddenInstanceFieldPointer j9HiddenInstanceFieldPointer = j9JavaVMPointer.hiddenInstanceFields();
        while (!j9HiddenInstanceFieldPointer.isNull()) {
            linkedList.add(new HiddenInstanceField(j9HiddenInstanceFieldPointer));
            j9HiddenInstanceFieldPointer = j9HiddenInstanceFieldPointer.next();
        }
        return linkedList;
    }

    private void calculateInstanceSize(J9ROMClassPointer j9ROMClassPointer, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        this.lockwordNeeded = NO_LOCKWORD_NEEDED;
        if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE)) {
            return;
        }
        ObjectFieldInfo objectFieldInfo = null;
        objectFieldInfo = this.valueTypeHelper.areValueTypesSupported() ? new ObjectFieldInfo(j9ROMClassPointer, this.instanceClass) : new ObjectFieldInfo(j9ROMClassPointer);
        if (j9ClassPointer.notNull()) {
            objectFieldInfo.setSuperclassFieldsSize(j9ClassPointer.totalInstanceSize().intValue());
            if (!j9ClassPointer.backfillOffset().eq(j9ClassPointer.totalInstanceSize().add(J9ObjectHelper.headerSize()))) {
                objectFieldInfo.setSuperclassBackfillOffset(j9ClassPointer.backfillOffset().sub(J9ObjectHelper.headerSize()).intValue());
            }
        } else {
            objectFieldInfo.setSuperclassFieldsSize(0);
        }
        this.lockwordNeeded = this.checkLockwordNeeded(j9ROMClassPointer, j9ClassPointer, this.instanceClass);
        if ((LOCKWORD_NEEDED.equals(this.lockwordNeeded) || NO_LOCKWORD_NEEDED.equals(this.lockwordNeeded)) && j9ClassPointer.notNull() && !j9ClassPointer.lockOffset().eq(new UDATA(-1L)) && J9ClassHelper.classDepth(j9ClassPointer).isZero()) {
            int n = objectFieldInfo.getSuperclassFieldsSize() - ObjectFieldInfo.LOCKWORD_SIZE;
            if (objectFieldInfo.isSuperclassBackfillSlotAvailable()) {
                n -= 4;
                objectFieldInfo.setSuperclassBackfillOffset(-1);
            }
            objectFieldInfo.setSuperclassFieldsSize(n);
        }
        LinkedList<HiddenInstanceField> linkedList = this.copyHiddenInstanceFieldsList(this.vm);
        this.finalizeLinkOffset = new UDATA(0L);
        if (!j9ClassPointer.isNull() && !j9ClassPointer.finalizeLinkOffset().isZero()) {
            this.finalizeLinkOffset = j9ClassPointer.finalizeLinkOffset();
        } else if (J9ROMClassHelper.finalizeNeeded(j9ROMClassPointer)) {
            linkedList.addFirst(new HiddenInstanceField(this.vm.hiddenFinalizeLinkFieldShape()));
        }
        this.lockOffset = new UDATA(this.lockwordNeeded);
        if (this.lockOffset.eq(LOCKWORD_NEEDED)) {
            linkedList.addFirst(new HiddenInstanceField(this.vm.hiddenLockwordFieldShape()));
        }
        objectFieldInfo.countInstanceFields();
        objectFieldInfo.countAndCopyHiddenFields(linkedList, this.hiddenInstanceFieldList);
        new UDATA(objectFieldInfo.calculateTotalFieldsSizeAndBackfill());
        if (this.valueTypeHelper.areValueTypesSupported()) {
            this.firstFlatDoubleOffset = new UDATA(objectFieldInfo.calculateFieldDataStart());
            this.firstDoubleOffset = new UDATA(objectFieldInfo.addFlatDoublesArea(this.firstFlatDoubleOffset.intValue()));
            this.firstFlatObjectOffset = new UDATA(objectFieldInfo.addDoublesArea(this.firstDoubleOffset.intValue()));
            this.firstObjectOffset = new UDATA(objectFieldInfo.addFlatObjectsArea(this.firstFlatObjectOffset.intValue()));
            this.firstFlatSingleOffset = new UDATA(objectFieldInfo.addObjectsArea(this.firstObjectOffset.intValue()));
            this.firstSingleOffset = new UDATA(objectFieldInfo.addFlatSinglesArea(this.firstFlatSingleOffset.intValue()));
        } else {
            this.firstDoubleOffset = new UDATA(objectFieldInfo.calculateFieldDataStart());
            this.firstObjectOffset = new UDATA(objectFieldInfo.addDoublesArea(this.firstDoubleOffset.intValue()));
            this.firstSingleOffset = new UDATA(objectFieldInfo.addObjectsArea(this.firstObjectOffset.intValue()));
        }
        if (objectFieldInfo.isMyBackfillSlotAvailable() && objectFieldInfo.isBackfillSuitableFieldAvailable()) {
            if (objectFieldInfo.isBackfillSuitableInstanceSingleAvailable()) {
                this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD);
            } else if (objectFieldInfo.isBackfillSuitableInstanceObjectAvailable()) {
                this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD);
            }
        }
        if (!this.hiddenInstanceFieldList.isEmpty()) {
            UDATA uDATA = this.firstSingleOffset.add(J9ObjectHelper.headerSize() + (long)(objectFieldInfo.getNonBackfilledInstanceSingleCount() * 4));
            UDATA uDATA2 = this.firstDoubleOffset.add(J9ObjectHelper.headerSize() + (long)(objectFieldInfo.getInstanceDoubleCount() * 8));
            UDATA uDATA3 = this.firstObjectOffset.add(J9ObjectHelper.headerSize() + (long)(objectFieldInfo.getNonBackfilledInstanceObjectCount() * ObjectFieldInfo.fj9object_t_SizeOf));
            boolean bl = false;
            boolean bl2 = false;
            if (objectFieldInfo.isMyBackfillSlotAvailable() && !this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                if (objectFieldInfo.isBackfillSuitableSingleAvailable()) {
                    bl2 = true;
                } else if (objectFieldInfo.isBackfillSuitableObjectAvailable()) {
                    bl = true;
                }
            }
            for (HiddenInstanceField hiddenInstanceField : this.hiddenInstanceFieldList) {
                UDATA uDATA4 = hiddenInstanceField.shape().modifiers();
                if (uDATA4.allBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    if (bl) {
                        hiddenInstanceField.setFieldOffset(objectFieldInfo.getMyBackfillOffsetForHiddenField());
                        bl = false;
                        continue;
                    }
                    hiddenInstanceField.setFieldOffset(uDATA3);
                    uDATA3 = uDATA3.add(ObjectFieldInfo.fj9object_t_SizeOf);
                    continue;
                }
                if (uDATA4.allBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    hiddenInstanceField.setFieldOffset(uDATA2);
                    uDATA2 = uDATA2.add(8L);
                    continue;
                }
                if (bl2) {
                    hiddenInstanceField.setFieldOffset(objectFieldInfo.getMyBackfillOffsetForHiddenField());
                    bl2 = false;
                    continue;
                }
                hiddenInstanceField.setFieldOffset(uDATA);
                uDATA = uDATA.add(4L);
            }
        }
        this.backfillOffsetToUse = new IDATA(objectFieldInfo.getMyBackfillOffset());
    }

    private UDATA checkLockwordNeeded(J9ROMClassPointer j9ROMClassPointer, J9ClassPointer j9ClassPointer, J9ClassPointer j9ClassPointer2) throws CorruptDataException {
        if (this.valueTypeHelper.isRomClassAValueType(j9ROMClassPointer)) {
            return NO_LOCKWORD_NEEDED;
        }
        J9ClassPointer j9ClassPointer3 = j9ClassPointer2;
        while (!j9ClassPointer3.isNull() && !j9ROMClassPointer.equals(j9ClassPointer3.romClass())) {
            j9ClassPointer3 = J9ClassHelper.superclass(j9ClassPointer3);
        }
        if (j9ClassPointer3.lockOffset().eq(NO_LOCKWORD_NEEDED)) {
            return NO_LOCKWORD_NEEDED;
        }
        if (j9ClassPointer != null && !j9ClassPointer.isNull() && j9ClassPointer3.lockOffset().eq(j9ClassPointer.lockOffset())) {
            return j9ClassPointer.lockOffset();
        }
        return LOCKWORD_NEEDED;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.getNext();
        return this.next != null;
    }

    private J9ObjectFieldOffset getNext() {
        if (this.romFieldsShapeIterator == null) {
            try {
                this.init();
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("CorruptDataException in com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator_V1.init()", corruptDataException, false);
                return null;
            }
        }
        try {
            this.nextField();
            if (this.field == null) {
                return null;
            }
            return new J9ObjectFieldOffset(this.field, this.offset, this.isHidden);
        }
        catch (AddressedCorruptDataException addressedCorruptDataException) {
            EventManager.raiseCorruptDataEvent("AddressedCorruptDataException getting next field offset.", addressedCorruptDataException, false);
            return null;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("CorruptDataException getting next field offset.", corruptDataException, false);
            return null;
        }
    }

    @Override
    public J9ObjectFieldOffset next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        J9ObjectFieldOffset j9ObjectFieldOffset = this.next;
        this.next = null;
        return j9ObjectFieldOffset;
    }
}

