/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.parser.Base;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class HeapdumpWriter
extends Base {
    String filename;
    DataOutputStream dos;
    Vector strings = new Vector();
    int lastAddress;
    int[] classAddressCache = new int[4];
    int classAddressCacheIndex;
    public int totalObjects;
    public int totalRefs;
    public int version;
    int[] counts = new int[256];
    int biggestGap;
    int totalGap;
    int where;
    public static final int START_OF_HEADER = 1;
    public static final int START_OF_DUMP = 2;
    public static final int END_OF_DUMP = 3;
    public static final int LONG_OBJECT_RECORD = 4;
    public static final int OBJECT_ARRAY_RECORD = 5;
    public static final int CLASS_RECORD = 6;
    public static final int PRIMITIVE_ARRAY_RECORD = 7;
    public static final int NEW_OBJECT_ARRAY_RECORD = 8;
    public static final int TOTALS = 1;
    public static final int END_OF_HEADER = 2;
    public static final int HASHCODE_RANDOMS = 3;
    public static final int FULL_VERSION = 4;

    public HeapdumpWriter(String string) {
        this.filename = string;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.dos = new DataOutputStream(bufferedOutputStream);
            this.dos.writeUTF("portable heap dump");
            this.dos.writeInt(4);
            this.dos.writeInt(0);
            this.dos.writeByte(1);
            this.dos.writeByte(1);
            this.dos.writeInt(this.totalObjects);
            this.dos.writeInt(this.totalRefs);
            this.dos.writeByte(2);
            this.dos.writeByte(2);
        }
        catch (Exception exception) {
            throw new Error("unexpected error: " + exception);
        }
    }

    public void close() {
        try {
            this.dos.writeByte(3);
            this.dos.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.filename, "rw");
            randomAccessFile.readUTF();
            randomAccessFile.readInt();
            randomAccessFile.readInt();
            randomAccessFile.readByte();
            randomAccessFile.readByte();
            randomAccessFile.writeInt(this.totalObjects);
            randomAccessFile.writeInt(this.totalRefs);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            throw new Error("unexpected error while closing file" + exception);
        }
    }

    int refsSize(int n, int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = Math.abs(n - nArray[i]) >> 3;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (n2 < 128) {
            return 0;
        }
        if (n2 < 32768) {
            return 1;
        }
        return 2;
    }

    void writeRefs(int n, int[] nArray, int n2) throws IOException {
        int n3 = nArray == null ? 0 : nArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i] - n >> 3;
            if (n2 == 0) {
                this.dos.writeByte(n4);
                continue;
            }
            if (n2 == 1) {
                this.dos.writeShort(n4);
                continue;
            }
            if (n2 == 2) {
                this.dos.writeInt(n4);
                continue;
            }
            if (n2 != 3) continue;
            this.dos.writeLong(n4);
        }
    }

    void addToCache(int n) {
        this.classAddressCache[this.classAddressCacheIndex] = n;
        this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
    }

    public void objectDump(int n, int n2, int[] nArray) {
        if ((n & 7) != 0 || (n2 & 7) != 0) {
            return;
        }
        HeapdumpWriter.Assert((n & 7) == 0);
        HeapdumpWriter.Assert((n2 & 7) == 0);
        int n3 = n - this.lastAddress >> 3;
        int n4 = Math.abs(n3);
        int n5 = nArray == null ? 0 : nArray.length;
        int n6 = this.refsSize(n, nArray);
        ++this.totalObjects;
        this.totalRefs += n5;
        try {
            int n7;
            if (n4 < 32768) {
                n7 = -1;
                if (n2 == this.classAddressCache[0]) {
                    n7 = 0;
                } else if (n2 == this.classAddressCache[1]) {
                    n7 = 1;
                } else if (n2 == this.classAddressCache[2]) {
                    n7 = 2;
                } else if (n2 == this.classAddressCache[3]) {
                    n7 = 3;
                }
                if (n7 != -1 && n5 < 4) {
                    int n8 = 128;
                    n8 |= n7 << 5;
                    n8 |= n5 << 3;
                    if (n4 >= 128) {
                        n8 |= 4;
                    }
                    this.dos.writeByte(n8 |= n6);
                    if (n4 >= 128) {
                        this.dos.writeShort(n3);
                    } else {
                        this.dos.writeByte(n3);
                    }
                    this.writeRefs(n, nArray, n6);
                    this.lastAddress = n;
                    return;
                }
                if (n5 < 8) {
                    int n9 = 64;
                    n9 |= n5 << 3;
                    if (n4 >= 128) {
                        n9 |= 4;
                    }
                    this.dos.writeByte(n9 |= n6);
                    if (n4 >= 128) {
                        this.dos.writeShort(n3);
                    } else {
                        this.dos.writeByte(n3);
                    }
                    this.dos.writeInt(n2);
                    this.writeRefs(n, nArray, n6);
                    this.addToCache(n2);
                    this.lastAddress = n;
                    return;
                }
            }
            this.dos.writeByte(4);
            n7 = n6 << 4;
            if (n4 >= 32768) {
                this.dos.writeByte(n7 | 0x80);
                this.dos.writeInt(n3);
            } else if (n4 >= 128) {
                this.dos.writeByte(n7 | 0x40);
                this.dos.writeShort(n3);
            } else {
                this.dos.writeByte(n7);
                this.dos.writeByte(n3);
            }
            this.dos.writeInt(n2);
            this.dos.writeInt(n5);
            this.writeRefs(n, nArray, n6);
            this.addToCache(n2);
            this.lastAddress = n;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    public void classDump(int n, int n2, String string, int n3, int[] nArray) {
        HeapdumpWriter.Assert((n & 7) == 0);
        int n4 = n - this.lastAddress >> 3;
        int n5 = Math.abs(n4);
        int n6 = nArray == null ? 0 : nArray.length;
        int n7 = this.refsSize(n, nArray);
        try {
            this.dos.writeByte(6);
            int n8 = n7 << 4;
            if (n5 >= 32768) {
                this.dos.writeByte(n8 | 0x80);
                this.dos.writeInt(n4);
            } else if (n5 >= 128) {
                this.dos.writeByte(n8 | 0x40);
                this.dos.writeShort(n4);
            } else {
                this.dos.writeByte(n8);
                this.dos.writeByte(n4);
            }
            this.dos.writeInt(n3);
            this.dos.writeInt(n2);
            this.dos.writeUTF(string);
            this.dos.writeInt(n6);
            this.writeRefs(n, nArray, n7);
            this.lastAddress = n;
            ++this.totalObjects;
            this.totalRefs += n6;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    public void objectArrayDump(int n, int n2, int[] nArray) {
        HeapdumpWriter.Assert((n & 7) == 0);
        HeapdumpWriter.Assert((n2 & 7) == 0);
        int n3 = n - this.lastAddress >> 3;
        int n4 = Math.abs(n3);
        int n5 = nArray == null ? 0 : nArray.length;
        int n6 = this.refsSize(n, nArray);
        try {
            this.dos.writeByte(5);
            int n7 = n6 << 4;
            if (n4 >= 32768) {
                this.dos.writeByte(n7 | 0x80);
                this.dos.writeInt(n3);
            } else if (n4 >= 128) {
                this.dos.writeByte(n7 | 0x40);
                this.dos.writeShort(n3);
            } else {
                this.dos.writeByte(n7);
                this.dos.writeByte(n3);
            }
            this.dos.writeInt(n2);
            this.dos.writeInt(n5);
            this.writeRefs(n, nArray, n6);
            this.lastAddress = n;
            ++this.totalObjects;
            this.totalRefs += n5;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    public void primitiveArrayDump(int n, int n2, int n3) {
        HeapdumpWriter.Assert((n & 7) == 0);
        if (n2 >= 8) {
            n2 -= 8;
        }
        HeapdumpWriter.Assert(n2 < 8);
        HeapdumpWriter.Assert(n2 >= 0);
        int n4 = n - this.lastAddress >> 3;
        int n5 = Math.abs(n4);
        try {
            if (n5 >= 32768 || n3 >= 32768) {
                this.dos.writeByte(0x20 | n2 << 2 | 2);
                this.dos.writeInt(n4);
                this.dos.writeInt(n3);
            } else if (n5 >= 128 || n3 >= 128) {
                this.dos.writeByte(0x20 | n2 << 2 | 1);
                this.dos.writeShort(n4);
                this.dos.writeShort(n3);
            } else {
                this.dos.writeByte(0x20 | n2 << 2 | 0);
                this.dos.writeByte(n4);
                this.dos.writeByte(n3);
            }
            this.lastAddress = n;
            ++this.totalObjects;
        }
        catch (IOException iOException) {
            throw new Error("unexpected error " + iOException);
        }
    }

    @Override
    String className() {
        return "HeapdumpWriter";
    }
}

