/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.structure.J9MemTag;
import com.ibm.j9ddr.vm29.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public class J9MemTagHelper {
    public static final long ROUNDING_GRANULARITY = 8L;
    public static IDATA J9PORT_MEMTAG_HEADER_TAG_CORRUPTED = new IDATA(1L);
    public static IDATA J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED = new IDATA(2L);
    public static IDATA J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED = new IDATA(4L);
    public static IDATA J9PORT_MEMTAG_NOT_A_TAG = new IDATA(8L);
    public static IDATA J9PORT_MEMTAG_VALID_TAG = new IDATA(16L);

    public static IDATA j9mem_check_tags(VoidPointer voidPointer, long l, long l2) throws J9MemTagCheckError {
        J9MemTagPointer j9MemTagPointer = J9MemTagHelper.j9mem_get_header_tag(voidPointer);
        J9MemTagPointer j9MemTagPointer2 = J9MemTagPointer.NULL;
        try {
            j9MemTagPointer2 = J9MemTagHelper.j9mem_get_footer_tag(j9MemTagPointer);
            J9MemTagHelper.checkTagSumCheck(j9MemTagPointer, l);
        }
        catch (J9MemTagCheckError j9MemTagCheckError) {
            try {
                if (J9MemTagHelper.checkEyecatcher(j9MemTagPointer2, l2)) {
                    throw j9MemTagCheckError;
                }
                return J9PORT_MEMTAG_NOT_A_TAG;
            }
            catch (CorruptDataException corruptDataException) {
                return J9PORT_MEMTAG_NOT_A_TAG;
            }
        }
        catch (CorruptDataException corruptDataException) {
            return J9PORT_MEMTAG_NOT_A_TAG;
        }
        try {
            J9MemTagHelper.checkTagSumCheck(j9MemTagPointer2, l2);
        }
        catch (J9MemTagCheckError j9MemTagCheckError) {
            if (l == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && l2 == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                return J9PORT_MEMTAG_FOOTER_TAG_CORRUPTED;
            }
            throw j9MemTagCheckError;
        }
        catch (CorruptDataException corruptDataException) {
            throw new J9MemTagCheckError(j9MemTagPointer, corruptDataException);
        }
        try {
            J9MemTagHelper.checkPadding(j9MemTagPointer);
        }
        catch (J9MemTagCheckError j9MemTagCheckError) {
            if (l == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_HEADER && l2 == J9PortLibrary.J9MEMTAG_EYECATCHER_FREED_FOOTER) {
                return J9PORT_MEMTAG_FOOTER_PADDING_CORRUPTED;
            }
            throw j9MemTagCheckError;
        }
        catch (CorruptDataException corruptDataException) {
            throw new J9MemTagCheckError(j9MemTagPointer, corruptDataException);
        }
        return J9PORT_MEMTAG_VALID_TAG;
    }

    public static void checkTagSumCheck(J9MemTagPointer j9MemTagPointer, long l) throws CorruptDataException {
        int n = 0;
        if (!J9MemTagHelper.checkEyecatcher(j9MemTagPointer, l)) {
            throw new J9MemTagCheckError(j9MemTagPointer, "Wrong eyecatcher. Expected 0x" + Long.toHexString(l) + " but was " + UDATA.cast(j9MemTagPointer).getHexValue());
        }
        U32Pointer u32Pointer = U32Pointer.cast(j9MemTagPointer);
        int n2 = 0;
        while ((long)n2 < J9MemTag.SIZEOF / 4L) {
            n = (int)((long)n ^ u32Pointer.at(n2).longValue());
            ++n2;
        }
        if (J9BuildFlags.env_data64) {
            U32 u32 = new U32(UDATA.cast(j9MemTagPointer).rightShift(32));
            U32 u322 = new U32(UDATA.cast(j9MemTagPointer).bitAnd(U32.MAX));
            n = (int)((long)n ^ (u32.longValue() ^ u322.longValue()));
        } else {
            n = (int)((long)n ^ j9MemTagPointer.longValue());
        }
        if (n != 0) {
            throw new J9MemTagCheckError(j9MemTagPointer, "J9MemTag sumcheck failed: " + n);
        }
    }

    private static boolean checkEyecatcher(J9MemTagPointer j9MemTagPointer, long l) throws CorruptDataException {
        return j9MemTagPointer.eyeCatcher().eq(l);
    }

    public static VoidPointer j9mem_get_memory_base(J9MemTagPointer j9MemTagPointer) {
        return VoidPointer.cast(U8Pointer.cast(j9MemTagPointer).add(J9MemTag.SIZEOF));
    }

    public static J9MemTagPointer j9mem_get_footer_tag(J9MemTagPointer j9MemTagPointer) throws CorruptDataException {
        UDATA uDATA = J9MemTagHelper.ROUNDED_FOOTER_OFFSET(j9MemTagPointer.allocSize());
        return J9MemTagPointer.cast(U8Pointer.cast(j9MemTagPointer).add(uDATA));
    }

    public static J9MemTagPointer j9mem_get_header_tag(VoidPointer voidPointer) {
        return J9MemTagPointer.cast(U8Pointer.cast(voidPointer).sub(J9MemTag.SIZEOF));
    }

    public static void checkPadding(J9MemTagPointer j9MemTagPointer) throws CorruptDataException {
        U8Pointer u8Pointer = U8Pointer.cast(J9MemTagHelper.j9mem_get_footer_padding(j9MemTagPointer));
        while (!UDATA.cast(u8Pointer).bitAnd(7L).eq(0L)) {
            if (u8Pointer.at(0L).eq(J9PortLibrary.J9MEMTAG_PADDING_BYTE)) {
                u8Pointer = u8Pointer.add(1L);
                continue;
            }
            throw new J9MemTagCheckError(j9MemTagPointer, "J9MemTag Footer Padding Corrupted at " + u8Pointer.getHexAddress() + ". Value: " + u8Pointer.at(0L));
        }
    }

    public static VoidPointer j9mem_get_footer_padding(J9MemTagPointer j9MemTagPointer) throws CorruptDataException {
        UDATA uDATA = UDATA.cast(U8Pointer.cast(j9MemTagPointer).add(J9MemTag.SIZEOF));
        U8Pointer u8Pointer = U8Pointer.cast(uDATA.add(j9MemTagPointer.allocSize()));
        return VoidPointer.cast(u8Pointer);
    }

    public static UDATA ROUNDED_FOOTER_OFFSET(UDATA uDATA) {
        UDATA uDATA2 = new UDATA(7L);
        UDATA uDATA3 = uDATA2.add(uDATA).add(J9MemTag.SIZEOF);
        UDATA uDATA4 = uDATA2.bitNot();
        return uDATA3.bitAnd(uDATA4);
    }

    public static class J9MemTagCheckError
    extends AddressedCorruptDataException {
        private static final long serialVersionUID = -8326638947722902353L;
        private final J9MemTagPointer memTag;

        J9MemTagCheckError(J9MemTagPointer j9MemTagPointer, String string) {
            super(j9MemTagPointer.getAddress(), string);
            this.memTag = j9MemTagPointer;
        }

        public J9MemTagCheckError(J9MemTagPointer j9MemTagPointer, CorruptDataException corruptDataException) {
            super(j9MemTagPointer.getAddress(), (Throwable)corruptDataException);
            this.memTag = j9MemTagPointer;
        }

        public J9MemTagPointer getMemTag() {
            return this.memTag;
        }
    }
}

