/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.ELF32FileReader;
import com.ibm.j9ddr.corereaders.elf.ELF64FileReader;
import com.ibm.j9ddr.corereaders.elf.ELFMemorySource;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public abstract class ELFFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    public static final int ELF_NOTE_HEADER_SIZE = 12;
    public static final int EI_NIDENT = 16;
    public static final byte ELFDATA2LSB = 1;
    public static final byte ELFDATA2MSB = 2;
    public static final int ELFCLASS32 = 1;
    public static final int ELFCLASS64 = 2;
    public static final int ELF_PRARGSZ = 80;
    public static final int ARCH_IA32 = 3;
    public static final int ARCH_PPC32 = 20;
    public static final int ARCH_PPC64 = 21;
    public static final int ARCH_S390 = 22;
    public static final int ARCH_ARM = 40;
    public static final int ARCH_IA64 = 50;
    public static final int ARCH_AMD64 = 62;
    public static final int ARCH_AARCH64 = 183;
    public static final int ARCH_RISCV64 = 243;
    public static final int DT_NULL = 0;
    public static final int DT_DEBUG = 21;
    public static final int DT_SONAME = 14;
    public static final int DT_STRTAB = 5;
    public static final short ET_NONE = 0;
    public static final short ET_REL = 1;
    public static final short ET_EXEC = 2;
    public static final short ET_DYN = 3;
    public static final short ET_CORE = 4;
    public static final short ET_NUM = 5;
    public static final int ET_LOOS = 65024;
    public static final int ET_HIOS = 65279;
    public static final int ET_LOPROC = 65280;
    public static final int ET_HIPROC = 65535;
    public static final int NT_PRSTATUS = 1;
    public static final int NT_PRPSINFO = 3;
    public static final int NT_AUXV = 6;
    public static final int NT_HGPRS = 768;
    public static final int AT_NULL = 0;
    public static final int AT_ENTRY = 9;
    public static final int AT_PLATFORM = 15;
    public static final int AT_HWCAP = 16;
    private long _programHeaderOffset = -1L;
    private long _sectionHeaderOffset = -1L;
    private short _programHeaderEntrySize = 0;
    private short _programHeaderCount = 0;
    private short _sectionHeaderEntrySize = 0;
    private short _sectionHeaderCount = 0;
    private short _objectType = 0;
    private int _version = 0;
    private int _e_flags = 0;
    private short _machineType;
    private long baseOffset = 0L;
    private final File _file;
    private List<ProgramHeaderEntry> _programHeaderEntries = new LinkedList<ProgramHeaderEntry>();
    private List<SectionHeaderEntry> _sectionHeaderEntries = new LinkedList<SectionHeaderEntry>();
    protected ImageInputStream is;
    protected String sourceName;

    protected abstract long padToWordBoundary(long var1);

    protected abstract ProgramHeaderEntry readProgramHeaderEntry() throws IOException;

    protected abstract long readElfWord() throws IOException;

    protected abstract Address readElfWordAsAddress() throws IOException;

    protected abstract List<ELFSymbol> readSymbolsAt(SectionHeaderEntry var1) throws IOException;

    protected abstract int addressSizeBits();

    protected ELFFileReader(File file, ByteOrder byteOrder, long l) throws IOException, FileNotFoundException, InvalidDumpFormatException {
        try {
            this.is = new FileImageInputStream(file);
            this.is.setByteOrder(byteOrder);
            this._file = file;
            this.sourceName = file.getAbsolutePath();
            this.baseOffset = l;
            this.initializeReader(l);
        }
        catch (IOException iOException) {
            if (this.is != null) {
                this.is.close();
            }
            throw iOException;
        }
        catch (InvalidDumpFormatException invalidDumpFormatException) {
            if (this.is != null) {
                this.is.close();
            }
            throw invalidDumpFormatException;
        }
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    protected ELFFileReader(ImageInputStream imageInputStream, long l) throws IOException, InvalidDumpFormatException {
        this._file = null;
        this.is = imageInputStream;
        this.baseOffset = l;
        this.sourceName = "internal data stream";
        this.initializeReader(l);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    private void initializeReader(long l) throws IOException, InvalidDumpFormatException {
        this.is.seek(l);
        this.readHeader();
        this.readSectionHeader();
        this.readProgramHeader();
    }

    public static ELFFileReader getELFFileReaderWithOffset(File file, long l) throws IOException, InvalidDumpFormatException {
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        if (!ELFFileReader.isFormatValid(fileImageInputStream)) {
            throw new InvalidDumpFormatException("File " + file.getAbsolutePath() + " is not an ELF file");
        }
        int n = fileImageInputStream.read();
        ByteOrder byteOrder = ELFFileReader.getByteOrder(fileImageInputStream);
        fileImageInputStream.close();
        if (2 == n) {
            return new ELF64FileReader(file, byteOrder, l);
        }
        return new ELF32FileReader(file, byteOrder, l);
    }

    public static ELFFileReader getELFFileReader(File file) throws IOException, InvalidDumpFormatException {
        return ELFFileReader.getELFFileReaderWithOffset(file, 0L);
    }

    public static ELFFileReader getELFFileReader(ImageInputStream imageInputStream) throws IOException, InvalidDumpFormatException {
        return ELFFileReader.getELFFileReaderWithOffset(imageInputStream, 0L);
    }

    public static ELFFileReader getELFFileReaderWithOffset(ImageInputStream imageInputStream, long l) throws IOException, InvalidDumpFormatException {
        imageInputStream.mark();
        imageInputStream.seek(l);
        if (!ELFFileReader.isFormatValid(imageInputStream)) {
            throw new InvalidDumpFormatException("The input stream is not an ELF file");
        }
        int n = imageInputStream.read();
        ByteOrder byteOrder = ELFFileReader.getByteOrder(imageInputStream);
        imageInputStream.setByteOrder(byteOrder);
        imageInputStream.reset();
        if (2 == n) {
            return new ELF64FileReader(imageInputStream, l);
        }
        return new ELF32FileReader(imageInputStream, l);
    }

    private static ByteOrder getByteOrder(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.read();
        ByteOrder byteOrder = null;
        byteOrder = 2 == n ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return byteOrder;
    }

    private static boolean isFormatValid(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = new byte[4];
        imageInputStream.readFully(byArray);
        return ELFFileReader.isELF(byArray);
    }

    public static boolean isELF(byte[] byArray) {
        return 127 == byArray[0] && 69 == byArray[1] && 76 == byArray[2] && 70 == byArray[3];
    }

    private String _nameForFileType(short s) {
        String string = "Unknown";
        int n = 0xFFFF & s;
        if (0 == s) {
            string = "No file type";
        } else if (1 == s) {
            string = "Relocatable file";
        } else if (2 == s) {
            string = "Executable file";
        } else if (3 == s) {
            string = "Shared object file";
        } else if (4 == s) {
            string = "Core file";
        } else if (5 == s) {
            string = "Number of defined types";
        } else if (65024 <= n && n <= 65279) {
            string = "OS-specific (" + Integer.toHexString(n) + ")";
        } else if (65280 <= n && n <= 65535) {
            string = "Processor-specific (" + Integer.toHexString(n) + ")";
        }
        return string;
    }

    private void readHeader() throws IOException, InvalidDumpFormatException {
        byte[] byArray = this.readBytes(16);
        if (!ELFFileReader.isELF(byArray)) {
            throw new InvalidDumpFormatException("Missing ELF magic number");
        }
        this._objectType = this.is.readShort();
        this._machineType = this.is.readShort();
        this._version = this.is.readInt();
        this.readElfWord();
        this._programHeaderOffset = this.readElfWord();
        this._sectionHeaderOffset = this.readElfWord();
        this._e_flags = this.is.readInt();
        this.is.readShort();
        this._programHeaderEntrySize = this.is.readShort();
        this._programHeaderCount = this.is.readShort();
        this._sectionHeaderEntrySize = this.is.readShort();
        this._sectionHeaderCount = this.is.readShort();
        this.is.readShort();
    }

    private SectionHeaderEntry readSectionHeaderEntry() throws IOException {
        long l = (long)this.is.readInt() & 0xFFFFFFFFL;
        long l2 = (long)this.is.readInt() & 0xFFFFFFFFL;
        long l3 = this.readElfWord();
        long l4 = this.readElfWord();
        long l5 = this.readElfWord();
        long l6 = this.readElfWord();
        long l7 = (long)this.is.readInt() & 0xFFFFFFFFL;
        long l8 = (long)this.is.readInt() & 0xFFFFFFFFL;
        return new SectionHeaderEntry(l, l2, l3, l4, l5, l6, l7, l8);
    }

    private void readSectionHeader() throws IOException {
        if (this._sectionHeaderCount < 3) {
            return;
        }
        this.seek(this._sectionHeaderOffset);
        SectionHeaderEntry sectionHeaderEntry = this.readSectionHeaderEntry();
        if (sectionHeaderEntry.offset != 0L || sectionHeaderEntry.size != 0L || sectionHeaderEntry._type != 0L || sectionHeaderEntry._name != 0L) {
            return;
        }
        this.seek(this._sectionHeaderOffset + (long)this._sectionHeaderEntrySize);
        SectionHeaderEntry sectionHeaderEntry2 = this.readSectionHeaderEntry();
        if (sectionHeaderEntry2.size == 0L) {
            return;
        }
        this._sectionHeaderEntries.add(sectionHeaderEntry);
        this._sectionHeaderEntries.add(sectionHeaderEntry2);
        for (int i = 2; i < this._sectionHeaderCount; ++i) {
            this.seek(this._sectionHeaderOffset + (long)(i * this._sectionHeaderEntrySize));
            SectionHeaderEntry sectionHeaderEntry3 = this.readSectionHeaderEntry();
            this._sectionHeaderEntries.add(sectionHeaderEntry3);
        }
    }

    private void readProgramHeader() throws IOException {
        for (int i = 0; i < this._programHeaderCount; ++i) {
            this.seek(this._programHeaderOffset + (long)(i * this._programHeaderEntrySize));
            this._programHeaderEntries.add(this.readProgramHeaderEntry());
        }
    }

    void seekToAddress(long l) throws IOException {
        ProgramHeaderEntry programHeaderEntry = null;
        for (ProgramHeaderEntry programHeaderEntry2 : this._programHeaderEntries) {
            if (!programHeaderEntry2.contains(l)) continue;
            programHeaderEntry = programHeaderEntry2;
            break;
        }
        if (null == programHeaderEntry) {
            throw new IOException("No ProgramHeaderEntry found for address");
        }
        this.seek(programHeaderEntry.fileOffset + (l - programHeaderEntry.virtualAddress));
    }

    public boolean canResolveAddress(long l) {
        ProgramHeaderEntry programHeaderEntry = null;
        for (ProgramHeaderEntry programHeaderEntry2 : this._programHeaderEntries) {
            if (!programHeaderEntry2.contains(l)) continue;
            programHeaderEntry = programHeaderEntry2;
            break;
        }
        return null != programHeaderEntry;
    }

    public List<? extends ISymbol> getSymbols(long l, boolean bl) throws IOException {
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        for (SectionHeaderEntry sectionHeaderEntry : this._sectionHeaderEntries) {
            if (!bl && !sectionHeaderEntry.isAllocated() || !sectionHeaderEntry.isSymbolTable()) continue;
            linkedList.addAll(this.readSymbolsFrom(sectionHeaderEntry, l));
        }
        return linkedList;
    }

    public Collection<? extends IMemorySource> getMemoryRanges(long l, List<SectionHeaderEntry> list, Map<Long, String> map) throws IOException {
        LinkedList<ELFMemorySource> linkedList = new LinkedList<ELFMemorySource>();
        if (map == null || list == null) {
            return linkedList;
        }
        for (SectionHeaderEntry sectionHeaderEntry : list) {
            if (!this.sectionHeaderMapsToProgramHeader(sectionHeaderEntry) || sectionHeaderEntry.isNoBits() || sectionHeaderEntry.address == 0L || sectionHeaderEntry.size == 0L) continue;
            String string = map.get(sectionHeaderEntry._name);
            linkedList.add(new ELFMemorySource(l + sectionHeaderEntry.offset, sectionHeaderEntry.size, sectionHeaderEntry.offset, this, string));
        }
        return linkedList;
    }

    public boolean sectionHeaderMapsToProgramHeader(SectionHeaderEntry sectionHeaderEntry) {
        for (ProgramHeaderEntry programHeaderEntry : this._programHeaderEntries) {
            long l = programHeaderEntry.fileOffset;
            long l2 = programHeaderEntry.fileOffset + programHeaderEntry.fileSize;
            if (sectionHeaderEntry.offset < l || sectionHeaderEntry.offset >= l2) continue;
            return true;
        }
        return false;
    }

    public Map<Long, String> getSectionHeaderStringTable() throws IOException {
        SectionHeaderEntry object = null;
        for (SectionHeaderEntry object2 : this._sectionHeaderEntries) {
            if (!object2.isStringTable()) continue;
            this.seek(object2.offset + object2._name);
            String string = this.readString();
            if (string != null) {
                if (!string.equals(".shstrtab")) continue;
                object = object2;
                continue;
            }
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        if (object == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (SectionHeaderEntry sectionHeaderEntry : this._sectionHeaderEntries) {
            if (null == object) continue;
            String string = "";
            this.seek(object.offset + sectionHeaderEntry._name);
            string = this.readString();
            hashMap.put(sectionHeaderEntry._name, string);
            if (string != null) continue;
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        return hashMap;
    }

    private List<ISymbol> readSymbolsFrom(SectionHeaderEntry sectionHeaderEntry, long l) throws IOException {
        SectionHeaderEntry sectionHeaderEntry2;
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        try {
            sectionHeaderEntry2 = this._sectionHeaderEntries.get((int)sectionHeaderEntry.link);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.log(Level.FINER, "Invalid link value " + sectionHeaderEntry.link + " when reading section header table of length " + this._sectionHeaderEntries.size());
            return linkedList;
        }
        this.seek(sectionHeaderEntry2.offset);
        for (ELFSymbol eLFSymbol : this.readSymbolsAt(sectionHeaderEntry)) {
            if (!eLFSymbol.isFunction()) continue;
            this.seek(sectionHeaderEntry2.offset + eLFSymbol.name);
            String string = this.readString();
            if (string != null) {
                if (eLFSymbol.value == 0L) continue;
                if (eLFSymbol.value > 0L && l > 0L || eLFSymbol.value < 0L && l < 0L) {
                    if (eLFSymbol.value >= l) {
                        linkedList.add(new Symbol(string, eLFSymbol.value));
                        continue;
                    }
                    linkedList.add(new Symbol(string, l + eLFSymbol.value));
                    continue;
                }
                if (eLFSymbol.value < l) {
                    linkedList.add(new Symbol(string, eLFSymbol.value));
                    continue;
                }
                linkedList.add(new Symbol(string, l + eLFSymbol.value));
                continue;
            }
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        return linkedList;
    }

    public boolean is64Bit() {
        return 64 == this.addressSizeBits();
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.is.readFully(byArray);
        return byArray;
    }

    public short getMachineType() {
        return this._machineType;
    }

    public List<? extends ProgramHeaderEntry> getProgramHeaderEntries() {
        return Collections.unmodifiableList(this._programHeaderEntries);
    }

    public List<SectionHeaderEntry> getSectionHeaderEntries() {
        return Collections.unmodifiableList(this._sectionHeaderEntries);
    }

    public ImageInputStream getStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        FileImageInputStream fileImageInputStream = new FileImageInputStream(this._file);
        return fileImageInputStream;
    }

    public File getFile() {
        return this._file;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("Object file type", this._nameForFileType(this._objectType));
        properties.setProperty("Object file version", Integer.toHexString(this._version));
        properties.setProperty("Processor-specific flags", Integer.toHexString(this._e_flags));
        return properties;
    }

    public int readInt() throws IOException {
        return this.is.readInt();
    }

    public byte readByte() throws IOException {
        return this.is.readByte();
    }

    public void seek(long l) throws IOException {
        try {
            this.is.seek(this.baseOffset + l);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException("Seek index out of bounds in " + this.getSourceName());
        }
    }

    public ByteOrder getByteOrder() {
        return this.is.getByteOrder();
    }

    public short readShort() throws IOException {
        return this.is.readShort();
    }

    public long readLong() throws IOException {
        return this.is.readLong();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.is.readFully(byArray, n, n2);
    }

    public String readString() {
        String string = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = this.readByte();
            long l = 1L;
            while (0 != by) {
                stringBuffer.append(new String(new byte[]{by}, "ASCII"));
                by = this.readByte();
                ++l;
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public long getBaseAddress() {
        long l = Long.MAX_VALUE;
        for (ProgramHeaderEntry programHeaderEntry : this.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isLoadable() || programHeaderEntry.virtualAddress >= l) continue;
            l = programHeaderEntry.virtualAddress;
        }
        return l;
    }

    public ProgramHeaderEntry getDynamicTableEntry() {
        for (ProgramHeaderEntry programHeaderEntry : this.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isDynamic()) continue;
            return programHeaderEntry;
        }
        return null;
    }

    public boolean isExecutable() {
        return this._objectType == 2;
    }

    public String readSONAME(ELFFileReader eLFFileReader) {
        ProgramHeaderEntry programHeaderEntry = this.getDynamicTableEntry();
        try {
            long l;
            long l2 = programHeaderEntry.virtualAddress;
            this.seekToAddress(l2);
            long l3 = -1L;
            long l4 = -1L;
            do {
                l = this.readElfWord();
                long l5 = this.readElfWord();
                if (!(l >= 0L && l <= 33L || l >= 0x60000000L && l <= 0x6FFFFFFFL || l >= 0x70000000L && l <= Integer.MAX_VALUE)) {
                    logger.log(Level.FINER, "Error reading SONAME. Invalid tag value '0x" + Long.toHexString(l) + "'. The core file is invalid and the results may unpredictable");
                }
                if (l == 14L) {
                    l3 = l5;
                    continue;
                }
                if (l != 5L) continue;
                l4 = l5;
            } while (l != 0L);
            if (l3 != -1L && l4 != -1L) {
                String string;
                if (this.canResolveAddress(l4 + l3)) {
                    this.seekToAddress(l4 + l3);
                    string = this.readString();
                } else {
                    eLFFileReader.seekToAddress(l4 + l3);
                    string = eLFFileReader.readString();
                }
                if (string == null || string.length() == 0) {
                    return null;
                }
                return string;
            }
            return null;
        }
        catch (IOException iOException) {
            logger.info("ProgramHeaderEntry @ " + Long.toHexString(programHeaderEntry.virtualAddress) + " does not appear point to a module with a valid SONAME tag.");
            return null;
        }
    }

    public boolean isCompatibleWith(ELFFileReader eLFFileReader) {
        if (null == eLFFileReader) {
            return false;
        }
        if (this.getMachineType() != eLFFileReader.getMachineType()) {
            return false;
        }
        if (this._programHeaderCount != eLFFileReader._programHeaderCount) {
            return false;
        }
        Iterator<? extends ProgramHeaderEntry> iterator = this.getProgramHeaderEntries().iterator();
        Iterator<? extends ProgramHeaderEntry> iterator2 = eLFFileReader.getProgramHeaderEntries().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            ProgramHeaderEntry programHeaderEntry = iterator.next();
            ProgramHeaderEntry programHeaderEntry2 = iterator2.next();
            if (programHeaderEntry.virtualAddress == programHeaderEntry2.virtualAddress) continue;
            return false;
        }
        if (this._sectionHeaderCount != eLFFileReader._sectionHeaderCount) {
            return false;
        }
        return this._version == eLFFileReader._version;
    }
}

