/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.x509.X509Key;

final class P11ECUtil {
    static ECPublicKey decodeX509ECPublicKey(byte[] byArray) throws InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return (ECPublicKey)P11ECUtil.ECGeneratePublic(x509EncodedKeySpec);
    }

    static byte[] x509EncodeECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeySpecException {
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        X509Key x509Key = (X509Key)P11ECUtil.ECGeneratePublic(eCPublicKeySpec);
        return x509Key.getEncoded();
    }

    static ECPrivateKey decodePKCS8ECPrivateKey(byte[] byArray) throws InvalidKeySpecException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return (ECPrivateKey)P11ECUtil.ECGeneratePrivate(pKCS8EncodedKeySpec);
    }

    static ECPrivateKey generateECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeySpecException {
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger, eCParameterSpec);
        return (ECPrivateKey)P11ECUtil.ECGeneratePrivate(eCPrivateKeySpec);
    }

    private static PublicKey ECGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
                return new ECPublicKeyImpl(x509EncodedKeySpec.getEncoded());
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
                return new ECPublicKeyImpl(eCPublicKeySpec.getW(), eCPublicKeySpec.getParams());
            }
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    private static PrivateKey ECGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
                return new ECPrivateKeyImpl(pKCS8EncodedKeySpec.getEncoded());
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
                return new ECPrivateKeyImpl(eCPrivateKeySpec.getS(), eCPrivateKeySpec.getParams());
            }
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    private P11ECUtil() {
    }
}

