/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import java.io.DataOutput;
import java.io.IOException;

public class ClassRecord
extends PortableHeapDumpRecord {
    private final String _className;
    private final long _superClassAddress;
    private final long _instanceSize;
    private final int _hashCode;
    private final boolean _is64Bit;
    private final boolean _is32BitHash;

    protected ClassRecord(long l, long l2, String string, long l3, long l4, int n, boolean bl, ReferenceIterator referenceIterator, boolean bl2) {
        super(l, l2, referenceIterator);
        this._className = string;
        this._superClassAddress = l3;
        this._instanceSize = l4;
        this._is64Bit = bl;
        this._hashCode = n;
        this._is32BitHash = bl2;
    }

    @Override
    protected void writeHeapDump(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(6);
        int n = 0;
        n = (byte)(n | this._gapSize << 6);
        n = (byte)(n | this._referenceFieldSize << 4);
        if (this._is32BitHash && this._hashCode != 0) {
            n = (byte)(n | 8);
        }
        dataOutput.writeByte(n);
        this.writeReference(dataOutput, this._gapSize, this._gapPreceding);
        dataOutput.writeInt((int)this._instanceSize);
        if (this._is32BitHash) {
            if (this._hashCode != 0) {
                dataOutput.writeInt(this._hashCode);
            }
        } else {
            dataOutput.writeShort(this._hashCode);
        }
        if (this._is64Bit) {
            dataOutput.writeLong(this._superClassAddress);
        } else {
            dataOutput.writeInt((int)this._superClassAddress);
        }
        dataOutput.writeUTF(this._className);
        dataOutput.writeInt(this._numberOfReferences);
        this.writeReferences(dataOutput);
    }
}

