/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.javacore.JCImage;
import com.ibm.dtfj.image.javacore.JCImagePointer;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageAddressSpace
implements ImageAddressSpace {
    private Vector fProcesses;
    private Vector fImageSections;
    private JCImage fImage;

    public JCImageAddressSpace(JCImage jCImage) {
        if (jCImage == null) {
            throw new IllegalArgumentException("Must pass a valid image");
        }
        this.fImage = jCImage;
        this.fProcesses = new Vector();
        this.fImageSections = new Vector();
        jCImage.addAddressSpace(this);
    }

    @Override
    public ImageProcess getCurrentProcess() {
        ImageProcess imageProcess = null;
        int n = this.fProcesses.size();
        if (n > 0) {
            imageProcess = (ImageProcess)this.fProcesses.get(n - 1);
        }
        return imageProcess;
    }

    @Override
    public Iterator getImageSections() {
        return this.fImageSections.iterator();
    }

    @Override
    public ImagePointer getPointer(long l) {
        try {
            return new JCImagePointer(this, l);
        }
        catch (JCInvalidArgumentsException jCInvalidArgumentsException) {
            jCInvalidArgumentsException.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterator getProcesses() {
        return this.fProcesses.iterator();
    }

    public void addImageProcess(ImageProcess imageProcess) {
        if (imageProcess != null) {
            this.fProcesses.add(imageProcess);
        }
    }

    public JCImage getImage() {
        return this.fImage;
    }

    public boolean isValidAddressID(long l) {
        return l != -1L;
    }

    public void addImageSection(ImageSection imageSection) {
        this.fImageSections.add(imageSection);
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return "0";
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

