/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import java.io.PrintStream;

public class EnumFormatter
extends BaseFieldFormatter {
    @Override
    public FormatWalkResult format(String string, String string2, String string3, int n, long l, PrintStream printStream, Context context, IStructureFormatter iStructureFormatter) throws CorruptDataException {
        long l2;
        if (n != 101) {
            return FormatWalkResult.KEEP_WALKING;
        }
        string2 = string2.replace("enum", "");
        StructureReader.StructureDescriptor structureDescriptor = StructureCommandUtil.getStructureDescriptor(string2 = string2.trim(), context);
        if (null == structureDescriptor) {
            printStream.print("<<Missing description of " + string2 + ">>");
            return FormatWalkResult.STOP_WALKING;
        }
        switch (structureDescriptor.getSizeOf()) {
            case 1: {
                l2 = U8Pointer.cast(l).at(0L).longValue();
                break;
            }
            case 2: {
                l2 = U16Pointer.cast(l).at(0L).longValue();
                break;
            }
            case 4: {
                l2 = U32Pointer.cast(l).at(0L).longValue();
                break;
            }
            case 8: {
                l2 = U64Pointer.cast(l).at(0L).longValue();
                break;
            }
            default: {
                printStream.print("<<Unhandled enum size: " + structureDescriptor.getSizeOf() + ">>");
                return FormatWalkResult.STOP_WALKING;
            }
        }
        printStream.print("0x" + Long.toHexString(l2));
        printStream.print(" (");
        printStream.print(l2);
        printStream.print(")");
        boolean bl = false;
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            if (constantDescriptor.getValue() != l2) continue;
            printStream.print(" //");
            printStream.print(constantDescriptor.getName());
            bl = true;
            break;
        }
        if (!bl) {
            printStream.print(" <<Not matched to enum constant>>");
        }
        return FormatWalkResult.STOP_WALKING;
    }
}

