/*
 * Decompiled with CFR 0.152.
 */
package openj9.management.internal;

import com.ibm.oti.util.Util;
import java.util.Arrays;
import java.util.Objects;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.MonitorInfoBase;

public class ThreadInfoBase {
    private final long threadId;
    private final long nativeTId;
    private final String threadName;
    private final Thread.State threadState;
    private final boolean suspended;
    private final boolean inNative;
    private final long blockedCount;
    private final long blockedTime;
    private final long waitedCount;
    private final long waitedTime;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;
    private StackTraceElement[] stackTrace = new StackTraceElement[0];
    private final LockInfoBase blockingLockInfo;
    private LockInfoBase[] lockedSynchronizers = new LockInfoBase[0];
    private MonitorInfoBase[] lockedMonitors = new MonitorInfoBase[0];
    private String cachedToStringResult;

    public ThreadInfoBase(long l, String string, Thread.State state, boolean bl, boolean bl2, long l2, long l3, long l4, long l5, String string2, long l6, String string3, StackTraceElement[] stackTraceElementArray, LockInfoBase lockInfoBase, MonitorInfoBase[] monitorInfoBaseArray, LockInfoBase[] lockInfoBaseArray) {
        this.threadId = l;
        this.nativeTId = -1L;
        this.threadName = string;
        this.threadState = state;
        this.suspended = bl;
        this.inNative = bl2;
        this.blockedCount = l2;
        this.blockedTime = l3;
        this.waitedCount = l4;
        this.waitedTime = l5;
        this.lockName = string2;
        this.lockOwnerId = l6;
        this.lockOwnerName = string3;
        this.stackTrace = stackTraceElementArray;
        this.blockingLockInfo = lockInfoBase;
        this.lockedMonitors = monitorInfoBaseArray;
        this.lockedSynchronizers = lockInfoBaseArray;
    }

    private ThreadInfoBase(Thread thread, long l, int n, boolean bl, boolean bl2, long l2, long l3, long l4, long l5, StackTraceElement[] stackTraceElementArray, Object object, Thread thread2, MonitorInfoBase[] monitorInfoBaseArray, LockInfoBase[] lockInfoBaseArray) {
        this.threadId = thread.getId();
        this.nativeTId = l;
        this.threadName = thread.getName();
        this.threadState = Thread.State.values()[n];
        this.suspended = bl;
        this.inNative = bl2;
        this.blockedCount = l2;
        this.blockedTime = l3;
        this.waitedCount = l4;
        this.waitedTime = l5;
        if (thread2 != null) {
            this.lockOwnerId = thread2.getId();
            this.lockOwnerName = thread2.getName();
        } else {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        }
        this.stackTrace = stackTraceElementArray;
        this.lockedMonitors = monitorInfoBaseArray;
        this.lockedSynchronizers = lockInfoBaseArray;
        if (object != null) {
            this.blockingLockInfo = new LockInfoBase(object.getClass().getName(), System.identityHashCode(object));
            this.lockName = this.blockingLockInfo.toString();
        } else {
            this.blockingLockInfo = null;
            this.lockName = null;
        }
    }

    public String toString() {
        String string = System.lineSeparator();
        if (this.cachedToStringResult == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("\"%s\" Id=%d %s", new Object[]{this.threadName, this.threadId, this.threadState}));
            if (Thread.State.BLOCKED == this.threadState) {
                stringBuilder.append(String.format(" on %s owned by \"%s\" Id=%d", this.lockName, this.lockOwnerName, this.lockOwnerId));
            }
            stringBuilder.append(string);
            if (this.stackTrace != null && this.stackTrace.length > 0) {
                MonitorInfoBase[] monitorInfoBaseArray = new MonitorInfoBase[this.stackTrace.length];
                MonitorInfoBase[] monitorInfoBaseArray2 = this.lockedMonitors;
                int n = monitorInfoBaseArray2.length;
                for (int i = 0; i < n; ++i) {
                    MonitorInfoBase monitorInfoBase;
                    monitorInfoBaseArray[monitorInfoBase.getStackDepth()] = monitorInfoBase = monitorInfoBaseArray2[i];
                }
                int n2 = 0;
                for (StackTraceElement stackTraceElement : this.stackTrace) {
                    stringBuilder.append("\tat ");
                    Util.printStackTraceElement(stackTraceElement, null, stringBuilder, true);
                    stringBuilder.append(string);
                    MonitorInfoBase monitorInfoBase = monitorInfoBaseArray[n2];
                    if (null != monitorInfoBase) {
                        stringBuilder.append(String.format("\t- locked %s%n", monitorInfoBase.toString()));
                    }
                    ++n2;
                }
            }
            this.cachedToStringResult = stringBuilder.toString();
        }
        return this.cachedToStringResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof ThreadInfoBase) {
            ThreadInfoBase threadInfoBase = (ThreadInfoBase)object;
            bl = threadInfoBase.threadId == this.threadId && threadInfoBase.blockedCount == this.blockedCount && threadInfoBase.blockedTime == this.blockedTime && threadInfoBase.lockOwnerId == this.lockOwnerId && threadInfoBase.waitedCount == this.waitedCount && threadInfoBase.waitedTime == this.waitedTime && threadInfoBase.inNative == this.inNative && threadInfoBase.suspended == this.suspended && threadInfoBase.threadName.equals(this.threadName) && threadInfoBase.threadState.equals((Object)this.threadState) && Objects.equals(threadInfoBase.lockName, this.lockName) && Objects.equals(threadInfoBase.lockOwnerName, this.lockOwnerName) && Objects.equals(threadInfoBase.blockingLockInfo, this.blockingLockInfo) && Arrays.equals(threadInfoBase.stackTrace, this.stackTrace);
        }
        return bl;
    }

    public int hashCode() {
        return (Long.toString(this.blockedCount) + this.blockedTime + this.lockName + this.lockOwnerId + this.lockOwnerName + this.stackTrace.length + this.threadId + this.threadName + (Object)((Object)this.threadState) + this.waitedCount + this.waitedTime + this.inNative + this.suspended).hashCode();
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getNativeTId() {
        return this.nativeTId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public LockInfoBase getBlockingLockInfo() {
        return this.blockingLockInfo;
    }

    public LockInfoBase[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public MonitorInfoBase[] getLockedMonitors() {
        return this.lockedMonitors;
    }
}

