/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaJitInputType;
import com.ibm.cuda.CudaJitOptions;
import com.ibm.cuda.internal.CudaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaLinker {
    private final CudaJitOptions createOptions;
    private final int deviceId;
    private final AtomicLong nativeHandle;

    private static native void add(int var0, long var1, int var3, byte[] var4, String var5, long var6) throws CudaException;

    private static native byte[] complete(int var0, long var1) throws CudaException;

    private static native long create(int var0, long var1) throws CudaException;

    private static native void destroy(int var0, long var1) throws CudaException;

    public CudaLinker(CudaDevice cudaDevice) throws CudaException {
        this(cudaDevice, null);
    }

    public CudaLinker(CudaDevice cudaDevice, CudaJitOptions cudaJitOptions) throws CudaException {
        this.createOptions = cudaJitOptions;
        this.deviceId = cudaDevice.getDeviceId();
        this.nativeHandle = new AtomicLong(CudaLinker.create(this.deviceId, cudaJitOptions == null ? 0L : cudaJitOptions.getHandle()));
    }

    public CudaLinker add(CudaJitInputType cudaJitInputType, byte[] byArray, String string) throws CudaException {
        return this.add(cudaJitInputType, byArray, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaLinker add(CudaJitInputType cudaJitInputType, byte[] byArray, String string, CudaJitOptions cudaJitOptions) throws CudaException {
        if (cudaJitInputType == null) {
            throw new NullPointerException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        long l = this.getHandle();
        if (cudaJitOptions == null) {
            CudaLinker.add(this.deviceId, l, cudaJitInputType.nativeValue, byArray, string, 0L);
        } else {
            try {
                CudaLinker.add(this.deviceId, l, cudaJitInputType.nativeValue, byArray, string, cudaJitOptions.getHandle());
            }
            finally {
                cudaJitOptions.releaseHandle(true);
            }
        }
        if (this.createOptions != null) {
            this.createOptions.update();
        }
        return this;
    }

    public CudaLinker add(CudaJitInputType cudaJitInputType, InputStream inputStream, String string) throws CudaException, IOException {
        return this.add(cudaJitInputType, inputStream, string, null);
    }

    public CudaLinker add(CudaJitInputType cudaJitInputType, InputStream inputStream, String string, CudaJitOptions cudaJitOptions) throws CudaException, IOException {
        return this.add(cudaJitInputType, CudaUtil.read(inputStream, true), string, cudaJitOptions);
    }

    public byte[] complete() throws CudaException {
        return CudaLinker.complete(this.deviceId, this.getHandle());
    }

    public void destroy() throws CudaException {
        long l = this.nativeHandle.getAndSet(0L);
        if (l != 0L) {
            CudaLinker.destroy(this.deviceId, l);
        }
        if (this.createOptions != null) {
            this.createOptions.releaseHandle(false);
        }
    }

    public String getErrorLogBuffer() {
        if (this.createOptions == null) {
            return "";
        }
        return this.createOptions.getErrorLogBuffer();
    }

    private long getHandle() {
        long l = this.nativeHandle.get();
        if (l == 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    public String getInfoLogBuffer() {
        if (this.createOptions == null) {
            return "";
        }
        return this.createOptions.getInfoLogBuffer();
    }

    public float getWallTime() {
        if (this.createOptions == null) {
            return 0.0f;
        }
        return this.createOptions.getWallTime();
    }
}

