/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import org.ietf.jgss.GSSException;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApRep;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.util.DerValue;

class AcceptSecContextToken
extends InitialToken {
    private KrbApRep apRep = null;

    public AcceptSecContextToken(Krb5Context krb5Context, KrbApReq krbApReq) throws KrbException, IOException, GSSException {
        boolean bl = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.acceptor.subkey"));
        boolean bl2 = true;
        EncryptionKey encryptionKey = null;
        if (bl) {
            encryptionKey = new EncryptionKey(krbApReq.getCreds().getSessionKey());
            krb5Context.setKey(2, encryptionKey);
        }
        this.apRep = new KrbApRep(krbApReq, bl2, encryptionKey);
        krb5Context.resetMySequenceNumber(this.apRep.getSeqNumber());
    }

    public AcceptSecContextToken(Krb5Context krb5Context, Credentials credentials, KrbApReq krbApReq, InputStream inputStream) throws IOException, GSSException, KrbException {
        Integer n;
        int n2 = inputStream.read() << 8 | inputStream.read();
        if (n2 != 512) {
            throw new GSSException(10, -1, "AP_REP token id does not match!");
        }
        byte[] byArray = new DerValue(inputStream).toByteArray();
        KrbApRep krbApRep = new KrbApRep(byArray, credentials, krbApReq);
        EncryptionKey encryptionKey = krbApRep.getSubKey();
        if (encryptionKey != null) {
            krb5Context.setKey(2, encryptionKey);
        }
        int n3 = (n = krbApRep.getSeqNumber()) != null ? n : 0;
        krb5Context.resetPeerSequenceNumber(n3);
    }

    @Override
    public final byte[] encode() throws IOException {
        byte[] byArray = this.apRep.getMessage();
        byte[] byArray2 = new byte[2 + byArray.length];
        AcceptSecContextToken.writeInt(512, byArray2, 0);
        System.arraycopy((Object)byArray, 0, (Object)byArray2, 2, byArray.length);
        return byArray2;
    }
}

