/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.Attachment;
import com.ibm.tools.attach.target.CommonDirectory;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.TargetDirectory;
import java.io.IOException;

final class WaitLoop
extends Thread {
    WaitLoop() {
        this.setDaemon(true);
        this.setName("Attach API wait loop");
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment waitForNotification(boolean bl) throws IOException {
        Object object = AttachHandler.mainHandler.getIgnoreNotification();
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entering");
        }
        Object object2 = object;
        synchronized (object2) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ignoreNotification entered");
            }
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification starting wait");
        }
        int n = 0;
        if (AttachHandler.startWaitingForSemaphore()) {
            n = CommonDirectory.waitSemaphore(AttachHandler.vmId);
            AttachHandler.endWaitingForSemaphore();
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification ended wait");
        }
        if (AttachHandler.isAttachApiTerminated()) {
            if (AttachHandler.getDoCancelNotify()) {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification cancelNotify");
                }
                CommonDirectory.cancelNotify(AttachHandler.getNumberOfTargets(), true);
            }
            return null;
        }
        if (n != 0) {
            if (bl) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " waitForNotification reopen semaphore");
                AttachHandler.AttachStateSync attachStateSync = AttachHandler.stateSync;
                synchronized (attachStateSync) {
                    if (!AttachHandler.isAttachApiTerminated()) {
                        try {
                            CommonDirectory.obtainMasterLock();
                            n = CommonDirectory.reopenSemaphore();
                            CommonDirectory.releaseMasterLock();
                        }
                        catch (IOException iOException) {
                            IPC.logMessage("waitForNotification: IOError on master lock : ", iOException.toString());
                        }
                    }
                }
                if (0 == n && TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                    if (CommonDirectory.tryObtainMasterLock()) {
                        IPC.logMessage("semaphore recovery: send test post");
                        int n2 = CommonDirectory.countTargetDirectories();
                        AttachHandler.setNumberOfTargets(n2);
                        CommonDirectory.notifyVm(n2, true);
                        CommonDirectory.releaseMasterLock();
                    }
                    return this.waitForNotification(false);
                }
            }
            AttachHandler.mainHandler.terminate(false);
            return null;
        }
        Attachment attachment = WaitLoop.checkReplyAndCreateAttachment();
        return attachment;
    }

    private static Attachment checkReplyAndCreateAttachment() throws IOException {
        Attachment attachment = AttachHandler.mainHandler.connectToAttacher();
        if (!TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
            AttachHandler.mainHandler.terminate(false);
        }
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("checkReplyAndCreateAttachment iteration " + AttachHandler.notificationCount + " waitForNotification obtainLock");
        }
        if (!AttachHandler.mainHandler.syncFileLock.lockFile(true)) {
            TargetDirectory.createMySyncFile();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("iteration ", AttachHandler.notificationCount, " checkReplyAndCreateAttachment releaseLock");
            }
            AttachHandler.mainHandler.syncFileLock.unlockFile();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            return attachment;
        }
        return attachment;
    }

    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        while (!AttachHandler.isAttachApiTerminated()) {
            try {
                this.waitForNotification(true);
            }
            catch (IOException iOException) {
                IPC.logMessage("exception in waitForNotification ", iOException.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IPC.tracepoint(-2, outOfMemoryError.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            ++AttachHandler.notificationCount;
        }
        AttachHandler.mainHandler.syncFileLock = null;
    }
}

