/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.target.FilelockTimer;
import com.ibm.tools.attach.target.IPC;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.TimerTask;

public final class FileLock {
    long fileDescriptor;
    String lockFilepath;
    int fileMode;
    private boolean locked = false;
    private static FilelockTimer fileLockWatchdogTimer;
    private static syncObject shutdownSync;
    static boolean terminated;
    private volatile java.nio.channels.FileLock lockObject;
    private volatile RandomAccessFile lockFileRAF;

    boolean isLocked() {
        return this.locked;
    }

    public FileLock(String string, int n) {
        if (null == string) {
            throw new NullPointerException("filePath is null");
        }
        this.lockFilepath = string;
        this.fileMode = n;
        this.lockObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockFile(boolean bl) throws IOException {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage(bl ? "locking file " : "non-blocking locking file ", this.lockFilepath);
        }
        if (this.locked) {
            throw new IOException(Msg.getString("K0574"));
        }
        this.fileDescriptor = FileLock.lockFileImpl(this.lockFilepath, this.fileMode, false);
        boolean bl2 = this.locked = 0L <= this.fileDescriptor;
        if (!this.locked && bl) {
            FileLockWatchdogTask fileLockWatchdogTask = new FileLockWatchdogTask();
            IPC.logMessage("lock failed, trying blocking lock");
            Object object = shutdownSync;
            synchronized (object) {
                if (!terminated && null == fileLockWatchdogTimer) {
                    fileLockWatchdogTimer = new FilelockTimer("file lock watchdog");
                }
                if (null == fileLockWatchdogTimer) {
                    return false;
                }
                fileLockWatchdogTimer.schedule((TimerTask)fileLockWatchdogTask, 60000L);
            }
            try {
                this.lockFileRAF = new RandomAccessFile(this.lockFilepath, "rw");
                object = this.lockFileRAF.getChannel();
                this.lockObject = ((FileChannel)object).lock();
                IPC.logMessage("Blocking lock succeeded");
                this.locked = true;
            }
            catch (IOException iOException) {
                this.locked = false;
            }
            object = shutdownSync;
            synchronized (object) {
                if (null != fileLockWatchdogTimer) {
                    fileLockWatchdogTask.cancel();
                }
            }
        }
        return this.locked;
    }

    public void unlockFile() {
        java.nio.channels.FileLock fileLock;
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("unlocking file ", this.lockFilepath);
        }
        if (null != (fileLock = this.lockObject)) {
            IPC.logMessage("closing ", this.lockFilepath);
            try {
                fileLock.release();
                this.lockFileRAF.close();
            }
            catch (IOException iOException) {
                IPC.logMessage("IOException unlocking file " + this.lockFilepath, iOException);
            }
        }
        if (this.locked && this.fileDescriptor >= 0L) {
            FileLock.unlockFileImpl(this.fileDescriptor);
        }
        this.locked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDown() {
        syncObject syncObject2 = shutdownSync;
        synchronized (syncObject2) {
            terminated = true;
            if (null != fileLockWatchdogTimer) {
                fileLockWatchdogTimer.cancel();
                fileLockWatchdogTimer.purge();
            }
            fileLockWatchdogTimer = null;
        }
    }

    private static native long lockFileImpl(String var0, int var1, boolean var2);

    private static native int unlockFileImpl(long var0);

    static {
        shutdownSync = new syncObject();
    }

    final class FileLockWatchdogTask
    extends TimerTask {
        FileLockWatchdogTask() {
        }

        @Override
        public void run() {
            IPC.logMessage("waitAndCheckLock recreating ", FileLock.this.lockFilepath);
            File file = new File(FileLock.this.lockFilepath);
            if (!file.renameTo(new File(file.getParent(), ".trash_" + IPC.getRandomNumber()))) {
                IPC.logMessage("waitAndCheckLock could not rename ", file.getName());
                file.renameTo(new File(file.getParent(), ".trash_" + IPC.getRandomNumber()));
            }
            FileLock.this.unlockFile();
            if (!file.delete()) {
                IPC.logMessage("waitAndCheckLock could not delete ", file.getAbsolutePath());
            } else {
                IPC.logMessage("waitAndCheckLock deleted ", file.getAbsolutePath());
            }
            IPC.logMessage("waitAndCheckLock normal return ");
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

