/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class AnalyseRomClassUTF8Command
extends Command {
    public AnalyseRomClassUTF8Command() {
        this.addCommand("analyseromClassutf8", "[WeightList] [maxDistribution%]", "Analyze ROM Class UTF8 distribution (max defaults to 85)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            boolean bl = false;
            int n = 85;
            if (stringArray.length >= 1 && stringArray[0].equals("UTF8WeightList")) {
                bl = true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith("%")) continue;
                try {
                    n = DecimalFormat.getInstance().parse(stringArray[i]).intValue();
                    continue;
                }
                catch (ParseException parseException) {
                    printStream.println("Usage: !analyseromClassutf8 [UTF8WeightList] [maxDistribution%]\t\tmaxDistribution defaults to 85%");
                }
            }
            Statistics statistics = new Statistics();
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ROMClassesIterator rOMClassesIterator = new ROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments());
            J9ObjectPointer j9ObjectPointer = j9JavaVMPointer.systemClassLoader().classLoaderObject();
            while (rOMClassesIterator.hasNext()) {
                J9ROMClassPointer j9ROMClassPointer = rOMClassesIterator.next();
                RomClassWalker romClassWalker = new RomClassWalker(j9ROMClassPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode j9ClassRegionNode = linearDumper.getAllRegions(romClassWalker);
                statistics.add(j9ClassRegionNode, rOMClassesIterator, j9ObjectPointer);
            }
            statistics.getResult(bl, n, printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private class Statistics {
        LinkedHashMap<String, Long[]> utf8global = new LinkedHashMap();
        LinkedHashMap<String, Long[]> utf8classloader = new LinkedHashMap();
        LinkedHashMap<String, Long[]> utf8bootstraploader = new LinkedHashMap();

        private Statistics() {
        }

        void add(LinearDumper.J9ClassRegionNode j9ClassRegionNode, ROMClassesIterator rOMClassesIterator, J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
            this.addRecursive(j9ClassRegionNode, rOMClassesIterator, j9ObjectPointer, null);
        }

        void addRecursive(LinearDumper.J9ClassRegionNode j9ClassRegionNode, ROMClassesIterator rOMClassesIterator, J9ObjectPointer j9ObjectPointer, String string) throws CorruptDataException {
            String string2;
            LinearDumper.J9ClassRegion j9ClassRegion = j9ClassRegionNode.getNodeValue();
            String string3 = null;
            if (j9ClassRegion != null) {
                string3 = j9ClassRegion.getName();
                if (j9ClassRegion.getType() == IClassWalkCallbacks.SlotType.J9_ROM_UTF8 && string != null && string.equals("UTF8")) {
                    long l = j9ClassRegion.getLength();
                    string2 = J9UTF8Helper.stringValue(J9UTF8Pointer.cast(j9ClassRegion.getSlotPtr()));
                    Long[] longArray = this.utf8global.get(string2);
                    long l2 = 0L;
                    long l3 = 1L;
                    if (longArray == null) {
                        l2 = new Long(l);
                    } else {
                        l2 = new Long(l) + longArray[0];
                        l3 += longArray[1].longValue();
                    }
                    this.utf8global.put(string2, new Long[]{l2, l3});
                    J9ClassLoaderPointer j9ClassLoaderPointer = rOMClassesIterator.getMemorySegmentPointer().classLoader();
                    if (!j9ClassLoaderPointer.classLoaderObject().equals(j9ObjectPointer)) {
                        l3 = 1L;
                        String string4 = string2 + "-" + j9ClassLoaderPointer;
                        longArray = this.utf8classloader.get(string4);
                        if (longArray == null) {
                            l2 = new Long(l);
                        } else {
                            l2 = new Long(l) + longArray[0];
                            l3 += longArray[1].longValue();
                        }
                        this.utf8classloader.put(string4, new Long[]{l2, l3});
                    } else {
                        l3 = 1L;
                        longArray = this.utf8bootstraploader.get(string2);
                        if (longArray == null) {
                            l2 = new Long(l);
                        } else {
                            l2 = new Long(l) + longArray[0];
                            l3 += longArray[1].longValue();
                        }
                        this.utf8bootstraploader.put(string2, new Long[]{l2, l3});
                    }
                }
            }
            for (LinearDumper.J9ClassRegionNode j9ClassRegionNode2 : j9ClassRegionNode.getChildren()) {
                string2 = j9ClassRegionNode2.getNodeValue().getName();
                if (j9ClassRegion != null && (string3 == null || !string3.equals("UTF8")) && (string2 == null || !string2.equals("UTF8"))) continue;
                this.addRecursive(j9ClassRegionNode2, rOMClassesIterator, j9ObjectPointer, string3);
            }
        }

        public void getResult(boolean bl, int n, PrintStream printStream) {
            Object object;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            TreeMap<Long, TreeSet<String>> treeMap;
            TreeMap<Long, Long[]> treeMap2;
            if (!this.utf8global.isEmpty()) {
                printStream.println();
                treeMap2 = new TreeMap<Long, Long[]>();
                treeMap = new TreeMap<Long, TreeSet<String>>();
                l5 = 0L;
                l4 = 0L;
                l3 = 0L;
                l2 = 0L;
                for (Map.Entry<String, Long[]> object2 : this.utf8global.entrySet()) {
                    if (object2.getValue()[1] == 1L) {
                        ++l2;
                        l3 += object2.getValue()[0].longValue();
                        continue;
                    }
                    ++l4;
                    l5 += object2.getValue()[0].longValue();
                    l = object2.getValue()[1];
                    Long[] longArray = (Long[])treeMap2.get(l);
                    long longArray2 = 0L;
                    long l6 = 1L;
                    if (longArray == null) {
                        longArray2 = new Long(object2.getValue()[0]);
                    } else {
                        longArray2 = new Long(object2.getValue()[0]) + (Long)longArray[1];
                        l6 += ((Long)longArray[0]).longValue();
                    }
                    treeMap2.put(l, new Long[]{l6, longArray2});
                    Iterator iterator = (TreeSet<String>)treeMap.get(l);
                    if (iterator != null) {
                        ((TreeSet)((Object)iterator)).add(object2.getKey());
                    } else {
                        iterator = new TreeSet<String>();
                        ((TreeSet)((Object)iterator)).add(object2.getKey());
                    }
                    treeMap.put(l, (TreeSet<String>)((Object)iterator));
                }
                printStream.println("<Global Unique UTF-8 (count, total size)>");
                printStream.println(l2 + ", " + l3 / 1024L + "K");
                printStream.println("\n<Global Duplicated UTF-8 (count, total size)>");
                printStream.println(l4 + ", " + l5 / 1024L + "K");
                printStream.println();
                printStream.println("<Distribution of Global Duplicated UTF-8>");
                printStream.println("(duplicated times, # UTF-8s, total size)");
                long l8 = 0L;
                l = 0L;
                for (Map.Entry entry : treeMap2.entrySet()) {
                    printStream.println(entry.getKey() + ", " + ((Long[])entry.getValue())[0] + ", " + (((Long[])entry.getValue())[1] == 0L ? "0K" : (((Long[])entry.getValue())[1] / 1024L < 1L ? "<1K" : ((Long[])entry.getValue())[1] / 1024L + "K")));
                    l8 += ((Long[])entry.getValue())[1].longValue();
                    l += ((Long[])entry.getValue())[0].longValue();
                    if (!((double)l8 / (double)l5 * 100.0 > (double)n)) continue;
                    printStream.println((Long)entry.getKey() + 1L + "+, " + (l4 - l) + ", " + (l5 - l8) / 1024L + "K");
                    break;
                }
                if (bl) {
                    printStream.println("<Global Duplicated UTF-8s>");
                    printStream.println("      times");
                    printStream.println("id    duplicated  weight string");
                    for (Map.Entry entry : treeMap.entrySet()) {
                        object = (Long)entry.getKey();
                        int n2 = 0;
                        for (Iterator iterator : (TreeSet)entry.getValue()) {
                            long l7 = ((Long)object - 1L) * (long)((String)((Object)iterator)).length();
                            printStream.println(String.format("%-5d %-11d %-5d \"%s\"", n2++, object, l7, iterator));
                        }
                    }
                }
            }
            if (!this.utf8classloader.isEmpty()) {
                long l8;
                printStream.println();
                treeMap2 = new TreeMap();
                treeMap = new TreeMap();
                l5 = 0L;
                l4 = 0L;
                l3 = 0L;
                l2 = 0L;
                Iterator<Map.Entry<String, Long[]>> iterator = this.utf8classloader.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Long[]> entry = iterator.next();
                    l = entry.getValue()[1];
                    long l9 = entry.getValue()[0];
                    object = entry.getKey().split("-")[0];
                    Long[] longArray = this.utf8bootstraploader.get(object);
                    if (longArray == null) continue;
                    Object object2 = longArray;
                    Long.valueOf(object2[0] + l9);
                    object2 = longArray;
                    Long.valueOf(object2[1] + l);
                    iterator.remove();
                }
                for (Map.Entry<String, Long[]> entry : this.utf8bootstraploader.entrySet()) {
                    if (entry.getValue()[1] == 1L) {
                        ++l2;
                        l3 += entry.getValue()[0].longValue();
                        continue;
                    }
                    ++l4;
                    l5 += entry.getValue()[0].longValue();
                    l8 = entry.getValue()[1];
                    Long[] longArray = (Long[])treeMap2.get(l8);
                    long l10 = 0L;
                    long l11 = 1L;
                    if (longArray == null) {
                        l10 = new Long(entry.getValue()[0]);
                    } else {
                        l10 = new Long(entry.getValue()[0]) + longArray[1];
                        l11 += longArray[0].longValue();
                    }
                    treeMap2.put(l8, new Long[]{l11, l10});
                    TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(l8);
                    if (treeSet != null) {
                        treeSet.add(entry.getKey());
                    } else {
                        treeSet = new TreeSet<String>();
                        treeSet.add(entry.getKey());
                    }
                    treeMap.put(l8, treeSet);
                }
                for (Map.Entry<String, Long[]> entry : this.utf8classloader.entrySet()) {
                    if (entry.getValue()[1] == 1L) {
                        ++l2;
                        l3 += entry.getValue()[0].longValue();
                        continue;
                    }
                    ++l4;
                    l5 += entry.getValue()[0].longValue();
                    l8 = entry.getValue()[1];
                    Long[] longArray = (Long[])treeMap2.get(l8);
                    long l12 = 0L;
                    long l13 = 1L;
                    if (longArray == null) {
                        l12 = new Long(entry.getValue()[0]);
                    } else {
                        l12 = new Long(entry.getValue()[0]) + longArray[1];
                        l13 += longArray[0].longValue();
                    }
                    treeMap2.put(l8, new Long[]{l13, l12});
                    TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(l8);
                    if (treeSet != null) {
                        treeSet.add(entry.getKey());
                    } else {
                        treeSet = new TreeSet<String>();
                        treeSet.add(entry.getKey());
                    }
                    treeMap.put(l8, treeSet);
                }
                printStream.println("<Classloader Unique UTF-8 (count, total size)>");
                printStream.println(l2 + ", " + l3 / 1024L + "K");
                printStream.println("\n<Classloader Duplicated UTF-8 (count, total size)>");
                printStream.println(l4 + ", " + l5 / 1024L + "K");
                printStream.println();
                printStream.println("<Distribution of Classloader Duplicated UTF-8>");
                printStream.println("(duplicated times, # UTF-8s, total size)");
                long l14 = 0L;
                l8 = 0L;
                for (Map.Entry entry : treeMap2.entrySet()) {
                    printStream.println(entry.getKey() + ", " + ((Long[])entry.getValue())[0] + ", " + (((Long[])entry.getValue())[1] == 0L ? "0K" : (((Long[])entry.getValue())[1] / 1024L < 1L ? "<1K" : ((Long[])entry.getValue())[1] / 1024L + "K")));
                    l14 += ((Long[])entry.getValue())[1].longValue();
                    l8 += ((Long[])entry.getValue())[0].longValue();
                    if (!((double)l14 / (double)l5 * 100.0 > (double)n)) continue;
                    printStream.println((Long)entry.getKey() + 1L + "+, " + (l4 - l8) + ", " + (l5 - l14) / 1024L + "K");
                    break;
                }
                if (bl) {
                    printStream.println("<Duplicated UTF-8s by Classloader>");
                    printStream.println("      times");
                    printStream.println("id    duplicated  weight string");
                    for (Map.Entry entry : treeMap.entrySet()) {
                        Long l15 = (Long)entry.getKey();
                        int n3 = 0;
                        for (String string : (TreeSet)entry.getValue()) {
                            long l16 = (l15 - 1L) * (long)string.length();
                            printStream.println(String.format("%-5d %-11d %-5d \"%s\"", n3++, l15, l16, string));
                        }
                    }
                }
            }
        }
    }
}

