/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.debugger.JniNatives;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;

public abstract class JniMemory
implements IMemory {
    private long searchSize = Integer.MAX_VALUE;

    @Override
    public native byte getByteAt(long var1) throws MemoryFault;

    @Override
    public native ByteOrder getByteOrder();

    @Override
    public native int getBytesAt(long var1, byte[] var3) throws MemoryFault;

    @Override
    public native int getBytesAt(long var1, byte[] var3, int var4, int var5) throws MemoryFault;

    @Override
    public native int getIntAt(long var1) throws MemoryFault;

    @Override
    public native long getLongAt(long var1) throws MemoryFault;

    @Override
    public native short getShortAt(long var1) throws MemoryFault;

    @Override
    public Properties getProperties(long l) {
        return new Properties();
    }

    @Override
    public Platform getPlatform() {
        return JniNatives.getPlatform();
    }

    @Override
    public native boolean isExecutable(long var1);

    @Override
    public native boolean isReadOnly(long var1);

    @Override
    public native boolean isShared(long var1);

    public long getPointerAt(long l, int n) throws MemoryFault {
        if (n == 8) {
            return this.getLongAt(l);
        }
        return this.getIntAt(l);
    }

    public native long readAddress(long var1);

    @Override
    public Collection<? extends IMemoryRange> getMemoryRanges() {
        LinkedList<MemoryRange> linkedList = new LinkedList<MemoryRange>();
        MemoryRange memoryRange = JniMemory.getValidRegionVirtual(0L, this.searchSize);
        while (memoryRange != null) {
            linkedList.add(memoryRange);
            memoryRange = JniMemory.getValidRegionVirtual(memoryRange.getBaseAddress() + memoryRange.getSize(), this.searchSize);
        }
        return linkedList;
    }

    private static native MemoryRange getValidRegionVirtual(long var0, long var2);
}

