/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.Advertisement;
import com.ibm.tools.attach.target.Attachment;
import com.ibm.tools.attach.target.CommonDirectory;
import com.ibm.tools.attach.target.FileLock;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.Reply;
import com.ibm.tools.attach.target.TargetDirectory;
import com.ibm.tools.attach.target.WaitLoop;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;

public class AttachHandler
extends Thread {
    private static final String VMID_PROPERTY = "com.ibm.tools.attach.id";
    private static final String DISPLAYNAME_PROPERTY = "com.ibm.tools.attach.displayName";
    static final String LOGGING_ENABLE_PROPERTY = "com.ibm.tools.attach.logging";
    static final String LOG_NAME_PROPERTY = "com.ibm.tools.attach.log.name";
    static final String VMID_VALID_PATTERN = "\\p{Alpha}\\w*";
    static final long shutdownTimeoutMs = Integer.getInteger("com.ibm.tools.attach.shutdown_timeout", 10000).longValue();
    static AttachHandler mainHandler = new AttachHandler();
    static volatile Thread currentAttachThread = mainHandler;
    private Vector<Attachment> attachments = new Vector();
    static String vmId = "";
    private String displayName;
    private static AttachStateValues attachState = AttachStateValues.ATTACH_UNINITIALIZED;
    private static boolean waitingForSemaphore = false;
    static AttachStateSync stateSync = new AttachStateSync();
    static int notificationCount;
    private static boolean doCancelNotify;
    private final syncObject ignoreNotification = new syncObject();
    private static final syncObject accessorMutex;
    private static String nameProperty;
    private static String pidProperty;
    private static int numberOfTargets;
    public static final String allowAttachSelf;
    FileLock syncFileLock;

    private AttachHandler() {
        this.setDaemon(true);
        this.setName("Attach API initializer");
    }

    static void initializeAttachAPI() {
        String string;
        if (IPC.isUsingDefaultUid()) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        boolean bl = true;
        String string2 = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
        if (null != string2) {
            if (string2.equalsIgnoreCase("z/OS")) {
                bl = false;
            } else if (string2.startsWith("Windows")) {
                IPC.isWindows = true;
            }
        }
        if (null != (string = VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.tools.attach.enable"))) {
            if (string.equalsIgnoreCase("no")) {
                bl = false;
            } else if (string.equalsIgnoreCase("yes")) {
                bl = true;
            }
        }
        if (bl) {
            Runtime.getRuntime().addShutdownHook(new teardownHook());
            mainHandler.start();
        } else {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
        }
    }

    private static String validateVmId(String string) {
        if (null != string && !string.matches(VMID_VALID_PATTERN)) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFiles(String string) throws IOException {
        try {
            if (CommonDirectory.tryObtainMasterLock()) {
                CommonDirectory.deleteStaleDirectories(pidProperty);
            } else {
                CommonDirectory.obtainMasterLock();
            }
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler obtained master lock");
            }
            CommonDirectory.createNotificationFile();
            if (AttachHandler.isAttachApiTerminated()) {
                boolean bl = false;
                return bl;
            }
            String string2 = TargetDirectory.createMyDirectory(pidProperty, false);
            if (null == string2) {
                boolean bl = false;
                return bl;
            }
            AttachHandler.setVmId(string2);
            this.setDisplayName(string);
            CommonDirectory.openSemaphore();
            CommonDirectory.obtainAttachLock();
            Advertisement.createAdvertisementFile(AttachHandler.getVmId(), string);
        }
        finally {
            CommonDirectory.releaseAttachLock();
            CommonDirectory.releaseMasterLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        Object object = stateSync;
        synchronized (object) {
            if (AttachStateValues.ATTACH_UNINITIALIZED != AttachHandler.getAttachState()) {
                return;
            }
            AttachHandler.setAttachState(AttachStateValues.ATTACH_STARTING);
        }
        try {
            if (!this.initialize()) {
                IPC.logMessage("ERROR: failed to initialize");
                return;
            }
            object = new WaitLoop();
            AttachStateSync attachStateSync = stateSync;
            synchronized (attachStateSync) {
                if (AttachHandler.isAttachApiTerminated()) {
                    return;
                }
                AttachHandler.setAttachState(AttachStateValues.ATTACH_INITIALIZED);
                currentAttachThread = object;
            }
            ((Thread)object).start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        catch (IOException iOException) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() throws IOException {
        String string = VM.getVMLangAccess().internalGetProperties().getProperty(LOGGING_ENABLE_PROPERTY);
        String string2 = VM.getVMLangAccess().internalGetProperties().getProperty(LOG_NAME_PROPERTY);
        string2 = null != string2 && !string2.equals("") ? string2 + '_' : "";
        nameProperty = VM.getVMLangAccess().internalGetProperties().getProperty(DISPLAYNAME_PROPERTY);
        pidProperty = AttachHandler.validateVmId(VM.getVMLangAccess().internalGetProperties().getProperty(VMID_PROPERTY));
        if (null == pidProperty || 0 == pidProperty.length()) {
            long l = IPC.getProcessId();
            pidProperty = Long.toString(l);
        }
        if (null == nameProperty) {
            nameProperty = VM.getVMLangAccess().internalGetProperties().getProperty("sun.java.command");
        }
        Object object = IPC.accessorMutex;
        synchronized (object) {
            if (null == IPC.logStream && null != string && string.equalsIgnoreCase("yes")) {
                File file = new File(string2 + pidProperty + ".log");
                IPC.logStream = new PrintStream(file);
                IPC.setDefaultVmId(pidProperty);
                IPC.printMessageWithHeader("AttachHandler initialized", IPC.logStream);
                IPC.loggingStatus = 2;
            } else {
                IPC.loggingStatus = 1;
            }
        }
        object = stateSync;
        synchronized (object) {
            if (AttachHandler.isAttachApiTerminated()) {
                IPC.logMessage("cancel initialize before prepareCommonDirectory");
                return false;
            }
            CommonDirectory.prepareCommonDirectory();
        }
        try {
            if (!this.createFiles(nameProperty)) {
                return false;
            }
        }
        catch (IOException iOException) {
            IPC.logMessage("AttachHandler IOException while creating files: ", iOException.getMessage());
            this.terminate(false);
            return false;
        }
        object = TargetDirectory.getSyncFileObject();
        if (AttachHandler.isAttachApiTerminated() || null == object) {
            IPC.logMessage("cancel initialize before creating syncFileLock");
            return false;
        }
        this.syncFileLock = new FileLock(((File)object).getAbsolutePath(), 438);
        return true;
    }

    public Attachment connectToAttacher() throws IOException {
        String string = TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId());
        IPC.checkOwnerAccessOnly(string);
        Reply reply = Reply.readReply(string);
        Attachment attachment = null;
        if (null != reply) {
            int n = reply.getPortNumber();
            IPC.logMessage(notificationCount + " connectToAttacher reply on port ", n);
            if (n >= 0) {
                attachment = new Attachment(mainHandler, reply);
                this.addAttachment(attachment);
                attachment.start();
            }
        } else if (1 != IPC.loggingStatus) {
            IPC.logMessage("connectToAttacher ", notificationCount, " waitForNotification no reply file");
        }
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminate(boolean bl) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("AttachHandler terminate: Attach API is being shut down");
        }
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues object = AttachHandler.getAttachState();
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            switch (object) {
                case ATTACH_UNINITIALIZED: {
                    return false;
                }
                case ATTACH_STARTING: {
                    break;
                }
                case ATTACH_INITIALIZED: {
                    break;
                }
                case ATTACH_TERMINATED: {
                    return false;
                }
                default: {
                    IPC.logMessage("Unrecognized synchronization state " + stateSync.toString());
                }
            }
        }
        currentAttachThread.interrupt();
        if (bl) {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing contents of directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyFiles();
        } else {
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("AttachHandler terminate removing directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyDirectory(false);
        }
        for (Attachment attachment : this.attachments) {
            if (null == attachment) continue;
            attachment.teardown();
        }
        FileLock.shutDown();
        return AttachHandler.terminateWaitLoop(bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean terminateWaitLoop(boolean bl, int n) {
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.nanoTime() + shutdownTimeoutMs * 1000000L / 10L;
        try {
            bl2 = CommonDirectory.tryObtainMasterLock();
            while (!bl2 && AttachHandler.isWaitingForSemaphore()) {
                Thread.sleep(10L);
                bl2 = CommonDirectory.tryObtainMasterLock();
                if (System.nanoTime() <= l) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            IPC.logMessage("InterruptedException while waiting to shut down", interruptedException);
        }
        if (!AttachHandler.isWaitingForSemaphore()) {
            bl = false;
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("VM already notified for termination, abandoning master lock");
            }
            if (bl2) {
                CommonDirectory.releaseMasterLock();
                bl2 = false;
            }
        }
        if (bl2) {
            try {
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate obtained master lock");
                }
                int n2 = CommonDirectory.countTargetDirectories() + n;
                AttachHandler.setNumberOfTargets(n2);
                if (n2 <= 1) {
                    AttachHandler.setDoCancelNotify(false);
                    if (bl) {
                        CommonDirectory.notifyVm(1);
                    }
                    bl3 = true;
                    return bl3;
                }
                if (!bl) return bl3;
                AttachHandler.setDoCancelNotify(true);
                CommonDirectory.notifyVm(n2);
                return bl3;
            }
            finally {
                CommonDirectory.releaseMasterLock();
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("AttachHandler terminate released master lock");
                }
            }
        } else {
            IPC.logMessage("AttachHandler tryObtainMasterLock failed");
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForAttachApiInitialization() {
        boolean bl;
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues attachStateValues = AttachHandler.getAttachState();
            if (AttachStateValues.ATTACH_INITIALIZED == attachStateValues) {
                bl = true;
            } else if (AttachStateValues.ATTACH_TERMINATED == attachStateValues) {
                bl = false;
            } else {
                int n = 2;
                bl = false;
                block10: while (n > 0) {
                    --n;
                    try {
                        stateSync.wait(100000L);
                        attachStateValues = AttachHandler.getAttachState();
                        switch (attachStateValues) {
                            case ATTACH_STARTING: {
                                continue block10;
                            }
                            case ATTACH_INITIALIZED: {
                                bl = true;
                                n = 0;
                                continue block10;
                            }
                            case ATTACH_TERMINATED: {
                                n = 0;
                                continue block10;
                            }
                        }
                        n = 0;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setNumberOfTargets(int n) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            numberOfTargets = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNumberOfTargets() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttachment(Attachment attachment) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.attachments.add(attachment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttachment(Attachment attachment) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            int n = this.attachments.indexOf(attachment);
            if (n > 0) {
                this.attachments.remove(n);
            }
        }
    }

    static Properties getAgentProperties() {
        String[] stringArray = new String[]{"com.sun.management.jmxremote.localConnectorAddress", "sun.jvm.args", "sun.jvm.flags", "sun.java.command"};
        Attachment.saveLocalConnectorAddress();
        Properties properties = new Properties();
        for (String string : stringArray) {
            String string2 = VM.getVMLangAccess().internalGetProperties().getProperty(string);
            if (null == string2) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    public static boolean isAttachApiInitialized() {
        return AttachStateValues.ATTACH_INITIALIZED == AttachHandler.getAttachState();
    }

    public static boolean isAttachApiTerminated() {
        return AttachStateValues.ATTACH_TERMINATED == AttachHandler.getAttachState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttachStateValues getAttachState() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return attachState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = attachState != AttachStateValues.ATTACH_TERMINATED;
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAttachState(AttachStateValues attachStateValues) {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            attachState = attachStateValues;
            stateSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplayName(String string) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.displayName = string;
        }
    }

    public Object getIgnoreNotification() {
        return this.ignoreNotification;
    }

    public static AttachHandler getMainHandler() {
        return mainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVmId() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return vmId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVmId(String string) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            vmId = string;
        }
    }

    public static long getProcessId() {
        return IPC.getProcessId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getDoCancelNotify() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return doCancelNotify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDoCancelNotify(boolean bl) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            doCancelNotify = bl;
        }
    }

    static {
        accessorMutex = new syncObject();
        allowAttachSelf = VM.getVMLangAccess().internalGetProperties().getProperty("jdk.attach.allowAttachSelf", "true");
    }

    static final class teardownHook
    extends Thread {
        teardownHook() {
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName("Attach API teardown");
                VM.markCurrentThreadAsSystem();
                if (1 != IPC.loggingStatus) {
                    IPC.logMessage("shutting down attach API");
                }
                if (null == mainHandler) {
                    return;
                }
                long l = System.nanoTime() + shutdownTimeoutMs * 1000000L;
                boolean bl = mainHandler.terminate(true);
                try {
                    mainHandler.join(shutdownTimeoutMs / 2L);
                    int n = 100;
                    int n2 = 0;
                    while (System.nanoTime() < l) {
                        currentAttachThread.join(n);
                        if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                            IPC.logMessage("Timeout waiting for wait loop termination.  Retry #" + n2);
                            n *= 2;
                            AttachHandler.terminateWaitLoop(true, n2);
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    IPC.logMessage("teardown join with attach handler interrupted");
                }
                if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                    IPC.logMessage("Attach API not terminated");
                }
                TargetDirectory.deleteMyDirectory(true);
                if (bl) {
                    if (CommonDirectory.tryObtainMasterLock()) {
                        CommonDirectory.destroySemaphore();
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("AttachHandler destroyed semaphore");
                        }
                        CommonDirectory.releaseMasterLock();
                    } else {
                        if (1 != IPC.loggingStatus) {
                            IPC.logMessage("could not obtain lock, semaphore not destroyed");
                        }
                        CommonDirectory.closeSemaphore();
                    }
                } else {
                    CommonDirectory.closeSemaphore();
                    if (1 != IPC.loggingStatus) {
                        IPC.logMessage("AttachHandler closed semaphore");
                    }
                }
                if (null != IPC.logStream) {
                    IPC.logStream.close();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IPC.tracepoint(-3, outOfMemoryError.getMessage());
                return;
            }
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }

    static final class AttachStateSync {
        AttachStateSync() {
        }
    }

    private static enum AttachStateValues {
        ATTACH_UNINITIALIZED,
        ATTACH_TERMINATED,
        ATTACH_STARTING,
        ATTACH_INITIALIZED;

    }
}

