/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.info;

import com.ibm.java.lang.management.internal.ThreadInfoUtil;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.util.Properties;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import openj9.tools.attach.diagnostics.base.DiagnosticProperties;
import openj9.tools.attach.diagnostics.info.JvmInfo;

public class JvmThreadInfo
extends JvmInfo {
    private final ThreadInfo myInfo;

    public JvmThreadInfo(Properties properties, int n) throws IOException {
        this(new DiagnosticProperties(properties), n);
    }

    public ThreadInfo getThreadInfo() {
        return this.myInfo;
    }

    static void put(ThreadInfo threadInfo, DiagnosticProperties diagnosticProperties, int n) {
        CompositeData compositeData = ThreadInfoUtil.toCompositeData(threadInfo);
        String string = JvmThreadInfo.thrdNumPrefix(n);
        CompositeType compositeType = ThreadInfoUtil.getCompositeType();
        JvmThreadInfo.addFields(diagnosticProperties, string, compositeType, compositeData);
    }

    static String thrdNumPrefix(int n) {
        return "threadgroup.thread_num." + n + '.';
    }

    JvmThreadInfo(DiagnosticProperties diagnosticProperties, int n) throws IOException {
        ThreadInfo threadInfo;
        block2: {
            String string = JvmThreadInfo.thrdNumPrefix(n);
            CompositeType compositeType = ThreadInfoUtil.getCompositeType();
            CompositeData compositeData = JvmThreadInfo.extractFields(diagnosticProperties, string, compositeType);
            threadInfo = null;
            try {
                threadInfo = null != compositeData ? ThreadInfo.from(compositeData) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                threadInfo = null;
                if (!DiagnosticProperties.isDebug) break block2;
                illegalArgumentException.printStackTrace();
            }
        }
        this.myInfo = threadInfo;
    }
}

