/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.AttachmentConnection;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.IbmAttachOperationFailedException;
import com.ibm.tools.attach.target.Reply;
import com.ibm.tools.attach.target.Response;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import sun.misc.VMSupport;

final class Attachment
extends Thread
implements Response {
    private Exception lastError;
    private OutputStream responseStream;
    private Socket attacherSocket;
    private final int portNumber;
    private InputStream commandStream;
    private String attachError;
    private final AttachHandler handler;
    private final String key;
    private static final String START_REMOTE_MANAGEMENT_AGENT = "startRemoteManagementAgent";
    private static final String START_LOCAL_MANAGEMENT_AGENT = "startLocalManagementAgent";

    Attachment(AttachHandler attachHandler, Reply reply) {
        this.setName("Attachment " + reply.getPortNumber());
        this.portNumber = reply.getPortNumber();
        this.key = reply.getKey();
        this.handler = attachHandler;
        this.setDaemon(true);
    }

    boolean connectToAttacher(int n) {
        try {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            this.attacherSocket = new Socket(inetAddress, n);
            IPC.logMessage("connectToAttacher localPort=", this.attacherSocket.getLocalPort(), " remotePort=", Integer.toString(this.attacherSocket.getPort()));
            this.responseStream = this.attacherSocket.getOutputStream();
            this.commandStream = this.attacherSocket.getInputStream();
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_CONNECTED " + this.key + ' ');
            return true;
        }
        catch (IOException iOException) {
            IPC.logMessage("connectToAttacher exception " + iOException.getMessage() + " " + iOException.toString());
            Attachment.closeQuietly(this.responseStream);
            Attachment.closeQuietly(this.commandStream);
            Attachment.closeQuietly(this.attacherSocket);
        }
        catch (Exception exception) {
            IPC.logMessage("connectToAttacher exception ", exception.toString());
        }
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        boolean bl = false;
        IPC.logMessage("Attachment run");
        this.connectToAttacher(this.getPortNumber());
        while (!bl && !this.isInterrupted()) {
            bl = this.doCommand(this.commandStream, this.responseStream);
        }
        try {
            AttachmentConnection.streamSend(this.responseStream, "ATTACH_DETACHED");
            if (null != this.responseStream) {
                this.responseStream.close();
                this.responseStream = null;
            }
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
        if (null != this.handler) {
            this.handler.removeAttachment(this);
        }
    }

    boolean doCommand(InputStream inputStream, OutputStream outputStream) {
        block20: {
            try {
                byte[] byArray = AttachmentConnection.streamReceiveBytes(inputStream, true);
                String string = AttachmentConnection.bytesToString(byArray);
                IPC.logMessage("doCommand ", string);
                if (null == string) {
                    return true;
                }
                if (string.startsWith("ATTACH_DETACH")) {
                    return true;
                }
                if (string.startsWith("ATTACH_LOADAGENT")) {
                    if (this.parseLoadAgent(string)) {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ERR " + this.attachError);
                    }
                    break block20;
                }
                if (string.startsWith("ATTACH_GETSYSTEMPROPERTIES")) {
                    this.replyWithProperties(VM.getVMLangAccess().internalGetProperties());
                    break block20;
                }
                if (string.startsWith("ATTACH_GETAGENTPROPERTIES")) {
                    this.replyWithProperties(AttachHandler.getAgentProperties());
                    break block20;
                }
                if (string.startsWith("ATTACH_START_LOCAL_MANAGEMENT_AGENT")) {
                    try {
                        String string2 = Attachment.startLocalAgent();
                        AttachmentConnection.streamSend(outputStream, "ATTACH_RESULT=" + string2);
                        break block20;
                    }
                    catch (IbmAttachOperationFailedException ibmAttachOperationFailedException) {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ERR AttachOperationFailedException in startLocalManagementAgent:  " + ibmAttachOperationFailedException.getMessage());
                        return false;
                    }
                }
                if (string.startsWith("ATTACH_START_MANAGEMENT_AGENT")) {
                    int n;
                    for (n = 0; n < byArray.length && 0 != byArray[n]; ++n) {
                    }
                    Properties properties = null;
                    properties = ++n < byArray.length ? IPC.receiveProperties(new ByteArrayInputStream(byArray, n, byArray.length - n), false) : IPC.receiveProperties(inputStream, true);
                    IPC.logMessage("startAgent:" + string);
                    if (this.startAgent(properties)) {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ACK");
                    } else {
                        AttachmentConnection.streamSend(outputStream, "ATTACH_ERR " + this.attachError);
                    }
                } else {
                    AttachmentConnection.streamSend(outputStream, "ATTACH_ERR command invalid: " + string);
                }
            }
            catch (IOException iOException) {
                IPC.logMessage("doCommand IOException ", iOException.toString());
                return true;
            }
            catch (Throwable throwable) {
                IPC.logMessage("doCommand exception ", throwable.toString());
                try {
                    AttachmentConnection.streamSend(outputStream, "ATTACH_ERR unexpected exception or error: " + throwable.toString());
                }
                catch (IOException iOException) {
                    IPC.logMessage("IOException sending error response" + iOException.toString());
                }
                return true;
            }
        }
        return false;
    }

    private void replyWithProperties(Properties properties) throws IOException {
        IPC.sendProperties(properties, this.responseStream);
    }

    synchronized void teardown() {
        try {
            if (null != this.responseStream) {
                this.responseStream.close();
            }
            if (null != this.attacherSocket) {
                this.attacherSocket.close();
            }
            if (null != this.commandStream) {
                this.commandStream.close();
            }
        }
        catch (IOException iOException) {
            this.lastError = iOException;
        }
    }

    private boolean parseLoadAgent(String string) {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(41);
        int n3 = string.indexOf(44);
        String string2 = "";
        boolean bl = true;
        this.attachError = null;
        if (string.startsWith("ATTACH_LOADAGENTPATH")) {
            bl = false;
        }
        if (n < 0 || n2 < 0) {
            this.attachError = "syntax error";
            return false;
        }
        int n4 = n3 < 0 ? n2 : n3;
        String string3 = string.substring(n + 1, n4);
        if (string3.length() < 1) {
            this.attachError = "invalid agent name";
            return false;
        }
        if (n3 > 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        this.attachError = this.loadAgentLibrary(string3, string2, bl);
        return this.attachError == null;
    }

    String loadAgentLibrary(String string, String string2, boolean bl) {
        IPC.logMessage("loadAgentLibrary " + string + ':' + string2 + " decorate=" + bl);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        int n = this.loadAgentLibraryImpl(classLoader, string, string2, bl);
        if (0 != n) {
            if (-1 == n) {
                return "AgentLoadException " + string + ':' + string2;
            }
            return "AgentInitializationException" + n;
        }
        return null;
    }

    private native int loadAgentLibraryImpl(ClassLoader var1, String var2, String var3, boolean var4);

    private int getPortNumber() {
        return this.portNumber;
    }

    private boolean startAgent(Properties properties) {
        try {
            IPC.logMessage("startAgent");
            if (null != MethodRefsHolder.startRemoteManagementAgentMethod) {
                String string = properties.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(","));
                MethodRefsHolder.startRemoteManagementAgentMethod.invoke(null, string);
                return true;
            }
            this.attachError = "NoSuchMethodException: startRemoteManagementAgent";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.attachError = "IllegalArgumentException: " + illegalArgumentException.getMessage();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.attachError = "IllegalAccessException: " + illegalAccessException.getMessage();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.attachError = "InvocationTargetException: " + invocationTargetException.getMessage();
        }
        return false;
    }

    private static String startLocalAgent() throws IbmAttachOperationFailedException {
        IPC.logMessage("startLocalAgent");
        try {
            if (null == MethodRefsHolder.startLocalManagementAgentMethod) {
                throw new IbmAttachOperationFailedException("startLocalManagementAgent cannot access startLocalManagementAgent");
            }
            MethodRefsHolder.startLocalManagementAgentMethod.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IbmAttachOperationFailedException("startLocalManagementAgent error starting agent:" + throwable.getClass() + " " + throwable.getMessage());
        }
        String string = Attachment.saveLocalConnectorAddress();
        if (Objects.isNull(string)) {
            throw new IbmAttachOperationFailedException("startLocalManagementAgent: com.sun.management.jmxremote.localConnectorAddress not defined");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String saveLocalConnectorAddress() {
        String string;
        Properties properties;
        Properties properties2 = properties = VM.getVMLangAccess().internalGetProperties();
        synchronized (properties2) {
            string = properties.getProperty("com.sun.management.jmxremote.localConnectorAddress");
            if (Objects.isNull(string) && !Objects.isNull(string = VMSupport.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress"))) {
                properties.setProperty("com.sun.management.jmxremote.localConnectorAddress", string);
            }
        }
        if (Objects.isNull(string)) {
            IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress not set");
            return null;
        }
        IPC.logMessage("com.sun.management.jmxremote.localConnectorAddress=", string);
        return string;
    }

    private static final class MethodRefsHolder {
        static Method startLocalManagementAgentMethod = null;
        static Method startRemoteManagementAgentMethod = null;

        private MethodRefsHolder() {
        }

        static {
            AccessController.doPrivileged(() -> {
                try {
                    Class<?> clazz = Class.forName("sun.management.Agent");
                    Class<String> clazz2 = String.class;
                    startLocalManagementAgentMethod = clazz.getDeclaredMethod(Attachment.START_LOCAL_MANAGEMENT_AGENT, new Class[0]);
                    startRemoteManagementAgentMethod = clazz.getDeclaredMethod(Attachment.START_REMOTE_MANAGEMENT_AGENT, clazz2);
                    startLocalManagementAgentMethod.setAccessible(true);
                    startRemoteManagementAgentMethod.setAccessible(true);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    startLocalManagementAgentMethod = null;
                    startRemoteManagementAgentMethod = null;
                }
                return null;
            });
        }
    }
}

