/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public final class Util {
    private static final String defaultEncoding;

    public static byte[] getBytes(String string) {
        if (defaultEncoding != null) {
            try {
                return string.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string.getBytes();
    }

    public static String toString(byte[] byArray) {
        if (defaultEncoding != null) {
            try {
                return new String(byArray, 0, byArray.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray, 0, byArray.length);
    }

    public static String convertFromUTF8(byte[] byArray, int n, int n2) throws UTFDataFormatException {
        return Util.convertUTF8WithBuf(byArray, new char[n2], n, n2);
    }

    public static String convertUTF8WithBuf(byte[] byArray, char[] cArray, int n, int n2) throws UTFDataFormatException {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by;
            if ((cArray[n4] = (char)byArray[n + n3++]) < '\u0080') {
                ++n4;
                continue;
            }
            char c = cArray[n4];
            if ((c & 0xE0) == 192) {
                if (n3 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3));
                }
                if (((by = byArray[n3++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3 - 1));
                }
                cArray[n4++] = (char)((c & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if ((c & 0xF0) == 224) {
                if (n3 + 1 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0063", n3 + 1));
                }
                by = byArray[n3++];
                byte by2 = byArray[n3++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", n3 - 2));
                }
                cArray[n4++] = (char)((c & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", n3 - 1));
        }
        return new String(cArray, 0, n4);
    }

    public static String urlEncode(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "_-!.~'()*,:$&+/@".indexOf(c) > -1) {
                if (n >= 0) {
                    bl = true;
                    Util.convert(string.substring(n, i), stringBuilder);
                    n = -1;
                }
                stringBuilder.append(c);
                continue;
            }
            if (n >= 0) continue;
            n = i;
        }
        if (n >= 0) {
            bl = true;
            Util.convert(string.substring(n, string.length()), stringBuilder);
        }
        return bl ? stringBuilder.toString() : string;
    }

    private static void convert(String string, StringBuilder stringBuilder) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append('%');
            stringBuilder.append("0123456789abcdef".charAt((byArray[i] & 0xF0) >> 4));
            stringBuilder.append("0123456789abcdef".charAt(byArray[i] & 0xF));
        }
    }

    public static boolean startsWithDriveLetter(String string) {
        if (string.charAt(1) != ':') {
            return false;
        }
        char c = string.charAt(0);
        return (c = Character.toLowerCase(c)) >= 'a' && c <= 'z';
    }

    public static String canonicalizePath(String string) {
        int n;
        while ((n = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n + 1) + string.substring(n + 3);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        while ((n = string.indexOf("/../")) >= 0) {
            if (n != 0) {
                string = string.substring(0, string.lastIndexOf(47, n - 1)) + string.substring(n + 3);
                continue;
            }
            string = string.substring(n + 3);
        }
        if (string.endsWith("/..") && string.length() > 3) {
            string = string.substring(0, string.lastIndexOf(47, string.length() - 4) + 1);
        }
        return string;
    }

    public static boolean doesClassLoaderDescendFrom(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader != classLoader2) {
            while (classLoader != null) {
                if (classLoader == classLoader2) {
                    return true;
                }
                classLoader = classLoader.getParent();
            }
            return false;
        }
        return true;
    }

    static {
        String string = VM.getVMLangAccess().internalGetProperties().getProperty("os.encoding");
        if (string != null) {
            try {
                "".getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = null;
            }
        }
        defaultEncoding = string;
    }
}

