/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectFieldInfo;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class ObjectSizeInfo
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String DATA_SIZE = "Data size";
    private static final String TOTAL_SIZE = "Total size";
    private static final String SPACE_USED = "Space used";
    private String className = null;
    TreeMap<String, ClassFieldInfo> fieldStats;
    private boolean includeArrays;

    public ObjectSizeInfo() {
        this.addCommand("objectsizeinfo", "[-a] [class name]", "Print information about object fields and size of the objects, including unused space");
        this.includeArrays = true;
    }

    private void printHelp(PrintStream printStream) {
        CommandUtils.dbgPrint(printStream, "!objectsizeinfo [-a] [classname]   -- Dump the information about objects of type <classname>.\nIf no name is given, all classes are displayed. \nTotal size includes the header, all instance and hidden fields, including unused space for sub-32-bit fields\nData size includes only the header plus instance and hidden fields\nSpace used is the total space used for objects including padding for minimum size and alignment\n'*' indicates that the size is less than the GC minimum object size.\n-a: suppress inclusion of array classes\n");
    }

    private boolean parseArgs(PrintStream printStream, String[] stringArray) throws DDRInteractiveCommandException {
        this.className = null;
        this.includeArrays = true;
        if (stringArray.length > 2) {
            printStream.append("Invalid number of argments" + nl);
            return false;
        }
        for (String string : stringArray) {
            if (string.equals("help")) {
                this.printHelp(printStream);
                return false;
            }
            if (string.equals("-a")) {
                this.includeArrays = false;
                continue;
            }
            if (!string.startsWith("-")) {
                this.className = string;
                continue;
            }
            printStream.append("Invalid argment: " + string);
        }
        return true;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.fieldStats = new TreeMap();
        Table table = new Table("Object field size summary");
        table.row(ClassFieldInfo.getTitleRow());
        HeapFieldInfo heapFieldInfo = new HeapFieldInfo();
        if (stringArray != null && !this.parseArgs(printStream, stringArray)) {
            return;
        }
        try {
            this.scanHeap();
            for (FieldInfo fieldInfo : this.fieldStats.values()) {
                table.row(fieldInfo.getResults());
                heapFieldInfo.addClass(fieldInfo);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        table.row(FieldInfo.getTitleRow());
        try {
            table.row(heapFieldInfo.getResults());
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        table.render(printStream);
    }

    private void scanHeap() {
        try {
            GCHeapRegionIterator gCHeapRegionIterator = GCHeapRegionIterator.from();
            while (gCHeapRegionIterator.hasNext()) {
                GCHeapRegionDescriptor gCHeapRegionDescriptor = gCHeapRegionIterator.next();
                this.scanObjects(gCHeapRegionDescriptor);
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    private void scanObjects(GCHeapRegionDescriptor gCHeapRegionDescriptor) throws CorruptDataException {
        GCObjectHeapIterator gCObjectHeapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(gCHeapRegionDescriptor, true, true);
        while (gCObjectHeapIterator.hasNext()) {
            J9ObjectPointer j9ObjectPointer = gCObjectHeapIterator.next();
            J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
            if (j9ClassPointer.isNull() || J9ClassHelper.isArrayClass(j9ClassPointer) && !this.includeArrays) continue;
            String string = J9ClassHelper.getJavaName(j9ClassPointer);
            if (null != this.className && !this.className.equals(string)) continue;
            ClassFieldInfo classFieldInfo = this.fieldStats.get(string);
            if (null == classFieldInfo) {
                classFieldInfo = new ClassFieldInfo(j9ClassPointer);
                this.fieldStats.put(string, classFieldInfo);
            }
            classFieldInfo.addInstance(j9ObjectPointer);
        }
    }

    static class HeapFieldInfo
    extends FieldInfo {
        public HeapFieldInfo() {
            this.objectClassString = "Heap summary";
        }

        public void addClass(FieldInfo fieldInfo) {
            this.instanceCount += fieldInfo.instanceCount;
            this.charCount += fieldInfo.charCount * fieldInfo.instanceCount;
            this.byteCount += fieldInfo.byteCount * fieldInfo.instanceCount;
            this.shortCount += fieldInfo.shortCount * fieldInfo.instanceCount;
            this.intCount += fieldInfo.intCount * fieldInfo.instanceCount;
            this.longCount += fieldInfo.longCount * fieldInfo.instanceCount;
            this.floatCount += fieldInfo.floatCount * fieldInfo.instanceCount;
            this.doubleCount += fieldInfo.doubleCount * fieldInfo.instanceCount;
            this.boolCount += fieldInfo.boolCount * fieldInfo.instanceCount;
            this.objectCount += fieldInfo.objectCount * fieldInfo.instanceCount;
            this.hiddenFields += fieldInfo.hiddenFields * fieldInfo.instanceCount;
            this.totalInstanceSize += fieldInfo.totalInstanceSize * (long)fieldInfo.instanceCount;
            this.bytesContainingData += fieldInfo.bytesContainingData * (long)fieldInfo.instanceCount;
            this.spaceUsed += fieldInfo.spaceUsed;
        }
    }

    static class ClassFieldInfo
    extends FieldInfo {
        private J9ClassPointer objectClass;

        public int getInstanceCount() {
            return this.instanceCount;
        }

        public String getObjectClassString() {
            return this.objectClassString;
        }

        public ClassFieldInfo(J9ClassPointer j9ClassPointer) throws CorruptDataException {
            this.objectClass = j9ClassPointer;
            this.instanceCount = 0;
            this.objectClassString = J9ClassHelper.getJavaName(j9ClassPointer);
            this.isArray = false;
            if (!J9ClassHelper.isArrayClass(j9ClassPointer)) {
                U32 u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
                J9ClassPointer j9ClassPointer2 = J9ClassHelper.superclass(j9ClassPointer);
                this.totalInstanceSize = j9ClassPointer.totalInstanceSize().longValue() + (long)ObjectFieldInfo.fj9object_t_SizeOf;
                Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(j9ClassPointer.romClass(), j9ClassPointer, j9ClassPointer2, u32);
                while (iterator.hasNext()) {
                    J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                    if (j9ObjectFieldOffset.isStatic()) continue;
                    J9ROMFieldShapePointer j9ROMFieldShapePointer = j9ObjectFieldOffset.getField();
                    UDATA uDATA = j9ROMFieldShapePointer.modifiers();
                    if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeByte)) {
                        ++this.byteCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeShort)) {
                        ++this.shortCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeInt)) {
                        ++this.intCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeLong)) {
                        ++this.longCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeFloat)) {
                        ++this.floatCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeDouble)) {
                        ++this.doubleCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldTypeBoolean)) {
                        ++this.boolCount;
                    } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                        ++this.objectCount;
                    } else {
                        ++this.charCount;
                    }
                    if (!j9ObjectFieldOffset.isHidden()) continue;
                    ++this.hiddenFields;
                }
                this.bytesContainingData = this.calculateBytesContainingData() + (long)ObjectFieldInfo.fj9object_t_SizeOf;
            } else {
                this.bytesContainingData = 0L;
                this.isArray = true;
            }
        }

        private long calculateBytesContainingData() throws CorruptDataException {
            J9ClassPointer j9ClassPointer = J9ClassHelper.superclass(this.objectClass);
            long l = 0L;
            if (!j9ClassPointer.isNull()) {
                l = j9ClassPointer.totalInstanceSize().intValue();
                if (j9ClassPointer.backfillOffset().gt(0)) {
                    l -= 4L;
                }
            }
            l += (long)((this.charCount + this.byteCount + this.boolCount) * 1);
            l += (long)(this.shortCount * 2);
            l += (long)((this.intCount + this.floatCount) * 4);
            l += (long)((this.longCount + this.doubleCount) * 8);
            return l += (long)(this.objectCount * ObjectFieldInfo.fj9object_t_SizeOf);
        }

        public void addInstance(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
            ++this.instanceCount;
            this.spaceUsed += ObjectModel.getConsumedSizeInBytesWithHeader(j9ObjectPointer).longValue();
        }
    }

    static abstract class FieldInfo {
        protected int instanceCount;
        protected int charCount = 0;
        protected int byteCount = 0;
        protected int shortCount = 0;
        protected int intCount = 0;
        protected int longCount = 0;
        protected int floatCount = 0;
        protected int doubleCount = 0;
        protected int boolCount = 0;
        protected int objectCount = 0;
        protected int hiddenFields = 0;
        protected long spaceUsed = 0L;
        protected long totalInstanceSize;
        protected String objectClassString;
        protected long bytesContainingData;
        protected boolean isArray;

        public static String[] getTitleRow() {
            return new String[]{"Class", ObjectSizeInfo.TOTAL_SIZE, ObjectSizeInfo.DATA_SIZE, ObjectSizeInfo.SPACE_USED, "Instances", "char", "byte", "short", "int", "long", "float", "double", "boolean", "object", "hidden"};
        }

        public String[] getResults() throws CorruptDataException {
            ArrayList<String> arrayList = new ArrayList<String>(16);
            arrayList.add(this.objectClassString);
            String string = "N/A";
            String string2 = "N/A";
            if (!this.isArray) {
                string = Long.toString(this.totalInstanceSize);
                if (this.totalInstanceSize < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
                    string = string + '*';
                }
                string2 = Long.toString(this.bytesContainingData);
                if (this.bytesContainingData < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
                    string2 = string2 + '*';
                }
            }
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(Long.toString(this.spaceUsed));
            arrayList.add(Integer.toString(this.instanceCount));
            arrayList.add(Integer.toString(this.charCount));
            arrayList.add(Integer.toString(this.byteCount));
            arrayList.add(Integer.toString(this.shortCount));
            arrayList.add(Integer.toString(this.intCount));
            arrayList.add(Integer.toString(this.longCount));
            arrayList.add(Integer.toString(this.floatCount));
            arrayList.add(Integer.toString(this.doubleCount));
            arrayList.add(Integer.toString(this.boolCount));
            arrayList.add(Integer.toString(this.objectCount));
            arrayList.add(Integer.toString(this.hiddenFields));
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

