/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ByteDataWrapper.class)
public class ByteDataWrapperPointer
extends StructurePointer {
    public static final ByteDataWrapperPointer NULL = new ByteDataWrapperPointer(0L);

    protected ByteDataWrapperPointer(long l) {
        super(l);
    }

    public static ByteDataWrapperPointer cast(AbstractPointer abstractPointer) {
        return ByteDataWrapperPointer.cast(abstractPointer.getAddress());
    }

    public static ByteDataWrapperPointer cast(UDATA uDATA) {
        return ByteDataWrapperPointer.cast(uDATA.longValue());
    }

    public static ByteDataWrapperPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new ByteDataWrapperPointer(l);
    }

    @Override
    public ByteDataWrapperPointer add(long l) {
        return ByteDataWrapperPointer.cast(this.address + ByteDataWrapper.SIZEOF * l);
    }

    @Override
    public ByteDataWrapperPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public ByteDataWrapperPointer addOffset(long l) {
        return ByteDataWrapperPointer.cast(this.address + l);
    }

    @Override
    public ByteDataWrapperPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public ByteDataWrapperPointer sub(long l) {
        return ByteDataWrapperPointer.cast(this.address - ByteDataWrapper.SIZEOF * l);
    }

    @Override
    public ByteDataWrapperPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public ByteDataWrapperPointer subOffset(long l) {
        return ByteDataWrapperPointer.cast(this.address - l);
    }

    @Override
    public ByteDataWrapperPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public ByteDataWrapperPointer untag(long l) {
        return ByteDataWrapperPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ByteDataWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ByteDataWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
    public UDATA dataLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(ByteDataWrapper._dataLengthOffset_));
    }

    public UDATAPointer dataLengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)ByteDataWrapper._dataLengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U8")
    public U8 dataType() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._dataTypeOffset_));
    }

    public U8Pointer dataTypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)ByteDataWrapper._dataTypeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_externalBlockOffsetOffset_", declaredType="I32")
    public IDATA externalBlockOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._externalBlockOffsetOffset_));
    }

    public IDATAPointer externalBlockOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)ByteDataWrapper._externalBlockOffsetOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_inPrivateUseOffset_", declaredType="U8")
    public U8 inPrivateUse() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._inPrivateUseOffset_));
    }

    public U8Pointer inPrivateUseEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)ByteDataWrapper._inPrivateUseOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_privateOwnerIDOffset_", declaredType="U16")
    public U16 privateOwnerID() throws CorruptDataException {
        return new U16(this.getShortAtOffset(ByteDataWrapper._privateOwnerIDOffset_));
    }

    public U16Pointer privateOwnerIDEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)ByteDataWrapper._privateOwnerIDOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tokenOffsetOffset_", declaredType="I32")
    public IDATA tokenOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._tokenOffsetOffset_));
    }

    public IDATAPointer tokenOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)ByteDataWrapper._tokenOffsetOffset_);
    }
}

