/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ProcessorSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private int arch;
    private boolean big;
    private int word;
    private int procs;
    private int subType;
    private int counter;

    public ProcessorSection(TraceFile traceFile, int n) throws IOException {
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        traceFile.skipBytes(16);
        this.arch = traceFile.readI();
        this.big = traceFile.readI() != 0;
        this.word = traceFile.readI();
        this.procs = traceFile.readI();
        traceFile.skipBytes(16);
        this.subType = traceFile.readI();
        this.counter = traceFile.readI();
        Util.setTimerType(this.counter);
        Util.Debug.println("ProcessorSection: eyecatcher:      " + this.eyecatcher_string);
        Util.Debug.println("ProcessorSection: length:          " + this.length);
        Util.Debug.println("ProcessorSection: version:         " + this.version);
        Util.Debug.println("ProcessorSection: modification:    " + this.modification);
        Util.Debug.println("ProcessorSection: arch:            " + this.arch);
        Util.Debug.println("ProcessorSection: big:             " + this.big);
        Util.Debug.println("ProcessorSection: word:            " + this.word);
        Util.Debug.println("ProcessorSection: procs:           " + this.procs);
        Util.Debug.println("ProcessorSection: subType:         " + this.subType);
        Util.Debug.println("ProcessorSection: counter:         " + this.counter);
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = new String[]{"Unknown", "x86", "S390", "Power", "IA64", "S390X", "AMD64"};
        String[] stringArray2 = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA", "Pentium IV", "T-Rex", "Opteron"};
        String[] stringArray3 = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer", "J9 timer"};
        bufferedWriter.write("Sys Processor Info :");
        bufferedWriter.newLine();
        bufferedWriter.write("        Arch family " + stringArray[this.arch]);
        bufferedWriter.newLine();
        bufferedWriter.write("        Processor Sub-type " + stringArray2[this.subType]);
        bufferedWriter.newLine();
        bufferedWriter.write("        Num Processors " + this.procs);
        bufferedWriter.newLine();
        bufferedWriter.write("        Big Endian " + this.big);
        bufferedWriter.newLine();
        bufferedWriter.write("        Word size " + this.word);
        bufferedWriter.newLine();
        bufferedWriter.write("        Using Trace Counter " + stringArray3[this.counter]);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
    }
}

