/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

import com.ibm.dtfj.phd.util.BitStream;
import com.ibm.dtfj.phd.util.BufferedNumberStream;
import com.ibm.dtfj.phd.util.LongArray;
import com.ibm.dtfj.phd.util.SortedNumberStream;
import java.util.NoSuchElementException;
import java.util.Random;

public class NumberStream {
    private static final int TYPE_FIELD_BITS = 2;
    private static final int SIGN_FIELD_BITS = 1;
    private static final int REPEATED_DELTA = 0;
    private static final int REPEATED_DELTA_BITS = 32;
    private static final int SMALL_DELTA = 1;
    private static final int SMALL_DELTA_BITS = 11;
    private static final int MEDIUM_DELTA = 2;
    private static final int MEDIUM_DELTA_BITS = 31;
    private static final int LARGE_DELTA = 3;
    private static final int LARGE_DELTA_BITS = 63;
    BitStream bitStream = new BitStream();
    long lastn;
    int repeatCount;
    int elementCount;
    int readElementCount;
    static final boolean dbg = false;

    public void setBitStream(BitStream bitStream) {
        this.bitStream = bitStream;
        this.repeatCount = 0;
        this.lastn = 0L;
    }

    public void writeLong(long l) {
        ++this.elementCount;
        long l2 = l - this.lastn;
        if (l2 == 0L) {
            if (this.repeatCount == -1) {
                this.flush();
            }
            ++this.repeatCount;
            return;
        }
        this.flush();
        boolean bl = l2 < 0L;
        long l3 = l2;
        l2 = Math.abs(l2);
        if (l2 < 2048L) {
            int n = 1;
            this.bitStream.writeIntBits(n, 2);
            this.bitStream.writeIntBits(bl ? 1 : 0, 1);
            this.bitStream.writeIntBits((int)l2, 11);
        } else if (l2 < 0x80000000L) {
            int n = 2;
            this.bitStream.writeIntBits(n, 2);
            this.bitStream.writeIntBits(bl ? 1 : 0, 1);
            this.bitStream.writeIntBits((int)l2, 31);
        } else {
            int n = 3;
            this.bitStream.writeIntBits(3, 2);
            this.bitStream.writeIntBits(bl ? 1 : 0, 1);
            this.bitStream.writeLongBits(l2, 63);
        }
        this.lastn = l;
    }

    public long readLong() {
        long l;
        boolean bl;
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        --this.readElementCount;
        if (this.repeatCount != 0) {
            --this.repeatCount;
            return this.lastn;
        }
        int n = this.bitStream.readIntBits(2);
        if (n == 0) {
            this.repeatCount = this.bitStream.readIntBits(32);
            NumberStream.Assert(this.repeatCount != 0);
            --this.repeatCount;
            return this.lastn;
        }
        boolean bl2 = bl = this.bitStream.readIntBits(1) != 0;
        if (n == 1) {
            l = this.bitStream.readIntBits(11);
            if (bl) {
                l = -l;
            }
        } else if (n == 2) {
            l = this.bitStream.readIntBits(31);
            if (bl) {
                l = -l;
            }
        } else {
            l = this.bitStream.readLongBits(63);
            if (bl) {
                l = -l;
            }
        }
        this.lastn += l;
        return this.lastn;
    }

    public void flush() {
        if (this.repeatCount != 0) {
            int n = 0;
            this.bitStream.writeIntBits(n, 2);
            this.bitStream.writeIntBits(this.repeatCount, 32);
            this.repeatCount = 0;
        }
    }

    void reset() {
        this.flush();
        this.bitStream.reset();
        this.repeatCount = 0;
        this.lastn = 0L;
    }

    public void rewind() {
        this.reset();
        this.readElementCount = this.elementCount;
    }

    public void clear() {
        this.rewind();
        this.bitStream.clear();
        this.elementCount = 0;
        this.readElementCount = 0;
    }

    public boolean hasMore() {
        return this.readElementCount != 0;
    }

    public int elementCount() {
        return this.elementCount;
    }

    public int[] toIntArray() {
        this.rewind();
        int[] nArray = new int[this.elementCount()];
        for (int i = 0; i < this.elementCount(); ++i) {
            nArray[i] = (int)this.readLong();
        }
        return nArray;
    }

    public long[] toLongArray() {
        this.rewind();
        long[] lArray = new long[this.elementCount()];
        for (int i = 0; i < this.elementCount(); ++i) {
            lArray[i] = this.readLong();
        }
        return lArray;
    }

    int memoryUsage() {
        return this.bitStream.memoryUsage();
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed");
        }
    }

    public static void main(String[] stringArray) {
        long l;
        long l2;
        int n = 0;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl = false;
        NumberStream numberStream = bl ? new SortedNumberStream() : new BufferedNumberStream();
        Random random = new Random(1L);
        for (int i = 0; i < 100; ++i) {
            int n2;
            System.out.println("pass " + i);
            LongArray longArray = new LongArray();
            int n3 = 16384;
            numberStream.clear();
            for (n2 = 0; n2 < n3; ++n2) {
                l2 = random.nextLong();
                numberStream.writeLong(l2);
                longArray.add(l2);
                numberStream.writeLong(l2 += (long)random.nextInt());
                longArray.add(l2);
                numberStream.writeLong(l2 += (long)random.nextInt(2048));
                longArray.add(l2);
                numberStream.writeLong(l2 -= (long)random.nextInt(2048));
                longArray.add(l2);
                int n4 = 0;
                while ((double)n4 < random.nextGaussian()) {
                    l2 = 0L;
                    numberStream.writeLong(l2);
                    longArray.add(l2);
                    ++n4;
                }
                if (n2 % 256 != 0) continue;
                for (n4 = 0; n4 < n2; ++n4) {
                    numberStream.writeLong(l2);
                    longArray.add(l2);
                }
            }
            numberStream.rewind();
            if (bl) {
                longArray.sort();
            }
            for (n2 = 0; n2 < longArray.size(); ++n2) {
                l2 = numberStream.readLong();
                if (l2 == longArray.get(n2)) continue;
                System.err.println("At " + n2 + " expected 0x" + Long.toHexString(longArray.get(n2)) + " got " + Long.toHexString(l2));
                System.exit(1);
            }
            l3 += (long)numberStream.memoryUsage();
            l4 += (long)(numberStream.bitStream.getOffset() * 4);
            n += longArray.size();
        }
        System.out.println("Test succeeded for " + n + " pairs");
        System.out.println("Items " + n + ", used bits per item " + (double)l4 * 8.0 / (double)n);
        numberStream.clear();
        long l5 = 78187493520L;
        l2 = Math.min(0x80000000L, 0x100000001L);
        for (l = -2L; l < l2; ++l) {
            if (l % 100000000L == 0L) {
                System.out.println("Write repeat " + l);
            }
            numberStream.writeLong(l == -2L ? 0L : l5);
        }
        numberStream.writeLong(0L);
        numberStream.rewind();
        for (l = -2L; l < l2; ++l) {
            if (l % 100000000L == 0L) {
                System.out.println("Read repeat " + l);
            }
            long l6 = numberStream.readLong();
            long l7 = l5 = l == -2L ? 0L : 78187493520L;
            if (l6 == l5) continue;
            System.err.println("At " + l + " expected 0x" + Long.toHexString(l5) + " got " + Long.toHexString(l6));
            System.exit(1);
        }
        l5 = 0L;
        l = numberStream.readLong();
        if (l != l5) {
            System.err.println("At end expected 0x" + Long.toHexString(l5) + " got " + Long.toHexString(l));
            System.exit(1);
        }
        if (numberStream.hasMore()) {
            l = numberStream.readLong();
            System.err.println("At end expected no more, got " + Long.toHexString(l));
            System.exit(1);
        }
        n = (int)((long)n + (l2 + 3L));
        System.out.println("Test succeeded for " + l2 + " repeated values");
        System.out.println("Memory usage " + (l3 += (long)numberStream.memoryUsage()) + " bytes, used bytes " + (l4 += (long)(numberStream.bitStream.getOffset() * 4)));
    }

    static String hex(long l) {
        return Long.toHexString(l);
    }
}

