/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.AbstractHashMap;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.IntEnumeration;
import java.util.HashMap;
import java.util.Random;

public final class IntegerMap
extends AbstractHashMap {
    long[] values = new long[17];
    private boolean doCheck = true;

    @Override
    Object getValuesArray() {
        return this.values;
    }

    @Override
    void allocNewValuesArray(int n) {
        this.values = new long[n];
    }

    @Override
    void put(long l, Object object, int n) {
        long[] lArray = (long[])object;
        this.put(l, lArray[n]);
    }

    public synchronized long get(long l) {
        int n = this.getIndex(l);
        return n == -1 ? -1L : this.values[n];
    }

    public synchronized void put(long l, long l2) {
        this.values[this.putIndex((long)l)] = l2;
        this.checkRehash();
    }

    public synchronized long remove(long l) {
        int n = this.removeIndex(l);
        return n == -1 ? -1L : this.values[n];
    }

    public int memoryUsage() {
        return this.tableSize * 17;
    }

    private void test() {
        Random random = new Random(23L);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        for (int i = 0; i < 500000; ++i) {
            boolean bl;
            long l = random.nextLong();
            long l2 = random.nextLong();
            boolean bl2 = bl = i % 3 == 0;
            if (this.get(l) != -1L) continue;
            this.put(l, l2);
            if (!this.doCheck) continue;
            hashMap.put(new Long(l), new Long(l2));
            if (this.get(l) != l2) {
                throw new Error("found " + this.get(l) + " expected " + l2);
            }
            if (!bl) continue;
            this.remove(l);
            hashMap.remove(new Long(l));
        }
        if (this.doCheck) {
            Long[] longArray = hashMap.keySet().toArray(new Long[0]);
            for (int i = 0; i < longArray.length; ++i) {
                long l = longArray[i];
                long l3 = (Long)hashMap.get(longArray[i]);
                if (this.get(l) == l3) continue;
                throw new Error("at " + i + " found " + this.get(l) + " expected " + l3 + " key " + l);
            }
        }
    }

    public static void main(String[] stringArray) {
        IntegerMap integerMap = new IntegerMap();
        integerMap.test();
        IntEnumeration intEnumeration = integerMap.getKeys();
        while (intEnumeration.hasMoreElements()) {
            long l = intEnumeration.nextInt();
            if (integerMap.get(l) != -1L) continue;
            throw new Error("uh oh");
        }
        System.out.println("finished!");
    }
}

