/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFAArch64DumpReader
extends ELFDumpReader {
    ELFAArch64DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "arm64";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (int i = 0; i < 30; ++i) {
            treeMap.put("x" + i, this._reader.readLong());
        }
        treeMap.put("lr", this._reader.readLong());
        treeMap.put("sp", this._reader.readLong());
        treeMap.put("pc", this._reader.readLong());
        treeMap.put("pstate", this._reader.readLong());
        return treeMap;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "sp";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return this.getStackPointerFrom(map);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return map.get("lr").longValue();
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in AArch64 ELF dump");
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] stringArray = new String[34];
        for (int i = 0; i < 30; ++i) {
            stringArray[i] = "x" + i;
        }
        stringArray[30] = "lr";
        stringArray[31] = "sp";
        stringArray[32] = "pc";
        stringArray[33] = "sptate";
        return stringArray;
    }
}

