/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.JdmpviewContextManager;
import com.ibm.jvm.dtfjview.Version;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.spi.ISession;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "open";
    private static final String defaultFactoryName = "com.ibm.dtfj.image.j9.ImageFactory";
    private String factoryName = System.getProperty("com.ibm.dtfj.image.factoryclass", "com.ibm.dtfj.image.j9.ImageFactory");
    private int apiLevelMajor = 0;
    private int apiLevelMinor = 0;
    private ImageFactory factory = null;

    public OpenCommand() {
        this.addCommand(CMD_NAME, "[path to core or zip]", "opens the specified core or zip file");
        this.factory = this.getFactory();
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        switch (stringArray.length) {
            case 0: {
                printStream.println(Version.getAllVersionInfo(this.factory));
                return;
            }
            case 1: 
            case 2: {
                this.imagesFromCommandLine(stringArray);
                break;
            }
            default: {
                printStream.println("The open command requires at least one and at most two parameters. See 'help open'.");
                return;
            }
        }
    }

    private void imagesFromCommandLine(String[] stringArray) {
        block8: {
            this.apiLevelMajor = this.factory.getDTFJMajorVersion();
            this.apiLevelMinor = this.factory.getDTFJMinorVersion();
            this.out.println(Version.getAllVersionInfo(this.factory));
            this.out.println("Loading image from DTFJ...\n");
            try {
                if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
                    Logger.getLogger("j9ddr.view.dtfj").setLevel(Level.WARNING);
                }
                long l = System.currentTimeMillis();
                File file = new File(stringArray[0]);
                Image[] imageArray = new Image[1];
                if (stringArray.length == 1) {
                    if (FileManager.isArchive((File)file) && !this.ctx.hasPropertyBeenSet("zip.mode.legacy")) {
                        imageArray = this.factory.getImagesFromArchive(file, this.ctx.hasPropertyBeenSet("extract.mode"));
                    } else {
                        imageArray[0] = this.factory.getImage(file);
                    }
                } else {
                    Image[] imageArray2 = new File(stringArray[1]);
                    imageArray[0] = this.factory.getImage(file, (File)imageArray2);
                }
                this.logger.fine(String.format("Time taken to load image %d ms", System.currentTimeMillis() - l));
                for (Image image : imageArray) {
                    this.createContexts(image, stringArray[0]);
                }
            }
            catch (IOException iOException) {
                this.out.println("Could not load dump file and/or could not load XML file: " + iOException.getMessage());
                if (!this.ctx.hasPropertyBeenSet("verbose.mode")) break block8;
                iOException.printStackTrace();
            }
        }
    }

    private ImageFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            Class<?> clazz = Class.forName(this.factoryName);
            this.factory = (ImageFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.out.println("ClassNotFoundException while getting ImageFactory: " + classNotFoundException.getMessage());
            this.out.println("Use -Dcom.ibm.dtfj.image.factoryclass=<classname> to change the ImageFactory");
            System.exit(1);
        }
        catch (ClassCastException classCastException) {
            this.out.println("ClassCastException while getting ImageFactory: " + classCastException.getMessage());
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.out.println("IllegalAccessException while getting ImageFactory: " + illegalAccessException.getMessage());
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            this.out.println("InstantiationException while getting ImageFactory: " + instantiationException.getMessage());
            System.exit(1);
        }
        return this.factory;
    }

    private void createContexts(Image image, String string) {
        if (image == null) {
            return;
        }
        boolean bl = false;
        Iterator iterator = image.getAddressSpaces();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ImageAddressSpace)) {
                this.logger.fine("Skipping corrupt ImageAddress space");
                continue;
            }
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)e;
            Iterator iterator2 = imageAddressSpace.getProcesses();
            if (!iterator2.hasNext()) {
                this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, imageAddressSpace, null, null, string);
                bl = true;
                continue;
            }
            while (iterator2.hasNext()) {
                e = iterator2.next();
                if (!(e instanceof ImageProcess)) continue;
                ImageProcess imageProcess = (ImageProcess)e;
                Iterator iterator3 = imageProcess.getRuntimes();
                if (!iterator3.hasNext()) {
                    this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, imageAddressSpace, imageProcess, null, string);
                    bl = true;
                    continue;
                }
                while (iterator3.hasNext()) {
                    e = iterator3.next();
                    if (e instanceof JavaRuntime) {
                        this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, imageAddressSpace, imageProcess, (JavaRuntime)e, string);
                        bl = true;
                        continue;
                    }
                    if (e instanceof CorruptData) {
                        this.logger.fine("CorruptData encountered in ImageProcess.getRuntimes(): " + e);
                        this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, imageAddressSpace, imageProcess, null, string);
                        bl = true;
                        continue;
                    }
                    this.logger.fine("Unexpected class encountered in ImageProcess.getRuntimes()");
                    this.createCombinedContext(image, this.apiLevelMajor, this.apiLevelMinor, imageAddressSpace, imageProcess, null, string);
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
                this.out.println("Warning: no contexts were found, is this a valid core file?");
            }
        } else if (image.isTruncated()) {
            this.out.println("Warning: dump file is truncated. Extracted information may be incomplete.");
            this.out.println();
        }
    }

    private void createCombinedContext(Image image, int n, int n2, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess, JavaRuntime javaRuntime, String string) {
        Object object = this.ctx.getProperties().get("session");
        if (object == null) {
            this.logger.fine("Could not create a new context as the session property has not been set");
            return;
        }
        if (!(object instanceof ISession)) {
            this.logger.fine("Could not create a new context as the session type was not recognised [" + object.getClass().getName() + "]");
            return;
        }
        JdmpviewContextManager jdmpviewContextManager = (JdmpviewContextManager)((ISession)object).getContextManager();
        CombinedContext combinedContext = (CombinedContext)jdmpviewContextManager.createContext(image, n, n2, imageAddressSpace, imageProcess, javaRuntime);
        combinedContext.startDDRInteractiveSession(image, this.out);
        combinedContext.getProperties().put("core_file_path", string);
        combinedContext.getProperties().put("image.factory", this.getFactory());
        if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
            combinedContext.getProperties().put("verbose.mode", "true");
        }
        try {
            boolean bl = true;
            String string2 = combinedContext.getImage().getSystemType().toLowerCase();
            if (string2.contains("linux") || string2.contains("aix")) {
                Iterator iterator;
                if (combinedContext.getProcess() != null && (iterator = combinedContext.getProcess().getLibraries()).hasNext() && (object = iterator.next()) instanceof ImageModule) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                this.out.println("Warning: native libraries are not available for " + string);
            }
        }
        catch (DataUnavailable dataUnavailable) {
            this.logger.log(Level.FINE, "Warning: native libraries are not available for " + string);
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Error determining if native libraries are required for " + string, exception);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("Opens a core file or zip file and loads it into jdmpview ready for further analysis.");
        printStream.println("Any resultant contexts are added to the list of currently available contexts.");
    }
}

