/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.rsa.RSAUtil;

public class RSAKeyFactory
extends KeyFactorySpi {
    private static final Class<?> RSA_PUB_KEYSPEC_CLS = RSAPublicKeySpec.class;
    private static final Class<?> RSA_PRIV_KEYSPEC_CLS = RSAPrivateKeySpec.class;
    private static final Class<?> RSA_PRIVCRT_KEYSPEC_CLS = RSAPrivateCrtKeySpec.class;
    private static final Class<?> X509_KEYSPEC_CLS = X509EncodedKeySpec.class;
    private static final Class<?> PKCS8_KEYSPEC_CLS = PKCS8EncodedKeySpec.class;
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    private final RSAUtil.KeyType type;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean restrictExpLen = "true".equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction("sun.security.rsa.restrictRSAExponent", "true")));

    static RSAKeyFactory getInstance(RSAUtil.KeyType keyType) {
        return new RSAKeyFactory(keyType);
    }

    private static void checkKeyAlgo(Key key, String string) throws InvalidKeyException {
        String string2 = key.getAlgorithm();
        if (string2 == null || !string2.equalsIgnoreCase(string)) {
            throw new InvalidKeyException("Expected a " + string + " key, but got " + string2);
        }
    }

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (key instanceof RSAPrivateKeyImpl || key instanceof RSAPrivateCrtKeyImpl || key instanceof RSAPublicKeyImpl) {
            return (RSAKey)((Object)key);
        }
        try {
            RSAUtil.KeyType keyType = RSAUtil.KeyType.lookup(key.getAlgorithm());
            RSAKeyFactory rSAKeyFactory = RSAKeyFactory.getInstance(keyType);
            return (RSAKey)((Object)rSAKeyFactory.engineTranslateKey(key));
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    static void checkRSAProviderKeyLengths(int n, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    public static void checkKeyLengths(int n, BigInteger bigInteger, int n2, int n3) throws InvalidKeyException {
        if (n2 > 0 && n < n2) {
            throw new InvalidKeyException("RSA keys must be at least " + n2 + " bits long");
        }
        int n4 = Math.min(n3, 16384);
        if (n > n4) {
            throw new InvalidKeyException("RSA keys must be no longer than " + n4 + " bits");
        }
        if (restrictExpLen && bigInteger != null && n > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException("RSA exponents can be no longer than 64 bits  if modulus is greater than 3072 bits");
        }
    }

    private RSAKeyFactory() {
        this.type = RSAUtil.KeyType.RSA;
    }

    public RSAKeyFactory(RSAUtil.KeyType keyType) {
        this.type = keyType;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        RSAKeyFactory.checkKeyAlgo(key, this.type.keyAlgo());
        if (key instanceof RSAPrivateKeyImpl || key instanceof RSAPrivateCrtKeyImpl || key instanceof RSAPublicKeyImpl) {
            return key;
        }
        if (key instanceof PublicKey) {
            return this.translatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    private PublicKey translatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            try {
                return new RSAPublicKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPublicKey.getParams()), rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException("Invalid key", providerException);
            }
        }
        if ("X.509".equals(publicKey.getFormat())) {
            RSAPublicKeyImpl rSAPublicKeyImpl = new RSAPublicKeyImpl(publicKey.getEncoded());
            RSAKeyFactory.checkKeyAlgo(rSAPublicKeyImpl, this.type.keyAlgo());
            return rSAPublicKeyImpl;
        }
        throw new InvalidKeyException("Public keys must be instance of RSAPublicKey or have X.509 encoding");
    }

    private PrivateKey translatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            try {
                return new RSAPrivateCrtKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPrivateCrtKey.getParams()), rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException("Invalid key", providerException);
            }
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            try {
                return new RSAPrivateKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPrivateKey.getParams()), rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException("Invalid key", providerException);
            }
        }
        if ("PKCS#8".equals(privateKey.getFormat())) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateCrtKeyImpl.newKey(privateKey.getEncoded());
            RSAKeyFactory.checkKeyAlgo(rSAPrivateKey, this.type.keyAlgo());
            return rSAPrivateKey;
        }
        throw new InvalidKeyException("Private keys must be instance of RSAPrivate(Crt)Key or have PKCS#8 encoding");
    }

    private PublicKey generatePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            RSAPublicKeyImpl rSAPublicKeyImpl = new RSAPublicKeyImpl(x509EncodedKeySpec.getEncoded());
            RSAKeyFactory.checkKeyAlgo(rSAPublicKeyImpl, this.type.keyAlgo());
            return rSAPublicKeyImpl;
        }
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            try {
                return new RSAPublicKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPublicKeySpec.getParams()), rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeySpecException(providerException);
            }
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    private PrivateKey generatePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            RSAPrivateKey rSAPrivateKey = RSAPrivateCrtKeyImpl.newKey(pKCS8EncodedKeySpec.getEncoded());
            RSAKeyFactory.checkKeyAlgo(rSAPrivateKey, this.type.keyAlgo());
            return rSAPrivateKey;
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            try {
                return new RSAPrivateCrtKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPrivateCrtKeySpec.getParams()), rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeySpecException(providerException);
            }
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            try {
                return new RSAPrivateKeyImpl(RSAUtil.createAlgorithmId(this.type, rSAPrivateKeySpec.getParams()), rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeySpecException(providerException);
            }
        }
        throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            if (RSA_PUB_KEYSPEC_CLS.isAssignableFrom(clazz)) {
                return (T)((KeySpec)clazz.cast(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent(), rSAPublicKey.getParams())));
            }
            if (X509_KEYSPEC_CLS.isAssignableFrom(clazz)) {
                return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be RSAPublicKeySpec or X509EncodedKeySpec for RSA public keys");
        }
        if (key instanceof RSAPrivateKey) {
            if (PKCS8_KEYSPEC_CLS.isAssignableFrom(clazz)) {
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            if (RSA_PRIVCRT_KEYSPEC_CLS.isAssignableFrom(clazz)) {
                if (key instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                    return (T)((KeySpec)clazz.cast(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient(), rSAPrivateCrtKey.getParams())));
                }
                throw new InvalidKeySpecException("RSAPrivateCrtKeySpec can only be used with CRT keys");
            }
            if (RSA_PRIV_KEYSPEC_CLS.isAssignableFrom(clazz)) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getParams())));
            }
            throw new InvalidKeySpecException("KeySpec must be RSAPrivate(Crt)KeySpec or PKCS8EncodedKeySpec for RSA private keys");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }

    public static final class PSS
    extends RSAKeyFactory {
        public PSS() {
            super(RSAUtil.KeyType.PSS);
        }
    }

    public static final class Legacy
    extends RSAKeyFactory {
        public Legacy() {
            super(RSAUtil.KeyType.RSA);
        }
    }
}

