/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyInfoContent;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyValue
extends SignatureElementProxy
implements KeyInfoContent {
    public KeyValue(Document document, DSAKeyValue dSAKeyValue) {
        super(document);
        this.addReturnToSelf();
        this.appendSelf(dSAKeyValue);
        this.addReturnToSelf();
    }

    public KeyValue(Document document, RSAKeyValue rSAKeyValue) {
        super(document);
        this.addReturnToSelf();
        this.appendSelf(rSAKeyValue);
        this.addReturnToSelf();
    }

    public KeyValue(Document document, Element element) {
        super(document);
        this.addReturnToSelf();
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public KeyValue(Document document, PublicKey publicKey) {
        super(document);
        this.addReturnToSelf();
        if (publicKey instanceof DSAPublicKey) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(this.getDocument(), publicKey);
            this.appendSelf(dSAKeyValue);
            this.addReturnToSelf();
        } else if (publicKey instanceof RSAPublicKey) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this.getDocument(), publicKey);
            this.appendSelf(rSAKeyValue);
            this.addReturnToSelf();
        } else {
            String string = "The given PublicKey type " + publicKey + " is not supported. Only DSAPublicKey and RSAPublicKey types are currently supported";
            throw new IllegalArgumentException(string);
        }
    }

    public KeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this.getFirstChild(), "RSAKeyValue", 0);
        if (element != null) {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element, this.baseURI);
            return rSAKeyValue.getPublicKey();
        }
        Element element2 = XMLUtils.selectDsNode(this.getFirstChild(), "DSAKeyValue", 0);
        if (element2 != null) {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(element2, this.baseURI);
            return dSAKeyValue.getPublicKey();
        }
        return null;
    }

    @Override
    public String getBaseLocalName() {
        return "KeyValue";
    }
}

