/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFIA32DumpReader
extends ELFDumpReader {
    ELFIA32DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readShort() & 0xFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "x86";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return map.get("ebp").longValue();
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("eip").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return 0L;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "esp";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int n;
        String[] stringArray = new String[]{"ebx", "ecx", "edx", "esi", "edi", "ebp", "eax", "ds", "es", "fs", "gs"};
        String[] stringArray2 = new String[]{"eip", "cs", "efl", "esp", "ss"};
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (n = 0; n < stringArray.length; ++n) {
            treeMap.put(stringArray[n], (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        this._reader.readInt();
        for (n = 0; n < stringArray2.length; ++n) {
            treeMap.put(stringArray2[n], (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        return treeMap;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] stringArray = new String[]{"eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi", "eip", "eflags", "cs", "ss", "ds", "es", "fs", "gs"};
        return stringArray;
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in IA32 ELF dump");
    }
}

