/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.DTFJContext;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.CdCommand;
import com.ibm.jvm.dtfjview.commands.CloseCommand;
import com.ibm.jvm.dtfjview.commands.OpenCommand;
import com.ibm.jvm.dtfjview.commands.PwdCommand;
import com.ibm.jvm.dtfjview.commands.setcommands.SetLoggingCommand;
import com.ibm.jvm.dtfjview.commands.showcommands.ShowLoggingCommand;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CombinedContext
extends DTFJContext
implements ICombinedContext {
    private Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger");
    private static final String DDR_INTERACTIVE_CLASS = "com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive";
    private Throwable ddrStartupException = null;
    private Object ddriObject = null;
    private Method ddriMethod = null;
    private boolean ddrAvailable = false;
    private int id = 0;

    public CombinedContext(int n, int n2, Image image, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess, JavaRuntime javaRuntime, int n3) {
        super(n, n2, image, imageAddressSpace, imageProcess, javaRuntime);
        this.globalCommands.add(new OpenCommand());
        this.globalCommands.add(new CloseCommand());
        this.globalCommands.add(new SetLoggingCommand());
        this.globalCommands.add(new ShowLoggingCommand());
        this.globalCommands.add(new PwdCommand());
        this.globalCommands.add(new CdCommand());
        this.id = n3;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int n) {
        this.id = n;
    }

    public void execute(String string, String[] stringArray, PrintStream printStream) {
        try {
            CommandParser commandParser = new CommandParser(string, stringArray);
            this.execute(commandParser, printStream);
        }
        catch (ParseException parseException) {
            printStream.println("Error parsing command: " + string + " (" + parseException.getMessage() + ")");
            this.logger.log(Level.FINE, "Error parsing command " + string, parseException);
        }
    }

    private boolean initJdmpviewCommand(CommandParser commandParser, PrintStream printStream) throws CommandException {
        for (ICommand iCommand : this.commands) {
            if (!iCommand.recognises(commandParser.getCommand(), (IContext)this)) continue;
            try {
                Class<?> clazz = iCommand.getClass().getClassLoader().loadClass(BaseJdmpviewCommand.class.getName());
                if (!clazz.isAssignableFrom(iCommand.getClass())) continue;
                Method method = clazz.getMethod("initCommand", String.class, String[].class, IContext.class, PrintStream.class);
                Object object = method.invoke((Object)iCommand, commandParser.getCommand(), commandParser.getArguments(), this, printStream);
                return (Boolean)object;
            }
            catch (Exception exception) {
                printStream.println("Error initialising command : " + commandParser.getOriginalLine() + " (" + exception.getMessage() + ")");
                this.logger.log(Level.FINE, "Error initialising command : " + commandParser.getOriginalLine(), exception);
            }
        }
        return false;
    }

    public void execute(String string, PrintStream printStream) {
        try {
            CommandParser commandParser = new CommandParser(string);
            this.execute(commandParser, printStream);
        }
        catch (ParseException parseException) {
            printStream.println("Error parsing command: " + string + " (" + parseException.getMessage() + ")");
            this.logger.log(Level.FINE, "Error parsing command " + string, parseException);
        }
    }

    public void execute(CommandParser commandParser, PrintStream printStream) {
        if (this.isDDRCommand(commandParser.getOriginalLine())) {
            this.executeDDRInteractiveCommand(commandParser.getOriginalLine(), printStream);
        } else {
            try {
                if (!this.initJdmpviewCommand(commandParser, printStream)) {
                    super.execute(commandParser, printStream);
                }
            }
            catch (Exception exception) {
                printStream.println("Error executing command: " + exception.getMessage());
                this.logger.log(Level.FINE, "Error executing command : " + commandParser.getOriginalLine(), exception);
            }
        }
    }

    private boolean isDDRCommand(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '!';
    }

    public void startDDRInteractiveSession(Image image, PrintStream printStream) {
        Constructor<?> constructor;
        Class<?> clazz;
        this.ddrAvailable = false;
        try {
            clazz = Class.forName(DDR_INTERACTIVE_CLASS, true, image.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.fine("DDR is not enabled for " + image.getSource() + " (context " + this.id + "). It may be pre-DDR or not a core file e.g. javacore or PHD");
            return;
        }
        try {
            constructor = clazz.getConstructor(List.class, PrintStream.class);
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Error getting DDR Interactive constructor", exception);
            return;
        }
        try {
            ArrayList<CombinedContext> arrayList = new ArrayList<CombinedContext>(1);
            arrayList.add(this);
            this.ddriObject = constructor.newInstance(arrayList, printStream);
            this.ddriMethod = this.ddriObject.getClass().getMethod("processLine", String.class);
            this.ddrAvailable = true;
            if (this.hasPropertyBeenSet("verbose.mode")) {
                printStream.println("DTFJ DDR is enabled for this core dump");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof UnsupportedOperationException) {
                this.logger.fine("DDR is not enabled for " + image.getSource() + " (context " + this.id + "). It may be pre-DDR or not a core file e.g. javacore or PHD");
            } else {
                this.ddrStartupException = throwable;
                this.logger.log(Level.FINE, "Error creating DDR Interactive instance", invocationTargetException.getCause());
            }
        }
        catch (Exception exception) {
            this.ddrStartupException = exception;
            this.logger.log(Level.FINE, "Error creating DDR Interactive instance", exception);
        }
    }

    @Override
    public Object getDDRIObject() {
        return this.ddriObject;
    }

    private void executeDDRInteractiveCommand(String string, PrintStream printStream) {
        if (!this.ddrAvailable) {
            printStream.println("DDR is not enabled for this core file, '!' commands are disabled");
            return;
        }
        try {
            this.ddriMethod.invoke(this.ddriObject, string);
        }
        catch (Exception exception) {
            printStream.println("Error executing DDR command " + string + " : " + exception.getMessage());
            exception.printStackTrace(printStream);
        }
    }

    @Override
    public Throwable getDDRStartupException() {
        return this.ddrStartupException;
    }

    @Override
    public void displayContext(IOutputManager iOutputManager, boolean bl) {
        iOutputManager.print(this.id + " : ");
        if (this.ddrAvailable) {
            iOutputManager.clearBuffer();
            try {
                iOutputManager.setBuffering(true);
                this.executeDDRInteractiveCommand("!context short", iOutputManager.getPrintStream());
            }
            finally {
                iOutputManager.setBuffering(false);
            }
            int n = iOutputManager.getBuffer().indexOf(58);
            if (n != -1) {
                iOutputManager.print(iOutputManager.getBuffer().substring(n + 1).trim());
            }
            iOutputManager.print(" : ");
            iOutputManager.print(this.getJREVersion(bl));
        } else {
            this.showDTFJContexts(iOutputManager, bl);
        }
        iOutputManager.print("\n");
    }

    private void showDTFJContexts(IOutputManager iOutputManager, boolean bl) {
        if (this.getRuntime() == null) {
            iOutputManager.print("<no Java runtime>");
        } else {
            iOutputManager.print(this.getJREVersion(bl));
        }
    }

    private String getJREVersion(boolean bl) {
        StringBuilder stringBuilder;
        block10: {
            stringBuilder = new StringBuilder();
            try {
                if (this.getRuntime() == null) {
                    stringBuilder.append("No JRE");
                    break block10;
                }
                try {
                    String string = this.getRuntime().getVersion();
                    if (bl) {
                        int n = string.indexOf("\n");
                        String string2 = null;
                        string2 = n == -1 ? (string.length() == 0 ? "[cannot determine JRE level]" : string) : string.substring(0, n).trim();
                        stringBuilder.append(string2);
                    } else {
                        String[] stringArray;
                        for (String string3 : stringArray = string.split("\n")) {
                            stringBuilder.append("\n\t\t" + string3.trim());
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    if (this.getRuntime().getJavaVM() != null) {
                        stringBuilder.append("JRE level unknown");
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                stringBuilder.append("<corrupt Java runtime>");
            }
            catch (Exception exception) {
                stringBuilder.append("<error : " + exception.getMessage() + ">");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setAsCurrent() {
        URI uRI = this.getImage().getSource();
        if (uRI.getFragment() != null && uRI.getFragment().length() != 0) {
            try {
                uRI = new URI(uRI.getScheme() + "://" + uRI.getRawPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        File file = new File(uRI);
        System.setProperty("com.ibm.j9ddr.tools.ddrinteractive.filepath", file.getAbsolutePath());
    }

    @Override
    public boolean isDDRAvailable() {
        return this.ddrAvailable;
    }
}

