/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class ObjectReferencePointer
extends Pointer {
    public static final ObjectReferencePointer NULL = new ObjectReferencePointer(0L);
    public static final long SIZEOF = J9ObjectHelper.compressObjectReferences ? 4L : (long)UDATA.SIZEOF;

    protected ObjectReferencePointer(long l) {
        super(l);
    }

    public static ObjectReferencePointer cast(AbstractPointer abstractPointer) {
        return ObjectReferencePointer.cast(abstractPointer.getAddress());
    }

    public static ObjectReferencePointer cast(UDATA uDATA) {
        return ObjectReferencePointer.cast(uDATA.longValue());
    }

    public static ObjectReferencePointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new ObjectReferencePointer(l);
    }

    @Override
    public ObjectReferencePointer add(long l) {
        return new ObjectReferencePointer(this.address + SIZEOF * l);
    }

    @Override
    public ObjectReferencePointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public ObjectReferencePointer addOffset(long l) {
        return new ObjectReferencePointer(this.address + l);
    }

    @Override
    public ObjectReferencePointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public J9ObjectPointer at(long l) throws CorruptDataException {
        return this.getObjectReferenceAtOffset(l * SIZEOF);
    }

    @Override
    public J9ObjectPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }

    @Override
    public ObjectReferencePointer sub(long l) {
        return new ObjectReferencePointer(this.address - SIZEOF * l);
    }

    @Override
    public ObjectReferencePointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public ObjectReferencePointer subOffset(long l) {
        return new ObjectReferencePointer(this.address - l);
    }

    @Override
    public ObjectReferencePointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public ObjectReferencePointer untag(long l) {
        return new ObjectReferencePointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ObjectReferencePointer untag() {
        return this.untag(SIZEOF - 1L);
    }
}

