/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.tools.ddrinteractive.commands.TraceFileHeaderWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public abstract class SnapBaseCommand
extends Command {
    private String fileName = null;

    protected abstract void writeHeaderBytesToTrace(Context var1, byte[] var2, PrintStream var3);

    protected abstract void writeBytesToTrace(Context var1, long var2, int var4, PrintStream var5);

    protected void extractTraceData(Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        long l = context.vmAddress;
        try {
            long l2;
            long l3 = CommandUtils.followPointerFromStructure(context, "J9JavaVM", l, "j9rasGlobalStorage");
            long l4 = CommandUtils.followPointerFromStructure(context, "RasGlobalStorage", l3, "utGlobalData");
            if (l4 == 0L) {
                printStream.println("Encountered null J9JavaVM->j9rasGlobalStorage->utGlobalData pointer. Trace was not initialized, check dump VM options for -Xtrace:none");
                return;
            }
            long l5 = CommandUtils.followPointerFromStructure(context, "UtGlobalData", l4, "traceHeader");
            long l6 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "bufferSize");
            int n = context.process.getIntAt(l4 + l6);
            if (l5 != 0L) {
                l2 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceFileHdr", context), "header");
                long l7 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtDataHeader", context), "length");
                int n2 = context.process.getIntAt(l5 + l2 + l7);
                printStream.println("traceHeader: !uttracefilehdr 0x" + Long.toHexString(l5));
                printStream.println("traceHeader: length     = " + n2);
                byte[] byArray = new byte[n2];
                context.process.getBytesAt(l5, byArray);
                this.writeHeaderBytesToTrace(context, byArray, printStream);
            } else {
                this.createAndWriteTraceFileHeader(context, l4, n, printStream);
            }
            l2 = CommandUtils.followPointerFromStructure(context, "UtGlobalData", l4, "traceGlobal");
            printStream.println("Buffer size = " + n);
            printStream.println("firstBuffer: !uttracebuffer 0x" + Long.toHexString(l2));
            int n3 = 0;
            long l8 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceBuffer", context), "record");
            while (l2 != 0L) {
                this.writeBytesToTrace(context, l2 + l8, n, printStream);
                l2 = CommandUtils.followPointerFromStructure(context, "UtTraceBuffer", l2, "globalNext");
                if (++n3 < 10 && l2 != 0L) {
                    printStream.println("nextBuffer:  !uttracebuffer 0x" + Long.toHexString(l2));
                    continue;
                }
                if (n3 != 10 || l2 == 0L) continue;
                printStream.println("...");
            }
            if (n3 > 0) {
                printStream.println(n3 + " trace buffers extracted from the dump.");
            } else {
                printStream.println("There were no trace buffers found in the dump");
            }
        }
        catch (MemoryFault memoryFault) {
            memoryFault.printStackTrace(printStream);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace(printStream);
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace(printStream);
        }
    }

    private void createAndWriteTraceFileHeader(Context context, long l, int n, PrintStream printStream) throws CorruptDataException, DDRInteractiveCommandException {
        IProcess iProcess = context.process;
        boolean bl = iProcess.getByteOrder().equals(ByteOrder.BIG_ENDIAN);
        long l2 = CommandUtils.followPointerFromStructure(context, "J9JavaVM", context.vmAddress, "j9ras");
        long l3 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("J9RAS", context), "cpus");
        int n2 = context.process.getIntAt(l2 + l3);
        long l4 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("J9RAS", context), "osarch");
        String string = this.getCStringAtAddress(iProcess, l2 + l4, 16L);
        String string2 = "";
        long l5 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "serviceInfo");
        long l6 = iProcess.getPointerAt(l + l5);
        String string3 = this.getCStringAtAddress(iProcess, l6);
        long l7 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "properties");
        long l8 = iProcess.getPointerAt(l + l7);
        String string4 = this.getCStringAtAddress(iProcess, l8);
        int n3 = iProcess.bytesPerPointer() * 8;
        String string5 = "";
        long l9 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceCfg", context), "command");
        long l10 = CommandUtils.followPointerFromStructure(context, "UtGlobalData", l, "config");
        while (l10 != 0L) {
            string5 = string5 + this.getCStringAtAddress(iProcess, l10 + l9);
            if ((l10 = CommandUtils.followPointerFromStructure(context, "UtTraceCfg", l10, "next")) == 0L) continue;
            string5 = string5 + "\n";
        }
        long l11 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "startPlatform");
        long l12 = context.process.getLongAt(l + l11);
        long l13 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "startSystem");
        long l14 = context.process.getLongAt(l + l13);
        long l15 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "externalTrace");
        int n4 = context.process.getIntAt(l + l15);
        long l16 = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "traceGenerations");
        int n5 = context.process.getIntAt(l + l16);
        try {
            TraceFileHeaderWriter traceFileHeaderWriter = new TraceFileHeaderWriter(this.fileName, bl, n2, n3, n, string, string2, string3, string4, string5, l12, l14, n4, n5);
            byte[] byArray = traceFileHeaderWriter.createAndWriteTraceFileHeader();
            this.writeHeaderBytesToTrace(context, byArray, printStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getCStringAtAddress(IProcess iProcess, long l) throws CorruptDataException {
        return this.getCStringAtAddress(iProcess, l, Long.MAX_VALUE);
    }

    public String getCStringAtAddress(IProcess iProcess, long l, long l2) throws CorruptDataException {
        int n = 0;
        while (0 != iProcess.getByteAt(l + (long)n) && (long)n < l2) {
            ++n;
        }
        byte[] byArray = new byte[n];
        iProcess.getBytesAt(l, byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

