/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Emulator;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.logging.Logger;

public final class MutableAddressSpace
extends AddressSpace
implements Emulator.ImageSpace {
    private ObjectMap mutableBlockCache = new ObjectMap();
    private AddressSpace parentSpace;
    protected long lastMutableBlockAddress;
    private byte[] lastMutableBlock;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public MutableAddressSpace(AddressSpace addressSpace) {
        super(addressSpace.dump, addressSpace.asid);
        this.addressMap = addressSpace.addressMap;
        this.ranges = addressSpace.getAddressRanges();
        this.parentSpace = addressSpace;
        this.setIs64bit(addressSpace.is64bit());
    }

    @Override
    protected byte[] getBlockFromCacheOrDisk(long l) throws IOException {
        assert ((l & 0xFFFL) == 0L);
        byte[] byArray = (byte[])this.mutableBlockCache.get(l);
        if (byArray == null) {
            byArray = this.parentSpace.getBlock(l);
        }
        this.putBlockInQuickCache(l, byArray);
        return byArray;
    }

    private byte[] getMutableBlock(long l) throws IOException {
        byte[] byArray;
        if ((l = this.roundToPage(l)) == this.lastMutableBlockAddress) {
            byArray = this.lastMutableBlock;
        } else {
            byArray = (byte[])this.mutableBlockCache.get(l);
            if (byArray == null) {
                byte[] byArray2 = this.parentSpace.getBlock(l);
                byArray = new byte[4096];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                this.mutableBlockCache.put(l, byArray);
            }
            this.lastMutableBlock = byArray;
            this.lastMutableBlockAddress = l;
        }
        this.putBlockInQuickCache(l, byArray);
        return byArray;
    }

    public void writeBytes(long l, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            this.writeByte(l++, byArray[i]);
        }
    }

    public void writeWord(long l, long l2) throws IOException {
        if (this.is64bit()) {
            this.writeInt(l, (int)(l2 >>> 32));
            this.writeInt(l + 4L, (int)l2);
        } else {
            this.writeInt(l, (int)l2);
        }
    }

    @Override
    public void writeByte(long l, int n) throws IOException {
        this.getMutableBlock((long)l)[(int)l & 0xFFF] = (byte)n;
    }

    @Override
    public void writeShort(long l, int n) throws IOException {
        this.writeByte(l, n >> 8);
        this.writeByte(l + 1L, n);
    }

    @Override
    public void writeInt(long l, int n) throws IOException {
        int n2 = (int)l & 0xFFF;
        if (n2 < 4093) {
            byte[] byArray = this.getMutableBlock(l);
            byArray[n2] = (byte)(n >> 24);
            byArray[n2 + 1] = (byte)(n >> 16);
            byArray[n2 + 2] = (byte)(n >> 8);
            byArray[n2 + 3] = (byte)n;
        } else {
            this.writeByte(l, n >>> 24);
            this.writeByte(l + 1L, n >>> 16);
            this.writeByte(l + 2L, n >>> 8);
            this.writeByte(l + 3L, n);
        }
    }

    @Override
    public void writeLong(long l, long l2) throws IOException {
        this.writeInt(l, (int)(l2 >>> 32));
        this.writeInt(l + 4L, (int)l2);
    }

    @Override
    public long malloc(int n) throws IOException {
        AddressRange[] addressRangeArray = this.getUnusedAddressRanges();
        n += 8;
        int n2 = (n += 4) + 4096 - 1 & 0xFFFFF000;
        int n3 = n2 / 4096;
        assert (addressRangeArray[0].getLength() > 16L);
        for (int i = 0; i < addressRangeArray.length; ++i) {
            long l = addressRangeArray[i].getStartAddress();
            if ((long)n >= addressRangeArray[i].getLength() || this.mutableBlockCache.get(l) != null) continue;
            for (int j = 0; j < n3; ++j) {
                byte[] byArray = new byte[4096];
                this.mutableBlockCache.put(l + (long)(j * 4096), byArray);
            }
            this.writeInt(l, (int)l);
            this.writeInt(l + 4L, n);
            log.fine("allocated 0x" + MutableAddressSpace.hex(n - 12) + " bytes at 0x" + MutableAddressSpace.hex(l + 8L));
            return l + 8L;
        }
        throw new IOException("could not malloc " + (n - 12));
    }

    public long rmalloc(int n) throws IOException {
        AddressRange[] addressRangeArray = this.getUnusedAddressRanges();
        n += 8;
        int n2 = (n += 4) + 4096 - 1 & 0xFFFFF000;
        int n3 = n2 / 4096;
        for (int i = addressRangeArray.length - n3; i >= 0; --i) {
            long l = addressRangeArray[i].getStartAddress();
            if ((long)n >= addressRangeArray[i].getLength() || this.mutableBlockCache.get(l) != null) continue;
            for (int j = 0; j < n3; ++j) {
                byte[] byArray = new byte[4096];
                this.mutableBlockCache.put(l + (long)(j * 4096), byArray);
            }
            this.writeInt(l, (int)l);
            this.writeInt(l + 4L, n);
            log.fine("allocated 0x" + MutableAddressSpace.hex(n - 12) + " bytes at 0x" + MutableAddressSpace.hex(l + 8L));
            return l + 8L;
        }
        throw new IOException("could not malloc " + (n - 12));
    }

    public void free(long l) throws IOException {
        if ((long)this.readInt(l -= 8L) != l) {
            return;
        }
        int n = this.readInt(l + 4L);
        assert (n >= 0 && n < 0x10000000);
        int n2 = n + 4096 - 1 & 0xFFFFF000;
        int n3 = n2 / 4096;
        for (int i = 0; i < n3; ++i) {
            Object object = this.mutableBlockCache.remove(l + (long)(i * 4096));
            assert (object != null);
        }
    }

    public void allocPage(long l) throws IOException {
        if (l % 4096L != 0L) {
            throw new IOException("address " + MutableAddressSpace.hex(l) + " not on page boundary");
        }
        if (this.isValidAddress(l) || this.mutableBlockCache.get(l) != null) {
            throw new IOException("address " + MutableAddressSpace.hex(l) + " already in use");
        }
        this.mutableBlockCache.put(l, new byte[4096]);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }
}

