/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;

public final class StringBuilder
extends AbstractStringBuilder
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = 4383685877147921099L;
    private static final int INITIAL_SIZE = 16;
    private static boolean TOSTRING_COPY_BUFFER_ENABLED = false;
    private static final JITHelpers helpers = JITHelpers.getHelpers();
    private static final int uncompressedBit = Integer.MIN_VALUE;
    private static final int sharedBit = Integer.MIN_VALUE;
    private transient int count;
    private transient char[] value;
    private transient int capacity;

    private int decompress(int n) {
        int n2;
        int n3 = this.lengthInternal();
        int n4 = this.capacityInternal();
        char[] cArray = null;
        cArray = n > n4 ? new char[n > (n2 = (n4 << 1) + 2) ? n : n2] : new char[n4];
        String.decompress(this.value, 0, cArray, 0, n3);
        this.count |= Integer.MIN_VALUE;
        this.value = cArray;
        this.capacity = cArray.length;
        String.initCompressionFlag();
        return this.capacity;
    }

    public StringBuilder() {
        this(16);
    }

    public StringBuilder(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        int n2 = n;
        if (String.enableCompression) {
            n2 = n == Integer.MAX_VALUE ? n / 2 + 1 : (n + 1) / 2;
        }
        this.value = new char[n2];
        this.capacity = n;
    }

    public StringBuilder(String string) {
        int n = string.lengthInternal();
        int n2 = n + 16;
        if (String.enableCompression) {
            if (string.isCompressed()) {
                this.value = new char[(n2 + 1) / 2];
                this.capacity = n2;
                string.getBytes(0, n, this.value, 0);
                this.count = n;
            } else {
                this.value = new char[n2];
                string.getCharsNoBoundChecks(0, n, this.value, 0);
                this.capacity = n2;
                this.count = n | Integer.MIN_VALUE;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[n2];
            string.getCharsNoBoundChecks(0, n, this.value, 0);
            this.capacity = n2;
            this.count = n;
        }
    }

    public StringBuilder append(char[] cArray) {
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        int n3 = n + cArray.length;
        if (String.enableCompression) {
            if (this.count >= 0 && String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                if (n3 > n2) {
                    this.ensureCapacityImpl(n3);
                }
                String.compress(cArray, 0, this.value, n, cArray.length);
                this.count = n3;
            } else {
                if (this.count >= 0) {
                    n2 = this.decompress(n3);
                }
                if (n3 > n2) {
                    this.ensureCapacityImpl(n3);
                }
                String.decompressedArrayCopy(cArray, 0, this.value, n, cArray.length);
                this.count = n3 | Integer.MIN_VALUE;
            }
        } else {
            if (n3 > n2) {
                this.ensureCapacityImpl(n3);
            }
            String.decompressedArrayCopy(cArray, 0, this.value, n, cArray.length);
            this.count = n3;
        }
        return this;
    }

    public StringBuilder append(char[] cArray, int n, int n2) {
        if (n >= 0 && 0 <= n2 && n2 <= cArray.length - n) {
            int n3 = this.lengthInternal();
            int n4 = this.capacityInternal();
            int n5 = n3 + n2;
            if (String.enableCompression) {
                if (this.count >= 0 && String.canEncodeAsLatin1(cArray, n, n2)) {
                    if (n5 > n4) {
                        this.ensureCapacityImpl(n5);
                    }
                    String.compress(cArray, n, this.value, n3, n2);
                    this.count = n5;
                } else {
                    if (this.count >= 0) {
                        n4 = this.decompress(n5);
                    }
                    if (n5 > n4) {
                        this.ensureCapacityImpl(n5);
                    }
                    String.decompressedArrayCopy(cArray, n, this.value, n3, n2);
                    this.count = n5 | Integer.MIN_VALUE;
                }
            } else {
                if (n5 > n4) {
                    this.ensureCapacityImpl(n5);
                }
                String.decompressedArrayCopy(cArray, n, this.value, n3, n2);
                this.count = n5;
            }
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    StringBuilder append(char[] cArray, int n, int n2, boolean bl) {
        int n3 = this.lengthInternal();
        int n4 = this.capacityInternal();
        int n5 = n3 + n2;
        if (String.enableCompression) {
            if (this.count >= 0 && bl) {
                if (n5 > n4) {
                    this.ensureCapacityImpl(n5);
                }
                String.compressedArrayCopy(cArray, n, this.value, n3, n2);
                this.count = n5;
            } else {
                if (this.count >= 0) {
                    n4 = this.decompress(n5);
                }
                if (n5 > n4) {
                    this.ensureCapacityImpl(n5);
                }
                if (bl) {
                    String.decompress(cArray, n, this.value, n3, n2);
                } else {
                    String.decompressedArrayCopy(cArray, n, this.value, n3, n2);
                }
                this.count = n5 | Integer.MIN_VALUE;
            }
        } else {
            if (n5 > n4) {
                this.ensureCapacityImpl(n5);
            }
            if (bl) {
                String.decompress(cArray, n, this.value, n3, n2);
            } else {
                String.decompressedArrayCopy(cArray, n, this.value, n3, n2);
            }
            this.count = n5;
        }
        return this;
    }

    @Override
    public StringBuilder append(char c) {
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        int n3 = n + 1;
        if (String.enableCompression) {
            if (this.count >= 0 && c <= '\u00ff') {
                if (n3 > n2) {
                    this.ensureCapacityImpl(n3);
                }
                helpers.putByteInArrayByIndex(this.value, n, (byte)c);
                this.count = n3;
            } else {
                if (this.count >= 0) {
                    n2 = this.decompress(n3);
                }
                if (n3 > n2) {
                    this.ensureCapacityImpl(n3);
                }
                this.value[n] = c;
                this.count = n3 | Integer.MIN_VALUE;
            }
        } else {
            if (n3 > n2) {
                this.ensureCapacityImpl(n3);
            }
            this.value[n] = c;
            this.count = n3;
        }
        return this;
    }

    public StringBuilder append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuilder append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuilder append(int n) {
        if (n != Integer.MIN_VALUE) {
            int n2;
            int n3;
            if (String.enableCompression && this.count >= 0) {
                return this.append(Integer.toString(n));
            }
            int n4 = this.lengthInternal();
            int n5 = n4 + (n3 = n < 0 ? Integer.stringSize(-n) + 1 : Integer.stringSize(n));
            if (n5 > (n2 = this.capacityInternal())) {
                this.ensureCapacityImpl(n5);
            }
            Integer.getChars(n, n5, this.value);
            this.count = String.enableCompression ? n5 | Integer.MIN_VALUE : n5;
            return this;
        }
        return this.append("-2147483648");
    }

    public StringBuilder append(long l) {
        if (l != Long.MIN_VALUE) {
            int n;
            int n2;
            if (String.enableCompression && this.count >= 0) {
                return this.append(Long.toString(l));
            }
            int n3 = this.lengthInternal();
            int n4 = n3 + (n2 = l < 0L ? Long.stringSize(-l) + 1 : Long.stringSize(l));
            if (n4 > (n = this.capacityInternal())) {
                this.ensureCapacityImpl(n4);
            }
            Long.getChars(l, n4, this.value);
            this.count = String.enableCompression ? n4 | Integer.MIN_VALUE : n4;
            return this;
        }
        return this.append("-9223372036854775808");
    }

    public StringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public StringBuilder append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        int n3 = string.lengthInternal();
        int n4 = n + n3;
        if (String.enableCompression) {
            if (this.count >= 0 && string.isCompressed()) {
                if (n4 > n2) {
                    this.ensureCapacityImpl(n4);
                }
                string.getBytes(0, n3, this.value, n);
                this.count = n4;
            } else {
                if (this.count >= 0) {
                    n2 = this.decompress(n4);
                }
                if (n4 > n2) {
                    this.ensureCapacityImpl(n4);
                }
                string.getCharsNoBoundChecks(0, n3, this.value, n);
                this.count = n4 | Integer.MIN_VALUE;
            }
        } else {
            if (n4 > n2) {
                this.ensureCapacityImpl(n4);
            }
            string.getCharsNoBoundChecks(0, n3, this.value, n);
            this.count = n4;
        }
        return this;
    }

    public StringBuilder append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public int capacity() {
        return this.capacityInternal();
    }

    int capacityInternal() {
        return this.capacity & Integer.MAX_VALUE;
    }

    @Override
    public char charAt(int n) {
        int n2 = this.lengthInternal();
        if (n >= 0 && n < n2) {
            if (String.enableCompression && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n));
            }
            return this.value[n];
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuilder delete(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n >= 0) {
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 > n) {
                int n4 = n3 - n2;
                try {
                    if (this.capacity >= 0) {
                        if (n4 > 0) {
                            if (String.enableCompression && this.count >= 0) {
                                String.compressedArrayCopy(this.value, n2, this.value, n, n4);
                            } else {
                                String.decompressedArrayCopy(this.value, n2, this.value, n, n4);
                            }
                        }
                    } else {
                        char[] cArray = new char[this.value.length];
                        if (String.enableCompression && this.count >= 0) {
                            if (n > 0) {
                                String.compressedArrayCopy(this.value, 0, cArray, 0, n);
                            }
                            if (n4 > 0) {
                                String.compressedArrayCopy(this.value, n2, cArray, n, n4);
                            }
                        } else {
                            if (n > 0) {
                                String.decompressedArrayCopy(this.value, 0, cArray, 0, n);
                            }
                            if (n4 > 0) {
                                String.decompressedArrayCopy(this.value, n2, cArray, n, n4);
                            }
                        }
                        this.value = cArray;
                        this.capacity &= Integer.MAX_VALUE;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new StringIndexOutOfBoundsException();
                }
                if (String.enableCompression) {
                    if (this.count >= 0) {
                        this.count = n3 - (n2 - n);
                    } else {
                        this.count = n3 - (n2 - n) | Integer.MIN_VALUE;
                        String.initCompressionFlag();
                    }
                } else {
                    this.count = n3 - (n2 - n);
                }
                return this;
            }
            if (n == n2) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder deleteCharAt(int n) {
        int n2 = this.lengthInternal();
        if (n2 != 0) {
            return this.delete(n, n + 1);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public void ensureCapacity(int n) {
        int n2 = this.capacityInternal();
        if (n > n2) {
            this.ensureCapacityImpl(n);
        }
    }

    private void ensureCapacityImpl(int n) {
        int n2;
        int n3 = this.lengthInternal();
        int n4 = this.capacityInternal();
        int n5 = (n4 << 1) + 2;
        int n6 = n2 = n > n5 ? n : n5;
        if (String.enableCompression && this.count >= 0) {
            char[] cArray = new char[(n2 + 1) / 2];
            String.compressedArrayCopy(this.value, 0, cArray, 0, n3);
            this.value = cArray;
        } else {
            char[] cArray = new char[n2];
            String.decompressedArrayCopy(this.value, 0, cArray, 0, n3);
            this.value = cArray;
        }
        this.capacity = n2;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        try {
            int n4 = this.lengthInternal();
            if (n <= n4 && n2 <= n4 && n >= 0 && n <= n2 && n3 >= 0 && n2 - n <= cArray.length - n3) {
                if (String.enableCompression && this.count >= 0) {
                    String.decompress(this.value, n, cArray, n3, n2 - n);
                    return;
                }
                System.arraycopy((Object)this.value, n, (Object)cArray, n3, n2 - n);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder insert(int n, char[] cArray) {
        int n2 = this.lengthInternal();
        if (0 <= n && n <= n2) {
            this.move(cArray.length, n);
            if (String.enableCompression) {
                if (this.count >= 0 && String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                    String.compress(cArray, 0, this.value, n, cArray.length);
                    this.count = n2 + cArray.length;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(this.value.length);
                }
                String.decompressedArrayCopy(cArray, 0, this.value, n, cArray.length);
                this.count = n2 + cArray.length | Integer.MIN_VALUE;
                return this;
            }
            String.decompressedArrayCopy(cArray, 0, this.value, n, cArray.length);
            this.count = n2 + cArray.length;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuilder insert(int n, char[] cArray, int n2, int n3) {
        int n4 = this.lengthInternal();
        if (0 <= n && n <= n4) {
            if (n2 >= 0 && 0 <= n3 && n3 <= cArray.length - n2) {
                this.move(n3, n);
                if (String.enableCompression) {
                    if (this.count >= 0 && String.canEncodeAsLatin1(cArray, n2, n3)) {
                        String.compress(cArray, n2, this.value, n, n3);
                        this.count = n4 + n3;
                        return this;
                    }
                    if (this.count >= 0) {
                        this.decompress(this.value.length);
                    }
                    String.decompressedArrayCopy(cArray, n2, this.value, n, n3);
                    this.count = n4 + n3 | Integer.MIN_VALUE;
                    return this;
                }
                String.decompressedArrayCopy(cArray, n2, this.value, n, n3);
                this.count = n4 + n3;
                return this;
            }
            throw new StringIndexOutOfBoundsException();
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    StringBuilder insert(int n, char[] cArray, int n2, int n3, boolean bl) {
        int n4 = this.lengthInternal();
        this.move(n3, n);
        if (String.enableCompression) {
            if (this.count >= 0 && bl) {
                String.compressedArrayCopy(cArray, n2, this.value, n, n3);
                this.count = n4 + n3;
                return this;
            }
            if (this.count >= 0) {
                this.decompress(this.value.length);
            }
            String.decompressedArrayCopy(cArray, n2, this.value, n, n3);
            this.count = n4 + n3 | Integer.MIN_VALUE;
            return this;
        }
        String.decompressedArrayCopy(cArray, n2, this.value, n, n3);
        this.count = n4 + n3;
        return this;
    }

    public StringBuilder insert(int n, char c) {
        int n2 = this.lengthInternal();
        if (0 <= n && n <= n2) {
            this.move(1, n);
            if (String.enableCompression) {
                if (this.count >= 0 && c <= '\u00ff') {
                    helpers.putByteInArrayByIndex(this.value, n, (byte)c);
                    this.count = n2 + 1;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(this.value.length);
                }
                this.value[n] = c;
                this.count = n2 + 1 | Integer.MIN_VALUE;
                return this;
            }
            this.value[n] = c;
            this.count = n2 + 1;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public StringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StringBuilder insert(int n, int n2) {
        return this.insert(n, Integer.toString(n2));
    }

    public StringBuilder insert(int n, long l) {
        return this.insert(n, Long.toString(l));
    }

    public StringBuilder insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public StringBuilder insert(int n, String string) {
        int n2 = this.lengthInternal();
        if (0 <= n && n <= n2) {
            if (string == null) {
                string = "null";
            }
            int n3 = string.lengthInternal();
            this.move(n3, n);
            if (String.enableCompression) {
                if (this.count >= 0 && string.isCompressed()) {
                    string.getBytes(0, n3, this.value, n);
                    this.count = n2 + n3;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(this.value.length);
                }
                string.getCharsNoBoundChecks(0, n3, this.value, n);
                this.count = n2 + n3 | Integer.MIN_VALUE;
                return this;
            }
            string.getCharsNoBoundChecks(0, n3, this.value, n);
            this.count = n2 + n3;
            return this;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public StringBuilder insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    @Override
    public int length() {
        return this.lengthInternal();
    }

    int lengthInternal() {
        if (String.enableCompression) {
            if (this.count >= 0) {
                return this.count;
            }
            return this.count & Integer.MAX_VALUE;
        }
        return this.count;
    }

    private void move(int n, int n2) {
        int n3 = this.lengthInternal();
        int n4 = this.capacityInternal();
        if (String.enableCompression && this.count >= 0) {
            int n5;
            if (n4 - n3 >= n) {
                if (this.capacity >= 0) {
                    String.compressedArrayCopy(this.value, n2, this.value, n2 + n, n3 - n2);
                    return;
                }
                n5 = n4;
            } else {
                n5 = Integer.max(n3 + n, (n4 << 1) + 2);
            }
            char[] cArray = new char[(n5 + 1) / 2];
            String.compressedArrayCopy(this.value, 0, cArray, 0, n2);
            String.compressedArrayCopy(this.value, n2, cArray, n2 + n, n3 - n2);
            this.value = cArray;
            this.capacity = n5;
        } else {
            int n6;
            if (n4 - n3 >= n) {
                if (this.capacity >= 0) {
                    String.decompressedArrayCopy(this.value, n2, this.value, n2 + n, n3 - n2);
                    return;
                }
                n6 = n4;
            } else {
                n6 = Integer.max(n3 + n, (n4 << 1) + 2);
            }
            char[] cArray = new char[n6];
            String.decompressedArrayCopy(this.value, 0, cArray, 0, n2);
            String.decompressedArrayCopy(this.value, n2, cArray, n2 + n, n3 - n2);
            this.value = cArray;
            this.capacity = n6;
        }
    }

    public StringBuilder replace(int n, int n2, String string) {
        int n3 = this.lengthInternal();
        if (String.enableCompression) {
            if (this.count >= 0 && string.isCompressed()) {
                if (n >= 0) {
                    if (n2 > n3) {
                        n2 = n3;
                    }
                    if (n2 > n) {
                        int n4 = string.lengthInternal();
                        int n5 = n2 - n - n4;
                        if (n5 > 0) {
                            if (this.capacity >= 0) {
                                String.compressedArrayCopy(this.value, n2, this.value, n + n4, n3 - n2);
                            } else {
                                char[] cArray = new char[this.value.length];
                                String.compressedArrayCopy(this.value, 0, cArray, 0, n);
                                String.compressedArrayCopy(this.value, n2, cArray, n + n4, n3 - n2);
                                this.value = cArray;
                                this.capacity &= Integer.MAX_VALUE;
                            }
                        } else if (n5 < 0) {
                            this.move(-n5, n2);
                        } else if (this.capacity < 0) {
                            this.value = (char[])this.value.clone();
                            this.capacity &= Integer.MAX_VALUE;
                        }
                        string.getBytes(0, n4, this.value, n);
                        this.count = n3 - n5;
                        return this;
                    }
                    if (n == n2) {
                        return this.insert(n, string);
                    }
                }
            } else {
                if (this.count >= 0) {
                    this.decompress(this.value.length);
                }
                if (n >= 0) {
                    if (n2 > n3) {
                        n2 = n3;
                    }
                    if (n2 > n) {
                        int n6 = string.lengthInternal();
                        int n7 = n2 - n - n6;
                        if (n7 > 0) {
                            if (this.capacity >= 0) {
                                String.decompressedArrayCopy(this.value, n2, this.value, n + n6, n3 - n2);
                            } else {
                                char[] cArray = new char[this.value.length];
                                String.decompressedArrayCopy(this.value, 0, cArray, 0, n);
                                String.decompressedArrayCopy(this.value, n2, cArray, n + n6, n3 - n2);
                                this.value = cArray;
                                this.capacity &= Integer.MAX_VALUE;
                            }
                        } else if (n7 < 0) {
                            this.move(-n7, n2);
                        } else if (this.capacity < 0) {
                            this.value = (char[])this.value.clone();
                            this.capacity &= Integer.MAX_VALUE;
                        }
                        string.getCharsNoBoundChecks(0, n6, this.value, n);
                        this.count = n3 - n7 | Integer.MIN_VALUE;
                        return this;
                    }
                    if (n == n2) {
                        string.getClass();
                        return this.insert(n, string);
                    }
                }
            }
        } else if (n >= 0) {
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 > n) {
                int n8 = string.lengthInternal();
                int n9 = n2 - n - n8;
                if (n9 > 0) {
                    if (this.capacity >= 0) {
                        String.decompressedArrayCopy(this.value, n2, this.value, n + n8, n3 - n2);
                    } else {
                        char[] cArray = new char[this.value.length];
                        String.decompressedArrayCopy(this.value, 0, cArray, 0, n);
                        String.decompressedArrayCopy(this.value, n2, cArray, n + n8, n3 - n2);
                        this.value = cArray;
                        this.capacity &= Integer.MAX_VALUE;
                    }
                } else if (n9 < 0) {
                    this.move(-n9, n2);
                } else if (this.capacity < 0) {
                    this.value = (char[])this.value.clone();
                    this.capacity &= Integer.MAX_VALUE;
                }
                string.getCharsNoBoundChecks(0, n8, this.value, n);
                this.count = n3 - n9;
                return this;
            }
            if (n == n2) {
                string.getClass();
                return this.insert(n, string);
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder reverse() {
        int n = this.lengthInternal();
        if (n < 2) {
            return this;
        }
        if (String.enableCompression && this.count >= 0) {
            if (this.capacity >= 0) {
                int n2 = 0;
                int n3 = n / 2;
                int n4 = n - 1;
                while (n2 < n3) {
                    byte by = helpers.getByteFromArrayByIndex(this.value, n2);
                    byte by2 = helpers.getByteFromArrayByIndex(this.value, n4);
                    helpers.putByteInArrayByIndex(this.value, n2, by2);
                    helpers.putByteInArrayByIndex(this.value, n4, by);
                    ++n2;
                    --n4;
                }
                return this;
            }
            char[] cArray = new char[this.value.length];
            int n5 = 0;
            int n6 = n - 1;
            while (n5 < n) {
                helpers.putByteInArrayByIndex(cArray, n6, helpers.getByteFromArrayByIndex(this.value, n5));
                ++n5;
                --n6;
            }
            this.value = cArray;
            this.capacity &= Integer.MAX_VALUE;
            return this;
        }
        if (this.capacity >= 0) {
            int n7 = n - 1;
            char c = this.value[0];
            char c2 = this.value[n7];
            boolean bl = true;
            boolean bl2 = true;
            int n8 = 0;
            int n9 = n / 2;
            while (n8 < n9) {
                char c3 = this.value[n8 + 1];
                char c4 = this.value[n7 - 1];
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl && c3 >= '\udc00' && c3 <= '\udfff' && c >= '\ud800' && c <= '\udbff') {
                    bl3 = true;
                    if (n < 3) {
                        return this;
                    }
                }
                if (bl2 && c4 >= '\ud800' && c4 <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                    bl4 = true;
                }
                bl = true;
                bl2 = true;
                if (bl3 == bl4) {
                    if (bl3) {
                        this.value[n7] = c3;
                        this.value[n7 - 1] = c;
                        this.value[n8] = c4;
                        this.value[n8 + 1] = c2;
                        c = this.value[n8 + 2];
                        c2 = this.value[n7 - 2];
                        ++n8;
                        --n7;
                    } else {
                        this.value[n7] = c;
                        this.value[n8] = c2;
                        c = c3;
                        c2 = c4;
                    }
                } else if (bl3) {
                    this.value[n7] = c3;
                    this.value[n8] = c2;
                    c2 = c4;
                    bl = false;
                } else {
                    this.value[n7] = c;
                    this.value[n8] = c4;
                    c = c3;
                    bl2 = false;
                }
                ++n8;
                --n7;
            }
            if (!((n & 1) != 1 || bl && bl2)) {
                this.value[n7] = bl ? c2 : c;
            }
        } else {
            char[] cArray = new char[this.value.length];
            int n10 = n;
            for (int i = 0; i < n; ++i) {
                char c;
                char c5 = this.value[i];
                if (i + 1 < n && c5 >= '\ud800' && c5 <= '\udbff' && (c = this.value[i + 1]) >= '\udc00' && c <= '\udfff') {
                    cArray[--n10] = c;
                    ++i;
                }
                cArray[--n10] = c5;
            }
            this.value = cArray;
            this.capacity &= Integer.MAX_VALUE;
        }
        return this;
    }

    public void setCharAt(int n, char c) {
        int n2 = this.lengthInternal();
        if (0 <= n && n < n2) {
            if (String.enableCompression) {
                if (this.count >= 0 && c <= '\u00ff') {
                    if (this.capacity < 0) {
                        this.value = (char[])this.value.clone();
                        this.capacity &= Integer.MAX_VALUE;
                    }
                    helpers.putByteInArrayByIndex(this.value, n, (byte)c);
                } else {
                    if (this.count >= 0) {
                        this.decompress(this.value.length);
                    }
                    if (this.capacity < 0) {
                        this.value = (char[])this.value.clone();
                        this.capacity &= Integer.MAX_VALUE;
                    }
                    this.value[n] = c;
                }
            } else {
                if (this.capacity < 0) {
                    this.value = (char[])this.value.clone();
                    this.capacity &= Integer.MAX_VALUE;
                }
                this.value[n] = c;
            }
        } else {
            throw new StringIndexOutOfBoundsException(n);
        }
    }

    public void setLength(int n) {
        int n2 = this.lengthInternal();
        int n3 = this.capacityInternal();
        if (String.enableCompression && this.count >= 0) {
            if (n > n3) {
                this.ensureCapacityImpl(n);
            } else if (n > n2) {
                for (int i = n2; i < n; ++i) {
                    helpers.putByteInArrayByIndex(this.value, i, (byte)0);
                }
            } else if (this.capacity < 0) {
                if (n < 0) {
                    throw new IndexOutOfBoundsException();
                }
                char[] cArray = new char[this.value.length];
                if (n > 0) {
                    String.compressedArrayCopy(this.value, 0, cArray, 0, n);
                }
                this.value = cArray;
                this.capacity &= Integer.MAX_VALUE;
            } else if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
        } else if (n > n3) {
            this.ensureCapacityImpl(n);
        } else if (n > n2) {
            Arrays.fill(this.value, n2, n, '\u0000');
        } else if (this.capacity < 0) {
            if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
            char[] cArray = new char[this.value.length];
            if (n > 0) {
                String.decompressedArrayCopy(this.value, 0, cArray, 0, n);
            }
            this.value = cArray;
            this.capacity &= Integer.MAX_VALUE;
        } else if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.count = String.enableCompression ? (this.count >= 0 ? n : n | Integer.MIN_VALUE) : n;
    }

    public String substring(int n) {
        int n2 = this.lengthInternal();
        if (String.enableCompression && this.count >= 0) {
            if (0 <= n && n <= n2) {
                return new String(this.value, n, n2 - n, true, false);
            }
        } else if (0 <= n && n <= n2) {
            return new String(this.value, n, n2 - n, false, false);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public String substring(int n, int n2) {
        int n3 = this.lengthInternal();
        if (String.enableCompression && this.count >= 0) {
            if (0 <= n && n <= n2 && n2 <= n3) {
                return new String(this.value, n, n2 - n, true, false);
            }
        } else if (0 <= n && n <= n2 && n2 <= n3) {
            return new String(this.value, n, n2 - n, false, false);
        }
        throw new StringIndexOutOfBoundsException();
    }

    static void initFromSystemProperties(Properties properties) {
        String string = properties.getProperty("java.lang.string.create.unique");
        TOSTRING_COPY_BUFFER_ENABLED = "true".equals(string) || "StringBuilder".equals(string);
    }

    @Override
    public String toString() {
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        if (!TOSTRING_COPY_BUFFER_ENABLED) {
            int n3 = n2 - n;
            if (n3 >= 768 || n3 >= 16 && n3 >= n2 >> 1) {
                if (String.enableCompression && this.count >= 0) {
                    return new String(this.value, 0, n, true, false);
                }
                return new String(this.value, 0, n, false, false);
            }
        } else {
            int n4 = n + 3 & 0xFFFFFFFC;
            if (n4 < n2) {
                if (String.enableCompression && this.count >= 0) {
                    return new String(this.value, 0, n, true, false);
                }
                return new String(this.value, 0, n, false, false);
            }
        }
        this.capacity |= Integer.MIN_VALUE;
        if (String.enableCompression && this.count >= 0) {
            return new String(this.value, 0, n, true);
        }
        return new String(this.value, 0, n, false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.lengthInternal();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        if (String.enableCompression && this.count >= 0) {
            char[] cArray = new char[n];
            String.decompress(this.value, 0, cArray, 0, n);
            objectOutputStream.writeObject(cArray);
        } else {
            objectOutputStream.writeObject(this.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        char[] cArray = (char[])objectInputStream.readObject();
        if (n > cArray.length) {
            throw new InvalidObjectException(Msg.getString("K0199"));
        }
        if (String.enableCompression) {
            if (String.canEncodeAsLatin1(cArray, 0, cArray.length)) {
                this.value = cArray.length == Integer.MAX_VALUE ? new char[cArray.length / 2 + 1] : new char[(cArray.length + 1) / 2];
                String.compress(cArray, 0, this.value, 0, cArray.length);
                this.count = n;
                this.capacity = cArray.length;
            } else {
                this.value = new char[cArray.length];
                System.arraycopy((Object)cArray, 0, (Object)this.value, 0, cArray.length);
                this.count = n | Integer.MIN_VALUE;
                this.capacity = cArray.length;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[cArray.length];
            System.arraycopy((Object)cArray, 0, (Object)this.value, 0, cArray.length);
            this.count = n;
            this.capacity = cArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append((String)null);
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            if (String.enableCompression && stringBuffer.isCompressed()) {
                return this.append(stringBuffer.getValue(), 0, stringBuffer.length(), true);
            }
            return this.append(stringBuffer.getValue(), 0, stringBuffer.length(), false);
        }
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        int n3 = this.lengthInternal();
        if (n < 0) {
            n = 0;
        }
        if ((n2 = string.lengthInternal()) > 0) {
            if (n2 + n > n3) {
                return -1;
            }
            char c = string.charAtInternal(0);
            if (String.enableCompression && this.count >= 0) {
                if (!string.isCompressed()) {
                    return -1;
                }
                while (true) {
                    int n4;
                    boolean bl = false;
                    for (n4 = n; n4 < n3; ++n4) {
                        if (helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n4)) != c) continue;
                        bl = true;
                        break;
                    }
                    if (!bl || n2 + n4 > n3) {
                        return -1;
                    }
                    int n5 = n4;
                    int n6 = 0;
                    while (++n6 < n2 && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, ++n5)) == string.charAtInternal(n6)) {
                    }
                    if (n6 == n2) {
                        return n4;
                    }
                    n = n4 + 1;
                }
            }
            while (true) {
                int n7;
                boolean bl = false;
                for (n7 = n; n7 < n3; ++n7) {
                    if (this.value[n7] != c) continue;
                    bl = true;
                    break;
                }
                if (!bl || n2 + n7 > n3) {
                    return -1;
                }
                int n8 = n7;
                int n9 = 0;
                while (++n9 < n2 && this.value[++n8] == string.charAtInternal(n9)) {
                }
                if (n9 == n2) {
                    return n7;
                }
                n = n7 + 1;
            }
        }
        return n < n3 || n == 0 ? n : n3;
    }

    public int lastIndexOf(String string) {
        int n = this.lengthInternal();
        return this.lastIndexOf(string, n);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = this.lengthInternal();
        int n3 = string.lengthInternal();
        if (n3 <= n2 && n >= 0) {
            if (n3 > 0) {
                if (n > n2 - n3) {
                    n = n2 - n3;
                }
                char c = string.charAtInternal(0);
                if (String.enableCompression && this.count >= 0) {
                    if (!string.isCompressed()) {
                        return -1;
                    }
                    while (true) {
                        int n4;
                        boolean bl = false;
                        for (n4 = n; n4 >= 0; --n4) {
                            if (helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n4)) != c) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            return -1;
                        }
                        int n5 = n4;
                        int n6 = 0;
                        while (++n6 < n3 && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, ++n5)) == string.charAtInternal(n6)) {
                        }
                        if (n6 == n3) {
                            return n4;
                        }
                        n = n4 - 1;
                    }
                }
                while (true) {
                    int n7;
                    boolean bl = false;
                    for (n7 = n; n7 >= 0; --n7) {
                        if (this.value[n7] != c) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return -1;
                    }
                    int n8 = n7;
                    int n9 = 0;
                    while (++n9 < n3 && this.value[++n8] == string.charAtInternal(n9)) {
                    }
                    if (n9 == n3) {
                        return n7;
                    }
                    n = n7 - 1;
                }
            }
            return n < n2 ? n : n2;
        }
        return -1;
    }

    char[] shareValue() {
        this.capacity |= Integer.MIN_VALUE;
        return this.value;
    }

    boolean isCompressed() {
        return String.enableCompression && this.count >= 0;
    }

    public StringBuilder(CharSequence charSequence) {
        int n = charSequence.length();
        if (n < 0) {
            n = 0;
        }
        int n2 = 16 + n;
        this.value = String.enableCompression ? new char[(n2 + 1) / 2] : new char[n2];
        this.capacity = n2;
        if (charSequence instanceof String) {
            this.append((String)charSequence);
        } else if (charSequence instanceof StringBuffer) {
            this.append((StringBuffer)charSequence);
        } else if (String.enableCompression) {
            int n3;
            boolean bl = true;
            for (n3 = 0; n3 < n; ++n3) {
                if (charSequence.charAt(n3) <= '\u00ff') continue;
                bl = false;
                break;
            }
            if (bl) {
                this.count = n;
                for (n3 = 0; n3 < n; ++n3) {
                    helpers.putByteInArrayByIndex(this.value, n3, (byte)charSequence.charAt(n3));
                }
            } else {
                this.value = new char[n2];
                this.count = n | Integer.MIN_VALUE;
                for (n3 = 0; n3 < n; ++n3) {
                    this.value[n3] = charSequence.charAt(n3);
                }
                String.initCompressionFlag();
            }
        } else {
            this.count = n;
            for (int i = 0; i < n; ++i) {
                this.value[i] = charSequence.charAt(i);
            }
        }
    }

    @Override
    public StringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.append(String.valueOf(charSequence));
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof StringBuffer) {
            return this.append((StringBuffer)charSequence);
        }
        if (charSequence instanceof StringBuilder) {
            StringBuilder stringBuilder = (StringBuilder)charSequence;
            if (String.enableCompression && stringBuilder.count >= 0) {
                return this.append(stringBuilder.value, 0, stringBuilder.lengthInternal(), true);
            }
            return this.append(stringBuilder.value, 0, stringBuilder.lengthInternal(), false);
        }
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        int n3 = charSequence.length();
        int n4 = n + n3;
        if (String.enableCompression) {
            int n5;
            boolean bl = true;
            if (this.count >= 0) {
                for (n5 = 0; n5 < charSequence.length(); ++n5) {
                    if (charSequence.charAt(n5) <= '\u00ff') continue;
                    bl = false;
                    break;
                }
            }
            if (this.count >= 0 && bl) {
                if (n4 > n2) {
                    this.ensureCapacityImpl(n4);
                }
                for (n5 = 0; n5 < charSequence.length(); ++n5) {
                    helpers.putByteInArrayByIndex(this.value, n + n5, (byte)charSequence.charAt(n5));
                }
                this.count = n4;
            } else {
                if (this.count >= 0) {
                    n2 = this.decompress(n4);
                }
                if (n4 > n2) {
                    this.ensureCapacityImpl(n4);
                }
                for (n5 = 0; n5 < charSequence.length(); ++n5) {
                    this.value[n + n5] = charSequence.charAt(n5);
                }
                this.count = n4 | Integer.MIN_VALUE;
            }
        } else {
            if (n4 > n2) {
                this.ensureCapacityImpl(n4);
            }
            for (int i = 0; i < charSequence.length(); ++i) {
                this.value[n + i] = charSequence.charAt(i);
            }
            this.count = n4;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.append(String.valueOf(charSequence), n, n2);
        }
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            if (n >= 0 && n <= n2 && n2 <= string.lengthInternal()) {
                int n3 = this.lengthInternal();
                int n4 = this.capacityInternal();
                int n5 = n3 + n2 - n;
                if (String.enableCompression) {
                    if (this.count >= 0 && string.isCompressed()) {
                        if (n5 > n4) {
                            this.ensureCapacityImpl(n5);
                        }
                        string.getBytes(n, n2, this.value, n3);
                        this.count = n5;
                    } else {
                        if (this.count >= 0) {
                            n4 = this.decompress(n5);
                        }
                        if (n5 > n4) {
                            this.ensureCapacityImpl(n5);
                        }
                        string.getCharsNoBoundChecks(n, n2, this.value, n3);
                        this.count = n5 | Integer.MIN_VALUE;
                    }
                } else {
                    if (n5 > n4) {
                        this.ensureCapacityImpl(n5);
                    }
                    string.getCharsNoBoundChecks(n, n2, this.value, n3);
                    this.count = n5;
                }
                return this;
            }
            throw new IndexOutOfBoundsException();
        }
        if (n >= 0 && n2 >= 0 && n <= n2 && n2 <= charSequence.length()) {
            if (charSequence instanceof StringBuffer) {
                CharSequence charSequence2 = charSequence;
                synchronized (charSequence2) {
                    StringBuffer stringBuffer = (StringBuffer)charSequence;
                    if (String.enableCompression && stringBuffer.isCompressed()) {
                        return this.append(stringBuffer.getValue(), n, n2 - n, true);
                    }
                    return this.append(stringBuffer.getValue(), n, n2 - n, false);
                }
            }
            if (charSequence instanceof StringBuilder) {
                CharSequence charSequence3 = charSequence;
                synchronized (charSequence3) {
                    StringBuilder stringBuilder = (StringBuilder)charSequence;
                    if (String.enableCompression && stringBuilder.count >= 0) {
                        return this.append(stringBuilder.value, n, n2 - n, true);
                    }
                    return this.append(stringBuilder.value, n, n2 - n, false);
                }
            }
            int n6 = this.lengthInternal();
            int n7 = this.capacityInternal();
            int n8 = n6 + n2 - n;
            if (String.enableCompression) {
                int n9;
                boolean bl = true;
                if (this.count >= 0) {
                    for (n9 = 0; n9 < charSequence.length(); ++n9) {
                        if (charSequence.charAt(n9) <= '\u00ff') continue;
                        bl = false;
                        break;
                    }
                }
                if (this.count >= 0 && bl) {
                    if (n8 > n7) {
                        this.ensureCapacityImpl(n8);
                    }
                    for (n9 = 0; n9 < n2 - n; ++n9) {
                        helpers.putByteInArrayByIndex(this.value, n6 + n9, (byte)charSequence.charAt(n + n9));
                    }
                    this.count = n8;
                } else {
                    if (this.count >= 0) {
                        n7 = this.decompress(n8);
                    }
                    if (n8 > n7) {
                        this.ensureCapacityImpl(n8);
                    }
                    for (n9 = 0; n9 < n2 - n; ++n9) {
                        this.value[n6 + n9] = charSequence.charAt(n + n9);
                    }
                    this.count = n8 | Integer.MIN_VALUE;
                }
            } else {
                if (n8 > n7) {
                    this.ensureCapacityImpl(n8);
                }
                for (int i = 0; i < n2 - n; ++i) {
                    this.value[n6 + i] = charSequence.charAt(n + i);
                }
                this.count = n8;
            }
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder insert(int n, CharSequence charSequence) {
        int n2 = this.lengthInternal();
        if (n >= 0 && n <= n2) {
            if (charSequence == null) {
                return this.insert(n, String.valueOf(charSequence));
            }
            if (charSequence instanceof String) {
                return this.insert(n, (String)charSequence);
            }
            if (charSequence instanceof StringBuffer) {
                CharSequence charSequence2 = charSequence;
                synchronized (charSequence2) {
                    StringBuffer stringBuffer = (StringBuffer)charSequence;
                    if (String.enableCompression && stringBuffer.isCompressed()) {
                        return this.insert(n, stringBuffer.getValue(), 0, stringBuffer.length(), true);
                    }
                    return this.insert(n, stringBuffer.getValue(), 0, stringBuffer.length(), false);
                }
            }
            if (charSequence instanceof StringBuilder) {
                CharSequence charSequence3 = charSequence;
                synchronized (charSequence3) {
                    StringBuilder stringBuilder = (StringBuilder)charSequence;
                    if (String.enableCompression && stringBuilder.count >= 0) {
                        return this.insert(n, stringBuilder.value, 0, stringBuilder.lengthInternal(), true);
                    }
                    return this.insert(n, stringBuilder.value, 0, stringBuilder.lengthInternal(), false);
                }
            }
            int n3 = charSequence.length();
            if (n3 > 0) {
                this.move(n3, n);
                int n4 = n2 + n3;
                if (String.enableCompression) {
                    int n5;
                    boolean bl = true;
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (charSequence.charAt(n5) <= '\u00ff') continue;
                        bl = false;
                        break;
                    }
                    if (this.count >= 0 && bl) {
                        for (n5 = 0; n5 < n3; ++n5) {
                            helpers.putByteInArrayByIndex(this.value, n + n5, (byte)charSequence.charAt(n5));
                        }
                        this.count = n4;
                        return this;
                    }
                    if (this.count >= 0) {
                        this.decompress(this.value.length);
                    }
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.value[n + n5] = charSequence.charAt(n5);
                    }
                    this.count = n4 | Integer.MIN_VALUE;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        this.value[n + i] = charSequence.charAt(i);
                    }
                    this.count = n4;
                }
            }
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        int n4 = this.lengthInternal();
        if (n >= 0 && n <= n4) {
            if (charSequence == null) {
                return this.insert(n, String.valueOf(charSequence), n2, n3);
            }
            if (charSequence instanceof String) {
                return this.insert(n, ((String)charSequence).substring(n2, n3));
            }
            if (n2 >= 0 && n3 >= 0 && n2 <= n3 && n3 <= charSequence.length()) {
                if (charSequence instanceof StringBuffer) {
                    CharSequence charSequence2 = charSequence;
                    synchronized (charSequence2) {
                        StringBuffer stringBuffer = (StringBuffer)charSequence;
                        if (String.enableCompression && stringBuffer.isCompressed()) {
                            return this.insert(n, stringBuffer.getValue(), n2, n3 - n2, true);
                        }
                        return this.insert(n, stringBuffer.getValue(), n2, n3 - n2, false);
                    }
                }
                if (charSequence instanceof StringBuilder) {
                    CharSequence charSequence3 = charSequence;
                    synchronized (charSequence3) {
                        StringBuilder stringBuilder = (StringBuilder)charSequence;
                        if (String.enableCompression && stringBuilder.count >= 0) {
                            return this.insert(n, stringBuilder.value, n2, n3 - n2, true);
                        }
                        return this.insert(n, stringBuilder.value, n2, n3 - n2, false);
                    }
                }
                int n5 = n3 - n2;
                if (n5 > 0) {
                    this.move(n5, n);
                    int n6 = n4 + n5;
                    if (String.enableCompression) {
                        int n7;
                        boolean bl = true;
                        for (n7 = 0; n7 < n5; ++n7) {
                            if (charSequence.charAt(n2 + n7) <= '\u00ff') continue;
                            bl = false;
                            break;
                        }
                        if (this.count >= 0 && bl) {
                            for (n7 = 0; n7 < n5; ++n7) {
                                helpers.putByteInArrayByIndex(this.value, n + n7, (byte)charSequence.charAt(n2 + n7));
                            }
                            this.count = n6;
                            return this;
                        }
                        if (this.count >= 0) {
                            this.decompress(this.value.length);
                        }
                        for (n7 = 0; n7 < n5; ++n7) {
                            this.value[n + n7] = charSequence.charAt(n2 + n7);
                        }
                        this.count = n6 | Integer.MIN_VALUE;
                    } else {
                        for (int i = 0; i < n5; ++i) {
                            this.value[n + i] = charSequence.charAt(n2 + i);
                        }
                        this.count = n6;
                    }
                }
                return this;
            }
            throw new IndexOutOfBoundsException();
        }
        throw new IndexOutOfBoundsException();
    }

    public void trimToSize() {
        int n = this.lengthInternal();
        int n2 = this.capacityInternal();
        if (String.enableCompression && this.count >= 0) {
            if (this.capacity >= 0 && n2 != n) {
                char[] cArray = new char[(n + 1) / 2];
                String.compressedArrayCopy(this.value, 0, cArray, 0, n);
                this.value = cArray;
                this.capacity = n;
            }
        } else if (this.capacity >= 0 && n2 != n) {
            char[] cArray = new char[n];
            String.decompressedArrayCopy(this.value, 0, cArray, 0, n);
            this.value = cArray;
            this.capacity = n;
        }
    }

    public int codePointAt(int n) {
        int n2 = this.lengthInternal();
        if (n >= 0 && n < n2) {
            char c;
            if (String.enableCompression && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n));
            }
            char c2 = this.value[n];
            if (n + 1 < n2 && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[n + 1]) >= '\udc00' && c <= '\udfff') {
                return 65536 + (c2 - 55296 << 10) + (c - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointBefore(int n) {
        int n2 = this.lengthInternal();
        if (n > 0 && n <= n2) {
            char c;
            if (String.enableCompression && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, n - 1));
            }
            char c2 = this.value[n - 1];
            if (n > 1 && c2 >= '\udc00' && c2 <= '\udfff' && (c = this.value[n - 2]) >= '\ud800' && c <= '\udbff') {
                return 65536 + (c - 55296 << 10) + (c2 - 56320);
            }
            return c2;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointCount(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n >= 0 && n <= n2 && n2 <= n3) {
            if (String.enableCompression && this.count >= 0) {
                return n2 - n;
            }
            int n4 = 0;
            for (int i = n; i < n2; ++i) {
                char c;
                char c2 = this.value[i];
                if (i + 1 < n2 && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[i + 1]) >= '\udc00' && c <= '\udfff') {
                    ++i;
                }
                ++n4;
            }
            return n4;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int n, int n2) {
        int n3 = this.lengthInternal();
        if (n >= 0 && n <= n3) {
            if (String.enableCompression && this.count >= 0) {
                int n4 = n + n2;
                if (n4 >= n3) {
                    throw new IndexOutOfBoundsException();
                }
                return n4;
            }
            int n5 = n;
            if (n2 == 0) {
                return n;
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    char c;
                    if (n5 == n3) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c2 = this.value[n5];
                    if (n5 + 1 < n3 && c2 >= '\ud800' && c2 <= '\udbff' && (c = this.value[n5 + 1]) >= '\udc00' && c <= '\udfff') {
                        ++n5;
                    }
                    ++n5;
                }
            } else {
                for (int i = n2; i < 0; ++i) {
                    char c;
                    if (n5 < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char c3 = this.value[n5 - 1];
                    if (n5 > 1 && c3 >= '\udc00' && c3 <= '\udfff' && (c = this.value[n5 - 2]) >= '\ud800' && c <= '\udbff') {
                        --n5;
                    }
                    --n5;
                }
            }
            return n5;
        }
        throw new IndexOutOfBoundsException();
    }

    public StringBuilder appendCodePoint(int n) {
        if (n >= 0) {
            if (n < 65536) {
                return this.append((char)n);
            }
            if (n < 0x110000) {
                int n2;
                int n3;
                int n4;
                if (String.enableCompression && this.count >= 0) {
                    this.decompress(this.value.length);
                }
                if ((n4 = (n3 = this.lengthInternal()) + 2) > (n2 = this.capacityInternal())) {
                    this.ensureCapacityImpl(n4);
                }
                this.value[n3] = (char)(55296 + ((n -= 65536) >> 10));
                this.value[n3 + 1] = (char)(56320 + (n & 0x3FF));
                this.count = String.enableCompression ? n4 | Integer.MIN_VALUE : n4;
                return this;
            }
        }
        throw new IllegalArgumentException();
    }

    char[] getValue() {
        return this.value;
    }
}

