/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.AttachedDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ByteDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CacheletHintsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CacheletWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathEntryItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ClasspathWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.CompiledMethodWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedCacheHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassCacheDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.OrphanWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ROMClassWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_CacheMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_CompositeCacheImplPointer;
import com.ibm.j9ddr.vm29.pointer.generated.SH_OSCachePointer;
import com.ibm.j9ddr.vm29.pointer.generated.ScopedROMClassWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ShcItemHdrPointer;
import com.ibm.j9ddr.vm29.pointer.generated.ShcItemPointer;
import com.ibm.j9ddr.vm29.pointer.helper.AttachedDataWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ByteDataWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.CacheletWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathEntryItemHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathItemHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ClasspathWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.CompiledMethodWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.OrphanWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ROMClassWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ScopedROMClassWrapperHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ShcItemHdrHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ShcItemHelper;
import com.ibm.j9ddr.vm29.structure.AttachedDataWrapper;
import com.ibm.j9ddr.vm29.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm29.structure.CacheletHints;
import com.ibm.j9ddr.vm29.structure.CompiledMethodWrapper;
import com.ibm.j9ddr.vm29.structure.J9GenericByID;
import com.ibm.j9ddr.vm29.structure.J9SharedCacheHeader;
import com.ibm.j9ddr.vm29.structure.J9UTF8;
import com.ibm.j9ddr.vm29.structure.OrphanWrapper;
import com.ibm.j9ddr.vm29.structure.ROMClassWrapper;
import com.ibm.j9ddr.vm29.structure.ScopedROMClassWrapper;
import com.ibm.j9ddr.vm29.structure.ShCFlags;
import com.ibm.j9ddr.vm29.structure.SharedconstsConstants;
import com.ibm.j9ddr.vm29.structure.ShcItem;
import com.ibm.j9ddr.vm29.structure.ShcItemHdr;
import com.ibm.j9ddr.vm29.structure.ShcdatatypesConstants;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;

public class ShrCCommand
extends Command {
    private static final long ORPHAN_STATS = 1L;
    private static final long ROMCLASS_STATS = 2L;
    private static final long CLASSPATH_STATS = 4L;
    private static final long AOT_STATS = 8L;
    private static final long SCOPE_STATS = 16L;
    private static final long BYTE_STATS = 32L;
    private static final long UNINDEXED_BYTE_STATS = 64L;
    private static final long INV_AOT_STATS = 128L;
    private static final long CACHELET_STATS = 256L;
    private static final long FIND_METHOD = 4096L;
    private static final long JITPROFILE_STATS = 8192L;
    private static final long JITHINT_STATS = 16384L;
    private static final long ALL_STALE_STATS = 32768L;
    private static final long ALL_STATS = 57855L;
    private static final int J9SHR_ATTACHED_DATA_TYPE_JITPROFILE = 1;
    private static final int J9SHR_ATTACHED_DATA_TYPE_JITHINT = 2;
    private static final String rangeDelim = "..";
    private static long cacheTotalSize = 0L;

    public ShrCCommand() {
        this.addCommand("shrc", "[command]", "shared class cache operations");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (!J9BuildFlags.opt_sharedClasses) {
                CommandUtils.dbgPrint(printStream, "no shared cache\n");
                return;
            }
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9SharedClassConfigPointer j9SharedClassConfigPointer = j9JavaVMPointer.sharedClassConfig();
            CommandUtils.dbgPrint(printStream, "!j9sharedclassconfig %s\n\n", j9SharedClassConfigPointer.getHexAddress());
            if (stringArray.length == 0) {
                this.printHelp(printStream);
            } else if (j9SharedClassConfigPointer.notNull()) {
                Object object;
                U8Pointer u8Pointer = this.getSharedCacheMetadataStart(j9JavaVMPointer, printStream);
                U8Pointer u8Pointer2 = this.getSharedCacheMetadataEnd(j9JavaVMPointer, printStream);
                U8Pointer u8Pointer3 = u8Pointer;
                U8Pointer u8Pointer4 = u8Pointer2;
                this.initTotalCacheSize(printStream, j9SharedClassConfigPointer);
                if (stringArray.length > 1 && stringArray[1].indexOf(rangeDelim) != -1) {
                    object = stringArray[1].substring(0, stringArray[1].indexOf(rangeDelim));
                    u8Pointer3 = U8Pointer.cast(CommandUtils.parsePointer((String)object, J9BuildFlags.env_data64));
                    object = stringArray[1].substring(stringArray[1].indexOf(rangeDelim) + rangeDelim.length());
                    u8Pointer4 = U8Pointer.cast(CommandUtils.parsePointer((String)object, J9BuildFlags.env_data64));
                }
                if (u8Pointer3 != null && u8Pointer3.longValue() < u8Pointer.longValue()) {
                    CommandUtils.dbgPrint(printStream, "User specified start boundary is before metadata start in cache\n");
                    u8Pointer3 = u8Pointer;
                }
                if (u8Pointer4 != null && u8Pointer4.longValue() > u8Pointer2.longValue()) {
                    CommandUtils.dbgPrint(printStream, "User specified end boundary is beyond metadata end in cache\n");
                    u8Pointer4 = u8Pointer2;
                }
                if (u8Pointer3 != null && u8Pointer4 != null && u8Pointer4.longValue() < u8Pointer3.longValue()) {
                    CommandUtils.dbgPrint(printStream, "User specified metadata region boundary is not valid. Ensure 'end' > 'start'\n");
                    return;
                }
                CommandUtils.dbgPrint(printStream, "Meta data region to be used: %s..%s\n", u8Pointer3.getHexAddress(), u8Pointer4.getHexAddress());
                if (stringArray[0].equals("allstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 57855L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("rcstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 2L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("cpstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 4L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("aotstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 8L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("invaotstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 128L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("orphanstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 1L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("scopestats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 16L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("bytestats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 32L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("ubytestats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 64L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("clstats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 256L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("stalestats")) {
                    this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 32768L, null, false, VoidPointer.NULL, false);
                } else if (stringArray[0].equals("classpath")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc classpath <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintClasspath(printStream, ClasspathWrapperPointer.cast(l));
                    }
                } else if (stringArray[0].equals("findclass")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findclass <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for class \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 3L, (String)object, false, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("findclassp")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findclassp <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for class prefix \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 3L, (String)object, true, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("findaot")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findaot <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for AOT method \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 136L, (String)object, false, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("findaotp")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findaot <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for AOT method prefix \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 136L, (String)object, true, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("aotfor")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc aotfor <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 136L, null, true, VoidPointer.cast(l), false);
                    }
                } else if (stringArray[0].equals("rcfor")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc rcfor <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 3L, null, false, VoidPointer.cast(l), false);
                    }
                } else if (stringArray[0].equals("incache")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc incache <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcInCache(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, VoidPointer.cast(l));
                    }
                } else if (stringArray[0].equals("stats")) {
                    if (j9SharedClassConfigPointer.notNull()) {
                        this.dbgShrcInCache(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, VoidPointer.NULL);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 0L, null, false, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("method")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc method <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 4096L, null, false, VoidPointer.cast(l), false);
                    }
                } else if (stringArray[0].equals("cachelet")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc incache <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintCachelet(printStream, CacheletWrapperPointer.cast(l));
                    }
                } else if (stringArray[0].equals("jitpstats")) {
                    if (j9SharedClassConfigPointer.notNull()) {
                        this.dbgShrcInCache(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, VoidPointer.NULL);
                        boolean bl = stringArray.length > 1 && "corrupt".equals(stringArray[1]);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 8192L, null, false, VoidPointer.NULL, bl);
                    }
                } else if (stringArray[0].equals("findjitp")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findjitp <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for JIT PROFILE method \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 8192L, (String)object, false, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("findjitpp")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findjitpp <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for JIT PROFILE method prefix \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 8192L, (String)object, true, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("jitpfor")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc jitpfor <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 8192L, null, false, VoidPointer.cast(l), false);
                    }
                } else if (stringArray[0].equals("jithstats")) {
                    if (j9SharedClassConfigPointer.notNull()) {
                        this.dbgShrcInCache(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, VoidPointer.NULL);
                        boolean bl = stringArray.length > 1 && "corrupt".equals(stringArray[1]);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer3, u8Pointer4, 16384L, null, false, VoidPointer.NULL, bl);
                    }
                } else if (stringArray[0].equals("findjith")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findjith <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for JIT HINT method \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 16384L, (String)object, false, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("findjithp")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc findjithp <name>\n");
                    } else {
                        object = stringArray[1];
                        CommandUtils.dbgPrint(printStream, "Looking for JIT HINT method prefix \"%s\"\n", object);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 16384L, (String)object, true, VoidPointer.NULL, false);
                    }
                } else if (stringArray[0].equals("jithfor")) {
                    if (stringArray.length != 2) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc jithfor <address>\n");
                    } else {
                        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(printStream, j9JavaVMPointer, j9SharedClassConfigPointer, u8Pointer, u8Pointer2, 16384L, null, false, VoidPointer.cast(l), false);
                    }
                } else if (stringArray[0].equals("rtflags")) {
                    if (j9SharedClassConfigPointer.notNull()) {
                        object = j9SharedClassConfigPointer.runtimeFlags();
                        CommandUtils.dbgPrint(printStream, "Printing the shared classes runtime flags %s\n", ((Scalar)object).getHexValue());
                        this.printShCFlags(printStream, (UScalar)object, "RUNTIMEFLAG");
                    }
                } else if (stringArray[0].equals("extraflags")) {
                    if (j9SharedClassConfigPointer.notNull()) {
                        object = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
                        UDATA uDATA = ((ShrcConfig)object).getCacheStartAddress().extraFlags();
                        CommandUtils.dbgPrint(printStream, "Printing the shared classes extra flags present in cache header %s\n", uDATA.getHexValue());
                        this.printShCFlags(printStream, uDATA, "EXTRA_FLAGS");
                    }
                } else if (stringArray[0].equals("write")) {
                    if (stringArray.length != 2 && stringArray.length != 3) {
                        CommandUtils.dbgPrint(printStream, "Usage: !shrc write <cachedir> [<cachename>]\n");
                    } else {
                        object = stringArray[1];
                        String string2 = stringArray.length == 3 ? stringArray[2] : null;
                        try {
                            this.dbgShrcWriteCache(printStream, j9SharedClassConfigPointer, (String)object, string2);
                        }
                        catch (CorruptDataException corruptDataException) {
                            CommandUtils.dbgPrint(printStream, "Unable to write complete cache: %s", corruptDataException.getMessage());
                            CommandUtils.dbgPrint(printStream, "Attempting to write only populated areas of cache.\n");
                            this.dbgShrcWriteCacheByAreas(printStream, j9SharedClassConfigPointer, (String)object, string2);
                        }
                    }
                } else if (stringArray[0].equals("name")) {
                    this.dbgShrcCacheName(printStream, j9SharedClassConfigPointer);
                } else {
                    CommandUtils.dbgPrint(printStream, "Unknown arg(s) : ");
                    for (int i = 0; i < stringArray.length; ++i) {
                        CommandUtils.dbgPrint(printStream, stringArray[i] + " ");
                    }
                    CommandUtils.dbgPrint(printStream, "\nType !shrc to see all the valid options.\n");
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printShCFlags(PrintStream printStream, UScalar uScalar, String string) {
        Field[] fieldArray;
        for (Field field : fieldArray = ShCFlags.class.getFields()) {
            String string2 = field.getName();
            try {
                Long l = (Long)field.get(null);
                if (!string2.contains(string) || !uScalar.anyBitsIn(l)) continue;
                if (uScalar.sizeof() == 8) {
                    CommandUtils.dbgPrint(printStream, "%-65s 0x%016X\n", string2, l);
                    continue;
                }
                CommandUtils.dbgPrint(printStream, "%-65s 0x%08X\n", string2, l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void dbgShrcCacheName(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer) throws CorruptDataException {
        SH_OSCachePointer sH_OSCachePointer = this.getOSCache(printStream, j9SharedClassConfigPointer);
        if (sH_OSCachePointer.notNull()) {
            String string;
            U8Pointer u8Pointer = sH_OSCachePointer._cacheNameWithVGen();
            U8Pointer u8Pointer2 = sH_OSCachePointer._cachePathName();
            if (u8Pointer.notNull()) {
                string = u8Pointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(printStream, "Cache name is %s\n", string);
            }
            if (u8Pointer2.notNull()) {
                string = u8Pointer2.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(printStream, "Cache path is %s\n", string);
            }
        }
    }

    CacheFileOutputStream createDbgShrcCacheFile(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer, String string, String string2) throws CorruptDataException {
        CacheFileOutputStream cacheFileOutputStream = null;
        SH_OSCachePointer sH_OSCachePointer = this.getOSCache(printStream, j9SharedClassConfigPointer);
        if (sH_OSCachePointer.notNull()) {
            String string3 = "default";
            U8Pointer u8Pointer = sH_OSCachePointer._cacheNameWithVGen();
            if (u8Pointer.notNull()) {
                string3 = u8Pointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(printStream, "Cache name is %s\n", string3);
            }
            if (string2 != null) {
                string3 = string2;
            }
            VoidPointer voidPointer = sH_OSCachePointer._headerStart();
            UDATA uDATA = sH_OSCachePointer._cacheSize();
            CommandUtils.dbgPrint(printStream, "Cache start 0x%x size %d\n", voidPointer.getAddress(), uDATA.longValue());
            File file = new File(string, string3);
            CommandUtils.dbgPrint(printStream, "Writing cache to %s\n", file.getAbsolutePath());
            try {
                cacheFileOutputStream = new CacheFileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                CommandUtils.dbgPrint(printStream, "Could not create %s: %s", file.getAbsolutePath(), fileNotFoundException.getMessage());
            }
        }
        return cacheFileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbgShrcWriteCache(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer, String string, String string2) throws CorruptDataException {
        CacheFileOutputStream cacheFileOutputStream = this.createDbgShrcCacheFile(printStream, j9SharedClassConfigPointer, string, string2);
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        J9SharedCacheHeaderInfo j9SharedCacheHeaderInfo = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
        try {
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getHeaderStart(), j9SharedCacheHeaderInfo.getDebugAreaEnd(), false);
        }
        catch (IOException iOException) {
            CommandUtils.dbgPrint(printStream, "Error writing %s: %s", cacheFileOutputStream.getFileName(), iOException.getMessage());
        }
        finally {
            try {
                cacheFileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbgShrcWriteCacheByAreas(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer, String string, String string2) throws CorruptDataException {
        CacheFileOutputStream cacheFileOutputStream = this.createDbgShrcCacheFile(printStream, j9SharedClassConfigPointer, string, string2);
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        J9SharedCacheHeaderInfo j9SharedCacheHeaderInfo = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
        try {
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getHeaderStart(), j9SharedCacheHeaderInfo.getRomClassesEnd(), false);
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getRomClassesEnd(), j9SharedCacheHeaderInfo.getMetaDataEnd(), true);
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getMetaDataEnd(), j9SharedCacheHeaderInfo.getMetaDataStart(), false);
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getLineNumberAreaStart(), j9SharedCacheHeaderInfo.getLineNumberAreaEnd(), false);
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getLineNumberAreaEnd(), j9SharedCacheHeaderInfo.getLocalVariableAreaEnd(), true);
            this.dbgShrcWriteCacheArea(cacheFileOutputStream, j9SharedCacheHeaderInfo.getLocalVariableAreaEnd(), j9SharedCacheHeaderInfo.getLocalVariableAreaStart(), false);
            CommandUtils.dbgPrint(printStream, "Cache successfully written to %s\n", cacheFileOutputStream.getFileName());
        }
        catch (IOException iOException) {
            CommandUtils.dbgPrint(printStream, "Error writing %s: %s", cacheFileOutputStream.getFileName(), iOException.getMessage());
        }
        finally {
            try {
                cacheFileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void dbgShrcWriteCacheArea(FileOutputStream fileOutputStream, UDATA uDATA, UDATA uDATA2, boolean bl) throws CorruptDataException, IOException {
        long l = 0L;
        long l2 = uDATA.longValue();
        long l3 = uDATA2.longValue();
        long l4 = l3 - l2;
        SH_OSCachePointer sH_OSCachePointer = SH_OSCachePointer.cast(l2);
        byte[] byArray = new byte[4096];
        if (bl) {
            Arrays.fill(byArray, (byte)0);
        }
        while (l < l4) {
            if (l4 - l < (long)byArray.length) {
                byArray = new byte[(int)(l4 - l)];
                if (bl) {
                    Arrays.fill(byArray, (byte)0);
                }
            }
            if (!bl) {
                sH_OSCachePointer.getBytesAtOffset(l, byArray);
            }
            fileOutputStream.write(byArray);
            l += (long)byArray.length;
        }
    }

    private SH_OSCachePointer getOSCache(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer) throws CorruptDataException {
        if (j9SharedClassConfigPointer.notNull()) {
            SH_CacheMapPointer sH_CacheMapPointer = j9SharedClassConfigPointer.sharedClassCache();
            if (sH_CacheMapPointer.notNull()) {
                long l = sH_CacheMapPointer.getAddress();
                SH_CacheMapPointer sH_CacheMapPointer2 = SH_CacheMapPointer.cast(l);
                SH_CompositeCacheImplPointer sH_CompositeCacheImplPointer = sH_CacheMapPointer2._cc();
                if (sH_CompositeCacheImplPointer.notNull()) {
                    SH_OSCachePointer sH_OSCachePointer = sH_CompositeCacheImplPointer._oscache();
                    if (sH_OSCachePointer.notNull()) {
                        return sH_OSCachePointer;
                    }
                    CommandUtils.dbgPrint(printStream, "SH_OSCache is NULL\n");
                } else {
                    CommandUtils.dbgPrint(printStream, "SH_CompositeCacheImpl is NULL\n");
                }
            } else {
                CommandUtils.dbgPrint(printStream, "SH_CacheMap is NULL\n");
            }
        } else {
            CommandUtils.dbgPrint(printStream, "J9SharedClassConfig is NULL\n");
        }
        return null;
    }

    private void printHelp(PrintStream printStream) {
        CommandUtils.dbgPrint(printStream, "!shrc stats [range]                  -- Print cache stats\n");
        CommandUtils.dbgPrint(printStream, "!shrc allstats [range]               -- Print all cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc rcstats [range]                -- Print romclass cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc cpstats [range]                -- Print classpath cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc aotstats [range]               -- Print aot cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc invaotstats [range]            -- Print invalidated aot cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc orphanstats [range]            -- Print orphan cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc scopestats [range]             -- Print scope cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc bytestats [range]              -- Print byte data cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc ubytestats [range]             -- Print unindexed byte data cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc stalestats [range]             -- Print all the stale cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc clstats [range]                -- Print cachelet cache contents\n");
        CommandUtils.dbgPrint(printStream, "!shrc classpath <address>            -- Print classpath at address\n");
        CommandUtils.dbgPrint(printStream, "!shrc findclass <name>               -- Find named class\n");
        CommandUtils.dbgPrint(printStream, "!shrc findclassp <name>              -- Find named class prefix\n");
        CommandUtils.dbgPrint(printStream, "!shrc findaot <name>                 -- Find AOT for named method\n");
        CommandUtils.dbgPrint(printStream, "!shrc findaotp <name>                -- Find AOT for named method prefix\n");
        CommandUtils.dbgPrint(printStream, "!shrc aotfor <address>               -- Find AOT for rom method\n");
        CommandUtils.dbgPrint(printStream, "!shrc rcfor <address>                -- Find romclass metadata from romclass address\n");
        CommandUtils.dbgPrint(printStream, "!shrc method <address>               -- Lookup rom method in cache\n");
        CommandUtils.dbgPrint(printStream, "!shrc incache <address>              -- Lookup address in cache\n");
        CommandUtils.dbgPrint(printStream, "!shrc cachelet <address>             -- Print cachelet at address\n");
        CommandUtils.dbgPrint(printStream, "!shrc jitpstats [range] [corrupt]    -- Print jit profile cache contents, add corrupt to only display the corrupted caches\n");
        CommandUtils.dbgPrint(printStream, "!shrc findjitp <name>                -- Find jit profile for named method\n");
        CommandUtils.dbgPrint(printStream, "!shrc findjitpp <name>               -- Find jit profile for named method prefix\n");
        CommandUtils.dbgPrint(printStream, "!shrc jitpfor <address>              -- Find jit profile for rom method\n");
        CommandUtils.dbgPrint(printStream, "!shrc jithstats [range] [corrupt]    -- Print jit hint cache contents, add corrupt to only display the corrupted caches\n");
        CommandUtils.dbgPrint(printStream, "!shrc findjith <name>                -- Find jit hint for named method\n");
        CommandUtils.dbgPrint(printStream, "!shrc findjithp <name>               -- Find jit hint for named method prefix\n");
        CommandUtils.dbgPrint(printStream, "!shrc jithfor <address>              -- Find jit hint for rom method\n");
        CommandUtils.dbgPrint(printStream, "!shrc rtflags                        -- Display shared classes runtime flags\n");
        CommandUtils.dbgPrint(printStream, "!shrc extraflags                     -- Display shared classes extra flags present in cache header\n");
        CommandUtils.dbgPrint(printStream, "!shrc write <dir> [<name>]           -- Write the shared cache to the given directory\n");
        CommandUtils.dbgPrint(printStream, "!shrc name                           -- Display the name of the shared cache\n");
        CommandUtils.dbgPrint(printStream, "\nNote: [range] is specified as <start addr>..<end addr> eg 0x1000..0x2000\n");
    }

    private void dbgShrcPrintAllStats(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9SharedClassConfigPointer j9SharedClassConfigPointer, U8Pointer u8Pointer, U8Pointer u8Pointer2, long l, String string, boolean bl, VoidPointer voidPointer, boolean bl2) throws CorruptDataException {
        DataType dataType;
        Object object;
        ArrayList<J9ROMClassPointer> arrayList = new ArrayList<J9ROMClassPointer>();
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int[] nArray = new int[(int)ShCFlags.J9SHR_DATA_TYPE_MAX + 1];
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = 0;
        int n29 = 0;
        int n30 = 0;
        int n31 = 0;
        int n32 = 0;
        int n33 = 0;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl4 = (l & 0x8000L) != 0L;
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        UDATA uDATA = shrcConfig.getRomclassStartAddress();
        UDATA uDATA2 = shrcConfig.getSegmentPtr();
        int n34 = 0;
        while ((long)n34 <= ShCFlags.J9SHR_DATA_TYPE_MAX) {
            nArray[n34] = 0;
            ++n34;
        }
        SharedClassMetadataIterator sharedClassMetadataIterator = new SharedClassMetadataIterator(j9JavaVMPointer, u8Pointer, u8Pointer2, 0L, true, printStream);
        while (sharedClassMetadataIterator.hasNext()) {
            UDATA uDATA3;
            J9UTF8Pointer j9UTF8Pointer;
            DataType dataType2;
            Object object2;
            UDATA uDATA4;
            J9ROMMethodPointer j9ROMMethodPointer;
            UDATA uDATA5;
            ClasspathItemPointer classpathItemPointer;
            ClasspathWrapperPointer classpathWrapperPointer;
            J9UTF8Pointer j9UTF8Pointer2;
            J9ROMClassPointer j9ROMClassPointer;
            object = sharedClassMetadataIterator.next();
            dataType = ((ShcItemPointer)object).dataType();
            J9UTF8Pointer j9UTF8Pointer3 = J9UTF8Pointer.NULL;
            J9UTF8Pointer j9UTF8Pointer4 = J9UTF8Pointer.NULL;
            boolean bl5 = ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND((ShcItemPointer)object)));
            if (bl5) {
                l3 += ShcItemHdrHelper.CCITEMLEN(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND((ShcItemPointer)object))).longValue();
                ++n3;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_ORPHAN)) {
                String string2;
                n19 = (int)((long)n19 + (OrphanWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                j9ROMClassPointer = OrphanWrapperHelper.romClass(OrphanWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object)));
                j9UTF8Pointer2 = j9ROMClassPointer.className();
                if (j9UTF8Pointer2.isNull()) {
                    CommandUtils.dbgPrint(printStream, "-- could not read SRP, OW ShcItem %s romClass %s --\n", ((AbstractPointer)object).getHexAddress(), j9ROMClassPointer.getHexAddress());
                    return;
                }
                arrayList.add(j9ROMClassPointer);
                if ((voidPointer.isNull() || j9ROMClassPointer.eq(voidPointer)) && (l & 1L) != 0L && this.matchClassName(string, string2 = J9UTF8Helper.stringValue(j9UTF8Pointer2), bl)) {
                    bl3 = true;
                    CommandUtils.dbgPrint(printStream, "%d: %s ORPHAN: %s at !j9romclass %s\n", ((ShcItemPointer)object).jvmID().longValue(), UDATA.cast((AbstractPointer)object).getHexValue(), string2, j9ROMClassPointer.getHexAddress());
                }
                ++n2;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_ROMCLASS) || ((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                ROMClassWrapperPointer rOMClassWrapperPointer = ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                n19 = (int)((long)n19 + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_ROMCLASS)) {
                    n19 = (int)((long)n19 + ROMClassWrapper.SIZEOF);
                } else {
                    n19 = (int)((long)n19 + ScopedROMClassWrapper.SIZEOF);
                    ScopedROMClassWrapperPointer scopedROMClassWrapperPointer = ScopedROMClassWrapperPointer.cast(rOMClassWrapperPointer);
                    j9UTF8Pointer3 = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWPARTITION(scopedROMClassWrapperPointer));
                    j9UTF8Pointer4 = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWMODCONTEXT(scopedROMClassWrapperPointer));
                }
                j9ROMClassPointer = J9ROMClassPointer.cast(ROMClassWrapperHelper.RCWROMCLASS(rOMClassWrapperPointer));
                j9UTF8Pointer2 = j9ROMClassPointer.className();
                if (j9UTF8Pointer2.isNull()) {
                    CommandUtils.dbgPrint(printStream, "-- could not read SRP, RC ShcItem %s romClass %s --\n", ((AbstractPointer)object).getHexAddress(), j9ROMClassPointer.getHexAddress());
                    return;
                }
                arrayList.add(j9ROMClassPointer);
                if (voidPointer.isNull() || j9ROMClassPointer.eq(voidPointer)) {
                    String string3;
                    classpathWrapperPointer = ClasspathWrapperPointer.cast(ROMClassWrapperHelper.RCWCLASSPATH(ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object))));
                    if (((l & 2L) != 0L || bl4 && bl5) && this.matchClassName(string, string3 = J9UTF8Helper.stringValue(j9UTF8Pointer2), bl)) {
                        bl3 = true;
                        CommandUtils.dbgPrint(printStream, "%d: %s ROMCLASS: %s at !j9romclass %s ", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), string3, j9ROMClassPointer.getHexAddress());
                        if (bl5) {
                            if (!j9ROMClassPointer.isNull()) {
                                l3 += j9ROMClassPointer.romSize().longValue();
                            }
                            CommandUtils.dbgPrint(printStream, "!STALE!");
                        }
                        CommandUtils.dbgPrint(printStream, "\n");
                        classpathItemPointer = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(classpathWrapperPointer));
                        uDATA5 = new UDATA(classpathItemPointer.type());
                        if (uDATA5.eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
                            CommandUtils.dbgPrint(printStream, "\tIndex %d in !shrc classpath %s\n", rOMClassWrapperPointer.cpeIndex().longValue(), classpathWrapperPointer.getHexAddress());
                        } else if (uDATA5.eq(J9GenericByID.CP_TYPE_URL)) {
                            CommandUtils.dbgPrint(printStream, "\tURL !shrc classpath %s\n", classpathWrapperPointer.getHexAddress());
                        } else if (uDATA5.eq(J9GenericByID.CP_TYPE_TOKEN)) {
                            CommandUtils.dbgPrint(printStream, "\tToken !shrc classpath %s\n", classpathWrapperPointer.getHexAddress());
                        }
                        if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                            if (j9UTF8Pointer3.notNull() && j9UTF8Pointer4.isNull()) {
                                CommandUtils.dbgPrint(printStream, "\tPartition !j9utf8 %s %s\n", j9UTF8Pointer3.getHexAddress(), this.dbgShrcPrintableString(j9UTF8Pointer3));
                            } else if (j9UTF8Pointer4.notNull() && j9UTF8Pointer3.isNull()) {
                                CommandUtils.dbgPrint(printStream, "\tModContext !j9utf8 %s %s\n", j9UTF8Pointer4.getHexAddress(), this.dbgShrcPrintableString(j9UTF8Pointer4));
                            } else if (j9UTF8Pointer4.notNull() && j9UTF8Pointer3.notNull()) {
                                CommandUtils.dbgPrint(printStream, "\tPartition !j9utf8 %s %s in ModContext !j9utf8 %s %s\n", j9UTF8Pointer3.getHexAddress(), this.dbgShrcPrintableString(j9UTF8Pointer3), j9UTF8Pointer4.getHexAddress(), this.dbgShrcPrintableString(j9UTF8Pointer4));
                            }
                        }
                    }
                }
                ++n;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_CLASSPATH)) {
                classpathWrapperPointer = ClasspathWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                classpathItemPointer = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(classpathWrapperPointer));
                if ((l & 4L) != 0L) {
                    bl3 = true;
                    this.dbgShrcPrintClasspath(printStream, classpathWrapperPointer);
                }
                if ((uDATA5 = new UDATA(classpathItemPointer.type())).eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
                    ++n4;
                    continue;
                }
                if (uDATA5.eq(J9GenericByID.CP_TYPE_URL)) {
                    ++n5;
                    continue;
                }
                if (!uDATA5.eq(J9GenericByID.CP_TYPE_TOKEN)) continue;
                ++n6;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_COMPILED_METHOD) || ((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD)) {
                CompiledMethodWrapperPointer compiledMethodWrapperPointer = CompiledMethodWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                j9ROMMethodPointer = J9ROMMethodPointer.cast(CompiledMethodWrapperHelper.CMWROMMETHOD(compiledMethodWrapperPointer));
                uDATA4 = new UDATA(compiledMethodWrapperPointer.dataLength());
                UDATA uDATA6 = new UDATA(compiledMethodWrapperPointer.codeLength());
                n16 = (int)((long)n16 + uDATA4.longValue());
                n17 = (int)((long)n17 + uDATA6.longValue());
                n18 = (int)((long)n18 + (CompiledMethodWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if (((l & 8L) != 0L && ((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_COMPILED_METHOD) || (l & 0x80L) != 0L && ((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD) || bl4 && bl5) && (voidPointer.isNull() || j9ROMMethodPointer.eq(voidPointer))) {
                    String string4 = J9ROMMethodHelper.getName(j9ROMMethodPointer) + J9ROMMethodHelper.getSignature(j9ROMMethodPointer);
                    if (this.matchRomMethodName(string, J9ROMMethodHelper.getName(j9ROMMethodPointer), J9ROMMethodHelper.getSignature(j9ROMMethodPointer), bl)) {
                        bl3 = true;
                        CommandUtils.dbgPrint(printStream, "%d: %s AOT data !j9x %s,%s code !j9x %s,%s ", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), CompiledMethodWrapperHelper.CMWDATA(compiledMethodWrapperPointer).getHexAddress(), uDATA4.getHexValue(), CompiledMethodWrapperHelper.CMWCODE(compiledMethodWrapperPointer).getHexAddress(), uDATA6.getHexValue());
                        if (bl5) {
                            CommandUtils.dbgPrint(printStream, "!STALE!");
                        }
                        if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_INVALIDATED_COMPILED_METHOD)) {
                            CommandUtils.dbgPrint(printStream, "INVALIDATED");
                        }
                        CommandUtils.dbgPrint(printStream, "\n\t%s !j9rommethod %s\n", string4, j9ROMMethodPointer.getHexAddress());
                        object2 = arrayList.listIterator(arrayList.size());
                        while (object2.hasPrevious()) {
                            dataType2 = (J9ROMClassPointer)object2.previous();
                            if (!j9ROMMethodPointer.gt((AbstractPointer)dataType2) || !j9ROMMethodPointer.lt(((J9ROMClassPointer)dataType2).addOffset(((J9ROMClassPointer)dataType2).romSize()))) continue;
                            CommandUtils.dbgPrint(printStream, "\t%s !j9romclass %s\n", J9UTF8Helper.stringValue(((J9ROMClassPointer)dataType2).className()), ((AbstractPointer)dataType2).getHexAddress());
                            break;
                        }
                    }
                }
                ++n7;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_ATTACHED_DATA)) {
                AttachedDataWrapperPointer attachedDataWrapperPointer = AttachedDataWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                j9ROMMethodPointer = J9ROMMethodPointer.cast(attachedDataWrapperPointer.cacheOffset());
                uDATA4 = new UDATA(attachedDataWrapperPointer.dataLength());
                int n35 = attachedDataWrapperPointer.type().intValue();
                boolean bl6 = 2 == n35;
                int n36 = attachedDataWrapperPointer.updateCount().intValue();
                int n37 = attachedDataWrapperPointer.corrupt().intValue();
                if (bl6) {
                    n32 = (int)((long)n32 + uDATA4.longValue());
                    n33 = (int)((long)n33 + (AttachedDataWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                } else {
                    n30 = (int)((long)n30 + uDATA4.longValue());
                    n31 = (int)((long)n31 + (AttachedDataWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                }
                if ((bl6 && 0L != (l & 0x4000L) || !bl6 && 0L != (l & 0x2000L) || bl4 && bl5) && (!bl2 && voidPointer.isNull() || j9ROMMethodPointer.eq(voidPointer) || bl2 && n37 != -1)) {
                    String string5 = J9ROMMethodHelper.getName(j9ROMMethodPointer) + J9ROMMethodHelper.getSignature(j9ROMMethodPointer);
                    if (this.matchRomMethodName(string, J9ROMMethodHelper.getName(j9ROMMethodPointer), J9ROMMethodHelper.getSignature(j9ROMMethodPointer), bl)) {
                        bl3 = true;
                        CommandUtils.dbgPrint(printStream, "%d: %s %s data !j9x %s,%s  type %d updates %d corrupt %d", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), bl6 ? "JITHINT" : "JITPROFILE", AttachedDataWrapperHelper.ADWDATA(attachedDataWrapperPointer).getHexAddress(), uDATA4.getHexValue(), n35, n36, n37);
                        if (bl5) {
                            CommandUtils.dbgPrint(printStream, "!STALE!");
                        }
                        CommandUtils.dbgPrint(printStream, "\n\t%s !j9rommethod %s\n", string5, j9ROMMethodPointer.getHexAddress());
                        ListIterator listIterator = arrayList.listIterator(arrayList.size());
                        while (listIterator.hasPrevious()) {
                            J9ROMClassPointer j9ROMClassPointer2 = (J9ROMClassPointer)listIterator.previous();
                            if (!j9ROMMethodPointer.gt(j9ROMClassPointer2) || !j9ROMMethodPointer.lt(j9ROMClassPointer2.addOffset(j9ROMClassPointer2.romSize()))) continue;
                            CommandUtils.dbgPrint(printStream, "\t%s !j9romclass %s\n", J9UTF8Helper.stringValue(j9ROMClassPointer2.className()), j9ROMClassPointer2.getHexAddress());
                            break;
                        }
                    }
                }
                if (bl6) {
                    ++n15;
                    continue;
                }
                ++n14;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_SCOPE)) {
                j9UTF8Pointer = J9UTF8Pointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                n20 = (int)((long)n20 + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                n21 = (int)((long)n21 + (J9UTF8.SIZEOF + j9UTF8Pointer.length().longValue()));
                if ((l & 0x10L) != 0L) {
                    bl3 = true;
                    CommandUtils.dbgPrint(printStream, "%d: %s SCOPE !j9utf8 %s %s\n", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), j9UTF8Pointer.getHexAddress(), J9UTF8Helper.stringValue(j9UTF8Pointer));
                }
                ++n8;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_BYTE_DATA)) {
                ByteDataWrapperPointer byteDataWrapperPointer = ByteDataWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
                n22 = (int)((long)n22 + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF + ByteDataWrapper.SIZEOF));
                UDATA uDATA7 = new UDATA(ByteDataWrapperHelper.BDWEXTBLOCK(byteDataWrapperPointer));
                uDATA3 = new UDATA(ByteDataWrapperHelper.BDWLEN(byteDataWrapperPointer));
                UDATA uDATA8 = new UDATA(ByteDataWrapperHelper.BDWTYPE(byteDataWrapperPointer));
                if (uDATA8.longValue() <= ShCFlags.J9SHR_DATA_TYPE_MAX) {
                    int n38 = (int)uDATA8.longValue();
                    nArray[n38] = (int)((long)nArray[n38] + uDATA3.longValue());
                } else {
                    int n39 = (int)ShCFlags.J9SHR_DATA_TYPE_UNKNOWN;
                    nArray[n39] = (int)((long)nArray[n39] + uDATA3.longValue());
                }
                if (uDATA7.eq(0L)) {
                    n23 = (int)((long)n23 + uDATA3.longValue());
                    if ((l & 0x20L) != 0L) {
                        bl3 = true;
                        CommandUtils.dbgPrint(printStream, "%d: %s %s BYTEDATA !j9x %s,%s", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), this.getType(uDATA8), ByteDataWrapperHelper.BDWDATA(byteDataWrapperPointer).getHexAddress(), uDATA3.getHexValue());
                    }
                } else {
                    n24 = (int)((long)n24 + uDATA3.longValue());
                    if ((l & 0x20L) != 0L) {
                        bl3 = true;
                        CommandUtils.dbgPrint(printStream, "%d: %s BYTEDATA RW !j9x %s,%s", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), ByteDataWrapperHelper.BDWDATA(byteDataWrapperPointer).getHexAddress(), uDATA3.getHexValue());
                    }
                }
                if ((l & 0x20L) != 0L || bl4 && bl5) {
                    if (bl5) {
                        CommandUtils.dbgPrint(printStream, "!STALE!");
                    }
                    UDATA uDATA9 = new UDATA(ByteDataWrapperHelper.BDWINPRIVATEUSE(byteDataWrapperPointer));
                    object2 = new UDATA(ByteDataWrapperHelper.BDWPRIVATEOWNERID(byteDataWrapperPointer));
                    j9UTF8Pointer = J9UTF8Pointer.cast(ByteDataWrapperHelper.BDWTOKEN(byteDataWrapperPointer));
                    if (j9UTF8Pointer.notNull()) {
                        CommandUtils.dbgPrint(printStream, "\n\tkey: !j9utf8 %s %s\n", j9UTF8Pointer.getHexAddress(), J9UTF8Helper.stringValue(j9UTF8Pointer));
                    }
                    if (!uDATA9.eq(0L) || !((Scalar)object2).eq(0L)) {
                        CommandUtils.dbgPrint(printStream, "\n\tinPrivateUse %d privateOwnerID %d\n", uDATA9.longValue(), ((Scalar)object2).longValue());
                    }
                }
                ++n9;
                continue;
            }
            if (((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_UNINDEXED_BYTE_DATA)) {
                uDATA3 = new UDATA(((ShcItemPointer)object).dataLen());
                n25 = (int)((long)n25 + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                n26 = (int)((long)n26 + uDATA3.longValue());
                if ((l & 0x40L) != 0L) {
                    bl3 = true;
                    CommandUtils.dbgPrint(printStream, "%d: %s UNINDEXEDBYTEDATA !j9x %s,%s\n", ((ShcItemPointer)object).jvmID().longValue(), ((AbstractPointer)object).getHexAddress(), ShcItemHelper.ITEMDATA((ShcItemPointer)object).getHexAddress(), uDATA3.getHexValue());
                }
                ++n10;
                continue;
            }
            if (!((Scalar)dataType).eq(ShcdatatypesConstants.TYPE_CACHELET)) continue;
            CacheletWrapperPointer cacheletWrapperPointer = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA((ShcItemPointer)object));
            J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer2 = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cacheletWrapperPointer));
            object2 = UDATA.cast(j9SharedCacheHeaderPointer2).add(j9SharedCacheHeaderPointer2.readWriteBytes());
            dataType2 = UDATA.cast(j9SharedCacheHeaderPointer2).add(j9SharedCacheHeaderPointer2.segmentSRP());
            l2 += ((UDATA)dataType2).sub((UScalar)object2).longValue();
            n29 = (int)((long)n29 + ((ShcItemPointer)object).dataLen().longValue());
            if ((l & 0x100L) != 0L) {
                bl3 = true;
                this.dbgShrcPrintCachelet(printStream, cacheletWrapperPointer);
            }
            if (cacheletWrapperPointer.numSegments().eq(0L)) {
                ++n13;
            }
            ++n12;
        }
        if ((l & 0x1000L) != 0L) {
            object = arrayList.iterator();
            dataType = J9ROMClassPointer.NULL;
            while (object.hasNext()) {
                dataType = (J9ROMClassPointer)object.next();
                if (!voidPointer.gt((AbstractPointer)dataType) || !voidPointer.lt(((J9ROMClassPointer)dataType).addOffset(((J9ROMClassPointer)dataType).romSize()))) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                CommandUtils.dbgPrint(printStream, "!j9rommethod %s not found in cache\n", J9ROMMethodPointer.cast(voidPointer).getHexAddress());
                if (voidPointer.lt(VoidPointer.cast(uDATA))) {
                    CommandUtils.dbgPrint(printStream, "\taddress is < cache romclassStartAddress %s\n", uDATA.getHexValue());
                }
                if (voidPointer.gt(VoidPointer.cast(uDATA2))) {
                    CommandUtils.dbgPrint(printStream, "\taddress is > cache romclass segment %s\n", uDATA2.getHexValue());
                }
            } else {
                CommandUtils.dbgPrint(printStream, "!j9rommethod %s found in %s !j9romclass %s\n", J9ROMMethodPointer.cast(voidPointer).getHexAddress(), J9UTF8Helper.stringValue(((J9ROMClassPointer)dataType).className()), ((AbstractPointer)dataType).getHexAddress());
            }
        } else if (!bl3) {
            CommandUtils.dbgPrint(printStream, "No entry found in the cache\n");
        }
        if (voidPointer.isNull() && string == null) {
            CommandUtils.dbgPrint(printStream, "\nCache contains %d classes, %d orphans, %d classpaths, %d URLs, %d tokens\n", n, n2, n4, n5, n6);
            CommandUtils.dbgPrint(printStream, "%d AOT, %d SCOPES, %d BYTE data, %d UNINDEXED DATA, %d CHARARRAY, %d stale\n", n7, n8, n9, n10, n11, n3);
            CommandUtils.dbgPrint(printStream, "stale bytes %d\n", l3);
            CommandUtils.dbgPrint(printStream, "%d JITPROFILE, %d JITHINT\n", n14, n15);
            CommandUtils.dbgPrint(printStream, "AOT data length %d code length %d metadata %d total %d\n", n16, n17, n18, n16 + n17, n18);
            CommandUtils.dbgPrint(printStream, "JITPROFILE data length %d metadata %d \n", n30, n31);
            CommandUtils.dbgPrint(printStream, "JITHINT data length %d metadata %d \n", n32, n33);
            if (j9SharedCacheHeaderPointer.containsCachelets().eq(0L)) {
                l2 = uDATA2.sub(uDATA).longValue();
            }
            CommandUtils.dbgPrint(printStream, "ROMClass data %d metadata %d\n", l2, n19);
            CommandUtils.dbgPrint(printStream, "SCOPE data %d metadata %d total %d\n", n21, n20, n20 + n21);
            CommandUtils.dbgPrint(printStream, "BYTE data %d metadata %d rwarea %d\n", n23, n22, n24);
            CommandUtils.dbgPrint(printStream, "UNINDEXEDBYTE data %d metadata %d\n", n26, n25);
            CommandUtils.dbgPrint(printStream, "CHARARRAY data %d metadata %d\n", n28, n27);
            CommandUtils.dbgPrint(printStream, "BYTEDATA Summary\n");
            CommandUtils.dbgPrint(printStream, "\tUNKNOWN %d  HELPER %d  POOL %d  AOTHEADER %d\n", nArray[(int)ShCFlags.J9SHR_DATA_TYPE_UNKNOWN], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_HELPER], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_POOL], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_AOTHEADER]);
            CommandUtils.dbgPrint(printStream, "\tJCL %d  VM %d  ROMSTRING %d  ZIPCACHE %d  STARTUPHINTS %d\n", nArray[(int)ShCFlags.J9SHR_DATA_TYPE_JCL], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_VM], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_ROMSTRING], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_ZIPCACHE], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_STARTUP_HINTS]);
            CommandUtils.dbgPrint(printStream, "\tJITHINT %d  AOTCLASSCHAIN %d AOTTHUNK %d\n", nArray[(int)ShCFlags.J9SHR_DATA_TYPE_JITHINT], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_AOTCLASSCHAIN], nArray[(int)ShCFlags.J9SHR_DATA_TYPE_AOTTHUNK]);
            if (n29 > 0) {
                CommandUtils.dbgPrint(printStream, "CACHELET count %d (without segments %d) metadata %d\n", n12, n13, n29);
            }
            object = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
            UDATA uDATA10 = ((J9SharedCacheHeaderInfo)object).getDebugLNTUsed();
            UDATA uDATA11 = ((J9SharedCacheHeaderInfo)object).getDebugLVTUsed();
            CommandUtils.dbgPrint(printStream, "DEBUG Area Summary\n");
            CommandUtils.dbgPrint(printStream, "\tLineNumberTable bytes    : %d\n", uDATA10.longValue());
            CommandUtils.dbgPrint(printStream, "\tLocalVariableTable bytes : %d\n", uDATA11.longValue());
        }
    }

    ShrcConfig dbgShrcReadConfig(J9SharedClassConfigPointer j9SharedClassConfigPointer, PrintStream printStream) throws CorruptDataException {
        SH_OSCachePointer sH_OSCachePointer;
        SH_CompositeCacheImplPointer sH_CompositeCacheImplPointer;
        DataType dataType;
        AbstractPointer abstractPointer = null;
        Scalar scalar = null;
        Scalar scalar2 = null;
        J9SharedClassCacheDescriptorPointer j9SharedClassCacheDescriptorPointer = j9SharedClassConfigPointer.cacheDescriptorList();
        if (null != j9SharedClassCacheDescriptorPointer) {
            abstractPointer = j9SharedClassCacheDescriptorPointer.cacheStartAddress();
        }
        if (abstractPointer.isNull() && ((AbstractPointer)(dataType = j9SharedClassConfigPointer.sharedClassCache())).notNull() && (sH_CompositeCacheImplPointer = ((SH_CacheMapPointer)dataType)._cc()).notNull() && (abstractPointer = sH_CompositeCacheImplPointer._theca()).isNull() && (sH_OSCachePointer = sH_CompositeCacheImplPointer._oscache()).notNull()) {
            abstractPointer = J9SharedCacheHeaderPointer.cast(sH_OSCachePointer._dataStart().longValue());
        }
        if (abstractPointer.isNull()) {
            CommandUtils.dbgPrint(printStream, "cacheStartAddress is zero");
            return null;
        }
        if (j9SharedClassCacheDescriptorPointer.notNull()) {
            scalar = UDATA.cast(j9SharedClassCacheDescriptorPointer.romclassStartAddress());
        }
        if (0L == scalar.longValue() && 0L != ((J9SharedCacheHeaderPointer)abstractPointer).readWriteBytes().longValue()) {
            scalar = new UDATA(((J9SharedCacheHeaderPointer)abstractPointer).addOffset(((J9SharedCacheHeaderPointer)abstractPointer).readWriteBytes()).longValue());
        }
        if (0L == scalar.longValue()) {
            CommandUtils.dbgPrint(printStream, "romclassStartAddress is zero");
        }
        if (0L != ((Scalar)(dataType = ((J9SharedCacheHeaderPointer)abstractPointer).segmentSRP())).longValue()) {
            scalar2 = UDATA.cast(abstractPointer).add((UScalar)dataType);
        }
        if (0L == scalar2.longValue()) {
            CommandUtils.dbgPrint(printStream, "segmentPtr is zero");
        }
        return new ShrcConfig((J9SharedCacheHeaderPointer)abstractPointer, (UDATA)scalar, (UDATA)scalar2);
    }

    U8Pointer getSharedCacheMetadataStart(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        J9SharedClassConfigPointer j9SharedClassConfigPointer = j9JavaVMPointer.sharedClassConfig();
        if (j9SharedClassConfigPointer.isNull()) {
            CommandUtils.dbgPrint(printStream, "SharedClassConfig can not be found.");
            return null;
        }
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        J9SharedCacheHeaderInfo j9SharedCacheHeaderInfo = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
        return U8Pointer.cast(j9SharedCacheHeaderInfo.getMetaDataEnd());
    }

    U8Pointer getSharedCacheMetadataEnd(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        J9SharedClassConfigPointer j9SharedClassConfigPointer = j9JavaVMPointer.sharedClassConfig();
        if (j9SharedClassConfigPointer.isNull()) {
            CommandUtils.dbgPrint(printStream, "SharedClassConfig can not be found.");
            return null;
        }
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        J9SharedCacheHeaderInfo j9SharedCacheHeaderInfo = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
        return U8Pointer.cast(j9SharedCacheHeaderInfo.getMetaDataStart().longValue() - ShcItemHdr.SIZEOF);
    }

    SharedCacheMetadata dbgReadSharedCacheMetadata(J9JavaVMPointer j9JavaVMPointer, PrintStream printStream) throws CorruptDataException {
        U8Pointer u8Pointer = this.getSharedCacheMetadataEnd(j9JavaVMPointer, printStream);
        U8Pointer u8Pointer2 = this.getSharedCacheMetadataStart(j9JavaVMPointer, printStream);
        if (u8Pointer.isNull() || u8Pointer2.isNull()) {
            CommandUtils.dbgPrint(printStream, "SharedCache is not initialized enough to find the metadata area of the cache");
            return null;
        }
        SharedCacheMetadata sharedCacheMetadata = new SharedCacheMetadata(u8Pointer2, u8Pointer);
        if (sharedCacheMetadata.getLength().lt(0)) {
            return null;
        }
        return sharedCacheMetadata;
    }

    SharedCacheMetadata dbgReadSharedCacheMetadata(J9JavaVMPointer j9JavaVMPointer, U8Pointer u8Pointer, U8Pointer u8Pointer2, PrintStream printStream) throws CorruptDataException {
        SharedCacheMetadata sharedCacheMetadata = new SharedCacheMetadata(u8Pointer, u8Pointer2);
        if (sharedCacheMetadata.getLength().lt(0)) {
            return null;
        }
        return sharedCacheMetadata;
    }

    private String getType(UDATA uDATA) {
        long l = uDATA.longValue();
        if (l == ShCFlags.J9SHR_DATA_TYPE_HELPER) {
            return "HELPER";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_POOL) {
            return "POOL";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_AOTHEADER) {
            return "AOTHEADER";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_JCL) {
            return "JCL";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_VM) {
            return "VM";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_ROMSTRING) {
            return "ROMSTRING";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_CACHELET) {
            return "CACHELET";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_ZIPCACHE) {
            return "ZIPCACHE";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_STARTUP_HINTS) {
            return "STARTUPHINT";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_JITHINT) {
            return "JITHINT";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_AOTCLASSCHAIN) {
            return "AOTCLASSCHAIN";
        }
        if (l == ShCFlags.J9SHR_DATA_TYPE_AOTTHUNK) {
            return "AOTTHUNK";
        }
        return "UNKNOWN(" + l + ")";
    }

    private String dbgShrcPrintableString(J9UTF8Pointer j9UTF8Pointer) throws CorruptDataException {
        String string = J9UTF8Helper.stringValue(j9UTF8Pointer);
        return string;
    }

    private boolean matchClassName(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return true;
        }
        if (bl) {
            return string2.startsWith(string);
        }
        return string.equals(string2);
    }

    private boolean matchRomMethodName(String string, String string2, String string3, boolean bl) {
        if (string == null || string2 == null || string3 == null) {
            return true;
        }
        String string4 = string2 + string3;
        if (bl) {
            return string4.startsWith(string);
        }
        if (string.equals(string2)) {
            return true;
        }
        return string.equals(string4);
    }

    private void dbgShrcPrintCachelet(PrintStream printStream, CacheletWrapperPointer cacheletWrapperPointer) throws CorruptDataException {
        AbstractPointer abstractPointer;
        ShcItemPointer shcItemPointer = ShcItemPointer.cast(UDATA.cast(cacheletWrapperPointer).sub(ShcItem.SIZEOF));
        CommandUtils.dbgPrint(printStream, "%d: %s CACHELET !shrc cachelet %s\n", shcItemPointer.jvmID().longValue(), shcItemPointer.getHexAddress(), cacheletWrapperPointer.getHexAddress());
        UDATA uDATA = cacheletWrapperPointer.numHints();
        U8Pointer u8Pointer = U8Pointer.cast(CacheletWrapperHelper.CLETHINTS(cacheletWrapperPointer));
        UDATA uDATA2 = cacheletWrapperPointer.numSegments();
        CommandUtils.dbgPrint(printStream, "  numHints: %d at: !j9x %s\n", uDATA.longValue(), u8Pointer.getHexAddress());
        CommandUtils.dbgPrint(printStream, "  numSegments: %d segmentStartOffset: %s lastSegmentAlloc: %s\n", uDATA2.longValue(), cacheletWrapperPointer.segmentStartOffset().getHexValue(), cacheletWrapperPointer.lastSegmentAlloc().getHexValue());
        if (uDATA2.gt(0)) {
            abstractPointer = UDATAPointer.NULL;
            U8Pointer u8Pointer2 = u8Pointer;
            int n = 0;
            while (uDATA.gt(n)) {
                CacheletHintsPointer cacheletHintsPointer = CacheletHintsPointer.cast(u8Pointer2);
                UDATA uDATA3 = cacheletHintsPointer.length();
                UDATA uDATA4 = cacheletHintsPointer.dataType();
                CommandUtils.dbgPrint(printStream, "  %s hints at: !j9x %s,%s\n", uDATA4.getHexValue(), UDATA.cast(cacheletHintsPointer).add(CacheletHints.SIZEOF).getHexValue(), uDATA3.getHexValue());
                u8Pointer2 = u8Pointer2.add(uDATA3).add(CacheletHints.SIZEOF);
                ++n;
            }
            abstractPointer = UDATAPointer.cast(u8Pointer2);
            CommandUtils.dbgPrint(printStream, "  segment hints at: !j9x %s,%s\n  ", abstractPointer.getHexAddress(), uDATA2.mult(UDATA.SIZEOF).getHexValue());
            n = 0;
            while (uDATA2.gt(n)) {
                CommandUtils.dbgPrint(printStream, "  %s", ((UDATAPointer)abstractPointer).at(n).getHexValue());
                ++n;
            }
            CommandUtils.dbgPrint(printStream, "\n");
        }
        abstractPointer = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cacheletWrapperPointer));
        CommandUtils.dbgPrint(printStream, "  ");
        this.dbgShrcHeaderOperations(printStream, (J9SharedCacheHeaderPointer)abstractPointer, VoidPointer.NULL, 1);
    }

    private Touple<Boolean, Long> dbgShrcHeaderOperations(PrintStream printStream, J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer, VoidPointer voidPointer, int n) throws CorruptDataException {
        long l = 0L;
        J9SharedCacheHeaderInfo j9SharedCacheHeaderInfo = new J9SharedCacheHeaderInfo(j9SharedCacheHeaderPointer);
        U32 u32 = j9SharedCacheHeaderInfo.getTotalBytes();
        U32 u322 = j9SharedCacheHeaderInfo.getSoftMaxBytes();
        U32 u323 = j9SharedCacheHeaderInfo.getReadWriteBytes();
        UDATA uDATA = j9SharedCacheHeaderInfo.getSegmentPtr();
        UDATA uDATA2 = j9SharedCacheHeaderInfo.getUpdatePtr();
        UDATA uDATA3 = j9SharedCacheHeaderInfo.getReadWritePtr();
        UDATA uDATA4 = j9SharedCacheHeaderInfo.getReadWriteStart();
        UDATA uDATA5 = j9SharedCacheHeaderInfo.getRomClassesStart();
        UDATA uDATA6 = j9SharedCacheHeaderInfo.getDebugAreaSize();
        UDATA uDATA7 = j9SharedCacheHeaderInfo.getMetaDataStart();
        UDATA uDATA8 = j9SharedCacheHeaderInfo.getDebugAreaStart();
        UDATA uDATA9 = j9SharedCacheHeaderInfo.getDebugAreaEnd();
        UDATA uDATA10 = j9SharedCacheHeaderInfo.getLineNumberAreaEnd();
        UDATA uDATA11 = j9SharedCacheHeaderInfo.getLocalVariableAreaEnd();
        UDATA uDATA12 = j9SharedCacheHeaderInfo.getDebugLNTUsed();
        UDATA uDATA13 = j9SharedCacheHeaderInfo.getDebugLVTUsed();
        UDATA uDATA14 = uDATA12.add(uDATA13);
        UDATA uDATA15 = 0L != uDATA6.longValue() ? new UDATA(uDATA14.longValue() * 100L / uDATA6.longValue()) : new UDATA(100L);
        UDATA uDATA16 = j9SharedCacheHeaderInfo.getFreeAvailableBytes();
        if (null != uDATA16) {
            l = uDATA16.longValue();
        }
        if (n == -1 || voidPointer.isNull()) {
            String string;
            CommandUtils.dbgPrint(printStream, "!j9sharedcacheheader %s\n", j9SharedCacheHeaderPointer.getHexAddress());
            String string2 = string = n >= 0 ? "    " : "";
            if (n > 0) {
                CommandUtils.dbgPrint(printStream, "    ccInitComplete: 0x%x free bytes: %d cacheFullFlags: %d\n", j9SharedCacheHeaderPointer.ccInitComplete().longValue(), uDATA2.sub(uDATA).longValue(), j9SharedCacheHeaderPointer.cacheFullFlags().longValue());
            } else {
                if (n == -1) {
                    CommandUtils.dbgPrint(printStream, "%scache size       : %d\n", string, u32.sub(u323).longValue());
                    if (null != uDATA16) {
                        CommandUtils.dbgPrint(printStream, "%sfree bytes       : %d\n", string, l);
                    }
                    if (u322.eq(U32.MAX)) {
                        CommandUtils.dbgPrint(printStream, "%ssoftmx bytes     : %d\n", string, -1);
                    } else {
                        CommandUtils.dbgPrint(printStream, "%ssoftmx bytes     : %d", string, u322.longValue());
                        try {
                            Field field = ShCFlags.class.getField("J9SHR_AVAILABLE_SPACE_FULL");
                            Long l2 = (Long)field.get(null);
                            if (j9SharedCacheHeaderInfo.getCacheFullFlags().anyBitsIn(l2)) {
                                CommandUtils.dbgPrint(printStream, " (J9SHR_AVAILABLE_SPACE_FULL is set)");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        CommandUtils.dbgPrint(printStream, "\n");
                    }
                }
                CommandUtils.dbgPrint(printStream, "%sread write area  : %s - %s size %d used %d\n", string, uDATA4.getHexValue(), uDATA3.getHexValue(), u323.longValue(), uDATA3.sub(uDATA4).longValue());
            }
            CommandUtils.dbgPrint(printStream, "%ssegment area     : %s - %s size %d\n", string, uDATA5.getHexValue(), uDATA.getHexValue(), uDATA.sub(uDATA5).longValue());
            CommandUtils.dbgPrint(printStream, "%smetadata area    : %s - %s size %d\n", string, uDATA2.getHexValue(), uDATA7.getHexValue(), uDATA7.sub(uDATA2).longValue());
            CommandUtils.dbgPrint(printStream, "%sclass debug area : %s - %s size %d used %d (%% used %d)\n", string, uDATA8.getHexValue(), uDATA9.getHexValue(), uDATA6.longValue(), uDATA14.longValue(), uDATA15.longValue());
        }
        if (voidPointer.isNull()) {
            return new Touple<Boolean, Long>(false, l);
        }
        if (voidPointer.gte(VoidPointer.cast(j9SharedCacheHeaderPointer)) && voidPointer.lt(j9SharedCacheHeaderPointer.addOffset(J9SharedCacheHeader.SIZEOF))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in the cache%s header", voidPointer.getAddress(), n > 0 ? "let" : "");
        } else if (voidPointer.gte(VoidPointer.cast(uDATA4)) && voidPointer.lt(VoidPointer.cast(uDATA3))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in the read write area", voidPointer.getAddress());
        } else if (voidPointer.gte(VoidPointer.cast(uDATA3)) && voidPointer.lt(VoidPointer.cast(uDATA5))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in the unused part of the read write area", voidPointer.getAddress());
        } else if (voidPointer.gte(VoidPointer.cast(uDATA5)) && voidPointer.lt(VoidPointer.cast(uDATA))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in the rom class segment area", voidPointer.getAddress());
        } else if (voidPointer.gte(VoidPointer.cast(uDATA)) && voidPointer.lt(VoidPointer.cast(uDATA2))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in unused area between class segments and metadata", voidPointer.getAddress());
        } else if (voidPointer.gte(VoidPointer.cast(uDATA2)) && voidPointer.lt(VoidPointer.cast(uDATA7))) {
            CommandUtils.dbgPrint(printStream, "\n0x%x is in the metadata area", voidPointer.getAddress());
        } else if (!uDATA6.eq(0L) && voidPointer.gte(VoidPointer.cast(uDATA7)) && voidPointer.lt(VoidPointer.cast(uDATA9))) {
            if (voidPointer.lt(VoidPointer.cast(uDATA10))) {
                CommandUtils.dbgPrint(printStream, "\n0x%x is in the line number table of the class debug area", voidPointer.getAddress());
            } else if (voidPointer.gt(VoidPointer.cast(uDATA11))) {
                CommandUtils.dbgPrint(printStream, "\n0x%x is in the local variable table of the class debug area", voidPointer.getAddress());
            } else {
                CommandUtils.dbgPrint(printStream, "\n0x%x is in the unused part of the class debug area", voidPointer.getAddress());
            }
        } else {
            return new Touple<Boolean, Long>(false, l);
        }
        if (n > 0) {
            CommandUtils.dbgPrint(printStream, " of cachelet %d\n", n);
        } else if (n == 0) {
            CommandUtils.dbgPrint(printStream, " of the main cache\n");
        } else {
            CommandUtils.dbgPrint(printStream, "\n");
        }
        return new Touple<Boolean, Long>(true, l);
    }

    private void dbgShrcPrintClasspath(PrintStream printStream, ClasspathWrapperPointer classpathWrapperPointer) throws CorruptDataException {
        ClasspathItemPointer classpathItemPointer = ClasspathItemPointer.cast(ClasspathWrapperHelper.CPWDATA(classpathWrapperPointer));
        UDATA uDATA = new UDATA(classpathItemPointer.type());
        ShcItemPointer shcItemPointer = ShcItemPointer.cast(UDATA.cast(classpathWrapperPointer).sub(ShcItem.SIZEOF));
        U16 u16 = shcItemPointer.jvmID();
        I16 i16 = classpathWrapperPointer.staleFromIndex();
        CommandUtils.dbgPrint(printStream, "%d: ", u16.longValue());
        if (uDATA.eq(J9GenericByID.CP_TYPE_CLASSPATH)) {
            CommandUtils.dbgPrint(printStream, "%s CLASSPATH", UDATA.cast(classpathWrapperPointer).getHexValue());
        } else if (uDATA.eq(J9GenericByID.CP_TYPE_URL)) {
            CommandUtils.dbgPrint(printStream, "%s URL", UDATA.cast(classpathWrapperPointer).getHexValue());
        } else if (uDATA.eq(J9GenericByID.CP_TYPE_TOKEN)) {
            CommandUtils.dbgPrint(printStream, "%s TOKEN", UDATA.cast(classpathWrapperPointer).getHexValue());
        }
        if (!i16.eq(ShcdatatypesConstants.CPW_NOT_STALE)) {
            CommandUtils.dbgPrint(printStream, " staleFromIndex %d", i16.longValue());
        }
        CommandUtils.dbgPrint(printStream, "\n");
        IDATA iDATA = classpathItemPointer.itemsAdded();
        IDATAPointer iDATAPointer = ClasspathItemHelper.CPEI_ARRAY_PTR_FROM_CPI(classpathItemPointer);
        int n = 0;
        while (iDATA.gt(n)) {
            ClasspathEntryItemPointer classpathEntryItemPointer = ClasspathEntryItemPointer.cast(UDATA.cast(classpathItemPointer).add(iDATAPointer.at(n)));
            UDATA uDATA2 = classpathEntryItemPointer.pathLen();
            U8Pointer u8Pointer = ClasspathEntryItemHelper.CPEIPATH(classpathEntryItemPointer);
            String string = u8Pointer.getCStringAtOffset(0L, uDATA2.longValue());
            CommandUtils.dbgPrint(printStream, "   %d)\t%s: %s \ttimestamp: %s%s\n", n, this.getProtocolName(classpathEntryItemPointer.protocol()), string, classpathEntryItemPointer.timestamp().getHexValue(), this.isStaleCPEntry(classpathEntryItemPointer) ? " !STALE" : "");
            ++n;
        }
    }

    private boolean isStaleCPEntry(ClasspathEntryItemPointer classpathEntryItemPointer) throws CorruptDataException {
        return (classpathEntryItemPointer.flags().longValue() & SharedconstsConstants.MARKED_STALE_FLAG) != 0L;
    }

    private String getProtocolName(UDATA uDATA) {
        long l = uDATA.longValue();
        if (l == SharedconstsConstants.PROTO_JAR) {
            return "JAR";
        }
        if (l == SharedconstsConstants.PROTO_DIR) {
            return "DIR";
        }
        if (l == SharedconstsConstants.PROTO_TOKEN) {
            return "TOKEN";
        }
        if (l == SharedconstsConstants.PROTO_UNKNOWN) {
            return "UNKNOWN";
        }
        return uDATA.getHexValue();
    }

    private void dbgShrcInCache(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9SharedClassConfigPointer j9SharedClassConfigPointer, VoidPointer voidPointer) throws CorruptDataException {
        StructurePointer structurePointer;
        Object object;
        int n;
        boolean bl = false;
        ShrcConfig shrcConfig = this.dbgShrcReadConfig(j9SharedClassConfigPointer, printStream);
        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = shrcConfig.getCacheStartAddress();
        UDATA uDATA = j9SharedCacheHeaderPointer.containsCachelets();
        if (!uDATA.eq(0L)) {
            n = 1;
            long l = 0L;
            this.dbgShrcHeaderOperations(printStream, J9SharedCacheHeaderPointer.cast(j9SharedCacheHeaderPointer), VoidPointer.NULL, 0);
            object = new SharedClassMetadataIterator(j9JavaVMPointer, ShcdatatypesConstants.TYPE_CACHELET, true, printStream);
            while (((SharedClassMetadataIterator)object).hasNext()) {
                structurePointer = ((SharedClassMetadataIterator)object).next();
                CacheletWrapperPointer cacheletWrapperPointer = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(structurePointer));
                J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer2 = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cacheletWrapperPointer));
                CommandUtils.dbgPrint(printStream, "Cachelet %d !shrc cachelet %s ", n, cacheletWrapperPointer.getHexAddress());
                Touple<Boolean, Long> touple = this.dbgShrcHeaderOperations(printStream, j9SharedCacheHeaderPointer2, VoidPointer.NULL, n);
                l += touple.getV2().longValue();
                ++n;
            }
            CommandUtils.dbgPrint(printStream, "total cache size : %d\n", j9SharedCacheHeaderPointer.totalBytes().sub((int)J9SharedCacheHeader.SIZEOF).longValue());
            CommandUtils.dbgPrint(printStream, "total free bytes : %d\n", l);
        } else {
            bl = this.dbgShrcHeaderOperations(printStream, j9SharedCacheHeaderPointer, voidPointer, -1).getV1();
        }
        if (voidPointer.isNull()) {
            return;
        }
        if (!uDATA.eq(0L)) {
            ShcItemPointer shcItemPointer;
            n = 1;
            SharedClassMetadataIterator sharedClassMetadataIterator = new SharedClassMetadataIterator(j9JavaVMPointer, ShcdatatypesConstants.TYPE_CACHELET, true, printStream);
            while (sharedClassMetadataIterator.hasNext() && !(bl = this.dbgShrcHeaderOperations(printStream, (J9SharedCacheHeaderPointer)(structurePointer = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA((CacheletWrapperPointer)(object = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(shcItemPointer = sharedClassMetadataIterator.next())))))), voidPointer, n++).getV1().booleanValue())) {
            }
            if (!bl) {
                bl = this.dbgShrcHeaderOperations(printStream, j9SharedCacheHeaderPointer, voidPointer, 0).getV1();
            }
        }
        if (!bl) {
            CommandUtils.dbgPrint(printStream, "\n%s is not in the shared cache\n", U8Pointer.cast(voidPointer).getHexAddress());
        }
    }

    private void initTotalCacheSize(PrintStream printStream, J9SharedClassConfigPointer j9SharedClassConfigPointer) throws CorruptDataException {
        SH_OSCachePointer sH_OSCachePointer;
        if (0L == cacheTotalSize && (sH_OSCachePointer = this.getOSCache(printStream, j9SharedClassConfigPointer)).notNull()) {
            cacheTotalSize = sH_OSCachePointer._cacheSize().longValue();
        }
    }

    class SharedClassMetadataIterator
    implements Iterator<ShcItemPointer> {
        private ShcItemPointer next;
        private U8Pointer metaStartInCache;
        private U8Pointer metaStart;
        private U8Pointer savedMetaStart;
        private ShcItemHdrPointer entry;
        private ShcItemHdrPointer savedEntry;
        private U16 limitDataType;
        private boolean includeStale;
        private PrintStream out;

        private void init(J9JavaVMPointer j9JavaVMPointer, SharedCacheMetadata sharedCacheMetadata, long l, boolean bl, PrintStream printStream) throws CorruptDataException {
            this.next = ShcItemPointer.NULL;
            this.metaStartInCache = ShrCCommand.this.getSharedCacheMetadataStart(j9JavaVMPointer, printStream);
            this.metaStart = sharedCacheMetadata.getHeapBase();
            this.savedMetaStart = sharedCacheMetadata.getHeapBase();
            this.entry = sharedCacheMetadata.getFirstEntry();
            this.savedEntry = ShcItemHdrPointer.NULL;
            this.limitDataType = new U16(l);
            this.includeStale = bl;
            this.out = printStream;
        }

        public SharedClassMetadataIterator(J9JavaVMPointer j9JavaVMPointer, long l, boolean bl, PrintStream printStream) throws CorruptDataException {
            SharedCacheMetadata sharedCacheMetadata = ShrCCommand.this.dbgReadSharedCacheMetadata(j9JavaVMPointer, printStream);
            this.init(j9JavaVMPointer, sharedCacheMetadata, l, bl, printStream);
        }

        public SharedClassMetadataIterator(J9JavaVMPointer j9JavaVMPointer, U8Pointer u8Pointer, U8Pointer u8Pointer2, long l, boolean bl, PrintStream printStream) throws CorruptDataException {
            SharedCacheMetadata sharedCacheMetadata = ShrCCommand.this.dbgReadSharedCacheMetadata(j9JavaVMPointer, u8Pointer, u8Pointer2, printStream);
            this.init(j9JavaVMPointer, sharedCacheMetadata, l, bl, printStream);
        }

        @Override
        public boolean hasNext() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            return this.next.notNull();
        }

        @Override
        public ShcItemPointer next() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            ShcItemPointer shcItemPointer = this.next;
            this.next = ShcItemPointer.NULL;
            return shcItemPointer;
        }

        private ShcItemPointer internalNext() {
            try {
                ShcItemPointer shcItemPointer = ShcItemPointer.NULL;
                ShcItemHdrPointer shcItemHdrPointer = this.entry;
                do {
                    ShcItemPointer shcItemPointer2;
                    U16 u16;
                    this.entry = shcItemHdrPointer;
                    long l = ShcItemHdrHelper.CCITEMLEN(this.entry).longValue();
                    if (l == 0L) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen is 0\n", this.entry.getHexAddress());
                        shcItemHdrPointer = ShcItemHdrPointer.NULL;
                        break;
                    }
                    shcItemHdrPointer = ShcItemHdrHelper.CCITEMNEXT(this.entry);
                    if (UDATA.cast(shcItemHdrPointer).lt(UDATA.cast(this.metaStartInCache.sub(ShcItemHdr.SIZEOF)))) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen %d is bigger than size of metadata area\n", this.entry.getHexAddress(), l);
                        shcItemHdrPointer = ShcItemHdrPointer.NULL;
                        break;
                    }
                    if (UDATA.cast(shcItemHdrPointer).lt(UDATA.cast(this.metaStart.sub(ShcItemHdr.SIZEOF)))) {
                        shcItemHdrPointer = ShcItemHdrPointer.NULL;
                    }
                    if (UDATA.cast(shcItemHdrPointer).lte(UDATA.cast(this.metaStart))) {
                        if (this.savedEntry.notNull()) {
                            this.metaStart = this.savedMetaStart;
                            shcItemHdrPointer = this.savedEntry;
                            this.savedEntry = ShcItemHdrPointer.NULL;
                            if (UDATA.cast(shcItemHdrPointer).lte(UDATA.cast(this.metaStart))) {
                                shcItemHdrPointer = ShcItemHdrPointer.NULL;
                            }
                        } else {
                            shcItemHdrPointer = ShcItemHdrPointer.NULL;
                        }
                    }
                    if ((u16 = (shcItemPointer2 = ShcItemPointer.cast(ShcItemHdrHelper.CCITEM(this.entry))).dataType()).eq(ShcdatatypesConstants.TYPE_CACHELET)) {
                        CacheletWrapperPointer cacheletWrapperPointer = CacheletWrapperPointer.cast(ShcItemHelper.ITEMDATA(shcItemPointer2));
                        J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer = J9SharedCacheHeaderPointer.cast(CacheletWrapperHelper.CLETDATA(cacheletWrapperPointer));
                        UDATA uDATA = j9SharedCacheHeaderPointer.totalBytes();
                        UDATA uDATA2 = UDATA.cast(j9SharedCacheHeaderPointer).add(j9SharedCacheHeaderPointer.updateSRP());
                        UDATA uDATA3 = UDATA.cast(j9SharedCacheHeaderPointer).add(uDATA);
                        if (uDATA3.sub(ShcItemHdr.SIZEOF).gt(uDATA2)) {
                            this.savedEntry = shcItemHdrPointer;
                            this.metaStart = U8Pointer.cast(uDATA2);
                            shcItemHdrPointer = ShcItemHdrPointer.cast(uDATA3.sub(ShcItemHdr.SIZEOF));
                        }
                    }
                    if (!this.limitDataType.eq(0L) && (!u16.eq(this.limitDataType) || !this.includeStale && ShcItemHdrHelper.CCITEMSTALE(this.entry))) continue;
                    shcItemPointer = shcItemPointer2;
                    break;
                } while (shcItemHdrPointer.notNull());
                this.entry = shcItemHdrPointer;
                return shcItemPointer;
            }
            catch (CorruptDataException corruptDataException) {
                corruptDataException.printStackTrace();
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }

    class SharedCacheMetadata {
        private final U8Pointer heapBase;
        private final U8Pointer heapTop;
        private final UDATA length;

        public SharedCacheMetadata(U8Pointer u8Pointer, U8Pointer u8Pointer2) {
            this.heapBase = u8Pointer;
            this.heapTop = u8Pointer2;
            this.length = new UDATA(u8Pointer2.sub(u8Pointer));
        }

        public U8Pointer getHeapBase() {
            return this.heapBase;
        }

        public U8Pointer getHeapTop() {
            return this.heapTop;
        }

        public UDATA getLength() {
            return this.length;
        }

        public ShcItemHdrPointer getFirstEntry() {
            return ShcItemHdrPointer.cast(this.heapTop);
        }
    }

    static class J9SharedCacheHeaderInfo {
        private J9SharedCacheHeaderPointer header;

        J9SharedCacheHeaderInfo(J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer) {
            this.header = j9SharedCacheHeaderPointer;
        }

        public J9SharedCacheHeaderPointer getHeader() {
            return this.header;
        }

        public void setHeader(J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer) {
            this.header = j9SharedCacheHeaderPointer;
        }

        public UDATA getHeaderStart() {
            return UDATA.cast(this.header);
        }

        public U32 getTotalBytes() throws CorruptDataException {
            return new U32(this.header.totalBytes());
        }

        public U32 getSoftMaxBytes() throws CorruptDataException {
            return new U32(this.header.softMaxBytes());
        }

        public U32 getReadWriteBytes() throws CorruptDataException {
            return new U32(this.header.readWriteBytes());
        }

        public UDATA getReadWritePtr() throws CorruptDataException {
            UDATA uDATA = this.header.readWriteSRP();
            return UDATA.cast(this.header).add(uDATA);
        }

        public UDATA getReadWriteStart() {
            return UDATA.cast(this.header).add(J9SharedCacheHeader.SIZEOF);
        }

        public UDATA getRomClassesStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getReadWriteBytes());
        }

        public UDATA getRomClassesEnd() throws CorruptDataException {
            return this.getSegmentPtr();
        }

        public UDATA getSegmentPtr() throws CorruptDataException {
            UDATA uDATA = this.header.segmentSRP();
            return UDATA.cast(this.header).add(uDATA);
        }

        public UDATA getUpdatePtr() throws CorruptDataException {
            UDATA uDATA = this.header.updateSRP();
            return UDATA.cast(this.header).add(uDATA);
        }

        public UDATA getDebugAreaSize() throws CorruptDataException {
            return new UDATA(this.header.debugRegionSize().longValue());
        }

        public UDATA getMetaDataStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getTotalBytes()).sub(this.getDebugAreaSize());
        }

        public UDATA getMetaDataEnd() throws CorruptDataException {
            return this.getUpdatePtr();
        }

        public UDATA getDebugAreaStart() throws CorruptDataException {
            return UDATA.cast(this.header).add(this.getTotalBytes()).sub(this.getDebugAreaSize());
        }

        public UDATA getDebugAreaEnd() throws CorruptDataException {
            return this.getDebugAreaStart().add(this.getDebugAreaSize());
        }

        public UDATA getLineNumberAreaStart() throws CorruptDataException {
            return this.getDebugAreaStart();
        }

        public UDATA getLineNumberAreaEnd() throws CorruptDataException {
            return new UDATA(this.header.lineNumberTableNextSRPEA().longValue() + this.header.lineNumberTableNextSRP().longValue());
        }

        public UDATA getLocalVariableAreaStart() throws CorruptDataException {
            return this.getDebugAreaEnd();
        }

        public UDATA getLocalVariableAreaEnd() throws CorruptDataException {
            return new UDATA(this.header.localVariableTableNextSRPEA().longValue() + this.header.localVariableTableNextSRP().longValue());
        }

        public UDATA getDebugLVTUsed() throws CorruptDataException {
            return this.getDebugAreaEnd().sub(this.getLocalVariableAreaEnd());
        }

        public UDATA getDebugLNTUsed() throws CorruptDataException {
            return this.getLineNumberAreaEnd().sub(this.getDebugAreaStart());
        }

        public I32 getMinAOT() throws CorruptDataException {
            return new I32(this.header.minAOT());
        }

        public I32 getMinJIT() throws CorruptDataException {
            return new I32(this.header.minJIT());
        }

        public UDATA getAotBytes() throws CorruptDataException {
            return this.header.aotBytes();
        }

        public UDATA getJitBytes() throws CorruptDataException {
            return this.header.jitBytes();
        }

        public UDATA getCacheFullFlags() throws CorruptDataException {
            return this.header.cacheFullFlags();
        }

        public I32 getFreeBlockBytes() throws CorruptDataException {
            long l = this.getMinAOT().longValue();
            long l2 = this.getMinJIT().longValue();
            long l3 = this.getAotBytes().longValue();
            long l4 = this.getJitBytes().longValue();
            UDATA uDATA = this.getUpdatePtr();
            UDATA uDATA2 = this.getSegmentPtr();
            long l5 = uDATA.sub(uDATA2).longValue();
            long l6 = -1L == l && -1L == l2 || -1L == l && l2 <= l4 || -1L == l2 && l <= l3 || l <= l3 && l2 <= l4 ? l5 : (l2 > l4 && (-1L == l || l <= l3) ? l5 - (l2 - l4) : (l > l3 && (-1L == l2 || l2 <= l4) ? l5 - (l - l3) : l5 - (l2 - l4) - (l - l3)));
            l6 = l6 > 0L ? l6 : 0L;
            return new I32(l6);
        }

        public U32 getUsedBytes() throws CorruptDataException {
            long l = cacheTotalSize;
            long l2 = this.getFreeBlockBytes().longValue();
            long l3 = this.getDebugAreaSize().longValue() - this.getDebugLNTUsed().longValue() - this.getDebugLVTUsed().longValue();
            if (0L == l) {
                return null;
            }
            return new U32(l - l2 - l3);
        }

        public UDATA getFreeAvailableBytes() throws CorruptDataException {
            long l = 0L;
            long l2 = cacheTotalSize;
            long l3 = this.getFreeBlockBytes().longValue();
            U32 u32 = this.getSoftMaxBytes();
            U32 u322 = this.getUsedBytes();
            if (null != u322) {
                l = u32.eq(U32.MAX) ? l2 - u322.longValue() : u32.sub(u322).longValue();
                l = l3 < l ? l3 : l;
                return new UDATA(l);
            }
            return null;
        }
    }

    class Touple<V1, V2> {
        V1 v1;
        V2 v2;

        public Touple(V1 V1, V2 V2) {
            this.v1 = V1;
            this.v2 = V2;
        }

        public V1 getV1() {
            return this.v1;
        }

        public V2 getV2() {
            return this.v2;
        }
    }

    class ShrcConfig {
        private final J9SharedCacheHeaderPointer cacheStartAddress;
        private final UDATA romclassStartAddress;
        private final UDATA segmentPtr;

        public ShrcConfig(J9SharedCacheHeaderPointer j9SharedCacheHeaderPointer, UDATA uDATA, UDATA uDATA2) {
            this.cacheStartAddress = j9SharedCacheHeaderPointer;
            this.romclassStartAddress = uDATA;
            this.segmentPtr = uDATA2;
        }

        public J9SharedCacheHeaderPointer getCacheStartAddress() {
            return this.cacheStartAddress;
        }

        public UDATA getRomclassStartAddress() {
            return this.romclassStartAddress;
        }

        public UDATA getSegmentPtr() {
            return this.segmentPtr;
        }
    }

    static class CacheFileOutputStream
    extends FileOutputStream {
        private String fileName;

        CacheFileOutputStream(File file) throws FileNotFoundException {
            super(file);
            this.fileName = file.getAbsolutePath();
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

