/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.util.NoSuchElementException;

class GCPointerArrayIterator_V1
extends GCObjectIterator {
    protected ObjectReferencePointer data;
    protected int scanIndex = 0;
    protected int scanLimit;

    protected GCPointerArrayIterator_V1(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        super(j9ObjectPointer, bl);
        this.scanLimit = ObjectModel.getSizeInElements(j9ObjectPointer).intValue();
        this.data = ObjectReferencePointer.cast(j9ObjectPointer.addOffset(ObjectModel.getHeaderSize(j9ObjectPointer)));
    }

    @Override
    public boolean hasNext() {
        if (this.includeClassSlot) {
            return true;
        }
        return this.scanIndex < this.scanLimit;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return J9ObjectHelper.clazz(this.object).classObject();
                }
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(this.data.at(this.scanIndex));
                ++this.scanIndex;
                return j9ObjectPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        try {
            if (this.hasNext()) {
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return VoidPointer.cast(J9ObjectHelper.clazz(this.object).classObjectEA());
                }
                VoidPointer voidPointer = VoidPointer.cast(this.data.add(this.scanIndex));
                ++this.scanIndex;
                return voidPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return null;
        }
    }
}

