/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;

public abstract class BaseMemoryRange
implements IMemoryRange {
    private final boolean fastPathContains;
    private int alignment;
    private long baseAddressTestValue;
    protected final long baseAddress;
    protected final long size;

    protected BaseMemoryRange(long l, long l2) {
        this.baseAddress = l;
        this.size = l2;
        this.alignment = 0;
        long l3 = l;
        for (int i = 0; i < 64 && (l3 & 1L) == 0L; ++i) {
            ++this.alignment;
            l3 >>>= 1;
        }
        this.baseAddressTestValue = l >>> this.alignment;
        long l4 = this.getTopAddress();
        this.fastPathContains = this.baseAddressTestValue == l4 >>> this.alignment && this.baseAddressTestValue != l4 + 1L >>> this.alignment;
    }

    @Override
    public boolean contains(long l) {
        if (this.fastPathContains) {
            return this.baseAddressTestValue == l >>> this.alignment;
        }
        return Addresses.greaterThanOrEqual(l, this.getBaseAddress()) && Addresses.lessThanOrEqual(l, this.getTopAddress());
    }

    @Override
    public int compareTo(IMemoryRange iMemoryRange) {
        if (iMemoryRange.getAddressSpaceId() != this.getAddressSpaceId()) {
            return this.getAddressSpaceId() - iMemoryRange.getAddressSpaceId();
        }
        if (Addresses.greaterThan(this.getBaseAddress(), iMemoryRange.getBaseAddress())) {
            return 1;
        }
        if (Addresses.lessThan(this.getBaseAddress(), iMemoryRange.getBaseAddress())) {
            return -1;
        }
        if (Addresses.greaterThan(this.getTopAddress(), iMemoryRange.getTopAddress())) {
            return 1;
        }
        if (Addresses.lessThan(this.getTopAddress(), iMemoryRange.getTopAddress())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MemoryRange ");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" from ");
        stringBuffer.append(Long.toHexString(this.getBaseAddress()));
        stringBuffer.append(" to ");
        stringBuffer.append(Long.toHexString(this.getTopAddress()));
        return stringBuffer.toString();
    }

    @Override
    public boolean isSubRange(IMemoryRange iMemoryRange) {
        boolean bl = Addresses.greaterThanOrEqual(iMemoryRange.getBaseAddress(), this.getBaseAddress());
        boolean bl2 = Addresses.greaterThanOrEqual(this.getTopAddress(), iMemoryRange.getTopAddress());
        return bl && bl2;
    }

    @Override
    public boolean overlaps(IMemoryRange iMemoryRange) {
        return this.contains(iMemoryRange.getBaseAddress()) || this.contains(iMemoryRange.getTopAddress()) || iMemoryRange.contains(this.getBaseAddress()) || iMemoryRange.contains(this.getTopAddress());
    }

    @Override
    public final long getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final long getTopAddress() {
        if (this.size == 0L) {
            return this.baseAddress;
        }
        return this.baseAddress + this.size - 1L;
    }

    @Override
    public boolean isBacked() {
        return true;
    }
}

